/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.dsig;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.dsig.SignatureReceiverConfig;
import com.ibm.xml.soapsec.dsig.SignatureResult;
import com.ibm.xml.soapsec.time.TimestampResult;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.IdUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignedPartChecker
implements SoapSecurityComponent {
    private static final TraceComponent tc = Tr.register(SignedPartChecker.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    SignatureReceiverConfig config;

    public void init(Map map) throws Exception {
        this.config = (SignatureReceiverConfig)map.get(SignatureReceiverConfig.class);
    }

    public void invoke(Document doc, Element target, Map context) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + doc + "," + target + "," + context + ")");
        }
        Result[] results = ResultPool.get(context, SignatureResult.class);
        for (String part : this.config.getRequiredIntegralParts()) {
            boolean signed = false;
            if (part.equals("body")) {
                for (int i = 0; i < results.length; ++i) {
                    String idvalue;
                    String idattr;
                    SignatureResult sigres = (SignatureResult)results[i];
                    if (sigres.isBodySigned()) {
                        sigres.setCompliance(true);
                        signed = true;
                        break;
                    }
                    Element el = doc.getDocumentElement();
                    if ((el = DOMUtil.getFirstElement(el, "http://schemas.xmlsoap.org/soap/envelope/", "Body")) == null || (idattr = IdUtil.getInstance().getIdAttributeName(el)) == null || (idvalue = el.getAttribute(idattr)).length() <= 0 || !sigres.isSigned(idvalue)) continue;
                    sigres.setCompliance(true);
                    signed = true;
                    break;
                }
                if (signed) continue;
                String wsseNSSent = Constants.getWSSENS(context);
                throw SoapSecurityException.format((QName)Constants.getQName(wsseNSSent, "FailedCheck"), (String)"security.wssecurity.SignatureReceiver.dsig12", (Document)doc);
            }
            if (part.equals("timestamp")) {
                Result[] tsresults = ResultPool.get(context, TimestampResult.class);
                if (tsresults.length < 1) continue;
                TimestampResult tsres = (TimestampResult)tsresults[0];
                for (int i = 0; i < results.length; ++i) {
                    SignatureResult sigres = (SignatureResult)results[i];
                    String id = tsres.getId();
                    if (id == null || !sigres.isSigned(id)) continue;
                    sigres.setCompliance(true);
                    signed = true;
                    break;
                }
                if (signed) continue;
                String wsseNSSent = Constants.getWSSENS(context);
                throw SoapSecurityException.format((QName)Constants.getQName(wsseNSSent, "FailedCheck"), (String)"security.wssecurity.SignatureReceiver.dsig20", (Document)doc);
            }
            if (part.equals("securitytoken")) continue;
            throw new RuntimeException("Internal Error: " + part);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target, Map context)");
        }
    }
}

