/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.confimpl;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.xml.soapsec.SenderConfig;
import com.ibm.xml.soapsec.dsig.SignatureSenderConfig;
import com.ibm.xml.soapsec.dsig.TemplateModifier;
import com.ibm.xml.soapsec.enc.EncryptionSenderConfig;
import com.ibm.xml.soapsec.enc.EncryptionSettings;
import com.ibm.xml.soapsec.time.TimestampSenderConfig;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.token.TokenSenderConfig;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.Duration;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class PrivateSenderConfig
implements SenderConfig {
    private static final TraceComponent tc = Tr.register(PrivateSenderConfig.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    protected String myactor = null;
    protected String targetactor = null;
    protected final Set integralParts = new HashSet();
    protected String keyName = null;
    protected KeyLocator keyLocator = null;
    protected String c14nMethod;
    protected String signatureMethod;
    protected String digestMethod;
    protected final List templateModifiers = new LinkedList();
    protected boolean isSecTokenSigned = false;
    protected boolean prec14n = false;
    protected boolean inclusiveNamespaces = false;
    protected boolean indentation = true;
    protected Map _properties = null;
    protected boolean clientSetMustUnderstand = true;
    protected boolean serviceGetMustUnderstand = true;
    protected final SignatureSenderConfig signatureSenderConfig = new SignatureSenderConfig(){

        public Set getIntegralParts() {
            return PrivateSenderConfig.this.integralParts;
        }

        public String getKeyName() {
            return PrivateSenderConfig.this.keyName;
        }

        public KeyLocator getKeyLocator() {
            return PrivateSenderConfig.this.keyLocator;
        }

        public boolean getPreC14n() {
            return PrivateSenderConfig.this.prec14n;
        }

        public void setPreC14n(boolean f) {
            PrivateSenderConfig.this.prec14n = f;
        }

        public boolean addInclusiveNamespaces() {
            return PrivateSenderConfig.this.inclusiveNamespaces;
        }

        public String getCanonicalizationMethod() {
            return PrivateSenderConfig.this.c14nMethod;
        }

        public String getSignatureMethod() {
            return PrivateSenderConfig.this.signatureMethod;
        }

        public String getDigestMethod() {
            return PrivateSenderConfig.this.digestMethod;
        }

        public List getTemplateModifiers() {
            return PrivateSenderConfig.this.templateModifiers;
        }

        public String toString() {
            return "SignatureSenderConfig(integralParts=" + PrivateSenderConfig.this.integralParts + " keyName=" + PrivateSenderConfig.this.keyName + " keyLocator=" + PrivateSenderConfig.this.keyLocator + " c14n=" + PrivateSenderConfig.this.c14nMethod + " signature=" + PrivateSenderConfig.this.signatureMethod + " digest=" + PrivateSenderConfig.this.digestMethod + " templateModifiers=" + PrivateSenderConfig.this.templateModifiers + ")";
        }
    };
    protected String authMethod = null;
    protected String idType = null;
    protected String trustMode = null;
    protected QName tokenValueType = null;
    protected CallbackHandler callbackHandler = null;
    protected boolean addNonce = false;
    protected boolean addNonceTimestamp = false;
    protected QName nonceEncodingType = null;
    protected NonceManager nonceManager = null;
    protected final TokenSenderConfig tokenSenderConfig = new TokenSenderConfig(){

        public String getAuthMethod() {
            return PrivateSenderConfig.this.authMethod;
        }

        public String getIdType() {
            return PrivateSenderConfig.this.idType;
        }

        public String getTrustMode() {
            return PrivateSenderConfig.this.trustMode;
        }

        public QName getTokenValueType() {
            return PrivateSenderConfig.this.tokenValueType;
        }

        public CallbackHandler getCallbackHandler() {
            return PrivateSenderConfig.this.callbackHandler;
        }

        public boolean isIntegral() {
            return PrivateSenderConfig.this.isSecTokenSigned;
        }

        public boolean isConfidential() {
            return PrivateSenderConfig.this.isUsernameTokenEncrypted;
        }

        public EncryptionSettings getEncryptionSettings() {
            return PrivateSenderConfig.this.encryptionSettings;
        }

        public boolean isNonceAdded() {
            return PrivateSenderConfig.this.addNonce;
        }

        public QName getEncodingType() {
            return PrivateSenderConfig.this.nonceEncodingType;
        }

        public NonceManager getNonceManager() {
            return PrivateSenderConfig.this.nonceManager;
        }

        public boolean isNonceTimestampAdded() {
            return PrivateSenderConfig.this.addNonceTimestamp;
        }

        public String toString() {
            return "TokenSenderConfig(authMethod=" + PrivateSenderConfig.this.authMethod + " idType=" + PrivateSenderConfig.this.idType + " trustMode=" + PrivateSenderConfig.this.trustMode + " tokenValueType=" + PrivateSenderConfig.this.tokenValueType + " callbackHandler=" + PrivateSenderConfig.this.callbackHandler + " isConfidential=" + this.isConfidential() + " encryptionSettings=" + PrivateSenderConfig.this.encryptionSettings + " isNonceAdded=" + PrivateSenderConfig.this.addNonce + " nonceEncodingType=" + PrivateSenderConfig.this.nonceEncodingType + " nonceManager=" + PrivateSenderConfig.this.nonceManager + " isNonceTimestampAdded=" + PrivateSenderConfig.this.addNonceTimestamp + ")";
        }
    };
    protected final Set confidentialParts = new HashSet();
    protected EncryptionSettings encryptionSettings = null;
    protected boolean isUsernameTokenEncrypted = false;
    protected EncryptionSenderConfig encryptionSenderConfig = new EncryptionSenderConfig(){

        public Set getConfidentialParts() {
            return PrivateSenderConfig.this.confidentialParts;
        }

        public EncryptionSettings getEncryptionSettings() {
            return PrivateSenderConfig.this.encryptionSettings;
        }

        public String toString() {
            return "EncryptionSenderConfig(confidentialParts=" + PrivateSenderConfig.this.confidentialParts + " encryptionSettings=" + PrivateSenderConfig.this.encryptionSettings + ")";
        }
    };
    protected boolean enableCreatedTimestamp;
    protected Duration duration;
    protected TimestampSenderConfig timestampSenderConfig = new TimestampSenderConfig(){

        public String getMyActor() {
            return PrivateSenderConfig.this.myactor;
        }

        public boolean addCreatedTimestamp() {
            return PrivateSenderConfig.this.enableCreatedTimestamp;
        }

        public boolean signTimestamp() {
            return PrivateSenderConfig.this.integralParts.contains("timestamp");
        }

        public Duration getDuration() {
            return PrivateSenderConfig.this.duration;
        }

        public String toString() {
            return "TimestampSenderConfig(addCreatedTimestamp=" + this.addCreatedTimestamp() + " signTimestamp=" + this.signTimestamp() + " duration=" + PrivateSenderConfig.this.duration + ")";
        }
    };

    protected void processPrivateConfig(Document privateConfig) throws SoapSecurityException {
        ClassLoader appClassLoader = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processPrivateConfig(" + privateConfig + ")");
        }
        NodeList list = privateConfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "TemplateModifier");
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Element elem = (Element)list.item(i);
            String cls = DOMUtil.getAttribute(elem, "class");
            Map map = ConfigUtil.getProperties(elem);
            TemplateModifier instance = (TemplateModifier)ConfigUtil.instantiate(cls, TemplateModifier.class, map, appClassLoader);
            this.templateModifiers.add(instance);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processPrivateConfig(Document privateConfig)");
        }
    }

    public String getTargetActor() {
        return this.targetactor;
    }

    public String getMyActor() {
        return this.myactor;
    }

    public boolean doIndentation() {
        return this.indentation;
    }

    public void setIndentation(boolean f) {
        this.indentation = f;
    }

    public boolean isSignatureEnabled() {
        return this.integralParts.size() > 0;
    }

    public boolean isTokenEnabled() {
        return this.authMethod != null;
    }

    public boolean isEncryptionEnabled() {
        return this.confidentialParts.size() > 0;
    }

    public boolean isTimestampEnabled() {
        return this.enableCreatedTimestamp || this.integralParts.contains("timestamp");
    }

    public void validate() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate()");
        }
        Iterator iter = this.integralParts.iterator();
        Object obj2 = null;
        while (iter.hasNext()) {
            obj2 = iter.next();
            if (!(obj2 instanceof String)) {
                throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.rconf02", (String)obj2.toString());
            }
            if ("body".equals(obj2) || "timestamp".equals(obj2) || "securitytoken".equals(obj2)) continue;
            throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.rconf02", (String)obj2.toString());
        }
        for (Object obj2 : this.confidentialParts) {
            if (!(obj2 instanceof String)) {
                throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.confPart", (String)obj2.toString());
            }
            if ("bodycontent".equals(obj2) || "usernametoken".equals(obj2)) continue;
            throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.confPart", (String)obj2.toString());
        }
        if (this.trustMode != null && !"Signature".equals(this.trustMode) && !"BasicAuth".equals(this.trustMode)) {
            throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.s08", (String)this.trustMode);
        }
        if (!(this.idType == null || "Username".equals(this.idType) || "DN".equals(this.idType) || "X509Certificate".equals(this.idType))) {
            throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.s31", (String)this.idType);
        }
        if ("Signature".equals(this.authMethod)) {
            if (this.integralParts.size() == 0) {
                throw SoapSecurityException.format((String)"security.wssecurity.PrivateSenderConfig.s30");
            }
            if (this.integralParts.contains("securitytoken")) {
                throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.sigWithSec");
            }
        }
        if ("IDAssertion".equals(this.authMethod) && this.idType == null) {
            throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.s32");
        }
        if (this.callbackHandler == null && ("BasicAuth".equals(this.authMethod) || "IDAssertion".equals(this.authMethod) && !"Signature".equals(this.trustMode))) {
            throw SoapSecurityException.format((String)"security.wssecurity.PrivateSenderConfig.s33");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate()");
        }
    }

    private boolean isNullOrZero(String str) {
        return str == null || str.length() == 0;
    }

    public SignatureSenderConfig getSignatureConfig() {
        return this.signatureSenderConfig;
    }

    public TokenSenderConfig getTokenConfig() {
        return this.tokenSenderConfig;
    }

    public EncryptionSenderConfig getEncryptionConfig() {
        return this.encryptionSenderConfig;
    }

    public TimestampSenderConfig getTimestampConfig() {
        return this.timestampSenderConfig;
    }

    public boolean getServiceGetMustUnderstand() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceGetMustUnderstand");
            Tr.exit(tc, "getServiceGetMustUnderstand=" + this.serviceGetMustUnderstand);
        }
        return this.serviceGetMustUnderstand;
    }

    public boolean getClientSetMustUnderstand() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientSetMustUnderstand");
            Tr.exit(tc, "getClientSetMustUnderstand=" + this.clientSetMustUnderstand);
        }
        return this.clientSetMustUnderstand;
    }

    public Map getProperties() {
        return this._properties;
    }

    public Object getProperty(Object property) {
        if (this._properties != null) {
            return this._properties.get(property);
        }
        return null;
    }

    protected String getLogProperties(Map defaultProps, Map bndParams, Map extProps, Map bndProps, String reqRespTypeIn, String genConTypeIn) {
        StringBuffer buf = new StringBuffer();
        String genConType = "";
        String reqRespType = "";
        if (genConTypeIn != null) {
            genConType = genConTypeIn;
        }
        if (reqRespTypeIn != null) {
            reqRespType = reqRespTypeIn;
        }
        buf.append("\nDefault properties: " + (defaultProps == null ? "null" : defaultProps.toString()));
        buf.append("\nApplication " + reqRespType + " " + genConType + " extension properties: " + (extProps == null ? "null" : extProps.toString()));
        buf.append("\nApplication binding parameters: " + (bndParams == null ? "null" : bndParams.toString()));
        buf.append("\nApplication " + reqRespType + " " + genConType + " binding properties: " + (bndProps == null ? "null" : bndProps.toString()));
        buf.append("\nCombined properties: " + this._properties);
        return buf.toString();
    }

    public String toString() {
        return this.getClass().getName() + "(" + "signatureSenderConfig=" + this.signatureSenderConfig + " tokenSenderConfig=" + this.tokenSenderConfig + " encryptionSenderConfig=" + this.encryptionSenderConfig + " properties=" + this._properties + ")";
    }
}

