/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.proxy.MessageContextProxy;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public abstract class Constants {
    private static final TraceComponent tc = Tr.register(Constants.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    public static final String NS_XMLNS = "http://www.w3.org/2000/xmlns/".intern();
    public static final String NS_WSSE200204 = "http://schemas.xmlsoap.org/ws/2002/04/secext".intern();
    public static final String NS_WSSE200207 = "http://schemas.xmlsoap.org/ws/2002/07/secext".intern();
    public static final String NS_WSSE = "http://schemas.xmlsoap.org/ws/2003/06/secext".intern();
    public static final String NS_WSU200207 = "http://schemas.xmlsoap.org/ws/2002/07/utility".intern();
    public static final String NS_WSU = "http://schemas.xmlsoap.org/ws/2003/06/utility".intern();
    public static final String NS_DSIG = "http://www.w3.org/2000/09/xmldsig#".intern();
    public static final String NS_ENC = "http://www.w3.org/2001/04/xmlenc#".intern();
    public static final String UNSUPPORTED_SECURITY_TOKEN_QNAME = "UnsupportedSecurityToken";
    public static final String UNSUPPORTED_ALGORITHM_QNAME = "UnsupportedAlgorithm";
    public static final String INVALID_SECURITY_QNAME = "InvalidSecurity";
    public static final String INVALID_SECURITY_TOKEN_QNAME = "InvalidSecurityToken";
    public static final String FAILED_AUTHENTICATION_QNAME = "FailedAuthentication";
    public static final String FAILED_CHECK_QNAME = "FailedCheck";
    public static final String SECURITY_TOKEN_UNAVAILABLE_QNAME = "SecurityTokenUnavailable";
    public static final String MESSAGE_EXPIRED_QNAME = "MessageExpired";
    public static final String PASSWORD_TEXT_SENT_QNAME = "PasswordText";
    public static final String PASSWORD_DIGEST_SENT_QNAME = "PasswordDigest";
    public static final String X509V3_SENT_QNAME = "X509v3";
    public static final String KERBEROSV5_TGT_SENT_QNAME = "Kerberosv5TGT";
    public static final String KERBEROSV5_ST_SENT_QNAME = "Kerberosv5ST";
    public static final String PKCS7_SENT_QNAME = "PKCS7";
    public static final String PKI_PATH_SENT_QNAME = "PKIPath";
    public static final String BASE64_BINARY_SENT_QNAME = "Base64Binary";
    public static final String HEX_BINARY_SENT_QNAME = "HexBinary";
    public static final String ITSHA1_SENT_QNAME = "ITSHA1";
    public static final String IT60SHA1_SENT_QNAME = "IT60SHA1";
    public static final String[][] NAMESPACES = new String[][]{{NS_WSSE, NS_WSSE200207, NS_WSSE200204}, {NS_WSU, NS_WSU200207}};
    public static final int INDEX_WSSE = 0;
    public static final int INDEX_WSU = 1;
    public static final String NS_SOAP = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String NS_CONFIG = null;
    public static final String NS_PRIVATECONFIG = "http://www.ibm.com/xml/soapsec/config";
    public static final String FN_SENDER_PRIVATE = "config/ibm-wssecurity-sender-private.xml";
    public static final String FN_RECEIVER_PRIVATE = "config/ibm-wssecurity-receiver-private.xml";
    public static final String FN_CONFIG_VALIDATION = "config/ibm-wssecurity-config-validation.xml";
    public static final String DSIG_EXCLUSIVE = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String DSIG_SIGPROPS = "http://www.w3.org/2000/09/xmldsig#SignatureProperties";
    public static final String DSIG_XPATH = "http://www.w3.org/TR/1999/REC-xpath-19991116";
    public static final String MES_CATALOG = "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity";
    public static final String COMPONENT_NAME = "security.wssecurity";
    public static final String REQUEST_CERT = "com.ibm.xml.soapsec.RequestCert";
    public static final String STR_ID = "IDAssertion";
    public static final String STR_BASIC = "BasicAuth";
    public static final String STR_SIG = "Signature";
    public static final String STR_USER = "Username";
    public static final String STR_DN = "DN";
    public static final String STR_X509 = "X509Certificate";
    public static final String PROPS_INTEROP_SENDER = "wssecurity-interop-sender";
    public static final QName PASSWORD_TEXT_RCVR = new QName(NS_WSSE, "PasswordText");
    public static final QName PASSWORD_DIGEST_RCVR = new QName(NS_WSSE, "PasswordDigest");
    public static final QName X509V3_RCVR = new QName(NS_WSSE, "X509v3");
    public static final QName KERBEROSV5_TGT_RCVR = new QName(NS_WSSE, "Kerberosv5TGT");
    public static final QName KERBEROSV5_ST_RCVR = new QName(NS_WSSE, "Kerberosv5ST");
    public static final QName PKCS7_RCVR = new QName(NS_WSSE, "PKCS7");
    public static final QName PKI_PATH_RCVR = new QName(NS_WSSE, "PKIPath");
    public static final QName BASE64_BINARY_RCVR = new QName(NS_WSSE, "Base64Binary");
    public static final QName HEX_BINARY_RCVR = new QName(NS_WSSE, "HexBinary");
    public static final QName ITSHA1_RCVR = new QName(NS_WSSE, "ITSHA1");
    public static final QName IT60SHA1_RCVR = new QName(NS_WSSE, "IT60SHA1");
    public static final String TARGET_ENDPOINT = "com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress";
    public static final String BASIC_AUTH_TOKEN = "com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.basicAuthToken";
    public static final String REQUEST_WSSE_NAMESPACE = "com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace";
    public static final String REQUEST_WSU_NAMESPACE = "com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace";
    public static final String NLS_MSG_FILE = "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity";
    public static final String TR_GROUP = "Web Services Security";
    private static final Set _WSSE_NAMESPACES = new HashSet(3);
    private static final Set _WSU_NAMESPACES = new HashSet(2);
    private static final Map _QNAMES = new HashMap(5);
    public static final String[] WSSEC_BINDING_PARAMS;

    public static String getWSSENS(MessageContextProxy messageContext) {
        String ns;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSSENS(MessageContextProxy)");
        }
        if ((ns = (String)messageContext.getConfig(REQUEST_WSSE_NAMESPACE)) == null || ns.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No WSSE namespace found in MessageContextProxy, use default");
            }
            ns = NS_WSSE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSSENS(MessageContextProxy) returns " + ns);
        }
        return ns;
    }

    public static String getWSUNS(MessageContextProxy messageContext) {
        String ns;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSUNS(MessageContextProxy)");
        }
        if ((ns = (String)messageContext.getConfig(REQUEST_WSU_NAMESPACE)) == null || ns.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No WSU namespace found in MessageContextProxy, use default");
            }
            ns = NS_WSU;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSUNS(MessageContextProxy) returns " + ns);
        }
        return ns;
    }

    public static String getWSSENS(Map context) {
        String ns;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSSENS(Map)");
        }
        if ((ns = (String)context.get(REQUEST_WSSE_NAMESPACE)) == null || ns.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No WSSE namespace found in context, use default");
            }
            ns = NS_WSSE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSSENS(Map) returns " + ns);
        }
        return ns;
    }

    public static String getWSUNS(Map context) {
        String ns;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSUNS(Map)");
        }
        if ((ns = (String)context.get(REQUEST_WSU_NAMESPACE)) == null || ns.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No WSU namespace found in context, use default");
            }
            ns = NS_WSU;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSUNS(Map) returns " + ns);
        }
        return ns;
    }

    public static QName getQName(String ns, String qName) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQName(" + ns + ", " + qName + ")");
        }
        if (ns == null || ns.length() == 0) {
            throw SoapSecurityException.format((String)"security.wssecurity.WSEC6718E");
        }
        Map qns = (Map)_QNAMES.get(ns);
        if (qns == null || qns.isEmpty()) {
            throw SoapSecurityException.format((String)"security.wssecurity.WSEC6719E", (String)(ns + qName));
        }
        QName q = (QName)qns.get(qName);
        if (q == null) {
            throw SoapSecurityException.format((String)"security.wssecurity.WSEC6719E", (String)(ns + qName));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getQName() returns " + q);
        }
        return q;
    }

    private static Map createWSSEQNames(String ns) {
        HashMap<String, QName> ret = new HashMap<String, QName>(32);
        ret.put(UNSUPPORTED_SECURITY_TOKEN_QNAME, new QName(ns, UNSUPPORTED_SECURITY_TOKEN_QNAME));
        ret.put(UNSUPPORTED_ALGORITHM_QNAME, new QName(ns, UNSUPPORTED_ALGORITHM_QNAME));
        ret.put(INVALID_SECURITY_QNAME, new QName(ns, INVALID_SECURITY_QNAME));
        ret.put(INVALID_SECURITY_TOKEN_QNAME, new QName(ns, INVALID_SECURITY_TOKEN_QNAME));
        ret.put(FAILED_AUTHENTICATION_QNAME, new QName(ns, FAILED_AUTHENTICATION_QNAME));
        ret.put(FAILED_CHECK_QNAME, new QName(ns, FAILED_CHECK_QNAME));
        ret.put(SECURITY_TOKEN_UNAVAILABLE_QNAME, new QName(ns, SECURITY_TOKEN_UNAVAILABLE_QNAME));
        ret.put(PASSWORD_TEXT_SENT_QNAME, new QName(ns, PASSWORD_TEXT_SENT_QNAME));
        ret.put(PASSWORD_DIGEST_SENT_QNAME, new QName(ns, PASSWORD_DIGEST_SENT_QNAME));
        ret.put(X509V3_SENT_QNAME, new QName(ns, X509V3_SENT_QNAME));
        ret.put(KERBEROSV5_TGT_SENT_QNAME, new QName(ns, KERBEROSV5_TGT_SENT_QNAME));
        ret.put(KERBEROSV5_ST_SENT_QNAME, new QName(ns, KERBEROSV5_ST_SENT_QNAME));
        ret.put(PKCS7_SENT_QNAME, new QName(ns, PKCS7_SENT_QNAME));
        ret.put(PKI_PATH_SENT_QNAME, new QName(ns, PKI_PATH_SENT_QNAME));
        ret.put(BASE64_BINARY_SENT_QNAME, new QName(ns, BASE64_BINARY_SENT_QNAME));
        ret.put(HEX_BINARY_SENT_QNAME, new QName(ns, HEX_BINARY_SENT_QNAME));
        ret.put(ITSHA1_SENT_QNAME, new QName(ns, ITSHA1_SENT_QNAME));
        ret.put(IT60SHA1_SENT_QNAME, new QName(ns, IT60SHA1_SENT_QNAME));
        return ret;
    }

    private static Map createWSUQNames(String ns) {
        HashMap<String, QName> ret = new HashMap<String, QName>(1);
        ret.put(MESSAGE_EXPIRED_QNAME, new QName(ns, MESSAGE_EXPIRED_QNAME));
        return ret;
    }

    private static void init() {
        _WSSE_NAMESPACES.add(NS_WSSE);
        _WSSE_NAMESPACES.add(NS_WSSE200207);
        _WSSE_NAMESPACES.add(NS_WSSE200207);
        _WSU_NAMESPACES.add(NS_WSU);
        _WSU_NAMESPACES.add(NS_WSU200207);
        _QNAMES.put(NS_WSSE, Constants.createWSSEQNames(NS_WSSE));
        _QNAMES.put(NS_WSSE200207, Constants.createWSSEQNames(NS_WSSE200207));
        _QNAMES.put(NS_WSSE200207, Constants.createWSSEQNames(NS_WSSE200207));
        _QNAMES.put(NS_WSU, Constants.createWSUQNames(NS_WSU));
        _QNAMES.put(NS_WSU200207, Constants.createWSUQNames(NS_WSU200207));
    }

    static {
        Constants.init();
        WSSEC_BINDING_PARAMS = new String[]{"com.ibm.wsspi.wssecurity.config.disableWSSIfApplicationSecurityDisabled"};
    }
}

