/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.security.tai;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import javax.security.auth.Subject;

public final class TAIResult {
    private int status;
    private String principal;
    private Subject subject;
    private static final TraceComponent tc = Tr.register(TAIResult.class, null, "com.ibm.ejs.resources.security");

    public static TAIResult create(int status, String principal, Subject subject) throws WebTrustAssociationFailedException {
        return new TAIResult(status, principal, subject);
    }

    public static TAIResult create(int status, String principal) throws WebTrustAssociationFailedException {
        return new TAIResult(status, principal, null);
    }

    public static TAIResult create(int status) throws WebTrustAssociationFailedException {
        return new TAIResult(status, null, null);
    }

    public final int getStatus() {
        return this.status;
    }

    public final String getAuthenticatedPrincipal() {
        return this.principal;
    }

    public final Subject getSubject() {
        return this.subject;
    }

    private TAIResult(int status, String principal, Subject subject) throws WebTrustAssociationFailedException {
        this.init(status, principal, subject);
    }

    private void init(int status, String principal, Subject subject) throws WebTrustAssociationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(" + status + ", " + principal + ", " + (subject == null ? "null" : "subject"));
        }
        if (status == 200 && (principal == null || principal.length() == 0)) {
            throw new WebTrustAssociationFailedException("No principal in Trust Association Result");
        }
        this.status = status;
        this.principal = principal;
        this.subject = subject;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }
}

