/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.runtime.provisioning;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.provisioning.ComponentInfo;
import com.ibm.wsspi.runtime.provisioning.ComponentInfoFactory;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerActivationHelper {
    private static final TraceComponent tc = Tr.register(ServerActivationHelper.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private static String serverType;
    private static String processType;
    public static final String MANAGED_PROCESS = "managed";
    public static final String UNMANAGED_PROCESS = "unmanaged";

    public static String getProcessType() throws RuntimeError {
        if (processType == null) {
            ServerActivationHelper.retrieveProcessType();
        }
        return processType;
    }

    public static String getServerType() throws RuntimeError {
        if (serverType == null) {
            ServerActivationHelper.retrieveServerType();
        }
        return serverType;
    }

    private static void retrieveServerType() throws RuntimeError {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveServerType()");
        }
        try {
            ConfigService configService = WsServiceRegistry.getService(ServerActivationHelper.class, ConfigService.class);
            String currentServerName = configService.getServerName();
            List list = configService.getDocumentObjects(configService.getScope(3), "serverindex.xml");
            ConfigObject configObject = (ConfigObject)list.get(0);
            List serverEntries = configObject.getObjectList("serverEntries");
            if (serverEntries == null) {
                throw new RuntimeError("No serverEntries in serverindex.xml");
            }
            for (ConfigObject serverEntry : serverEntries) {
                String serverName = serverEntry.getString("serverName", "__null__");
                if (!serverName.equals(currentServerName)) continue;
                serverType = serverEntry.getString("serverType", "__null__");
            }
            if (serverType == null) {
                throw new RuntimeError("No serverType found for current server");
            }
        }
        catch (Exception e) {
            throw new RuntimeError("Exception caught while retrieving server type", e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveServerType()");
        }
    }

    private static String retrieveProcessType() throws RuntimeError {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveProcessType()");
        }
        try {
            ConfigService configService = WsServiceRegistry.getService(ServerActivationHelper.class, ConfigService.class);
            List list = configService.getDocumentObjects(configService.getScope(4), "server.xml");
            ConfigObject serverObject = (ConfigObject)list.get(0);
            List services = serverObject.getObjectList("services");
            for (ConfigObject service : services) {
                if (!service.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/adminservice.xmi", "AdminService")) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "found AdminService");
                }
                boolean standalone = service.getBoolean("standalone", true);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "standalone - " + standalone);
                }
                processType = standalone ? UNMANAGED_PROCESS : MANAGED_PROCESS;
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeError("Exception received while retrieving process type", e);
        }
        if (processType == null) {
            throw new RuntimeError("Unable to retrieve process type");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveProcessType()");
        }
        return processType;
    }

    public static List<ComponentInfo> getComponents(String extensionPointId) throws RuntimeError {
        IExtensionRegistry registry;
        IExtensionPoint extensionPoint;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getComponents", new Object[]{extensionPointId});
        }
        String currentProcessType = ServerActivationHelper.getProcessType();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "currentProcessType - " + currentProcessType);
        }
        if ((extensionPoint = (registry = ExtensionRegistryFactory.instance().getExtensionRegistry()).getExtensionPoint(extensionPointId)) == null) {
            throw new RuntimeError("Unable to find extension point " + extensionPointId);
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing extension point - " + extensionPointId + " in bundle " + extensionPoint.getNamespaceIdentifier());
                Tr.debug(tc, "   found " + extensions.length + " extensions");
            }
        } else {
            return null;
        }
        ArrayList<ComponentInfo> componentList = new ArrayList<ComponentInfo>();
        for (int i = 0; i < extensions.length; ++i) {
            IConfigurationElement[] componentsElements;
            IExtension extension = extensions[i];
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "extension found for extension id - " + extension.getUniqueIdentifier() + " in bundle " + extension.getNamespaceIdentifier());
            }
            if ((componentsElements = extension.getConfigurationElements()).length != 1) {
                throw new RuntimeError("Invalid number of <components> elements found - " + componentsElements.length);
            }
            IConfigurationElement componentsElement = componentsElements[0];
            IConfigurationElement[] componentElements = componentsElement.getChildren();
            for (int j = 0; j < componentElements.length; ++j) {
                IConfigurationElement componentElement = componentElements[j];
                String processType = componentElement.getAttribute("processType");
                if (processType != null && !processType.equalsIgnoreCase(MANAGED_PROCESS) && !processType.equalsIgnoreCase(UNMANAGED_PROCESS)) {
                    throw new RuntimeError("Invalid value for processType - " + processType);
                }
                if (processType != null && !processType.equalsIgnoreCase(currentProcessType)) continue;
                String componentId = componentElement.getAttribute("id");
                if (componentId == null) {
                    throw new RuntimeError("missing attribute - id");
                }
                String componentVersion = componentElement.getAttribute("version");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding component with componentId " + componentId + " and version " + componentVersion);
                }
                ComponentInfo component = componentVersion == null ? ComponentInfoFactory.createComponentInfo(componentId) : ComponentInfoFactory.createComponentInfo(componentId, componentVersion);
                componentList.add(component);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Exit ServerActivationHelper.getComponents()");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getComponents");
        }
        return componentList;
    }
}

