/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.metadata;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollectorManager;
import com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollectorManagerFactory;
import java.util.Properties;

public class ProfileActionProcessor {
    private String _actionParamProfileType;
    private String _extensionID;
    private String[] _profileType;
    private String _traceFileName;

    public ProfileActionProcessor(String actionParamProfileType, String extensionID, String[] profileType, String traceFileName) {
        this._actionParamProfileType = actionParamProfileType;
        this._extensionID = extensionID;
        this._profileType = profileType;
        this._traceFileName = traceFileName;
    }

    public void collectManagedObjectMetadata(String[] args) throws Exception {
        String traceString = null;
        boolean add = false;
        boolean remove = false;
        boolean profileTypeRequired = false;
        String profileType = null;
        try {
            ManagedObjectMetadataCollectorManager manager;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-traceString")) {
                    traceString = i < args.length - 1 && !args[i + 1].startsWith("-") ? args[++i] : "com.ibm.*=all=enabled";
                } else if (args[i].equals("-add")) {
                    add = true;
                    profileTypeRequired = true;
                } else if (args[i].equals("-remove")) {
                    remove = true;
                    profileTypeRequired = true;
                }
                if (add && remove) {
                    throw new AdminException("Adding and removing the node metadata can not be performed at the same time in a profile augmentation action");
                }
                if (!profileTypeRequired) continue;
                if (i < args.length - 1) {
                    if ((profileType = args[++i]).startsWith("-")) {
                        throw new AdminException("Command syntax error.  Invalid profile type: " + profileType);
                    }
                    boolean match = false;
                    for (int j = 0; j < this._profileType.length; ++j) {
                        if (!profileType.equals(this._profileType[j])) continue;
                        match = true;
                        profileTypeRequired = false;
                        break;
                    }
                    if (match) continue;
                    throw new AdminException("Command syntax error.  Unrecognized profile type: " + profileType);
                }
                throw new AdminException("Command syntax error.  No profile type specified.");
            }
            if (traceString != null) {
                try {
                    ManagerAdmin.configureClientTrace(traceString, (String)"named file", (String)this._traceFileName, (boolean)false, (String)"basic", (boolean)false);
                    System.out.println("Trace enabled.  Writing to log file \"" + this._traceFileName + "\".");
                }
                catch (Exception e) {
                    System.out.println("Trace setup failed.");
                    e.printStackTrace();
                }
            }
            if ((manager = ManagedObjectMetadataCollectorManagerFactory.createCollectorManager(null)) == null) {
                throw new AdminException("Could not initialize ManagedObjectMetadataCollector");
            }
            if (add) {
                System.out.println("ACTION: Add to profile. ");
                Properties actionParams = new Properties();
                actionParams.setProperty("param.action.extension.id", this._extensionID);
                actionParams.setProperty(this._actionParamProfileType, profileType);
                manager.updateMetadata("Add Extension", actionParams);
            }
            if (remove) {
                System.out.println("ACTION: Remove from profile.");
                Properties actionParams = new Properties();
                actionParams.setProperty("param.action.extension.id", this._extensionID);
                actionParams.setProperty(this._actionParamProfileType, profileType);
                manager.updateMetadata("Remove Extension", actionParams);
            } else {
                System.out.println("ACTION: Collect");
                Properties collectedProps = manager.updateMetadata("Collect Metadata", null);
                System.out.println(collectedProps.toString());
            }
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("ProfileActionProcessor.collectManagedObjectMetadata(): Metadata collection failed.");
            e.printStackTrace();
            throw e;
        }
    }
}

