/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.commands.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.wsspi.management.commands.server.ServerCommandBase;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class CreateServer
extends ServerCommandBase {
    private static TraceComponent tc = Tr.register(CreateServer.class, "CreateServer", "com.ibm.wsspi.management.commands.server");
    private ObjectName matchTemplate = null;
    private String serverTypeSave = null;
    private static String JVM_Mode_64 = "64bit";
    private static String JVM_Mode_31 = "31bit";

    public CreateServer(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateServer(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    protected void taskCommandExecuted(boolean success) {
        block5: {
            if (!success) {
                ConfigService configService = ConfigServiceFactory.getConfigService();
                Session session = this.getConfigSession();
                try {
                    ObjectName createdServer = (ObjectName)this.getCommandResult().getResult();
                    if (createdServer == null) break block5;
                    if (configService != null) {
                        configService.deleteConfigData(session, createdServer);
                        break block5;
                    }
                    String errMsg = "Cannot delete config data: no config service created yet for this process";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "taskCommandExecuted", errMsg);
                    }
                    throw new ConfigServiceException(errMsg);
                }
                catch (Exception ex) {
                    Manager.Ffdc.log(ex, this, "com.ibm.wsspi.management.commands.server.CreateServer.taskCommandExecuted", "86");
                }
            }
        }
    }

    public void beforeStepsExecuted() {
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        try {
            ObjectName server2;
            block57: {
                Method method;
                String bitmode;
                String serverName;
                String nodeName;
                Session session;
                block56: {
                    ConfigService configService;
                    block55: {
                        String serverType;
                        configService = ConfigServiceFactory.getConfigService();
                        if (configService == null) {
                            String errMsg = "No config service created yet for this process";
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "beforeStepsExecuted", errMsg);
                            }
                            throw new ConfigServiceException(errMsg);
                        }
                        session = this.getConfigSession();
                        nodeName = (String)this.getTargetObject();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Node Name: " + nodeName);
                        }
                        serverName = (String)this.getParameter("name");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Server Name: " + serverName);
                        }
                        if ((serverType = this.serverTypeSave) == null) {
                            this.serverTypeSave = serverType = this.getServerType(nodeName);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Server Type: " + serverType);
                        }
                        String genericShortName = (String)this.getParameter("genericShortName");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Generic Short Name: " + genericShortName);
                        }
                        if (genericShortName != null && !CreateServer.isShortNameValid(genericShortName, this.getName())) {
                            throw new InvalidParameterValueException(this.getName(), "genericShortName", genericShortName);
                        }
                        String specificShortName = (String)this.getParameter("specificShortName");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Specific Short Name: " + specificShortName);
                        }
                        if (specificShortName != null && !CreateServer.isShortNameValid(specificShortName, this.getName())) {
                            throw new InvalidParameterValueException(this.getName(), "specificShortName", specificShortName);
                        }
                        if (AdminHelper.getPlatformHelper().isZOS() && !CreateServer.checkshortNameZOS(session, specificShortName, false)) {
                            throw new InvalidParameterValueException(this.getName(), "specificShortName", specificShortName);
                        }
                        boolean bitmode64Valid = false;
                        String nodeVersion = this.metadataHelper.getNodeBaseProductVersion(nodeName);
                        if (nodeVersion.startsWith("6.1")) {
                            int compare = this.metadataHelper.compareNodeVersion(nodeName, "6.1.0.4");
                            if (compare >= 0) {
                                bitmode64Valid = true;
                            }
                        } else {
                            bitmode64Valid = !nodeVersion.startsWith("6.0") && !nodeVersion.startsWith("5");
                        }
                        bitmode = (String)this.getParameter("bitmode");
                        if (bitmode != null) {
                            if (bitmode.equals("64")) {
                                bitmode = JVM_Mode_64;
                            } else if (bitmode.equals("31")) {
                                bitmode = JVM_Mode_31;
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "bitmode: " + bitmode);
                        }
                        if (bitmode == null && bitmode64Valid) {
                            bitmode = JVM_Mode_64;
                        } else if (bitmode == null) {
                            bitmode = JVM_Mode_31;
                        } else {
                            if (!JVM_Mode_31.equals(bitmode) && !JVM_Mode_64.equals(bitmode)) {
                                throw new InvalidParameterValueException(this.getName(), "bitmode", bitmode);
                            }
                            if (JVM_Mode_64.equals(bitmode) && !bitmode64Valid) {
                                throw new InvalidParameterValueException(this.getName(), "bitmode", bitmode);
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "bitmode" + bitmode);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, " use Template:" + this.matchTemplate);
                        }
                        Boolean gen = (Boolean)this.getParameter("genUniquePorts");
                        boolean genUnique = true;
                        if (gen != null) {
                            genUnique = gen;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Generate Unique Ports: " + genUnique);
                        }
                        ObjectName[] queryResult = configService.resolve(session, "Node=" + nodeName);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Result from ConfigService: " + queryResult);
                        }
                        if (queryResult.length == 0) {
                            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0250E", new Object[]{nodeName}, null);
                            throw new ConfigServiceException(msg);
                        }
                        server2 = null;
                        try {
                            Method method2 = this.implClass.getMethod("createServer", Session.class, ObjectName.class, String.class, ObjectName.class, Boolean.TYPE);
                            server2 = (ObjectName)method2.invoke(null, this.getConfigSession(), queryResult[0], serverName, this.matchTemplate, genUnique ? Boolean.TRUE : Boolean.FALSE);
                            method2 = this.templateConfigHelperClass.getMethod("updateTemplateMetadata", ConfigService.class, Session.class, ObjectName.class, String.class);
                            method2.invoke(null, configService, this.getConfigSession(), server2, serverName);
                        }
                        catch (InvocationTargetException ex) {
                            throw ex.getTargetException();
                        }
                        try {
                            if (specificShortName != null) {
                                this.changeServerSpecificShortName(configService, session, serverName, nodeName, specificShortName);
                            }
                            if (genericShortName != null) {
                                this.changeServerGenericShortName(configService, session, serverName, nodeName, genericShortName);
                            }
                        }
                        catch (Throwable e) {
                            if (server2 == null) break block55;
                            try {
                                method = this.implClass.getMethod("deleteServer", Session.class, String.class, String.class);
                                method.invoke(null, session, nodeName, serverName);
                            }
                            catch (InvocationTargetException ex) {
                                throw ex.getTargetException();
                            }
                        }
                    }
                    if (System.getProperty("os.name").equals("OS/400")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "os.name is " + System.getProperty("os.name"));
                        }
                        try {
                            this.updateIPv6(configService, session, server2);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (!tc.isDebugEnabled()) break block56;
                            Tr.debug(tc, "Exception caught updating server for IPv6", e);
                        }
                    }
                }
                try {
                    if (this.metadataHelper.isNodeZOS(nodeName)) {
                        String nodeVer = this.metadataHelper.getNodeBaseProductVersion(nodeName);
                        if (!JVM_Mode_64.equals(bitmode) || !nodeVer.startsWith("7")) {
                            CommandMgr cmdMgr = CommandMgr.getCommandMgr();
                            AdminCommand cmd = cmdMgr.createCommand("setJVMMode");
                            cmd.setConfigSession(session);
                            cmd.setParameter("serverName", serverName);
                            cmd.setParameter("nodeName", nodeName);
                            cmd.setParameter("mode", bitmode);
                            cmd.execute();
                            CommandResult result2 = cmd.getCommandResult();
                            if (!result2.isSuccessful()) {
                                Throwable th = result.getException();
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "setJVMMode", new Object[]{th});
                                }
                                throw new ConfigServiceException(th);
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    if (server2 == null) break block57;
                    try {
                        method = this.implClass.getMethod("deleteServer", Session.class, String.class, String.class);
                        method.invoke(null, session, nodeName, serverName);
                    }
                    catch (InvocationTargetException ex) {
                        throw ex.getTargetException();
                    }
                }
            }
            result.setResult(server2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "server created", server2);
            }
        }
        catch (Throwable ex) {
            result.setException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private void updateIPv6(ConfigService configService, Session session, ObjectName server2) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "determine if property fix required for IPv6 on i5/OS");
            Tr.debug(tc, "os.version is " + System.getProperty("os.version"));
        }
        if (System.getProperty("os.version").startsWith("V5R4")) {
            String preferIPv4 = System.getProperty("java.net.preferIPv4Stack");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "value of java.net.preferIPv4Stack system property is " + preferIPv4);
            }
            if (preferIPv4 != null && preferIPv4.equals("false")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "add IPv6 system property to server");
                }
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "JavaProcessDef");
                ObjectName processDef = configService.queryConfigObjects(session, server2, pattern, null)[0];
                AttributeList value2 = configService.getAttributes(session, processDef, new String[]{"jvmEntries"}, false);
                ObjectName jvmEntries = (ObjectName)((List)ConfigServiceHelper.getAttributeValue(value2, "jvmEntries")).get(0);
                AttributeList attrList = new AttributeList();
                ConfigServiceHelper.setAttributeValue(attrList, "name", "java.net.preferIPv4Stack");
                ConfigServiceHelper.setAttributeValue(attrList, "value", "false");
                ObjectName prop = configService.createConfigData(session, jvmEntries, "systemProperties", "Property", attrList);
            }
        }
    }

    private String getServerType(String nodeName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerType");
        }
        String serverType = null;
        CommandMgr cmdMgr = CommandMgr.getCommandMgr();
        AdminCommand listServerTypesCmd = cmdMgr.createCommand("listServerTypes");
        listServerTypesCmd.setConfigSession(this.getConfigSession());
        listServerTypesCmd.setTargetObject(nodeName);
        listServerTypesCmd.execute();
        List serverTypes = (List)listServerTypesCmd.getCommandResult().getResult();
        String commandName = this.getCommandMetadata().getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "commandName", commandName);
        }
        for (String thisServerType : serverTypes) {
            AdminCommand showServerTypeInfoCmd = cmdMgr.createCommand("showServerTypeInfo");
            showServerTypeInfoCmd.setConfigSession(this.getConfigSession());
            showServerTypeInfoCmd.setTargetObject(thisServerType);
            showServerTypeInfoCmd.execute();
            AttributeList serverTypeInfo = (AttributeList)showServerTypeInfoCmd.getCommandResult().getResult();
            Object createCommandName = ConfigServiceHelper.getAttributeValue(serverTypeInfo, "createCommand");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createCommandName", createCommandName);
            }
            if (!commandName.equals(createCommandName)) continue;
            serverType = thisServerType;
            break;
        }
        if (serverType == null) {
            Manager.Ffdc.log(new Exception(), this, "com.ibm.ws.management.commands.server.CreateServer.getServerType", "208");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerType", serverType);
        }
        return serverType;
    }

    protected List getTemplates(boolean all) {
        List templates;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getTemplate, " + all);
            }
            templates = Collections.EMPTY_LIST;
            try {
                String nodeVersion;
                Session session = this.getConfigSession();
                String nodeName = (String)this.getTargetObject();
                String templateName = (String)this.getParameter("templateName");
                String serverType = this.serverTypeSave;
                if (serverType == null) {
                    this.serverTypeSave = serverType = this.getServerType(nodeName);
                }
                String[] queryExp = null;
                queryExp = !all ? new String[3] : new String[2];
                boolean isZOS = this.metadataHelper.isNodeZOS(nodeName);
                if (isZOS) {
                    queryExp[0] = "com.ibm.websphere.nodeOperatingSystem=os390";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ZOS Platform Query", queryExp);
                    }
                } else {
                    queryExp[0] = "com.ibm.websphere.nodeOperatingSystem!=os390";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Distributed Platform Query", queryExp);
                    }
                }
                if (!all) {
                    queryExp[1] = templateName == null || templateName.equals("") ? "isDefaultTemplate=true" : "name=" + templateName;
                }
                nodeVersion = (nodeVersion = this.metadataHelper.getNodeBaseProductVersion(nodeName)).startsWith("6.1") ? "6.1" : this.metadataHelper.getNodeMajorVersion(nodeName);
                if (!all) {
                    queryExp[2] = "com.ibm.websphere.baseProductMajorVersion=" + nodeVersion;
                } else {
                    queryExp[1] = "com.ibm.websphere.baseProductMajorVersion=" + nodeVersion;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server template query expressions = ", queryExp);
                }
                templates = this.listServerTemplates(serverType, queryExp, nodeName);
            }
            catch (Throwable ex) {
                Manager.Ffdc.log(ex, this, "com.ibm.wsspi.management.commands.server.CreateServer.taskCommandExecuted", "268");
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug(tc, "Exception occured during getChoices", ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTemplate", templates);
        }
        return templates;
    }

    public Object[] getChoices(String paramName) {
        final String paramNameFinal = paramName;
        Object[] matches = null;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            matches = (Object[])ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Object[] names = CreateServer.this.getChoicesAsSystem(paramNameFinal);
                    return names;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            matches = null;
        }
        catch (Exception e) {
            matches = null;
        }
        return matches;
    }

    public Object[] getChoicesAsSystem(String paramName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChoices", paramName);
        }
        String[] result = null;
        if (paramName.equals("templateName")) {
            List templates = this.getTemplates(true);
            result = new String[templates.size()];
            for (int i = 0; i < templates.size(); ++i) {
                ObjectName template = (ObjectName)templates.get(i);
                result[i] = ConfigServiceHelper.getDisplayName(template);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChoices", result);
        }
        return result;
    }

    public void validate() throws CommandValidationException {
        String bitmode;
        Object gen;
        String nodeName;
        block47: {
            String msg;
            String node;
            Properties location;
            String nodeName2;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate, ");
            }
            super.validate();
            ConfigService configService = ConfigServiceFactory.getConfigService();
            if (configService == null) {
                String errMsg = "No config service created yet for this process";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "validate", errMsg);
                }
                ConfigServiceException cse = new ConfigServiceException(errMsg);
                throw new CommandValidationException(cse, "Cannot validate the command parameters.");
            }
            Session session = this.getConfigSession();
            ObjectName[] cellManagers = null;
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "CellManager");
            try {
                cellManagers = configService.queryConfigObjects(session, null, pattern, null);
            }
            catch (ConfigServiceException cse) {
            }
            catch (ConnectorException ce) {
                // empty catch block
            }
            if (cellManagers != null && cellManagers.length > 0 && (nodeName2 = (location = ConfigServiceHelper.getObjectLocation(cellManagers[0])).getProperty("node")) != null && (node = (String)this.getTargetObject()) != null && nodeName2.equals(node)) {
                String msg2 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0250E", new Object[]{nodeName2}, null);
                throw new CommandValidationException(msg2);
            }
            nodeName = (String)this.getTargetObject();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Node Name: " + nodeName);
            }
            try {
                ObjectName[] queryResult = configService.resolve(session, "Node=" + nodeName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Result from ConfigService: " + queryResult);
                }
                if (queryResult.length == 0) {
                    msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0250E", new Object[]{nodeName}, null);
                    throw new CommandValidationException(msg);
                }
            }
            catch (ConfigServiceException cse) {
                msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0254E", new Object[]{cse}, null);
                throw new CommandValidationException(cse, msg);
            }
            catch (ConnectorException ce) {
                msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0254E", new Object[]{ce}, null);
                throw new CommandValidationException(ce, msg);
            }
            String serverName = (String)this.getParameter("name");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server Name: " + serverName);
            }
            if (serverName.length() == 0) {
                msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0247E", new Object[]{serverName}, null);
                throw new CommandValidationException(msg);
            }
            boolean serverValid = ConfigServiceHelper.checkIfNameValid(serverName.trim());
            if (!serverValid) {
                String msg3 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0249E", new Object[]{serverName}, null);
                throw new CommandValidationException(msg3);
            }
            try {
                ObjectName[] serverResult = configService.resolve(session, "Node=" + nodeName + ":Server=" + serverName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Result from ConfigService: " + serverResult);
                }
                if (serverResult.length != 0) {
                    String msg4 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0248E", new Object[]{serverName, nodeName}, null);
                    throw new CommandValidationException(msg4);
                }
            }
            catch (ConfigServiceException cse) {
                String msg5 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0254E", new Object[]{cse}, null);
                throw new CommandValidationException(cse, msg5);
            }
            catch (ConnectorException ce) {
                String msg6 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0254E", new Object[]{ce}, null);
                throw new CommandValidationException(ce, msg6);
            }
            List templates = null;
            String templateName = (String)this.getParameter("templateName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Template Name: " + templateName);
            }
            this.matchTemplate = null;
            ObjectName templateLocation = (ObjectName)this.getParameter("templateLocation");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "templateLocation", templateLocation);
            }
            templates = templateLocation != null ? this.getTemplate(templateLocation, templateName) : this.getTemplates(false);
            int lastNum = 0;
            for (int i = 0; templates != null && i < templates.size(); ++i) {
                int num = this.getMatchCount((ObjectName)templates.get(i), nodeName);
                if (num < lastNum) continue;
                lastNum = num;
                this.matchTemplate = (ObjectName)templates.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found matching template", this.matchTemplate);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "found matching template", new Integer(lastNum));
            }
            if (templateName != null || templateLocation != null) {
                try {
                    if (this.serverTypeSave == null) {
                        this.serverTypeSave = this.getServerType(nodeName);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                int num = this.getDefaultTemplateMatchCount(this.serverTypeSave, nodeName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "match count ", new Integer(lastNum) + " " + new Integer(num));
                }
                if (num > lastNum) {
                    this.matchTemplate = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "no matching template", new Integer(num) + " " + new Integer(lastNum));
                    }
                }
            }
            if (templates == null || templates.size() == 0 || this.matchTemplate == null) {
                if (null != templateName) {
                    String msg7 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0253E", new Object[]{templateName}, null);
                    throw new CommandValidationException(msg7);
                }
                String msg8 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0247I", new Object[]{nodeName}, null);
                throw new CommandValidationException(msg8);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " matchTemplate", this.matchTemplate);
            }
            if (templateName != null && templateName.length() != 0) {
                try {
                    Method method = this.templateConfigHelperClass.getMethod("checkIfTemplateDeprecated", ConfigService.class, Session.class, ObjectName.class);
                    method.invoke(null, configService, this.getConfigSession(), this.matchTemplate);
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block47;
                    Tr.debug(tc, "check for a deprecated template with an exception: " + e);
                }
            }
        }
        if ((gen = this.getParameter("genUniquePorts")) != null && gen instanceof Boolean) {
            boolean genUnique = true;
            if (gen != null) {
                genUnique = (Boolean)gen;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Generate Unique Ports: " + genUnique);
            }
        }
        if ((bitmode = (String)this.getParameter("bitmode")) != null && bitmode.trim().length() > 0) {
            boolean validForBitmode;
            block48: {
                validForBitmode = false;
                try {
                    if (this.serverTypeSave == null) {
                        this.serverTypeSave = this.getServerType(nodeName);
                    }
                    if ("APPLICATION_SERVER".equals(this.serverTypeSave) || "NODE_AGENT".equals(this.serverTypeSave) || "DEPLOYMENT_MANAGER".equals(this.serverTypeSave) || "PROXY_SERVER".equals(this.serverTypeSave) || "ONDEMAND_ROUTER".equals(this.serverTypeSave)) {
                        validForBitmode = true;
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block48;
                    Tr.debug(tc, "Exception validating bit mode: ", e);
                }
            }
            if (!validForBitmode) {
                throw new CommandValidationException("Invalid ServerType: " + this.serverTypeSave + " for bitmode parm");
            }
        }
    }

    private void changeServerSpecificShortName(ConfigService cs, Session session, String serverName, String nodeName, String specificShortName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeServerSpecificShortName", specificShortName);
        }
        CommandMgr cmdMgr = CommandMgr.getCommandMgr();
        AdminCommand cmd = cmdMgr.createCommand("changeServerSpecificShortName");
        cmd.setConfigSession(session);
        cmd.setParameter("nodeName", nodeName);
        cmd.setParameter("serverName", serverName);
        cmd.setParameter("specificShortName", specificShortName);
        cmd.execute();
        CommandResult res = cmd.getCommandResult();
        if (!res.isSuccessful()) {
            Object errMsg = res.getResult();
            if (errMsg != null && errMsg instanceof String) {
                throw new Exception((String)errMsg, res.getException());
            }
            throw new Exception(res.getException());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeServerSpecificShortName", specificShortName);
        }
    }

    private void changeServerGenericShortName(ConfigService cs, Session session, String serverName, String nodeName, String genericShortName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeServerGenericShortName", genericShortName);
        }
        try {
            CommandMgr cmdMgr = CommandMgr.getCommandMgr();
            AdminCommand cmd = cmdMgr.createCommand("changeServerGenericShortName");
            cmd.setConfigSession(session);
            cmd.setParameter("nodeName", nodeName);
            cmd.setParameter("serverName", serverName);
            cmd.setParameter("genericShortName", genericShortName);
            cmd.execute();
            CommandResult res = cmd.getCommandResult();
            if (!res.isSuccessful()) {
                Object errMsg = res.getResult();
                if (errMsg != null && errMsg instanceof String) {
                    throw new Exception((String)errMsg, res.getException());
                }
                throw new Exception(res.getException());
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeServerGenericShortName", genericShortName);
        }
    }

    public static boolean isShortNameValid(String shortName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isShortNameValid " + shortName);
        }
        boolean result = true;
        if (shortName == null || shortName.length() == 0) {
            result = true;
        } else if (shortName.length() > 8) {
            result = false;
        }
        if (result) {
            for (int i = 0; shortName != null && i < shortName.length(); ++i) {
                char ch = shortName.charAt(i);
                if (i == 0 && Character.isDigit(ch)) {
                    result = false;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "First letter is digit " + shortName);
                    break;
                }
                if (!Character.isLetterOrDigit(ch)) {
                    result = false;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "shortname is not letter or digit " + shortName);
                    break;
                }
                if (!Character.isLetter(ch) || Character.isUpperCase(ch)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "shortname is not uppercase letter " + shortName);
                }
                result = false;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isShortNameValid " + new Boolean(result));
        }
        return result;
    }

    public static boolean isClusterShortNameValid(String shortName) {
        boolean retValue;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isClusterShortNameValid " + shortName);
        }
        if (retValue = CreateServer.isShortNameValid(shortName)) {
            retValue = CreateServer.checkshortNameZOS(null, shortName, true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isClusterShortNameValid " + retValue);
        }
        return retValue;
    }

    public static boolean isShortNameValid(String shortName, String cmdName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isShortNameValid", shortName + " " + cmdName);
        }
        boolean result = true;
        result = !cmdName.equals("createApplicationServer") && !cmdName.equals("createProxyServer") && !cmdName.equals("createOnDemandRouter") ? false : CreateServer.isShortNameValid(shortName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isShortNameValid", new Boolean(result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkshortNameZOS(Session session, String shortName, boolean clusterCheck) {
        boolean discardSession = false;
        boolean retValue = true;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkserverShortNameZOS,", retValue);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "shortName=" + shortName);
        }
        if (null != shortName && !shortName.trim().equals("")) {
            if (null == session) {
                discardSession = true;
                session = new Session();
            }
            if (AdminHelper.getPlatformHelper().isZOS()) {
                ConfigService configService = ConfigServiceFactory.getConfigService();
                try {
                    ObjectName[] serverIndexes = configService.resolve(session, "ServerIndex=");
                    if (null != serverIndexes) {
                        for (int i = 0; i < serverIndexes.length; ++i) {
                            ObjectName[] serverEntries = configService.resolve(session, serverIndexes[i], "ServerEntry=");
                            if (null == serverEntries) continue;
                            for (int j = 0; j < serverEntries.length; ++j) {
                                String serverType = (String)configService.getAttribute(session, serverEntries[j], "serverType");
                                String shortNameVal = null;
                                shortNameVal = clusterCheck ? (String)configService.getAttribute(session, serverEntries[j], "genericShortName") : (String)configService.getAttribute(session, serverEntries[j], "serverShortName");
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "shortNameVal=" + shortNameVal);
                                    Tr.debug(tc, "serverType=" + serverType);
                                }
                                if (null == shortNameVal || !shortNameVal.equalsIgnoreCase(shortName)) continue;
                                if (clusterCheck) {
                                    if (null != serverType && (serverType.equalsIgnoreCase("NODE_AGENT") || serverType.equalsIgnoreCase("DEPLOYMENT_MANAGER"))) {
                                        retValue = false;
                                    }
                                } else {
                                    retValue = false;
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "checkshortNameZOS,", retValue);
                                }
                                boolean bl = retValue;
                                return bl;
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkserverShortNameZOS,", " retValue=" + retValue + " Exception caught");
                    }
                    Manager.Ffdc.log(ex, "CreateServer", "com.ibm.wsspi.management.commands.server.CreateServer.taskCommandExecuted", "912");
                }
                finally {
                    if (discardSession) {
                        try {
                            configService.discard(session);
                        }
                        catch (Exception ex) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "checkserverShortNameZOS,", " retValue=" + retValue + " Exception caught");
                            }
                            Manager.Ffdc.log(ex, "CreateServer", "com.ibm.wsspi.management.commands.server.CreateServer.taskCommandExecuted", "929");
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkserverShortNameZOS,", retValue);
        }
        return retValue;
    }
}

