/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.genericbnf;

import com.ibm.wsspi.genericbnf.GenericKeys;

public class KeyMatcher {
    private boolean isCaseSensitive = false;
    private KeyBucket[] buckets = new KeyBucket[255];

    public KeyMatcher(boolean caseSensitive) {
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = null;
        }
        this.isCaseSensitive = caseSensitive;
    }

    protected KeyBucket getBucket(char c) {
        if (c > this.buckets.length) {
            return null;
        }
        int index = c;
        if (!this.isCaseSensitive() && c >= 65 && c <= 90) {
            index += 32;
        }
        return this.buckets[index];
    }

    protected KeyBucket makeBucket(char c) {
        if (c > this.buckets.length) {
            return null;
        }
        int index = c;
        if (!this.isCaseSensitive() && c >= 65 && c <= 90) {
            index += 32;
        }
        if (null == this.buckets[index]) {
            this.buckets[index] = new KeyBucket();
        }
        return this.buckets[index];
    }

    protected boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public synchronized void add(GenericKeys key) {
        KeyBucket bucket = this.makeBucket(key.getName().charAt(0));
        if (null != bucket) {
            bucket.add(key);
        }
    }

    public GenericKeys match(String name2, int start, int length) {
        if (null == name2 || 0 == name2.length() || start < 0 || length > name2.length()) {
            return null;
        }
        KeyBucket bucket = this.getBucket(name2.charAt(start));
        if (null != bucket) {
            return bucket.match(name2.toCharArray(), start, length);
        }
        return null;
    }

    public GenericKeys match(byte[] name2, int start, int length) {
        if (null == name2 || 0 == name2.length || start < 0 || length > name2.length) {
            return null;
        }
        KeyBucket bucket = this.getBucket((char)name2[start]);
        if (null != bucket) {
            return bucket.match(name2, start, length);
        }
        return null;
    }

    public class KeyBucket {
        private GenericKeys[] list = new GenericKeys[10];
        private char[][] values = new char[10][];
        private int number = 0;

        protected void add(GenericKeys key) {
            if (this.number == this.list.length) {
                GenericKeys[] newlist = new GenericKeys[this.number + 10];
                char[][] newvalues = new char[newlist.length][];
                for (int i = 0; i < this.number; ++i) {
                    newlist[i] = this.list[i];
                    newvalues[i] = this.values[i];
                }
                this.list = newlist;
                this.values = newvalues;
            }
            this.list[this.number] = key;
            this.values[this.number] = key.getName().toCharArray();
            ++this.number;
        }

        protected GenericKeys match(byte[] data, int start, int length) {
            int end = start + length - 1;
            int stop = this.number;
            char[][] vlist = this.values;
            for (int i = 0; i < stop; ++i) {
                char[] temp = vlist[i];
                if (temp.length != length) continue;
                int x = end;
                int y = temp.length - 1;
                while (x >= start && this.isEqual((char)data[x], temp[y])) {
                    --x;
                    --y;
                }
                if (-1 != y) continue;
                return this.list[i];
            }
            return null;
        }

        protected GenericKeys match(char[] data, int start, int length) {
            int end = start + length - 1;
            int stop = this.number;
            char[][] vlist = this.values;
            for (int i = 0; i < stop; ++i) {
                char[] temp = vlist[i];
                if (temp.length != length) continue;
                int x = end;
                int y = temp.length - 1;
                while (x >= start && this.isEqual(data[x], temp[y])) {
                    --x;
                    --y;
                }
                if (-1 != y) continue;
                return this.list[i];
            }
            return null;
        }

        private boolean isEqual(char c1, char c2) {
            if (c1 == c2) {
                return true;
            }
            if (!KeyMatcher.this.isCaseSensitive()) {
                return c1 + 32 == c2 || c1 - 32 == c2;
            }
            return false;
        }
    }
}

