/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.wsspi.configarchive.ConfigArchiveCommand;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class ExportCommand
extends ConfigArchiveCommand {
    private static TraceComponent tc = Tr.register(ExportCommand.class, "configarchive", "com.ibm.ws.management.resources.configarchive");

    public ExportCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public ExportCommand(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    private void createArchiveSession() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createArchiveWorkspace");
        }
        try {
            File archive = this.getArchiveLocation();
            Method createMethod = this.composerCls.getMethod("createConfigArchiveSession", String.class, FileAccessor.class);
            Session archiveSession = (Session)createMethod.invoke(null, archive.getName(), null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "archiveSession", archiveSession);
            }
            this.setConfigArchiveSession(archiveSession);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createArchiveSession");
            }
        }
        catch (InvocationTargetException ex) {
            Throwable th = ex.getTargetException();
            if (th instanceof ConfigArchiveException) {
                Manager.Ffdc.log(ex, this, "com.ibm.wsspi.configarchive.ExportCommand.createArchiveSession", "88");
                throw (ConfigArchiveException)th;
            }
            Manager.Ffdc.log(ex, this, "com.ibm.wsspi.configarchive.ExportCommand.createArchiveSession", "91");
            throw new ConfigArchiveException(th, "unexpected exception");
        }
        catch (Throwable ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.wsspi.configarchive.ExportCommand.createArchiveSession", "95");
            throw new ConfigArchiveException(ex, "unexpected exception");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        try {
            this.createArchiveSession();
        }
        catch (Throwable th) {
            Manager.Ffdc.log(th, this, "com.ibm.wsspi.configarchive.ExportCommand.beforeStepsExecuted", "99");
            result.setException(new ConfigArchiveException(th, "exportCommand command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        try {
            if (result.isSuccessful()) {
                Session archiveSession = this.getConfigArchiveSession();
                Method saveMethod = this.composerCls.getMethod("saveConfigArchive", String.class, File.class);
                saveMethod.invoke(null, archiveSession.toString(), this.getArchiveLocation());
            }
        }
        catch (Throwable th) {
            if (th instanceof InvocationTargetException) {
                th = ((InvocationTargetException)th).getTargetException();
            }
            Manager.Ffdc.log(th, this, "com.ibm.wsspi.configarchive.ExportCommand.afterStepsExecuted", "99");
            result.setException(new ConfigArchiveException(th, this.getName() + " command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }
}

