/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class ConfigArchiveCommand
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ConfigArchiveCommand.class, "configarchive", "com.ibm.ws.management.resources.configarchive");
    protected Class composerCls = null;
    private boolean unload = true;
    private Session configArchiveSession = null;

    public ConfigArchiveCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        this.init();
    }

    public ConfigArchiveCommand(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
        this.init();
    }

    private void init() {
        try {
            this.composerCls = Class.forName("com.ibm.ws.management.configarchive.ConfigArchiveComposer");
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", th);
            }
            Manager.Ffdc.log(th, this, "com.ibm.ws.wsspi.configarchive.ConfigArchiveCommand.initImpl", "56");
        }
    }

    public Session getConfigArchiveSession() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigArchiveSession");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigArchiveSession", this.configArchiveSession);
        }
        return this.configArchiveSession;
    }

    public void setConfigArchiveSession(Session archiveSession) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setConfigArchiveSession", archiveSession);
        }
        this.configArchiveSession = archiveSession;
        try {
            if (this.getParameter("archive") == null) {
                this.setParameter("archive", "");
                this.unload = false;
            }
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "fail to set archive parameter", ex);
            }
            Manager.Ffdc.log(ex, this, "com.ibm.wsspi.configarchive.ConfigArchiveCommand.setArchiveWorkspace", "62");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setConfigArchiveSession");
        }
    }

    protected final void unload() throws Exception {
        if (this.unload) {
            Method unloadMethod = this.composerCls.getMethod("unloadConfigArchive", String.class);
            unloadMethod.invoke(null, this.configArchiveSession.toString());
        }
    }

    protected void taskCommandExecuted(boolean success) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "taskCommandExecuted," + success);
        }
        try {
            this.unload();
        }
        catch (Throwable th) {
            Manager.Ffdc.log(th, this, "com.ibm.wsspi.configarchive.ConfigArchiveCommandBase.taskCommandExecuted", "86");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "taskCommandExecuted");
        }
    }

    protected File getArchiveLocation() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getArchiveLocation");
        }
        String archivePath = null;
        try {
            Object paramVal = this.getParameter("archive");
            archivePath = paramVal == null ? null : paramVal.toString();
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", ex);
            }
            Manager.Ffdc.log(ex, this, "com.ibm.wsspi.configarchive.ConfigArchiveCommand.getArchiveLocation", "73");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "archivePath", archivePath);
        }
        File result = new File(archivePath);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getArchiveLocation", result);
        }
        return result;
    }

    private ManagedObjectMetadataHelper getMetadataHelper(Session session) throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMetadataHelper", session);
        }
        ManagedObjectMetadataHelper result = null;
        try {
            Method method = this.composerCls.getMethod("getMetadataHelper", Session.class);
            result = (ManagedObjectMetadataHelper)method.invoke(null, session);
        }
        catch (InvocationTargetException ex) {
            Throwable th = ex.getTargetException();
            if (th instanceof ConfigArchiveException) {
                throw (ConfigArchiveException)th;
            }
            throw new ConfigArchiveException(th, "failed to get ManagedObjectMetadataHelper for session " + session);
        }
        catch (Throwable th) {
            throw new ConfigArchiveException(th, "failed to get ManagedObjectMetadataHelper for session " + session);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMetadataHelper", result);
        }
        return result;
    }

    public ManagedObjectMetadataHelper getConfigArchiveMetadataHelper() throws ConfigArchiveException {
        return this.getMetadataHelper(this.getConfigArchiveSession());
    }

    public ManagedObjectMetadataHelper getMetadataHelper() throws ConfigArchiveException {
        return this.getMetadataHelper(this.getConfigSession());
    }
}

