/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cmdframework;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.authorizer.SecurityAuditingHelper;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.ParameterMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;

public class CommandAuditHelper {
    private static TraceComponent tc = Tr.register(CommandAuditHelper.class, "CommandAuditHelper", "com.ibm.wsspi.cmdframework");

    public static void cmdAudit(AdminCommand cmd, String action, boolean result, List requiredRoles) throws Exception {
        String cmdAndParams;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "cmdAudit", new Object[]{cmd, action, new Boolean(result), requiredRoles});
            }
            cmdAndParams = action;
            try {
                cmdAndParams = CommandAuditHelper.getCmdStepsAndParams(cmd, action);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "excpetion getting parameters", e);
            }
        }
        action = action + " " + cmd.getName();
        SecurityAuditingHelper.getInstance().logSecurityAuditForCommand(result, cmd.getClass().getName(), cmdAndParams, cmd.getConfigSession().toString(), action, requiredRoles);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cmdAudit");
        }
    }

    public static void sessionAudit(boolean result, String sessionId, String className, String action, String userId) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sessionAudit", new Object[]{new Boolean(result), sessionId});
        }
        SecurityAuditingHelper.getInstance().logSecurityAuditForSession(result, className, sessionId, action, userId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sessionAudit");
        }
    }

    private static String getCmdStepsAndParams(AdminCommand cmd, String action) throws Exception {
        String ret = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCmdStepsAndParams", new Object[]{cmd, action});
        }
        StringBuffer sb = new StringBuffer();
        sb.append(cmd.getName()).append("(");
        HashMap map = CommandAuditHelper.getCommandParamters(cmd.getCommandMetadata(), cmd);
        if (map != null && !map.isEmpty()) {
            Set s = map.keySet();
            boolean firstTime = true;
            for (String key : s) {
                Object val = map.get(key);
                if (!firstTime) {
                    sb.append(",");
                }
                sb.append(key).append("=").append(val.toString());
                firstTime = false;
            }
        }
        sb.append(")");
        CommandMetadata cmdMetadata = cmd.getCommandMetadata();
        if (cmdMetadata instanceof TaskCommandMetadata) {
            sb.append(" Steps { ");
            TaskCommand taskCmd = (TaskCommand)cmd;
            TaskCommandMetadata taskMetadata = (TaskCommandMetadata)cmdMetadata;
            EList steps = taskMetadata.getSteps();
            for (int i = 0; steps != null && i < steps.size(); ++i) {
                String stepName;
                CommandStep cmdStep;
                CommandStepMetadata stepMetadata = (CommandStepMetadata)steps.get(i);
                HashMap smap = CommandAuditHelper.getCommandStepParamters(stepMetadata, cmdStep = taskCmd.getCommandStep(stepName = stepMetadata.getName()));
                if (smap == null || smap.isEmpty()) continue;
                sb.append(stepName).append("(");
                Set s = smap.keySet();
                boolean firstTime = true;
                for (String key : s) {
                    Object val = smap.get(key);
                    if (!firstTime) {
                        sb.append(",");
                    }
                    sb.append(key).append("=").append(val.toString());
                    firstTime = false;
                }
                sb.append(") ");
            }
            sb.append("}");
        }
        ret = sb.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCmdStepsAndParams", ret);
        }
        return ret;
    }

    private static HashMap getCommandParamters(CommandMetadata cmdMetadata, AdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandParamters", new Object[]{cmdMetadata, cmd});
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (cmdMetadata.isTargetObjectAllowed() && cmd.getTargetObject() != null) {
            map.put("targetObject", cmd.getTargetObject());
        }
        EList params = cmdMetadata.getParameters();
        for (int i = 0; params != null && i < params.size(); ++i) {
            ParameterMetadata pMetadata = (ParameterMetadata)params.get(i);
            if (cmd.getParameter(pMetadata.getName()) == null) continue;
            String name2 = pMetadata.getName();
            Object value2 = cmd.getParameter(name2);
            String val = null;
            String nameLowerCase = name2.toLowerCase();
            if (nameLowerCase.contains("password") || nameLowerCase.contains("passwd")) {
                val = new String("******");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "param value", value2);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "param value", value2);
                }
                val = CommandAuditHelper.convert(value2, pMetadata.getType());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "param value", value2);
                }
            }
            map.put(name2, val);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandParamters", map);
        }
        return map;
    }

    private static HashMap getCommandStepParamters(CommandStepMetadata cmdStepMetadata, CommandStep cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandStepParamters", new Object[]{cmdStepMetadata, cmd});
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (cmdStepMetadata.isTargetObjectAllowed() && cmd.getTargetObject() != null) {
            map.put("targetObject", cmd.getTargetObject());
        }
        EList params = cmdStepMetadata.getParameters();
        for (int i = 0; params != null && i < params.size(); ++i) {
            ParameterMetadata pMetadata = (ParameterMetadata)params.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "param", pMetadata.getName());
            }
            if (cmd.getParameter(pMetadata.getName()) == null) continue;
            String name2 = pMetadata.getName();
            Object value2 = cmd.getParameter(name2);
            String val = null;
            String nameLowerCase = name2.toLowerCase();
            if (nameLowerCase.contains("password") || nameLowerCase.contains("passwd")) {
                val = new String("******");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "param value", value2);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "param value", value2);
                }
                val = CommandAuditHelper.convert(value2, pMetadata.getType());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "param value", value2);
                }
            }
            map.put(name2, val);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandStepParamters", map);
        }
        return map;
    }

    private static String convert(Object value2, String type) {
        String val = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convert", new Object[]{value2, type});
        }
        if ((val = type != null && type.startsWith("[Ljava.lang.String") ? CommandAuditHelper.convertToString((String[])value2) : value2.toString()) != null && (val.contains(",") || val.contains("="))) {
            val = "\"" + val + "\"";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convert", val);
        }
        return val;
    }

    private static String convertToString(String[] arr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToString", arr);
        }
        String pValue = "{";
        boolean firstTime = true;
        for (int i = 0; arr != null && i < arr.length; ++i) {
            String str = arr[i];
            if (!firstTime) {
                pValue = pValue.concat(",");
            } else {
                firstTime = false;
            }
            pValue = pValue.concat(str);
        }
        pValue = pValue.concat("}");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertToString", pValue);
        }
        return pValue;
    }
}

