/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cluster.customadvisor;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.customadvisor.CustomAdvisorConfigListener;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomAdvisorHandler {
    private static final TraceComponent tc = Tr.register(CustomAdvisorHandler.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private Map<Identity, Boolean> theBestUsabilityMapInTheWorld = new HashMap<Identity, Boolean>();
    private CustomAdvisorNotifier caNotifier = new CustomAdvisorNotifier();

    public void setUsabilityMap(Map<Identity, Boolean> treasureMap) {
        this.theBestUsabilityMapInTheWorld = treasureMap;
        this.caNotifier.notifyListeners();
    }

    public Map<Identity, Boolean> getUsabilityMap() {
        return Collections.unmodifiableMap(this.theBestUsabilityMapInTheWorld);
    }

    public CustomAdvisorNotifier getNotifier() {
        return this.caNotifier;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : 1.2");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListenerWeakRef
    extends WeakReference<CustomAdvisorConfigListener> {
        private final Long theKey;

        ListenerWeakRef(CustomAdvisorConfigListener referent, ReferenceQueue queue, Long key) {
            super(referent, queue);
            this.theKey = key;
        }
    }

    public class CustomAdvisorNotifier {
        private final TraceComponent tc = Tr.register(CustomAdvisorNotifier.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
        private final Map<Long, ListenerWeakRef> listeners = new HashMap<Long, ListenerWeakRef>();
        private final ReferenceQueue refQueue = new ReferenceQueue();
        private final Object listenersMutex = new Object();
        private final AtomicLong numPurged = new AtomicLong();
        private final AtomicLong numDeregistered = new AtomicLong();
        private Long currentTime = new Long(System.currentTimeMillis());

        public CustomAdvisorNotifier() {
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "version : 1.2 (inner class)");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerListener(CustomAdvisorConfigListener listener) {
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "registerListener", listener);
            }
            if (listener != null) {
                Object object = this.listenersMutex;
                synchronized (object) {
                    this.purge();
                    long newTime = System.currentTimeMillis();
                    this.currentTime = newTime > this.currentTime ? new Long(newTime) : new Long(this.currentTime + 1L);
                    ListenerWeakRef ref = new ListenerWeakRef(listener, this.refQueue, this.currentTime);
                    this.listeners.put(this.currentTime, ref);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deregisterListener(CustomAdvisorConfigListener listener) {
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "deregisterListener", listener);
            }
            Object object = this.listenersMutex;
            synchronized (object) {
                this.purge();
                Long keyToRemove = null;
                Set<Map.Entry<Long, ListenerWeakRef>> entries = this.listeners.entrySet();
                for (Map.Entry<Long, ListenerWeakRef> mapEntry : entries) {
                    CustomAdvisorConfigListener caConfigL = (CustomAdvisorConfigListener)mapEntry.getValue().get();
                    if (caConfigL == null || !caConfigL.equals(listener)) continue;
                    keyToRemove = mapEntry.getKey();
                    break;
                }
                if (keyToRemove != null) {
                    this.listeners.remove(keyToRemove);
                    this.numDeregistered.incrementAndGet();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyListeners() {
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "notifyListeners");
            }
            Object object = this.listenersMutex;
            synchronized (object) {
                this.purge();
                Set<Map.Entry<Long, ListenerWeakRef>> entries = this.listeners.entrySet();
                for (Map.Entry<Long, ListenerWeakRef> mapEntry : entries) {
                    CustomAdvisorConfigListener caConfigL = (CustomAdvisorConfigListener)mapEntry.getValue().get();
                    if (caConfigL == null) continue;
                    caConfigL.handleNotification();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long[] getRegisteredPurgedAndDeregistered() {
            Object object = this.listenersMutex;
            synchronized (object) {
                long[] numbers = new long[]{this.listeners.size(), this.numPurged.longValue(), this.numDeregistered.longValue()};
                return numbers;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void purge() {
            ListenerWeakRef weakRef;
            while ((weakRef = (ListenerWeakRef)this.refQueue.poll()) != null) {
                Object object = this.listenersMutex;
                synchronized (object) {
                    this.numPurged.incrementAndGet();
                    this.listeners.remove(weakRef.theKey);
                }
            }
        }
    }
}

