/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cluster.adapter.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.channel.ChannelTargetRule;
import com.ibm.wsspi.channel.framework.CFEndPointCriteria;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.selection.SelectionCriteria;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import com.ibm.wsspi.cluster.selection.SelectionService;
import com.ibm.wsspi.cluster.selection.SelectionServiceFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class ChannelSelectionCriteria
implements CFEndPointCriteria {
    private static final TraceComponent tc = Tr.register(ChannelSelectionCriteria.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final SelectionService selectionService = SelectionServiceFactory.getSelectionService();
    private final Identity clusterIdentity;
    private final SelectionCriteria criteria;
    private final CFEndPointCriteria cfEndPointCriteria;
    private final String chainName;
    private final Class accessor;
    private final Class[] channelFactories;
    private final boolean sslRequired;
    private String string = null;
    private int equalsTraces = 0;
    private static final int MAX_EQUALS_TRACES = 100;

    public ChannelSelectionCriteria(Identity clusterIdentity, boolean process, boolean host, CFEndPointCriteria cfCriteria) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{clusterIdentity, String.valueOf(process), String.valueOf(host)});
        }
        if (clusterIdentity == null) {
            throw new IllegalArgumentException("The identity attribute must not be null.");
        }
        this.criteria = selectionService.getCriteria(clusterIdentity, process, host, null, null);
        this.cfEndPointCriteria = cfCriteria;
        this.clusterIdentity = clusterIdentity;
        this.chainName = cfCriteria == null ? null : cfCriteria.getChainName();
        this.accessor = cfCriteria == null ? null : cfCriteria.getChannelAccessor();
        this.channelFactories = cfCriteria == null ? null : cfCriteria.getOptionalChannelFactories();
        boolean bl = this.sslRequired = cfCriteria == null ? false : cfCriteria.isSSLRequired();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            this.toStringForce();
            Tr.exit(tc, "<init>", this);
        }
    }

    public ChannelSelectionCriteria(Identity clusterIdentity, Map context, String chainName, Class channelAccessor, Class[] optionalChannelFactories, boolean sslRequired) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{clusterIdentity, context, chainName, channelAccessor, String.valueOf(sslRequired)});
        }
        if (clusterIdentity == null) {
            throw new IllegalArgumentException("The identity attribute must not be null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("The context attribute must not be null.");
        }
        this.clusterIdentity = clusterIdentity;
        this.chainName = chainName;
        this.accessor = channelAccessor;
        this.channelFactories = optionalChannelFactories;
        this.sslRequired = sslRequired;
        this.cfEndPointCriteria = this;
        this.setChannelTargetRule(this, context);
        this.criteria = selectionService.getCriteria(clusterIdentity, context);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            this.toStringForce();
            Tr.exit(tc, "<init>", this);
        }
    }

    public ChannelSelectionCriteria(Identity clusterIdentity, Map context, CFEndPointCriteria cfCriteria) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{clusterIdentity, context, cfCriteria});
        }
        if (clusterIdentity == null) {
            throw new IllegalArgumentException("The identity attribute must not be null.");
        }
        if (cfCriteria == null) {
            throw new IllegalArgumentException("The CFEndPointCriteria attribute must not be null.");
        }
        if (context == null) {
            context = new HashMap(3);
        }
        this.setChannelTargetRule(cfCriteria, context);
        this.criteria = selectionService.getCriteria(clusterIdentity, context);
        this.clusterIdentity = clusterIdentity;
        this.chainName = cfCriteria.getChainName();
        this.accessor = cfCriteria.getChannelAccessor();
        this.channelFactories = cfCriteria.getOptionalChannelFactories();
        this.sslRequired = cfCriteria.isSSLRequired();
        this.cfEndPointCriteria = cfCriteria;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            this.toStringForce();
            Tr.exit(tc, "<init>", this);
        }
    }

    public CFEndPointCriteria getCFEndPointCriteria() {
        return this.cfEndPointCriteria;
    }

    public String toString() {
        if (this.string == null) {
            this.toStringForce();
        }
        return this.string;
    }

    private String toStringForce() {
        StringBuilder sbuilder = new StringBuilder(128);
        sbuilder.append(super.toString());
        sbuilder.append(" [clusterIdentity=");
        sbuilder.append(this.clusterIdentity);
        sbuilder.append("] [criteria = ");
        sbuilder.append(this.criteria);
        sbuilder.append("] [chainName=");
        sbuilder.append(this.chainName);
        sbuilder.append("] [sslRequired=");
        sbuilder.append(this.sslRequired);
        sbuilder.append("] [accessor=");
        sbuilder.append(this.accessor);
        sbuilder.append("] [channelFactories=");
        if (this.channelFactories != null) {
            sbuilder.append("{");
            for (int i = 0; i < this.channelFactories.length; ++i) {
                sbuilder.append(this.channelFactories[i]);
                if (i + 1 == this.channelFactories.length) continue;
                sbuilder.append(", ");
            }
            sbuilder.append("}");
        } else {
            sbuilder.append("{null}");
        }
        this.string = sbuilder.toString();
        return this.string;
    }

    public Identity getIdentity() {
        return this.clusterIdentity;
    }

    public SelectionCriteria getCriteria() {
        return this.criteria;
    }

    public Class getChannelAccessor() {
        return this.accessor;
    }

    public String getChainName() {
        return this.chainName;
    }

    public Class[] getOptionalChannelFactories() {
        return this.channelFactories;
    }

    public boolean isSSLRequired() {
        return this.sslRequired;
    }

    private void setChannelTargetRule(CFEndPointCriteria cfCriteria, Map context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setChannelTargetRule");
        }
        boolean found = false;
        SelectionRule[] selectionRules = (SelectionRule[])context.get("rules.restriction");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "SelectionRules = ", selectionRules);
        }
        if (selectionRules == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "no restrictive rules in context add channel target rule");
            }
            selectionRules = new SelectionRule[]{new ChannelTargetRule(cfCriteria)};
            context.put("rules.restriction", selectionRules);
        } else {
            SelectionRule[] newSelectionRules = new SelectionRule[selectionRules.length + 1];
            for (int i = 0; i < selectionRules.length; ++i) {
                if (selectionRules[i] == null) continue;
                if (selectionRules[i] instanceof ChannelTargetRule) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Restrictive rule ChannelTargetRule already in list");
                    }
                    found = true;
                    break;
                }
                newSelectionRules[i] = selectionRules[i];
            }
            if (!found) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "not found add channel target rule");
                }
                newSelectionRules[newSelectionRules.length - 1] = new ChannelTargetRule(cfCriteria);
                context.put("rules.restriction", newSelectionRules);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setChannelTargetRule", context);
        }
    }

    public boolean equals(Object o) {
        return this.equals(o, false);
    }

    public boolean equals(Object o, boolean trace) {
        if (trace && this.equalsTraces <= 100 && TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "equals");
        }
        if (o == null) {
            if (trace && this.equalsTraces <= 100 && TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "equals", "passed in object is null, returning false");
            }
            return false;
        }
        if (o == this) {
            if (trace && this.equalsTraces <= 100 && TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "equals", "passed in object is == this object, returning true");
            }
            return true;
        }
        if (!(o instanceof ChannelSelectionCriteria)) {
            if (trace && this.equalsTraces <= 100 && TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "equals", "passed in object is not an instance of ChannelSelectionCriteria, returning false");
            }
            return false;
        }
        ChannelSelectionCriteria other = (ChannelSelectionCriteria)o;
        boolean accessorEqual = false;
        boolean chainNameEqual = false;
        boolean channelFactoriesLengthEqual = false;
        boolean channelFactoriesNull = false;
        if (!(this.accessor != null && other.accessor != null || this.accessor == null && other.accessor == null)) {
            if (trace && this.equalsTraces <= 100 && TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "equals", "accessors are mismatched, returning false");
            }
            return false;
        }
        if (this.accessor != null && this.accessor.equals(other.accessor) || this.accessor == null) {
            accessorEqual = true;
        }
        if (!(this.chainName != null && other.chainName != null || this.chainName == null && other.chainName == null)) {
            if (trace && this.equalsTraces <= 100 && TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "equals", "chainNames are mismatched, returning false");
            }
            return false;
        }
        if (this.chainName != null && this.chainName.equals(other.chainName) || this.chainName == null) {
            chainNameEqual = true;
        }
        if (!(this.channelFactories != null && other.channelFactories != null || this.channelFactories == null && other.channelFactories == null)) {
            if (trace && this.equalsTraces <= 100 && TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "equals", "channelFactories are mismatched, returning false");
            }
            return false;
        }
        if (this.channelFactories != null && this.channelFactories.length == other.channelFactories.length) {
            channelFactoriesLengthEqual = true;
        } else if (this.channelFactories == null) {
            channelFactoriesNull = true;
        }
        if (this.criteria.equals(other.criteria) && this.clusterIdentity == other.clusterIdentity && chainNameEqual && accessorEqual && this.sslRequired == other.sslRequired && (channelFactoriesLengthEqual || channelFactoriesNull)) {
            if (!channelFactoriesNull && other.channelFactories.length > 0) {
                int i;
                ArrayList<Class> otherlist = new ArrayList<Class>(other.channelFactories.length);
                for (i = 0; i < this.channelFactories.length; ++i) {
                    otherlist.add(other.channelFactories[i]);
                }
                for (i = 0; i < this.channelFactories.length; ++i) {
                    if (otherlist.contains(this.channelFactories[i])) continue;
                    if (trace && this.equalsTraces <= 100 && TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "equals", "passed in object's channelFactories array does not contain: " + this.channelFactories[i] + ", returning false");
                    }
                    return false;
                }
            }
            if (trace && this.equalsTraces <= 100 && TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "equals", "unexpected - passed in object matches this object, returning true");
            }
            return true;
        }
        if (trace && this.equalsTraces <= 100 && TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            ++this.equalsTraces;
            if (this.equalsTraces > 100) {
                Tr.debug(tc, "exceeded MAX_EQUALS_TRACES; no further trace for this object.");
            }
            Tr.debug(tc, "this  = " + this);
            Tr.debug(tc, "other = " + other);
            if (!this.criteria.equals(other.criteria)) {
                Tr.exit(tc, "equals", "other object's criteria doesn't match this object's criteria, returning false");
            } else if (this.clusterIdentity != other.clusterIdentity) {
                Tr.exit(tc, "equals", "other object's cluster identity doesn't match this object's cluster identity, returning false");
            } else if (!chainNameEqual) {
                Tr.exit(tc, "equals", "other object's chainName doesn't match this object's chainName, returning false");
            } else if (!accessorEqual) {
                Tr.exit(tc, "equals", "other object's accessor doesn't match this object's accessor, returning false");
            } else if (this.sslRequired != other.sslRequired) {
                Tr.exit(tc, "equals", "other object's sslRequired doesn't match this object's sslRequired, returning false");
            } else if (!channelFactoriesNull && !channelFactoriesLengthEqual) {
                Tr.exit(tc, "equals", "other object's channelFactories.length doesn't match this object's channelFactories.length, returning false");
            } else {
                Tr.exit(tc, "equals", "unexpected - don't know what wasn't equal");
            }
        }
        return false;
    }

    public int hashCode() {
        int prime = 29;
        int result = 1;
        result = 29 * result + (this.clusterIdentity == null ? 0 : this.clusterIdentity.hashCode());
        result = 29 * result + (this.chainName == null ? 0 : this.chainName.hashCode());
        result = 29 * result + (this.accessor == null ? 0 : this.accessor.hashCode());
        int cFs = 0;
        if (this.channelFactories != null) {
            for (Class c : this.channelFactories) {
                cFs += c.hashCode();
            }
        }
        result = 29 * result + cFs;
        result = 29 * result + (this.sslRequired ? 1 : 2);
        result = 29 * result + (this.criteria == null ? 0 : this.criteria.hashCode());
        return result;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.21 ");
        }
    }
}

