/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cluster.adapter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import java.util.HashMap;
import java.util.Map;

public class IdentityMappingUtility {
    private static final TraceComponent tc = Tr.register(IdentityMappingUtility.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final ClusterService clusterService = ClusterServiceFactory.getClusterService();
    private static final String SCA_ATTRIBUTE_IDENTIFIER = "SCAAtribute";

    public static Identity generateSCAAttributeIdentity(Identity clusterId, String attribute) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "generateSCAAttributeIdentity", new Object[]{clusterId, attribute});
        }
        if (clusterId == null) {
            throw new IllegalArgumentException("The cluster identity argument must not be null.");
        }
        Identity scaIdentity = null;
        HashMap<String, String> idMap = new HashMap<String, String>(clusterId.getProperties());
        idMap.put(SCA_ATTRIBUTE_IDENTIFIER, attribute);
        scaIdentity = clusterService.getIdentity(idMap);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "generateSCAAttributeIdentity", scaIdentity);
        }
        return scaIdentity;
    }

    public static Identity getClusterIdentityFromSCAAttributeIdentity(Identity scaIdentity) {
        Identity clusterId = null;
        String attribute = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterIdentityFromSCAAttributeIdentity", scaIdentity);
        }
        if (scaIdentity == null) {
            throw new IllegalArgumentException("The scaIdentity argument must not be null.");
        }
        HashMap idMap = new HashMap(scaIdentity.getProperties());
        attribute = (String)idMap.remove(SCA_ATTRIBUTE_IDENTIFIER);
        if (attribute != null) {
            clusterId = clusterService.getIdentity(idMap);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterIdentityFromSCAAttributeIdentity", clusterId);
        }
        return clusterId;
    }

    public static String getAttributeFromSCAAttributeIdentity(Identity scaIdentity) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributeFromSCAAttributeIdentity", scaIdentity);
        }
        if (scaIdentity == null) {
            throw new IllegalArgumentException("The scaIdentity argument must not be null.");
        }
        String attribute = null;
        Map idMap = scaIdentity.getProperties();
        attribute = (String)idMap.get(SCA_ATTRIBUTE_IDENTIFIER);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributeFromSCAAttributeIdentity", attribute);
        }
        return attribute;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.2 ");
        }
    }
}

