/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.handlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.DestinationUnreachableException;
import com.ibm.ws.wsaddressing.InvalidMultipleElementException;
import com.ibm.ws.wsaddressing.UCFRoutingHelper;
import com.ibm.ws.wsaddressing.binders.AttributedURIBinder;
import com.ibm.ws.wsaddressing.binders.EndpointReferenceTypeBinder;
import com.ibm.ws.wsaddressing.binders.RelationshipBinder;
import com.ibm.ws.wsaddressing.integration.EndpointReference;
import com.ibm.ws.wsaddressing.namespace.NamespaceData;
import com.ibm.wsspi.cluster.ClusterMemberService;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReferenceManager;
import com.ibm.wsspi.wsaddressing.Relationship;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;

public class MAPReader {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(MAPReader.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.handlers.MAPReader";
    private static final String TO = "To";
    private static final String FROM = "From";
    private static final String FAULTTO = "FaultTo";
    private static final String REPLYTO = "ReplyTo";
    private static final String ACTION = "Action";
    private static final String MESSAGEID = "MessageID";
    private static final String RELATESTO = "RelatesTo";
    private NamespaceData _namespaceData;
    private SOAPHeader _soapHeader;
    private SOAPMessageContext _soapMsgContext;
    private AttributedURI messageIDAURI;
    private AttributedURI actionURI;
    private EndpointReference fromEPR;
    private EndpointReference replyToEPR;
    private EndpointReference faultToEPR;
    private Set relationshipSet;
    private AttributedURI toAddress;
    private static AttributedURIBinder _attributedURIBinder = new AttributedURIBinder();
    private static RelationshipBinder _relationshipBinder = new RelationshipBinder();
    private static EndpointReferenceTypeBinder _endpointReferenceTypeBinder = new EndpointReferenceTypeBinder();
    private ArrayList _relatesToSOAPElements = new ArrayList();
    private HashMap _flagMap = new HashMap();
    private HashMap _singleHeaderMap = new HashMap();
    private boolean _wsaPresent = false;

    public boolean setMessageContext(SOAPMessageContext soapMsgContext) throws InvalidMultipleElementException, DestinationUnreachableException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setMessageContext", soapMsgContext);
        }
        this._soapMsgContext = soapMsgContext;
        SOAPMessage soapmessage = soapMsgContext.getMessage();
        if (soapmessage != null) {
            try {
                this._soapHeader = soapmessage.getSOAPHeader();
            }
            catch (SOAPException se) {
                String message = "An Exception occurred retrieving the SOAPHeader: " + (Object)((Object)se);
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.warning(TRACE_COMPONENT, message);
                }
                FFDCFilter.processException(se, CLASSNAME, "1:149:1.20");
            }
        }
        if (this._soapHeader == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Object[] trace = new Object[]{"SOAPHeader is null"};
                Tr.exit(TRACE_COMPONENT, "setMessageContext", trace);
            }
            return false;
        }
        this.processHeaders();
        boolean wsaPresent = this.isWSAPresent();
        if (wsaPresent) {
            this.removeHeaders();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setMessageContext", wsaPresent);
        }
        return wsaPresent;
    }

    public NamespaceData getNamespaceData() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getNamespaceData", this._namespaceData);
        }
        return this._namespaceData;
    }

    public void addPropertiesToContext() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addPropertiesToContext");
        }
        this.messageIDAURI = this.deserializeAURI(this.getMessageIDSOAPElement());
        this.setProperty("com.ibm.wsspi.wsaddressing.inbound.MessageID", this.messageIDAURI);
        this.actionURI = this.deserializeAURI(this.getActionSOAPElement());
        this.setProperty("com.ibm.wsspi.wsaddressing.inbound.Action", this.actionURI);
        this.fromEPR = this.deserializeEPR(this.getFromSOAPElement());
        this.setProperty("com.ibm.wsspi.wsaddressing.inbound.FromEPR", this.fromEPR);
        this.replyToEPR = this.deserializeEPR(this.getReplyToSOAPElement());
        this.setProperty("com.ibm.wsspi.wsaddressing.inbound.ReplyToEPR", this.replyToEPR);
        this.faultToEPR = this.deserializeEPR(this.getFaultToSOAPElement());
        this.setProperty("com.ibm.wsspi.wsaddressing.inbound.FaultToEPR", this.faultToEPR);
        this.relationshipSet = this.buildRelationshipSet();
        this.setProperty("com.ibm.wsspi.wsaddressing.inbound.RelationshipSet", this.relationshipSet);
        this.toAddress = this.deserializeAURI(this.getToSOAPElement());
        this.setProperty("com.ibm.wsspi.wsaddressing.inbound.To", this.toAddress);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addPropertiesToContext");
        }
    }

    private void setProperty(String key, Object value2) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] parms = new Object[]{key, value2};
            Tr.entry(TRACE_COMPONENT, "setProperty", parms);
        }
        if (value2 != null) {
            this._soapMsgContext.setProperty(key, value2);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setProperty");
        }
    }

    private void processHeaders() throws InvalidMultipleElementException, DestinationUnreachableException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "processHeaders");
        }
        InvalidMultipleElementException invalidCardinalityFound = null;
        SOAPElement routingInformation = null;
        Iterator iter = this._soapHeader.getChildElements();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (!(next instanceof SOAPElement)) continue;
            SOAPElement se = (SOAPElement)next;
            String localName = se.getLocalName();
            try {
                if (localName == null) continue;
                if (localName.equals(TO)) {
                    this.addSingleCardinalityHeader(TO, se);
                    continue;
                }
                if (localName.equals(REPLYTO)) {
                    this.addSingleCardinalityHeader(REPLYTO, se);
                    continue;
                }
                if (localName.equals(FAULTTO)) {
                    this.addSingleCardinalityHeader(FAULTTO, se);
                    continue;
                }
                if (localName.equals(ACTION)) {
                    this.addSingleCardinalityHeader(ACTION, se);
                    continue;
                }
                if (localName.equals(FROM)) {
                    this.addSingleCardinalityHeader(FROM, se);
                    continue;
                }
                if (localName.equals(MESSAGEID)) {
                    this.addSingleCardinalityHeader(MESSAGEID, se);
                    continue;
                }
                if (localName.equals(RELATESTO)) {
                    this.addRelatesToSOAPElement(se);
                    continue;
                }
                if (!localName.equals("RoutingInformation")) continue;
                routingInformation = se;
            }
            catch (InvalidMultipleElementException e) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Multiple " + localName + " headers found.");
                }
                invalidCardinalityFound = e;
            }
        }
        if (invalidCardinalityFound != null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "processHeaders", "Throwing InvalidMultipleElementException caught earlier: " + invalidCardinalityFound);
            }
            throw invalidCardinalityFound;
        }
        Identity clusterIdent = null;
        if (routingInformation != null) {
            Iterator children = routingInformation.getChildElements();
            while (clusterIdent == null && children.hasNext()) {
                Object nextChild = children.next();
                if (!(nextChild instanceof SOAPElement)) continue;
                SOAPElement se = (SOAPElement)nextChild;
                clusterIdent = UCFRoutingHelper.getClusterIdentityFromSOAPElementText(se);
            }
        }
        if (clusterIdent != null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Cluster Identity found in reference parameter.");
            }
            try {
                ClusterMemberService cms = WsServiceRegistry.getService(this, ClusterMemberService.class);
                boolean isMember = cms.getServerClusterContextListener().validateClusterResidency(clusterIdent);
                if (!isMember) {
                    String message = "This server is not a member of the cluster identified by the wsaucf:RoutingInformation";
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.warning(TRACE_COMPONENT, message);
                    }
                    throw new DestinationUnreachableException();
                }
            }
            catch (DestinationUnreachableException e) {
                throw e;
            }
            catch (Exception e) {
                String message = "An Exception occurred attempting to access the ClusterMemberService: " + e;
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.warning(TRACE_COMPONENT, message);
                }
                FFDCFilter.processException(e, CLASSNAME, "1:343:1.20");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "processHeaders");
        }
    }

    private void removeHeaders() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "processHeaders");
        }
        Iterator singleCardinalityElements = this.getSingleCardinalitySOAPElementIterator();
        while (singleCardinalityElements.hasNext()) {
            this._soapHeader.removeChild((Node)((SOAPElement)singleCardinalityElements.next()));
        }
        Iterator relElts = this.getRelatesToSOAPElementIterator();
        while (relElts.hasNext()) {
            this._soapHeader.removeChild((Node)((SOAPElement)relElts.next()));
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "processHeaders");
        }
    }

    private boolean correctNamespace(SOAPElement se) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "correctNamespace", se);
        }
        if (this._namespaceData == null) {
            this._namespaceData = NamespaceData.addInboundNamespaceDataToContext(this._soapHeader, this._soapMsgContext);
        }
        boolean correct = se.getNamespaceURI().equals(this._namespaceData.getNamespace());
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "correctNamespace", correct);
        }
        return correct;
    }

    private EndpointReference deserializeEPR(SOAPElement se) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "deserializeEPR", se);
        }
        EndpointReference epr = null;
        if (se != null) {
            try {
                epr = (EndpointReference)_endpointReferenceTypeBinder.deserialize(se, null);
            }
            catch (SOAPException e) {
                String message = "An Exception occurred deserializing an EndpointReference: " + (Object)((Object)e);
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.warning(TRACE_COMPONENT, message);
                }
                FFDCFilter.processException(e, CLASSNAME, "1:412:1.20");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "deserializeEPR", epr);
        }
        return epr;
    }

    private AttributedURI deserializeAURI(SOAPElement se) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "deserializeAURI", se);
        }
        AttributedURI auri = null;
        if (se != null) {
            try {
                auri = (AttributedURI)_attributedURIBinder.deserialize(se, null);
            }
            catch (SOAPException e) {
                String message = "An Exception occurred deserializing an AttributedURI: " + (Object)((Object)e);
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.warning(TRACE_COMPONENT, message);
                }
                FFDCFilter.processException(e, CLASSNAME, "1:439:1.20");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "deserializeAURI", auri);
        }
        return auri;
    }

    private URI deserializeURI(SOAPElement se) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "deserializeURI", se);
        }
        URI uri = null;
        if (se != null) {
            try {
                String uristring = se.getValue();
                if (uristring != null) {
                    uri = new URI(uristring.trim());
                } else {
                    String message = "The MessageID SOAPElement did not contain a MessageID";
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.warning(TRACE_COMPONENT, message);
                    }
                }
            }
            catch (URISyntaxException e) {
                String message = "An Exception occurred deserializing an URI: " + e;
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.warning(TRACE_COMPONENT, message);
                }
                FFDCFilter.processException(e, CLASSNAME, "1:474:1.20");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "deserializeURI", uri);
        }
        return uri;
    }

    private Relationship deserializeRelationship(SOAPElement se) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "deserializeRelationship", se);
        }
        Relationship auri = null;
        if (se != null) {
            try {
                auri = (Relationship)_relationshipBinder.deserialize(se, this._namespaceData);
            }
            catch (SOAPException e) {
                String message = "An Exception occurred deserializing a Relationship: " + (Object)((Object)e);
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.warning(TRACE_COMPONENT, message);
                }
                FFDCFilter.processException(e, CLASSNAME, "1:500:1.20");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "deserializeRelationship", auri);
        }
        return auri;
    }

    private EndpointReference createEPR(AttributedURI auri) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createEPR", auri);
        }
        EndpointReference epr = null;
        if (auri != null) {
            try {
                epr = (EndpointReference)EndpointReferenceManager.createEndpointReference(auri);
            }
            catch (EndpointReferenceCreationException e) {
                String message = "An Exception occurred creating and EndpointReference: " + e;
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.warning(TRACE_COMPONENT, message);
                }
                FFDCFilter.processException(e, CLASSNAME, "1:527:1.20");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createEPR", epr);
        }
        return epr;
    }

    private Set buildRelationshipSet() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "buildRelationshipSet");
        }
        HashSet<Relationship> relationshipSet = null;
        Iterator relatesToIterator = this.getRelatesToSOAPElementIterator();
        while (relatesToIterator.hasNext()) {
            SOAPElement currentRelatesToElement = (SOAPElement)relatesToIterator.next();
            Relationship relationship = this.deserializeRelationship(currentRelatesToElement);
            if (relationshipSet == null) {
                relationshipSet = new HashSet<Relationship>();
            }
            relationshipSet.add(relationship);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "buildRelationshipSet", relationshipSet);
        }
        return relationshipSet;
    }

    public AttributedURI getActionURI() {
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getActionURI", this.actionURI);
        }
        return this.actionURI;
    }

    public EndpointReference getFaultToEPR() {
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getActionURI", this.actionURI);
        }
        return this.faultToEPR;
    }

    public EndpointReference getFromEPR() {
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getFromEPR", this.fromEPR);
        }
        return this.fromEPR;
    }

    public AttributedURI getMessageIDAURI() {
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getMessageIDURI", this.messageIDAURI);
        }
        return this.messageIDAURI;
    }

    public Set getRelationshipSet() {
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getRelationshipSet", this.relationshipSet);
        }
        return this.relationshipSet;
    }

    public EndpointReference getReplyToEPR() {
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getReplyToEPR", this.replyToEPR);
        }
        return this.replyToEPR;
    }

    public AttributedURI getToAddress() {
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getToEPR", this.toAddress);
        }
        return this.toAddress;
    }

    private void addSingleCardinalityHeader(String headerName, SOAPElement found) throws InvalidMultipleElementException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] parms = new Object[]{headerName, found};
            Tr.exit(TRACE_COMPONENT, "addSingleCardinalityHeader", parms);
        }
        if (this.correctNamespace(found)) {
            Object headerFlag = this._flagMap.get(headerName);
            if (headerFlag == null) {
                this._wsaPresent = true;
                this._flagMap.put(headerName, Boolean.TRUE);
                this._singleHeaderMap.put(headerName, found);
            } else {
                String message = "Multiple elements found with name: " + headerName + ". Throwing InvalidMultipleElementException";
                this._singleHeaderMap.remove(headerName);
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "addSingleCardinalityHeader", message);
                }
                throw new InvalidMultipleElementException(message, new QName(this._namespaceData.getNamespace(), headerName));
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addSingleCardinalityHeader");
        }
    }

    private void addRelatesToSOAPElement(SOAPElement se) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addRelatesToSOAPElement", se);
        }
        if (this.correctNamespace(se)) {
            this._relatesToSOAPElements.add(se);
            this._wsaPresent = true;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addRelatesToSOAPElement");
        }
    }

    private boolean isWSAPresent() {
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "isWSAPresent", this._wsaPresent);
        }
        return this._wsaPresent;
    }

    private SOAPElement getActionSOAPElement() {
        SOAPElement result = (SOAPElement)this._singleHeaderMap.get(ACTION);
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getActionSOAPElement", result);
        }
        return result;
    }

    private SOAPElement getFaultToSOAPElement() {
        SOAPElement result = (SOAPElement)this._singleHeaderMap.get(FAULTTO);
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getFaultToSOAPElement", result);
        }
        return result;
    }

    private SOAPElement getFromSOAPElement() {
        SOAPElement result = (SOAPElement)this._singleHeaderMap.get(FROM);
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getFromSOAPElement", result);
        }
        return result;
    }

    private SOAPElement getMessageIDSOAPElement() {
        SOAPElement result = (SOAPElement)this._singleHeaderMap.get(MESSAGEID);
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getMessageIDSOAPElement", result);
        }
        return result;
    }

    private Iterator getRelatesToSOAPElementIterator() {
        Iterator result = this._relatesToSOAPElements.iterator();
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getRelatesToSOAPElementIterator", result);
        }
        return result;
    }

    private Iterator getSingleCardinalitySOAPElementIterator() {
        Iterator result = this._singleHeaderMap.values().iterator();
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getSingleCardinalitySOAPElementIterator", result);
        }
        return result;
    }

    private SOAPElement getReplyToSOAPElement() {
        SOAPElement result = (SOAPElement)this._singleHeaderMap.get(REPLYTO);
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getReplyToSOAPElement", result);
        }
        return result;
    }

    private SOAPElement getToSOAPElement() {
        SOAPElement result = (SOAPElement)this._singleHeaderMap.get(TO);
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getToSOAPElement", result);
        }
        return result;
    }
}

