/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.handlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.wsaddressing.namespace.NamespaceData;
import com.ibm.wsspi.webservices.rpc.handler.RPCContext;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;

public class ActionSpecifier {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.handlers.ActionSpecifier";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(ActionSpecifier.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private RPCContext _rpcContext = null;

    public ActionSpecifier(RPCContext rpcContext) {
        this._rpcContext = rpcContext;
    }

    public AttributedURI getActionForInputMessageFromWSDL() {
        AttributedURI actionURI;
        block11: {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.entry(TRACE_COMPONENT, "getActionForInputMessageFromWSDL");
            }
            if (this._rpcContext.getWSDLUnavailable().booleanValue()) {
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getActionForInputMessageFromWSDL", null);
                }
                return null;
            }
            String wsaAction = this._rpcContext.getInputWSAAction();
            if (wsaAction == null || wsaAction.length() < 1 || wsaAction.equals("")) {
                wsaAction = this._rpcContext.getSOAPActionURI();
            }
            if (wsaAction == null || wsaAction.length() < 1 || wsaAction.equals("")) {
                wsaAction = this.generateDefaultActionPatternForMessage(MessageType.REQUEST);
            }
            if (wsaAction == null || wsaAction.length() < 1 || wsaAction.equals("")) {
                String message = "WS-Addressing Action cannot be determined for this outbound message.  It may be set on the Call or Stub, or defined in the target service WSDL.  The Action is mandatory for WSAddressed messages.";
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getActionForInputMessageFromWSDL", message);
                }
                throw new JAXRPCException(message);
            }
            actionURI = null;
            try {
                if (wsaAction != null) {
                    actionURI = WSAddressingFactory.createAttributedURI(new URI(wsaAction));
                }
            }
            catch (URISyntaxException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.wsaddressing.handlers.ActionSpecifier.getActionForInputMessageFromWSDL", "1:165:1.30", e);
                if (!TRACE_COMPONENT.isEntryEnabled()) break block11;
                Tr.debug(TRACE_COMPONENT, "getActionForInputMessageFromWSDL", "URISyntaxException thrown whilst trying to generate Input Action");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getActionForInputMessageFromWSDL", actionURI);
        }
        return actionURI;
    }

    public AttributedURI getActionForOutputMessageFromWSDL() {
        AttributedURI actionURI;
        block6: {
            String wsaAction;
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.entry(TRACE_COMPONENT, "getActionForOutputMessageFromWSDL");
            }
            if ((wsaAction = this._rpcContext.getOutputWSAAction()) == null || wsaAction.length() < 1 || wsaAction.equals("")) {
                wsaAction = this.generateDefaultActionPatternForMessage(MessageType.RESPONSE);
            }
            actionURI = null;
            try {
                if (wsaAction != null) {
                    actionURI = WSAddressingFactory.createAttributedURI(new URI(wsaAction));
                }
            }
            catch (URISyntaxException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.wsaddressing.handlers.ActionSpecifier.getActionForOutputMessageFromWSDL", "1:210:1.30", e);
                if (!TRACE_COMPONENT.isEntryEnabled()) break block6;
                Tr.debug(TRACE_COMPONENT, "getActionForOutputMessageFromWSDL", "URISyntaxException thrown whilst trying to generate Output Action");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getActionForOutputMessageFromWSDL", actionURI);
        }
        return actionURI;
    }

    public AttributedURI getActionForFaultMessageFromWSDL(NamespaceData namespaceData, boolean isWSAFault) {
        AttributedURI actionURI;
        block12: {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.entry(TRACE_COMPONENT, "getActionForFaultMessageFromWSDL");
            }
            if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(namespaceData.getNamespace())) {
                AttributedURI auri = WSAddressingFactory.createAttributedURI(namespaceData.getFaultActionURI());
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getActionForFaultMessageFromWSDL", auri);
                }
                return auri;
            }
            if (isWSAFault) {
                AttributedURI auri = WSAddressingFactory.createAttributedURI(namespaceData.getFaultActionURI());
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getActionForFaultMessageFromWSDL", auri);
                }
                return auri;
            }
            String wsaAction = this._rpcContext.getFaultWSAAction();
            if (wsaAction == null || wsaAction.length() < 1 || wsaAction.equals("")) {
                wsaAction = this.generateDefaultActionPatternForMessage(MessageType.FAULT);
            }
            URI defaultAction = null;
            if (wsaAction == null || wsaAction.length() < 1 || wsaAction.equals("")) {
                defaultAction = namespaceData.getFaultActionURI();
            }
            actionURI = null;
            try {
                if (wsaAction != null) {
                    actionURI = WSAddressingFactory.createAttributedURI(new URI(wsaAction));
                }
                if (defaultAction != null) {
                    actionURI = WSAddressingFactory.createAttributedURI(defaultAction);
                }
            }
            catch (URISyntaxException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.wsaddressing.handlers.ActionSpecifier.getActionForFaultMessageFromWSDL", "1:285:1.30", e);
                if (!TRACE_COMPONENT.isEntryEnabled()) break block12;
                Tr.debug(TRACE_COMPONENT, "getActionForOutputMessageFromWSDL", "URISyntaxException thrown whilst trying to generate Output Action");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getActionForFaultMessageFromWSDL", actionURI);
        }
        return actionURI;
    }

    protected void soapActionMustMatch(String soapAction, String wsaAction) throws JAXRPCException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "soapActionMustMatch", new Object[]{soapAction, wsaAction});
        }
        if (soapAction == null || soapAction.length() < 1 || soapAction.equals("")) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "soapActionMustMatch", "SoapAction is null so do not compare to Addressing Action.");
            }
            return;
        }
        if (soapAction.equals(wsaAction)) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "SoapAction matches wsa:Action.");
            }
        } else {
            String message = "WS-Addressing Configuration Error: The SoapActionUri set on the stub/call properties ( " + soapAction + " ) does not match the WS-Addressing action defined in the target service WSDL by the <wsaw:Action> marker, or generated from the WSDL using the default action pattern ( " + wsaAction + " ).";
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.debug(TRACE_COMPONENT, message);
                Tr.exit(TRACE_COMPONENT, "soapActionMustMatch", new Object[]{soapAction, wsaAction});
            }
            throw new JAXRPCException("SoapActionUri does not match the WSAddressing Action obtained from the WSDL.  This is an invalid configuration according to the W3C WSA specification.");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "soapActionMustMatch");
        }
    }

    private String generateDefaultActionPatternForMessage(MessageType msgType) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "generateDefaultActionPatternForMessage", (Object)msgType);
        }
        StringBuffer sb = new StringBuffer();
        String defaultTNSSlashPortType = this.getDefaultTargetNamespaceDelimPortTypeDelim();
        if (defaultTNSSlashPortType == null) {
            String msg = "Unable to determine wsa:Action value.";
            Tr.exit(TRACE_COMPONENT, "generateDefaultActionPatternForMessage", msg);
            return null;
        }
        String delim = defaultTNSSlashPortType.substring(defaultTNSSlashPortType.length() - 1);
        sb.append(defaultTNSSlashPortType);
        String messageName = this.getWSDLName(msgType);
        if (messageName == null) {
            String msg = "Unable to determine wsa:Action value as WSDL Name value not generated.";
            Tr.exit(TRACE_COMPONENT, "generateDefaultActionPatternForMessage", msg);
            return null;
        }
        if (msgType.equals((Object)MessageType.REQUEST) || msgType.equals((Object)MessageType.RESPONSE)) {
            sb.append(messageName);
        } else if (msgType.equals((Object)MessageType.FAULT)) {
            String operationName = this._rpcContext.getWSDLOperation();
            sb.append(operationName);
            sb.append(delim);
            sb.append("Fault");
            sb.append(delim);
            sb.append(messageName);
        }
        String result = sb.toString();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "generateDefaultActionPatternForMessage", result);
        }
        return result;
    }

    private String getWSDLName(MessageType msgType) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getWSDLName", (Object)msgType);
        }
        String messageName = null;
        if (MessageType.REQUEST.equals((Object)msgType)) {
            messageName = this._rpcContext.getWSDLInputName();
            if (messageName == null || messageName.length() < 1) {
                messageName = this._rpcContext.getWSDLOperation();
                if (!((MessageContext)this._rpcContext).isOneWay()) {
                    messageName = messageName + "Request";
                }
            }
        } else if (MessageType.RESPONSE.equals((Object)msgType)) {
            messageName = this._rpcContext.getWSDLOutputName();
            if (messageName == null || messageName.length() < 1) {
                messageName = this._rpcContext.getWSDLOperation() + "Response";
            }
        } else if (MessageType.FAULT.equals((Object)msgType)) {
            messageName = this._rpcContext.getWSDLFaultName();
        } else {
            String msg = "Invalid internal parameter passed in to private method so do not know whether message is REQUEST, RESPONSE, or FAULT.";
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getWSDLName", msg);
            }
            return null;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getWSDLName", messageName);
        }
        return messageName;
    }

    private String getDefaultTargetNamespaceDelimPortTypeDelim() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getDefaultTargetNamespaceDelimPortTypeDelim");
        }
        StringBuffer sb = new StringBuffer();
        String tns = this._rpcContext.getWSDLTargetNamespace();
        if (tns == null || tns.length() < 1) {
            String msg = "Unable to determine targetNameSpace via RPCContext.";
            Tr.exit(TRACE_COMPONENT, "getDefaultTargetNamespaceDelimPortTypeDelim", msg);
            return null;
        }
        sb.append(tns);
        String delim = "/";
        if (tns.startsWith("urn:") || tns.startsWith("URN:")) {
            delim = ":";
        }
        if (!tns.endsWith(delim)) {
            sb.append(delim);
        }
        QName wsdlPortType = this._rpcContext.getWSDLPortType();
        String portType = null;
        if (wsdlPortType == null) {
            String msg = "Unable to determine wsdlPortType via RPCContext.";
            Tr.exit(TRACE_COMPONENT, "getDefaultTargetNamespaceDelimPortTypeDelim", msg);
            return null;
        }
        portType = wsdlPortType.getLocalPart();
        if (portType == null || portType.length() < 1) {
            String msg = "Unable to determine PortType localpart via RPCContext.";
            Tr.exit(TRACE_COMPONENT, "getDefaultTargetNamespaceDelimPortTypeDelim", msg);
            return null;
        }
        sb.append(portType);
        sb.append(delim);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] returnParams = new Object[]{sb.toString()};
            Tr.exit(TRACE_COMPONENT, "getDefaultTargetNamespaceDelimPortTypeDelim", returnParams);
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MessageType {
        REQUEST,
        RESPONSE,
        FAULT;

    }
}

