/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.binders;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wsaddressing.binders.BinderHelper;
import com.ibm.ws.wsaddressing.namespace.NamespaceData;
import com.ibm.wsspi.wsaddressing.ServiceName;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class ServiceNameTypeBinder {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(ServiceNameTypeBinder.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private BinderHelper _binderHelper = new BinderHelper();

    public String getJavaName() {
        return "com.ibm.wsspi.wsaddressing.ServiceName";
    }

    public SOAPElement serialize(Object data, SOAPElement rootNode, NamespaceData namespaceData) throws SOAPException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] params = new Object[]{data, rootNode, namespaceData};
            Tr.entry(TRACE_COMPONENT, "serialize", params);
        }
        this._binderHelper.validateSerializeMethodParameters(data, rootNode, "ServiceNameType", namespaceData);
        if (!(data instanceof ServiceName)) {
            String javaName = this.getJavaName();
            String unexpectedName = data.getClass().getName();
            String binderName = "ServiceNameTypeBinder";
            String message = "The object to be bound passed to " + binderName + " was of incorrect type. Expected class implementing:[" + javaName + "] but was:[" + unexpectedName + "]";
            Tr.error(TRACE_COMPONENT, message);
            throw new SOAPException(message);
        }
        ServiceName serviceName = (ServiceName)data;
        rootNode = this.serializeServiceNameSpecificData(rootNode, serviceName, namespaceData);
        rootNode = this._binderHelper.addAttributesToSOAPElementFromAttributedType(rootNode, serviceName);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "serialize", rootNode);
        }
        return rootNode;
    }

    public Object deserialize(SOAPElement source, NamespaceData namespaceData) throws SOAPException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] params = new Object[]{source, namespaceData};
            Tr.entry(TRACE_COMPONENT, "deserialize", params);
        }
        this._binderHelper.checkForNullSOAPElement(source, "ServiceNameType");
        if (namespaceData == null) {
            String message = "Namespace Data object passed to ServiceNameBinder was null";
            Tr.error(TRACE_COMPONENT, message);
            throw new SOAPException(message);
        }
        QName retrievedQName = this._binderHelper.getQNameFromSOAPElementTextValue(source);
        ServiceName serviceName = WSAddressingFactory.createServiceName(retrievedQName);
        serviceName.setEndpointName(source.getAttributeValue(namespaceData.getwsawEndpointName()));
        source.removeAttribute(namespaceData.getwsawEndpointName());
        serviceName = (ServiceName)this._binderHelper.addAttributesToAttributedTypeFromSOAPElement(source, serviceName);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "deserialize", serviceName);
        }
        return serviceName;
    }

    private SOAPElement serializeServiceNameSpecificData(SOAPElement rootNode, ServiceName serviceName, NamespaceData namespaceData) throws SOAPException {
        QName qnameValue = serviceName.getQName();
        rootNode = this._binderHelper.addQNameAsTextValueToSOAPElement(rootNode, qnameValue);
        String endpointName = serviceName.getEndpointName();
        if (endpointName != null && endpointName.length() > 0) {
            rootNode.addAttribute(namespaceData.getwsawEndpointName(), endpointName);
        }
        return rootNode;
    }
}

