/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.binders;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.wsaddressing.binders.BinderHelper;
import com.ibm.ws.wsaddressing.namespace.NamespaceData;
import com.ibm.wsspi.wsaddressing.Relationship;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;

public class RelationshipBinder {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.binders.RelationshipBinder";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(RelationshipBinder.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private BinderHelper _binderHelper = new BinderHelper();

    public QName getQName() {
        return new QName("http://www.w3.org/2005/08/addressing", "Relationship");
    }

    public String getJavaName() {
        return "com.ibm.wsspi.wsaddressing.Relationship";
    }

    public javax.xml.soap.SOAPElement serialize(Object data, javax.xml.soap.SOAPElement rootNode, NamespaceData namespaceData) throws SOAPException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] params = new Object[]{data, rootNode, namespaceData};
            Tr.entry(TRACE_COMPONENT, "serialize", params);
        }
        this._binderHelper.validateSerializeMethodParameters(data, rootNode, "Relationship");
        if (!(data instanceof Relationship)) {
            String javaName = this.getJavaName();
            String unexpectedName = data.getClass().getName();
            String binderName = "RelationshipBinder";
            String message = "The object to be bound passed to " + binderName + " was of incorrect type. Expected class implementing:[" + javaName + "] but was:[" + unexpectedName + "]";
            Tr.error(TRACE_COMPONENT, message);
            throw new SOAPException(message);
        }
        Relationship relationship = (Relationship)data;
        rootNode.addTextNode(relationship.getURI().toString());
        rootNode = this._binderHelper.addAttributesToSOAPElementFromAttributedType(rootNode, relationship);
        URI relationshipType = relationship.getRelationshipType();
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "RelationshipType is :", relationshipType);
        }
        if (relationshipType == null || relationshipType.equals(namespaceData.getReplyRelationshipURI())) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "RelationshipType is default wsa:Reply so is not being specified on the relationship.");
            }
        } else {
            String relationshipTypeString = relationshipType.toString();
            rootNode.addAttribute(namespaceData.getwsaRelationshipType(), relationshipTypeString);
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "RelationShipType Attribute added to relationship is : ", relationshipTypeString);
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "serialize", rootNode);
        }
        return rootNode;
    }

    public Object deserialize(javax.xml.soap.SOAPElement source, NamespaceData namespaceData) throws SOAPException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] params = new Object[]{source, namespaceData};
            Tr.entry(TRACE_COMPONENT, "deserialize", params);
        }
        this._binderHelper.checkForNullSOAPElement(source, "Relationship");
        URI address = null;
        try {
            String val = source.getValue();
            if (val != null) {
                address = new URI(val.trim());
            } else {
                String message = "The SOAPElement did not contain a value";
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.warning(TRACE_COMPONENT, message);
                }
            }
        }
        catch (URISyntaxException e) {
            String message = "Caught a URISyntaxException: " + e.getMessage() + " when trying to deserialize an element of type wsa:Relationship";
            Tr.error(TRACE_COMPONENT, message);
            FFDCFilter.processException(e, CLASSNAME, "1:1.22:227");
            throw new SOAPException(message, (Throwable)e);
        }
        SOAPFactory sf = ((SOAPElement)source).getSOAPFactory();
        Relationship relationship = WSAddressingFactory.createRelationship(address);
        URI relationshipType = null;
        String relationshipTypeAttributeValue = source.getAttributeValue(namespaceData.getwsaRelationshipType());
        relationshipType = this.getRelationshipTypeURI(source, relationshipTypeAttributeValue, namespaceData, sf);
        source.removeAttribute(namespaceData.getwsaRelationshipType());
        relationship.setRelationshipType(relationshipType);
        this._binderHelper.addAttributesToAttributedTypeFromSOAPElement(source, relationship);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "deserialize", relationship);
        }
        return relationship;
    }

    private URI getRelationshipTypeURI(javax.xml.soap.SOAPElement source, String relationshipTypeAttributeValue, NamespaceData namespaceData, javax.xml.soap.SOAPFactory sf) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] params = new Object[]{source, relationshipTypeAttributeValue, namespaceData, sf};
            Tr.entry(TRACE_COMPONENT, "getRelationshipTypeURI", params);
        }
        URI resultURI = null;
        if (namespaceData.getNamespace().equals("http://schemas.xmlsoap.org/ws/2004/08/addressing")) {
            if (this.is200408Default(source, relationshipTypeAttributeValue, namespaceData, sf)) {
                resultURI = namespaceData.getReplyRelationshipURI();
            }
        } else {
            try {
                if (relationshipTypeAttributeValue != null) {
                    resultURI = URI.create(relationshipTypeAttributeValue);
                }
            }
            catch (IllegalArgumentException iae) {
                Tr.warning(TRACE_COMPONENT, "RelationshipType attribute was not a valid URI");
                FFDCFilter.processException(iae, CLASSNAME, "1:271:1.22");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getRelationshipTypeURI", resultURI);
        }
        return resultURI;
    }

    private boolean is200408Default(javax.xml.soap.SOAPElement source, String relationshipTypeAttributeValue, NamespaceData namespaceData, javax.xml.soap.SOAPFactory sf) {
        int colonIndex;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] params = new Object[]{source, relationshipTypeAttributeValue, namespaceData, sf};
            Tr.entry(TRACE_COMPONENT, "is200408Default", params);
        }
        if (relationshipTypeAttributeValue != null && relationshipTypeAttributeValue.length() > 0 && (colonIndex = relationshipTypeAttributeValue.indexOf(":")) > -1) {
            String namespacePrefix = relationshipTypeAttributeValue.substring(0, colonIndex);
            String namespaceURI = source.getNamespaceURI(namespacePrefix);
            String localName = relationshipTypeAttributeValue.substring(colonIndex + 1);
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "RelationShipType Attribute found.");
                Tr.debug(TRACE_COMPONENT, "     RelationShipType Namespace is: ", namespaceURI);
                Tr.debug(TRACE_COMPONENT, "     RelationShipType Prefix is:    ", namespacePrefix);
                Tr.debug(TRACE_COMPONENT, "     RelationShipType localName is: ", localName);
            }
            if (namespaceData.getNamespace().equals(namespaceURI) && localName.equals("Reply")) {
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "is200408Default", Boolean.TRUE);
                }
                return true;
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "is200408Default", Boolean.FALSE);
        }
        return false;
    }
}

