/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.binders;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.ExtensibleType;
import com.ibm.ws.wsaddressing.namespace.NamespaceData;
import com.ibm.wsspi.wsaddressing.AttributedType;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.Text;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;

public class BinderHelper {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(BinderHelper.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");

    protected void validateSerializeMethodParameters(Object data, SOAPElement rootNode, String javaType) throws SOAPException {
        if (data == null) {
            String message = "Object to be bound passed to " + javaType + "Binder was null";
            Tr.error(TRACE_COMPONENT, message);
            throw new SOAPException(message);
        }
        this.checkForNullSOAPElement(rootNode, javaType);
    }

    protected void validateSerializeMethodParameters(Object data, SOAPElement rootNode, String javaType, NamespaceData namespaceData) throws SOAPException {
        if (namespaceData == null) {
            String message = "Namespace Data object passed to " + javaType + "Binder was null";
            Tr.error(TRACE_COMPONENT, message);
            throw new SOAPException(message);
        }
        this.validateSerializeMethodParameters(data, rootNode, javaType);
    }

    protected void checkForNullSOAPElement(SOAPElement source, String javaType) throws SOAPException {
        if (source == null) {
            String message = "The SOAPElement passed to " + javaType + "Binder was null";
            Tr.error(TRACE_COMPONENT, message);
            throw new SOAPException(message);
        }
    }

    protected SOAPElement addAttributesToSOAPElementFromAttributedType(SOAPElement rootNode, AttributedType attributedType) throws SOAPException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] params = new Object[]{rootNode, attributedType};
            Tr.entry(TRACE_COMPONENT, "addAttributesToSOAPElementFromAttributedType", params);
        }
        Iterator attributeNameIterator = attributedType.getAttributeNames();
        while (attributeNameIterator.hasNext()) {
            Name attributeName = (Name)attributeNameIterator.next();
            rootNode.addAttribute(attributeName, attributedType.getAttributeValue(attributeName));
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addAttributesToSOAPElementFromAttributedType", rootNode);
        }
        return rootNode;
    }

    protected AttributedType addAttributesToAttributedTypeFromSOAPElement(SOAPElement source, AttributedType attributedType) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] params = new Object[]{source, attributedType};
            Tr.entry(TRACE_COMPONENT, "addAttributesToAttributedTypeFromSOAPElement", params);
        }
        NamedNodeMap map = source.getAttributes();
        Iterator attributeNameIterator = source.getAllAttributes();
        while (attributeNameIterator.hasNext()) {
            Name attributeName = (Name)attributeNameIterator.next();
            Attr attribute = (Attr)map.getNamedItemNS(attributeName.getURI(), attributeName.getLocalName());
            if (attribute != null) {
                attributedType.addAttribute(attributeName, attribute.getValue());
                continue;
            }
            attributedType.addAttribute(attributeName, source.getAttributeValue(attributeName));
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addAttributesToAttributedTypeFromSOAPElement", attributedType);
        }
        return attributedType;
    }

    protected SOAPElement addQNameAsTextValueToSOAPElement(SOAPElement rootNode, QName qnameValue) throws SOAPException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] params = new Object[]{rootNode, qnameValue};
            Tr.entry(TRACE_COMPONENT, "addQNameAsTextValueToSOAPElement", params);
        }
        String prefix = qnameValue.getPrefix();
        String namespace = qnameValue.getNamespaceURI();
        if (namespace != null && namespace.length() != 0) {
            if (prefix == null || prefix.length() == 0) {
                prefix = "ns" + namespace.hashCode();
            }
            rootNode.addNamespaceDeclaration(prefix, namespace);
        }
        String textValue = prefix == null || prefix.length() == 0 ? "" : prefix + ":";
        textValue = textValue + qnameValue.getLocalPart();
        rootNode.addTextNode(textValue);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addQNameAsTextValueToSOAPElement", rootNode);
        }
        return rootNode;
    }

    protected QName getQNameFromSOAPElementTextValue(SOAPElement source) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] params = new Object[]{source};
            Tr.entry(TRACE_COMPONENT, "getQNameFromSOAPElementTextValue", params);
        }
        String qnameTextValue = source.getValue();
        QName retrievedQName = null;
        int colonIndex = qnameTextValue.indexOf(":");
        if (colonIndex == -1) {
            retrievedQName = new QName(qnameTextValue);
        } else {
            String namespacePrefix = qnameTextValue.substring(0, colonIndex);
            String namespaceURI = source.getNamespaceURI(namespacePrefix);
            String localName = qnameTextValue.substring(colonIndex + 1);
            retrievedQName = new QName(namespaceURI, localName, namespacePrefix);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getQNameFromSOAPElementTextValue", retrievedQName);
        }
        return retrievedQName;
    }

    protected void addChildElementsToExtensibleType(SOAPFactory sf, SOAPElement source, ExtensibleType eti) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] params = new Object[]{sf, source, eti};
            Tr.entry(TRACE_COMPONENT, "addChildElementsToExtensibleType", params);
        }
        Iterator extensibilityElementsIterator = source.getChildElements();
        while (extensibilityElementsIterator.hasNext()) {
            Object object = extensibilityElementsIterator.next();
            SOAPElement thisExtensibilityElement = null;
            if (object instanceof SOAPElement) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.info(TRACE_COMPONENT, "Extensibility Element is of type javax.xml.soap.SOAPEElement", object);
                }
                thisExtensibilityElement = (SOAPElement)object;
                eti.addExtensibilityElement(thisExtensibilityElement);
                continue;
            }
            if (object instanceof Text) {
                Text soapTextElement;
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.info(TRACE_COMPONENT, "Extensibility Element is of type javax.xml.soap.Text", object);
                }
                if ((thisExtensibilityElement = this.getSOAPElementFromTextElement(soapTextElement = (Text)object, sf)) == null) continue;
                eti.addExtensibilityElement(thisExtensibilityElement);
                continue;
            }
            if (!TRACE_COMPONENT.isDebugEnabled()) continue;
            Tr.error(TRACE_COMPONENT, "Ref property/param was not of type text or SOAPElement", object);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addChildElementsToExtensibleType");
        }
    }

    protected SOAPElement getSOAPElementFromTextElement(Text soapTextElement, SOAPFactory sf) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getSOAPElementFromTextElement", soapTextElement);
        }
        SOAPElement soapElementToReturn = null;
        try {
            String localName = soapTextElement.getLocalName();
            String prefix = soapTextElement.getPrefix();
            String uri = soapTextElement.getNamespaceURI();
            if (prefix == null && uri == null && localName == null) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.info(TRACE_COMPONENT, "Text object just contained whitespace");
                }
                soapElementToReturn = null;
            } else {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.info(TRACE_COMPONENT, "Found TextObject and converted to SOAPElement ref param/prop  Local name:" + localName + " prefix: " + prefix + " uri: " + uri);
                }
                soapElementToReturn = prefix != null && uri != null ? sf.createElement(localName, prefix, uri) : sf.createElement(localName);
                soapElementToReturn.setValue(soapTextElement.getValue());
            }
        }
        catch (SOAPException e) {
            FFDCFilter.processException(e, BinderHelper.class.getName() + ".getSOAPElementFromTextElement", "1:362:1.7", this, new Object[]{soapElementToReturn, soapTextElement});
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getSOAPElementFromTextElement", soapElementToReturn);
        }
        return soapElementToReturn;
    }
}

