/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.binders;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.binders.BinderHelper;
import com.ibm.wsspi.webservices.binding.CustomBinder;
import com.ibm.wsspi.webservices.binding.CustomBindingContext;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class AttributedURIBinder
implements CustomBinder {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.binders.AttributedURIBinder";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(AttributedURIBinder.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private BinderHelper _binderHelper = new BinderHelper();

    public String getQNameScope() {
        return "complexType";
    }

    public QName getQName() {
        return new QName("http://www.w3.org/2005/08/addressing", "AttributedURI");
    }

    public String getJavaName() {
        return "com.ibm.wsspi.wsaddressing.AttributedURI";
    }

    public SOAPElement serialize(Object data, SOAPElement rootNode, CustomBindingContext context) throws SOAPException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] params = new Object[]{data, rootNode, context};
            Tr.entry(TRACE_COMPONENT, "serialize", params);
        }
        this._binderHelper.validateSerializeMethodParameters(data, rootNode, "AttributedURI");
        if (!(data instanceof AttributedURI)) {
            String javaName = this.getJavaName();
            String unexpectedName = data.getClass().getName();
            String binderName = "AttributedURIBinder";
            String message = "The object to be bound passed to " + binderName + " was of incorrect type. Expected class implementing:[" + javaName + "] but was:[" + unexpectedName + "]";
            Tr.error(TRACE_COMPONENT, message);
            throw new SOAPException(message);
        }
        AttributedURI attributedURI = (AttributedURI)data;
        rootNode.addTextNode(attributedURI.getURI().toString());
        rootNode = this._binderHelper.addAttributesToSOAPElementFromAttributedType(rootNode, attributedURI);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "serialize", rootNode);
        }
        return rootNode;
    }

    public Object deserialize(SOAPElement source, CustomBindingContext context) throws SOAPException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] params = new Object[]{source, context};
            Tr.entry(TRACE_COMPONENT, "deserialize", params);
        }
        this._binderHelper.checkForNullSOAPElement(source, "AttributeURI");
        URI address = null;
        String auriValue = source.getValue();
        if (auriValue != null && auriValue.length() > 0) {
            try {
                address = new URI(auriValue.trim());
            }
            catch (URISyntaxException e) {
                String message = "Check the contents on the SOAPHeader.  The URI " + auriValue.trim() + " cound not be created. " + e.getMessage();
                Tr.warning(TRACE_COMPONENT, message);
                FFDCFilter.processException(e, CLASSNAME, "1:159:1.19");
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Object[] params = new Object[]{address, auriValue};
                    Tr.exit(TRACE_COMPONENT, "deserialize", params);
                }
                return null;
            }
        } else {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Object[] params = new Object[]{address, auriValue};
                Tr.exit(TRACE_COMPONENT, "deserialize", params);
            }
            return null;
        }
        AttributedURI attributedURI = WSAddressingFactory.createAttributedURI(address);
        this._binderHelper.addAttributesToAttributedTypeFromSOAPElement(source, attributedURI);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "deserialize", attributedURI);
        }
        return attributedURI;
    }
}

