/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.binders;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wsaddressing.binders.BinderHelper;
import com.ibm.wsspi.webservices.binding.CustomBinder;
import com.ibm.wsspi.webservices.binding.CustomBindingContext;
import com.ibm.wsspi.wsaddressing.AttributedQName;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class AttributedQNameBinder
implements CustomBinder {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(AttributedQNameBinder.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private BinderHelper _binderHelper = new BinderHelper();

    public String getQNameScope() {
        return "complexType";
    }

    public QName getQName() {
        return new QName("http://www.w3.org/2005/08/addressing", "AttributedQName");
    }

    public String getJavaName() {
        return "com.ibm.wsspi.wsaddressing.AttributedQName";
    }

    public SOAPElement serialize(Object data, SOAPElement rootNode, CustomBindingContext context) throws SOAPException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] params = new Object[]{data, rootNode, context};
            Tr.entry(TRACE_COMPONENT, "serialize", params);
        }
        this._binderHelper.validateSerializeMethodParameters(data, rootNode, "AttributedQName");
        if (!(data instanceof AttributedQName)) {
            String javaName = this.getJavaName();
            String unexpectedName = data.getClass().getName();
            String binderName = "AttributedQNameBinder";
            String message = "The object to be bound passed to " + binderName + " was of incorrect type. Expected class implementing:[" + javaName + "] but was:[" + unexpectedName + "]";
            Tr.error(TRACE_COMPONENT, message);
            throw new SOAPException(message);
        }
        AttributedQName attributedQName = (AttributedQName)data;
        rootNode = this._binderHelper.addQNameAsTextValueToSOAPElement(rootNode, attributedQName.getQName());
        rootNode = this._binderHelper.addAttributesToSOAPElementFromAttributedType(rootNode, attributedQName);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "serialize", rootNode);
        }
        return rootNode;
    }

    public Object deserialize(SOAPElement source, CustomBindingContext context) throws SOAPException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] params = new Object[]{source, context};
            Tr.entry(TRACE_COMPONENT, "deserialize", params);
        }
        this._binderHelper.checkForNullSOAPElement(source, "AttributedQName");
        QName retrievedQName = this._binderHelper.getQNameFromSOAPElementTextValue(source);
        AttributedQName attributedQName = WSAddressingFactory.createAttributedQName(retrievedQName);
        this._binderHelper.addAttributesToAttributedTypeFromSOAPElement(source, attributedQName);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "deserialize", attributedQName);
        }
        return attributedQName;
    }
}

