/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.webservices.soap.IBMSOAPElement;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.wsaddressing.ReferenceParameter;
import com.ibm.ws.wsrf.WebSphereIOSerializableSOAPElement;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class PersistableSOAPElement
implements Externalizable,
ReferenceParameter,
WebSphereIOSerializableSOAPElement {
    private static final long serialVersionUID = 1399290188997056040L;
    private static final TraceComponent TRACE_COMPONENT = Tr.register(PersistableSOAPElement.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private transient SOAPElement _soapElement = null;
    private String _xmlString = "";

    public PersistableSOAPElement() {
    }

    public PersistableSOAPElement(SOAPElement soapElement) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "PersistableSOAPElement", soapElement);
        }
        this._soapElement = soapElement;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "PersistableSOAPElement");
        }
    }

    public SOAPElement getSOAPElement() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getSOAPElement");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getSOAPElement", this._soapElement);
        }
        return this._soapElement;
    }

    public void setSOAPElement(SOAPElement soapElement) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setSOAPElement", soapElement);
        }
        this._soapElement = soapElement;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setSOAPElement");
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] params = new Object[]{this._soapElement, this._xmlString, out};
            Tr.entry(TRACE_COMPONENT, "writeExternal", params);
        }
        this.convertSoapElementToInitialiseXMLString();
        out.writeObject(this._xmlString);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "writeExternal");
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Object[] params;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            params = new Object[]{this._soapElement, this._xmlString, in};
            Tr.entry(TRACE_COMPONENT, "readExternal", params);
        }
        this._xmlString = (String)in.readObject();
        if (this._xmlString == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                params = new Object[]{this._soapElement, this._xmlString};
                Tr.debug(TRACE_COMPONENT, "readExternal", params);
            }
        } else {
            this.xmlStringToSOAPElement();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            params = new Object[]{this._soapElement, this._xmlString};
            Tr.exit(TRACE_COMPONENT, "readExternal", params);
        }
    }

    private void xmlStringToSOAPElement() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "xmlStringToSOAPElement");
        }
        SOAPFactory sf = new SOAPFactory();
        try {
            this._soapElement = sf.createElementFromXMLString(this._xmlString);
        }
        catch (SOAPException e) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "xmlStringToSOAPElement", new Object[]{this._soapElement, this._xmlString});
            }
            FFDCFilter.processException(e, this.getClass().getName() + ".xmlStringToSOAPElement", "1:255:1.18", this, new Object[]{this._soapElement, this._xmlString});
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "xmlStringToSOAPElement");
        }
    }

    private void convertSoapElementToInitialiseXMLString() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] params = new Object[]{this._soapElement, this._xmlString};
            Tr.entry(TRACE_COMPONENT, "soapElementToXMLString", params);
        }
        if (this._soapElement != null) {
            this._xmlString = ((IBMSOAPElement)this._soapElement).toXMLString(true);
            if (this._xmlString == null) {
                this._xmlString = "";
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "soapElementToXMLString");
        }
    }

    public String toString() {
        if (this._soapElement != null) {
            this.convertSoapElementToInitialiseXMLString();
        } else {
            this._xmlString = "";
        }
        return this._xmlString;
    }

    public boolean equals(Object o) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] params = new Object[]{this._soapElement, o};
            Tr.entry(TRACE_COMPONENT, "equals", params);
        }
        boolean areEqual = false;
        if (o instanceof PersistableSOAPElement) {
            PersistableSOAPElement pseFromObject = (PersistableSOAPElement)o;
            areEqual = this.getSOAPElement() == null ? pseFromObject.getSOAPElement() == null : (this.getSOAPElement().getValue() != null ? (areEqual = this.getQName().equals(pseFromObject.getQName())) && this.getSOAPElement().getValue().equals(pseFromObject.getSOAPElement().getValue()) : pseFromObject.toString().equals(this.toString()));
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            if (areEqual) {
                Tr.exit(TRACE_COMPONENT, "getQName", "true");
            } else {
                Tr.exit(TRACE_COMPONENT, "getQName", "false");
            }
        }
        return areEqual;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        if (this._soapElement != null) {
            if (this._soapElement.getValue() != null) {
                result = 31 * result + this._soapElement.getElementQName().hashCode();
                result = 31 * result + this._soapElement.getValue().hashCode();
            } else {
                result = 31 * result + this.toString().hashCode();
            }
        }
        return result;
    }

    public QName getQName() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getQName");
        }
        QName qname = null;
        if (this._soapElement != null) {
            qname = this._soapElement.getElementQName();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getQName", qname);
        }
        return qname;
    }

    public String getStringValue() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getStringValue");
        }
        String value2 = null;
        if (this._soapElement != null && this._soapElement.getChildElements() != null) {
            value2 = this._soapElement.getValue();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getStringValue");
        }
        return value2;
    }
}

