/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.xml;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.xml.BaseType;
import com.ibm.ws.webservices.xml.SimpleType;
import java.text.ParseException;
import java.util.Date;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComplexType
extends BaseType {
    private static final TraceComponent _tc = Tr.register(BaseType.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");

    public boolean removeElement(int index, String elementName) {
        Node deleteNode;
        NodeList nodes = this.xmlElement.getElementsByTagName(elementName);
        int length = nodes.getLength();
        if (index < length && (deleteNode = nodes.item(index)) != null) {
            try {
                this.xmlElement.removeChild(deleteNode);
                return true;
            }
            catch (DOMException ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.xml.ComplexType.removeElement", "64", this);
                Tr.error(_tc, "internal.error", ex);
            }
        }
        return false;
    }

    public void setElementValue(int index, String elementName, BaseType baseType) {
        Element childXml = baseType.getXMLElement();
        this.insertXMLElementAtLocation(childXml, index, elementName);
    }

    public void setElementValue(int index, String elementName, String elementValue) {
        Element newChild = this.factory.createXMLElementAndText(elementName, elementValue);
        this.insertXMLElementAtLocation(newChild, index, elementName);
    }

    public void setElementValue(int index, String elementName, boolean value2) {
        this.setElementValue(index, elementName, new Boolean(value2).toString());
    }

    public void setElementValue(int index, String elementName, int value2) {
        this.setElementValue(index, elementName, new Integer(value2).toString());
    }

    public void setElementValue(int index, String elementName, float value2) {
        this.setElementValue(index, elementName, new Float(value2).toString());
    }

    public void setElementValue(int index, String elementName, double value2) {
        this.setElementValue(index, elementName, new Double(value2).toString());
    }

    public void setElementValue(int index, String elementName, long value2) {
        this.setElementValue(index, elementName, new Long(value2).toString());
    }

    public void setElementValue(int index, String elementName, short value2) {
        this.setElementValue(index, elementName, new Short(value2).toString());
    }

    public void setElementValue(int index, String elementName, byte value2) {
        this.setElementValue(index, elementName, new Byte(value2).toString());
    }

    public void setElementValue(int index, String elementName, Date value2) {
        this.setElementValue(index, elementName, this.simpleDateFormat.format(value2));
    }

    public boolean getElementBooleanValue(String elementName, int index) {
        return new Boolean(this.getElementValue(elementName, index));
    }

    public int getElementIntegerValue(String elementName, int index) {
        return new Integer(this.getElementValue(elementName, index));
    }

    public float getElementFloatValue(String elementName, int index) {
        return new Float(this.getElementValue(elementName, index)).floatValue();
    }

    public double getElementDoubleValue(String elementName, int index) {
        return new Double(this.getElementValue(elementName, index));
    }

    public long getElementLongValue(String elementName, int index) {
        return new Long(this.getElementValue(elementName, index));
    }

    public short getElementShortValue(String elementName, int index) {
        return new Short(this.getElementValue(elementName, index));
    }

    public byte getElementByteValue(String elementName, int index) {
        return new Byte(this.getElementValue(elementName, index));
    }

    public Date getElementDateValue(String elementName, int index) {
        try {
            String result = this.getElementValue(elementName, index);
            if (result != null) {
                return this.simpleDateFormat.parse(result);
            }
        }
        catch (ParseException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.xml.ComplexType.getElementDateValue", "177", this);
            Tr.error(_tc, "internal.error", ex);
        }
        return null;
    }

    public void setAttributeValue(String attrname, String attrvalue) {
        if (this.xmlElement == null) {
            this.xmlAttr.setValue(attrvalue);
        } else {
            Attr attr = this.xmlElement.getAttributeNode(attrname);
            if (attr == null) {
                attr = this.factory.createAttribute(attrname, this.xmlElement);
            }
            attr.setValue(attrvalue);
        }
    }

    public void setAttributeValue(String attrname, SimpleType attrObject) {
        this.setAttributeValue(attrname, attrObject.getElementValue());
    }

    public void setAttributeValue(String attrname, boolean attrObject) {
        this.setAttributeValue(attrname, new Boolean(attrObject).toString());
    }

    public void setAttributeValue(String attrname, int attrObject) {
        this.setAttributeValue(attrname, new Integer(attrObject).toString());
    }

    public void setAttributeValue(String attrname, float attrObject) {
        this.setAttributeValue(attrname, new Float(attrObject).toString());
    }

    public void setAttributeValue(String attrname, double attrObject) {
        this.setAttributeValue(attrname, new Double(attrObject).toString());
    }

    public void setAttributeValue(String attrname, long attrObject) {
        this.setAttributeValue(attrname, new Long(attrObject).toString());
    }

    public void setAttributeValue(String attrname, short attrObject) {
        this.setAttributeValue(attrname, new Short(attrObject).toString());
    }

    public void setAttributeValue(String attrname, byte attrObject) {
        this.setAttributeValue(attrname, new Byte(attrObject).toString());
    }

    public void setAttributeValue(String attrname, Date attrObject) {
        this.setAttributeValue(attrname, this.simpleDateFormat.format(attrObject));
    }

    public String getAttributeValue(String attrname) {
        Attr attr = this.xmlElement.getAttributeNode(attrname);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    public boolean getAttributeBooleanValue(String attrname) {
        return new Boolean(this.getAttributeValue(attrname));
    }

    public int getAttributeIntegerValue(String attrname) {
        return new Integer(this.getAttributeValue(attrname));
    }

    public float getAttributeFloatValue(String attrname) {
        return new Float(this.getAttributeValue(attrname)).floatValue();
    }

    public double getAttributeDoubleValue(String attrname) {
        return new Double(this.getAttributeValue(attrname));
    }

    public long getAttributeLongValue(String attrname) {
        return new Long(this.getAttributeValue(attrname));
    }

    public short getAttributeShortValue(String attrname) {
        return new Short(this.getAttributeValue(attrname));
    }

    public byte getAttributeByteValue(String attrname) {
        return new Byte(this.getAttributeValue(attrname));
    }

    public Date getAttributeDateValue(String attrname) {
        try {
            String result = this.getAttributeValue(attrname);
            if (result != null) {
                return this.simpleDateFormat.parse(result);
            }
        }
        catch (ParseException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.xml.ComplexType.getAttributeDateValue", "338", this);
            Tr.error(_tc, "internal.error", ex);
        }
        return null;
    }

    public Object getAttributeValue(String property, String className) {
        Attr attr = this.xmlElement.getAttributeNode(property);
        return this.factory.newInstance(attr, className);
    }

    public boolean removeAttribute(String attrname) {
        try {
            this.xmlElement.removeAttribute(attrname);
            return true;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.xml.ComplexType.removeAttribute", "365", this);
            return false;
        }
    }

    private void insertXMLElementAtLocation(Element newChild, int index, String elementName) {
        NodeList nodes = this.xmlElement.getElementsByTagName(elementName);
        int length = nodes.getLength();
        if (index >= length) {
            Node nextSibling;
            Node lastContent;
            if (length > 0 && (lastContent = nodes.item(length - 1)) != null && (nextSibling = lastContent.getNextSibling()) != null) {
                this.xmlElement.insertBefore(newChild, nextSibling);
                return;
            }
            this.xmlElement.appendChild(newChild);
        } else {
            Node refChild = nodes.item(index);
            this.xmlElement.replaceChild(newChild, refChild);
        }
    }
}

