/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntryComparator;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaStubWriter;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import com.ibm.ws.webservices.wsdl.utils.OperationDescBuilder;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;

public class JavaServiceInformationWriter
extends JavaClassWriter {
    private ServiceEntry sEntry;
    private SymbolTable symbolTable;

    protected JavaServiceInformationWriter(Emitter emitter, ServiceEntry sEntry, SymbolTable symbolTable) {
        super(emitter, sEntry.getName() + "Information", "service");
        this.sEntry = sEntry;
        this.symbolTable = symbolTable;
        this.setDeployPhaseOnly(true);
    }

    protected String getExtendsText() {
        return "";
    }

    protected String getImplementsText() {
        return "implements com.ibm.ws.webservices.multiprotocol.ServiceInformation ";
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        Service service = this.sEntry.getService();
        this.writeComment(pw, service.getDocumentationElement());
        TreeSet types = new TreeSet(new SymTabEntryComparator());
        ArrayList<PortType> portTypes = new ArrayList<PortType>();
        HashMap ports = new HashMap();
        for (int i = 0; i < this.sEntry.numPorts(); ++i) {
            ArrayList<BindingOperationEntry> boes = new ArrayList<BindingOperationEntry>();
            PortEntry pe = this.sEntry.getPort(i);
            Port p = pe.getPort();
            Binding binding = p.getBinding();
            if (binding == null) {
                throw new IOException(Messages.getMessage("emitFailNoBinding01", new String[]{p.getName()}));
            }
            BindingEntry bEntry = this.symbolTable.getBindingEntry(binding.getQName());
            if (bEntry == null) {
                throw new IOException(Messages.getMessage("emitFailNoBindingEntry01", new String[]{binding.getQName().toString()}));
            }
            PortTypeEntry ptEntry = this.symbolTable.getPortTypeEntry(binding.getPortType().getQName());
            if (ptEntry == null) {
                throw new IOException(Messages.getMessage("emitFailNoPortType01", new String[]{binding.getPortType().getQName().toString()}));
            }
            this.populateTypesFromPortType(binding.getPortType(), bEntry, types);
            if (bEntry.isReferenced() && !portTypes.contains(binding.getPortType())) {
                portTypes.add(binding.getPortType());
                List operations = binding.getBindingOperations();
                for (int j = 0; j < operations.size(); ++j) {
                    BindingOperation operation = (BindingOperation)operations.get(j);
                    BindingOperationEntry boe = bEntry.getOperation(operation.getOperation());
                    Operation ptOperation = operation.getOperation();
                    OperationType type = ptOperation.getStyle();
                    if (type == OperationType.NOTIFICATION || type == OperationType.SOLICIT_RESPONSE) continue;
                    boes.add(boe);
                }
            }
            if (boes.size() > 1) {
                Collections.sort(boes, new Comparator(){

                    public int compare(Object obj1, Object obj2) {
                        int i = 0;
                        try {
                            i = ((BindingOperationEntry)obj1).getName().compareTo(((BindingOperationEntry)obj2).getName());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        return i;
                    }
                });
            }
            ports.put(p, boes);
        }
        this.writeStaticInitializer(pw);
        this.writeOperationDescriptions(pw, ports);
        this.writeTypeMappingMethods(pw, types);
        this.writeGetOperationDescMethods(pw);
    }

    private void populateTypesFromPortType(PortType portType, BindingEntry bEntry, Set types) {
        TreeSet firstPassTypes = new TreeSet(new SymTabEntryComparator());
        List operations = portType.getOperations();
        for (int i = 0; i < operations.size(); ++i) {
            Operation op = (Operation)operations.get(i);
            firstPassTypes.addAll(JavaStubWriter.getTypesInOperation(op, bEntry));
        }
        Iterator i = firstPassTypes.iterator();
        while (i.hasNext()) {
            TypeEntry type = (TypeEntry)i.next();
            if (types.contains(type)) continue;
            types.add(type);
            types.addAll(Utils.getNestedTypes(type, this.symbolTable));
        }
    }

    protected void writeTypeMappingMethods(PrintWriter pw, Set types) throws IOException {
        this.writeTypeMappingInitialization(pw, types);
        this.writeGetTypeMappings(pw);
        this.writeGetJavaType(pw);
    }

    protected void writeTypeMappingInitialization(PrintWriter pw, Set types) throws IOException {
        pw.println("    private static void initTypeMappings() {");
        pw.println("        typeMappings = new java.util.HashMap();");
        this.writeTypeMappings(pw, types);
        pw.println("        typeMappings = java.util.Collections.unmodifiableMap(typeMappings);");
        pw.println("    }");
        pw.println();
    }

    protected void writeGetTypeMappings(PrintWriter pw) throws IOException {
        pw.println("    public java.util.Map getTypeMappings() {");
        pw.println("        return typeMappings;");
        pw.println("    }");
        pw.println();
    }

    protected void writeGetJavaType(PrintWriter pw) throws IOException {
        pw.println("    public Class getJavaType(javax.xml.namespace.QName xmlName) {");
        pw.println("        return (Class) typeMappings.get(xmlName);");
        pw.println("    }");
        pw.println();
    }

    private void writeTypeMappings(PrintWriter pw, Set types) throws IOException {
        int mappingCount = 0;
        int mappingMethodCount = 1;
        Iterator it = types.iterator();
        while (it.hasNext()) {
            TypeEntry type = (TypeEntry)it.next();
            if (type.isBaseType() && type.getRefType() == null || type.isCollectionTypeEntry() || !(type instanceof Type) || !type.isReferenced() || type.isOnlyWrappedLiteralReferenced()) continue;
            if (mappingCount < 200) {
                this.writeType(pw, (Type)type);
                ++mappingCount;
                continue;
            }
            pw.println("        initTypeMappings" + ++mappingMethodCount + "();");
            pw.println("    }");
            pw.println("");
            pw.println("    private static void initTypeMappings" + mappingMethodCount + "() {");
            pw.println("        typeMappings = new java.util.HashMap();");
            this.writeType(pw, (Type)type);
            mappingCount = 0;
        }
    }

    private void writeType(PrintWriter pw, Type type) throws IOException {
        QName qname = type.getQName();
        pw.println("        typeMappings.put(com.ibm.ws.webservices.engine.utils.QNameTable.createQName(\"" + qname.getNamespaceURI() + "\", \"" + qname.getLocalPart() + "\"),");
        pw.println("                         " + type.getName() + ".class);");
        pw.println();
    }

    protected void writeStaticInitializer(PrintWriter pw) {
        pw.println();
        pw.println("    private static java.util.Map operationDescriptions;");
        pw.println("    private static java.util.Map typeMappings;");
        pw.println();
        pw.println("    static {");
        pw.println("         initOperationDescriptions();");
        pw.println("         initTypeMappings();");
        pw.println("    }");
        pw.println();
    }

    protected void writeOperationDescriptions(PrintWriter pw, HashMap ports) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, "UTF-8");
        PrintWriter methodPW = new PrintWriter(new BufferedWriter(writer));
        pw.println("    private static void initOperationDescriptions() { ");
        pw.println("        operationDescriptions = new java.util.HashMap();");
        pw.println();
        HashMap<QName, String> portTypes = new HashMap<QName, String>();
        Iterator it = ports.keySet().iterator();
        int innerMapID = 0;
        int varID = 0;
        while (it.hasNext()) {
            Port port2 = (Port)it.next();
            List boes = (List)ports.get(port2);
            QName pt = port2.getBinding().getPortType().getQName();
            BindingEntry bEntry = this.symbolTable.getBindingEntry(port2.getBinding().getQName());
            String innerMapVariableName = "";
            String existingMapVariable = (String)portTypes.get(pt);
            if (existingMapVariable != null) {
                innerMapVariableName = existingMapVariable;
            } else {
                innerMapVariableName = "inner" + innerMapID;
                portTypes.put(pt, innerMapVariableName);
                pw.println("        java.util.Map " + innerMapVariableName + " = new java.util.HashMap();");
                pw.println();
            }
            String previous = null;
            String listName = null;
            Iterator pit = boes.iterator();
            while (pit.hasNext()) {
                BindingOperationEntry boe = (BindingOperationEntry)pit.next();
                if (!boe.getName().equals(previous)) {
                    listName = "list" + varID;
                    pw.println("        java.util.List " + listName + " = new java.util.ArrayList();");
                    pw.println("        " + innerMapVariableName + ".put(\"" + boe.getName() + "\", " + listName + ");");
                    pw.println();
                }
                this.writeOperationEntry(pw, methodPW, boe, bEntry, listName, varID);
                previous = boe.getName();
                ++varID;
            }
            if (innerMapVariableName != null) {
                pw.println("        operationDescriptions.put(\"" + port2.getName() + "\"," + innerMapVariableName + ");");
            }
            ++innerMapID;
        }
        pw.println("        operationDescriptions = java.util.Collections.unmodifiableMap(operationDescriptions);");
        pw.println("    }");
        pw.println();
        methodPW.flush();
        pw.println(baos.toString());
    }

    protected void writeOperationEntryOld(PrintWriter pw, BindingOperationEntry boe, BindingEntry bEntry, String listName, int id) throws IOException {
        String opName = boe.getName();
        String opVar = opName + id + "Op";
        this.writeOperationDesc(pw, boe, bEntry, opVar, id);
        pw.println("        " + listName + ".add(" + opVar + ");");
        pw.println();
    }

    protected void writeOperationEntry(PrintWriter pw, PrintWriter methodPW, BindingOperationEntry boe, BindingEntry bEntry, String listName, int id) throws IOException {
        String opName = boe.getName();
        String opVar = opName + id + "Op";
        this.writeOperationDescCall(pw, opVar);
        pw.println("        " + listName + ".add(" + opVar + ");");
        pw.println();
        this.writeOperationDescMethod(methodPW, boe, bEntry, opVar);
    }

    protected void writeOperationDesc(PrintWriter pw, BindingOperationEntry boe, BindingEntry bEntry, String opDescName, int id) throws IOException {
        OperationDescBuilder odb = OperationDescBuilder.create(boe, bEntry, this.symbolTable);
        pw.println("        com.ibm.ws.webservices.engine.description.OperationDesc " + opDescName + " = null;");
        odb.writeOperationDesc(pw, true, "        ", opDescName, id);
    }

    protected void writeOperationDescMethod(PrintWriter pw, BindingOperationEntry boe, BindingEntry bEntry, String opDescName) throws IOException {
        OperationDescBuilder odb = OperationDescBuilder.create(boe, bEntry, this.symbolTable);
        pw.println("    private static com.ibm.ws.webservices.engine.description.OperationDesc _" + opDescName + "() {");
        pw.println("        com.ibm.ws.webservices.engine.description.OperationDesc " + opDescName + " = null;");
        odb.writeOperationDesc(pw, true, "        ", opDescName, 0);
        pw.println("        return " + opDescName + ";");
        pw.println();
        pw.println("    }");
        pw.println();
    }

    protected void writeOperationDescCall(PrintWriter pw, String opDescName) throws IOException {
        pw.println("        com.ibm.ws.webservices.engine.description.OperationDesc " + opDescName + " = _" + opDescName + "();");
    }

    protected void writeGetOperationDescMethods(PrintWriter pw) throws IOException {
        pw.println("    public java.util.Map getOperationDescriptions(String portName) {");
        pw.println("        return (java.util.Map) operationDescriptions.get(portName);");
        pw.println("    }");
        pw.println();
        pw.println("    public java.util.List getOperationDescriptions(String portName, String operationName) {");
        pw.println("        java.util.Map map = (java.util.Map) operationDescriptions.get(portName);");
        pw.println("        if (map != null) {");
        pw.println("            return (java.util.List) map.get(operationName);");
        pw.println("        }");
        pw.println("        return null;");
        pw.println("    }");
        pw.println();
    }
}

