/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.symbolTable;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.tools.resource.ToolEnv;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildAttribute;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildElement;
import com.ibm.ws.webservices.wsdl.symbolTable.DefinedType;
import com.ibm.ws.webservices.wsdl.symbolTable.SchemaUtils;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntryComparator;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import org.apache.commons.logging.Log;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Utils {
    protected static Log log = LogFactory.getLog("com.ibm.ws.webservices.wsdl.symbolTable.Utils");
    private static final String DERIVED_TYPES = "derivedTypes";
    private static final String NESTED_TYPES = "nestedTypes";
    private static HashSet relativeNSset = new HashSet();

    public static String getScopedAttribute(Node node, String attr, List nodeStack) {
        if (node == null) {
            if (nodeStack != null && nodeStack.size() > 0) {
                node = (Node)nodeStack.get(nodeStack.size() - 1);
                nodeStack = nodeStack.subList(0, nodeStack.size() - 1);
            } else {
                return null;
            }
        }
        if (node.getAttributes() == null) {
            return Utils.getScopedAttribute(node.getParentNode(), attr, nodeStack);
        }
        Node attrNode = node.getAttributes().getNamedItem(attr);
        if (attrNode != null) {
            return attrNode.getNodeValue();
        }
        return Utils.getScopedAttribute(node.getParentNode(), attr, nodeStack);
    }

    private static String getNamespace(Node node, List nodeStack, ToolEnv env) {
        return node == null ? null : Utils.getScopedAttribute(node, "targetNamespace", nodeStack);
    }

    public static String getAbsoluteNamespace(Node node, List nodeStack, ToolEnv env) {
        String SA = Utils.getScopedAttribute(node, "targetNamespace", nodeStack);
        if (node == null || SA == null) {
            return null;
        }
        if (SA.indexOf(58) >= 0) {
            return SA;
        }
        List localNodeStack = nodeStack;
        boolean absoluteFound = false;
        Node parentNode = node.getParentNode();
        String previousAttribute = SA;
        while (parentNode != null && !absoluteFound) {
            String prefixAttribute = null;
            Node attrNode = null;
            if (parentNode.getAttributes() != null) {
                attrNode = parentNode.getAttributes().getNamedItem("targetNamespace");
                if (attrNode == null) {
                    attrNode = parentNode.getAttributes().getNamedItem("namespace");
                }
                if (attrNode != null) {
                    prefixAttribute = attrNode.getNodeValue();
                }
            }
            if (prefixAttribute != null && !prefixAttribute.equals(previousAttribute)) {
                SA = prefixAttribute + SA;
                previousAttribute = prefixAttribute;
                if (prefixAttribute.indexOf(58) >= 0) {
                    absoluteFound = true;
                }
            }
            if ((parentNode = parentNode.getParentNode()) != null || localNodeStack == null || localNodeStack.size() <= 0) continue;
            parentNode = (Node)localNodeStack.get(localNodeStack.size() - 1);
            localNodeStack = localNodeStack.subList(0, localNodeStack.size() - 1);
        }
        if (SA.indexOf(58) >= 0) {
            return SA;
        }
        if (env != null) {
            env.reportWarning(Messages.getMessage("warningRelativeNamespace01", SA));
        } else {
            System.err.println(Messages.getMessage("warningRelativeNamespace01", SA));
        }
        return SA;
    }

    public static String getAttribute(Node node, String attr) {
        if (node == null || node.getAttributes() == null) {
            return null;
        }
        Node attrNode = node.getAttributes().getNamedItem(attr);
        if (attrNode != null) {
            return attrNode.getNodeValue();
        }
        return null;
    }

    public static Vector getAttributesWithLocalName(Node node, String localName) {
        Vector<Node> v = new Vector<Node>();
        if (node == null) {
            return v;
        }
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            for (int i = 0; i < map.getLength(); ++i) {
                Node attrNode = map.item(i);
                if (attrNode == null || !attrNode.getLocalName().equals(localName)) continue;
                v.add(attrNode);
            }
        }
        return v;
    }

    public static QName getNodeQName(Node node) {
        if (node == null) {
            return null;
        }
        String localName = node.getLocalName();
        if (localName == null) {
            return null;
        }
        String namespace = node.getNamespaceURI();
        return QNameTable.createQName(namespace, localName);
    }

    public static QName getNodeNameQName(Node node, List nodeStack, ToolEnv env) {
        return Utils.getNodeNameQName(node, nodeStack, env, true);
    }

    public static QName getNodeNameQName(Node node, List nodeStack, ToolEnv env, boolean wantAnonType) {
        if (node == null) {
            return null;
        }
        String localName = null;
        String namespace = null;
        QName ref = Utils.getTypeQNameFromAttr(node, "ref", nodeStack, env, false);
        if (ref != null) {
            localName = ref.getLocalPart();
            namespace = ref.getNamespaceURI();
        }
        if (localName == null) {
            QName kind = Utils.getNodeQName(node);
            if (kind == null) {
                return null;
            }
            QName parentQName = null;
            if (kind != null && Constants.equals(kind, Constants.XSD_ANY)) {
                return kind;
            }
            if (kind.getLocalPart().equals("schema")) {
                return null;
            }
            if (kind.getLocalPart().equals("complexType") || kind.getLocalPart().equals("simpleType")) {
                localName = Utils.getAttribute(node, "name");
                if (localName == null && (parentQName = Utils.getNodeNameQName(node.getParentNode(), nodeStack, env)) != null) {
                    localName = ">" + parentQName.getLocalPart();
                    namespace = parentQName.getNamespaceURI();
                }
            } else if (kind.getLocalPart().equals("group") || kind.getLocalPart().equals("attributeGroup")) {
                localName = Utils.getAttribute(node, "name");
                if (localName == null && (parentQName = Utils.getNodeNameQName(node.getParentNode(), nodeStack, env)) != null) {
                    localName = ">" + parentQName.getLocalPart();
                    namespace = parentQName.getNamespaceURI();
                }
            } else if (kind.getLocalPart().equals("element") || kind.getLocalPart().equals("attribute") || kind.getLocalPart().equals("restriction")) {
                parentQName = Utils.getNodeNameQName(node.getParentNode(), nodeStack, env);
                String theName = Utils.getAttribute(node, "name");
                if (parentQName == null) {
                    localName = theName;
                } else if (theName == null) {
                    localName = parentQName.getLocalPart();
                    namespace = parentQName.getNamespaceURI();
                } else {
                    localName = parentQName.getLocalPart() + ">" + theName;
                    namespace = parentQName.getNamespaceURI();
                }
            } else {
                parentQName = Utils.getNodeNameQName(node.getParentNode(), nodeStack, env);
                if (parentQName != null) {
                    localName = parentQName.getLocalPart();
                    namespace = parentQName.getNamespaceURI();
                }
            }
        }
        if (localName == null) {
            return null;
        }
        if (namespace == null) {
            namespace = Utils.getNamespace(node, nodeStack, env);
        }
        if (!wantAnonType && localName.lastIndexOf(">") >= 0) {
            localName = localName.substring(localName.lastIndexOf(">") + 1);
        }
        return QNameTable.createQName(namespace, localName);
    }

    public static QName getNodeNameQName_v5(Node node, List nodeStack) {
        QName ref;
        if (node == null) {
            return null;
        }
        String localName = null;
        String namespace = null;
        localName = Utils.getAttribute(node, "name");
        if (localName == null && (ref = Utils.getTypeQNameFromAttr(node, "ref", nodeStack, null, true)) != null) {
            localName = ref.getLocalPart();
            namespace = ref.getNamespaceURI();
        }
        if (localName == null) {
            localName = "";
            Node search = node.getParentNode();
            while (search != null) {
                QName kind = Utils.getNodeQName(search);
                if (kind != null && Constants.equals(kind, Constants.XSD_ANY)) {
                    return kind;
                }
                if (kind.getLocalPart().equals("schema")) {
                    search = null;
                    continue;
                }
                if (kind.getLocalPart().equals("element") || kind.getLocalPart().equals("attribute")) {
                    localName = ">" + Utils.getNodeNameQName_v5(search, nodeStack).getLocalPart();
                    search = search.getParentNode();
                    continue;
                }
                if (kind.getLocalPart().equals("complexType") || kind.getLocalPart().equals("simpleType")) {
                    localName = Utils.getNodeNameQName_v5(search, nodeStack).getLocalPart() + localName;
                    search = null;
                    continue;
                }
                search = search.getParentNode();
            }
        }
        if (localName == null) {
            return null;
        }
        if (namespace == null) {
            namespace = Utils.getScopedAttribute(node, "targetNamespace", nodeStack);
        }
        return QNameTable.createQName(namespace, localName);
    }

    public static QName getTypeQName(Node node, BooleanHolder forElement, boolean ignoreMaxOccurs, List nodeStack, ToolEnv env) {
        return Utils.getTypeQName(node, forElement, ignoreMaxOccurs, nodeStack, env, false);
    }

    public static QName getTypeQName(Node node, BooleanHolder forElement, boolean ignoreMaxOccurs, List nodeStack, ToolEnv env, boolean legacy) {
        if (node == null) {
            return null;
        }
        forElement.value = false;
        QName qName = Utils.getTypeQNameFromAttr(node, "type", nodeStack, env, legacy);
        if (qName == null) {
            forElement.value = true;
            qName = Utils.getTypeQNameFromAttr(node, "ref", nodeStack, env, legacy);
            if (qName == null && Constants.equals(Utils.getNodeQName(node), Constants.XSD_ANY)) {
                qName = Constants.XSD_ANY;
                forElement.value = false;
            }
        }
        if (!ignoreMaxOccurs && qName != null) {
            String maxOccurs = Utils.getAttribute(node, "maxOccurs");
            String minOccurs = Utils.getAttribute(node, "minOccurs");
            String maxOccursValue = maxOccurs;
            String minOccursValue = minOccurs;
            if (maxOccurs == null) {
                maxOccursValue = "1";
                maxOccurs = "";
            }
            if (minOccurs == null) {
                minOccursValue = "1";
                minOccurs = "";
            }
            if (!(minOccursValue.equals("0") && maxOccursValue.equals("1") || maxOccursValue.equals("1") && minOccursValue.equals("1"))) {
                String localPart = qName.getLocalPart();
                if (localPart.startsWith(">")) {
                    localPart = localPart.substring(1);
                }
                localPart = localPart + "[" + minOccurs + "," + maxOccurs + "]";
                qName = QNameTable.createQName(qName.getNamespaceURI(), localPart);
            }
        }
        if (qName == null) {
            forElement.value = true;
            qName = Utils.getTypeQNameFromAttr(node, "element", nodeStack, env, legacy);
        }
        if (qName == null) {
            forElement.value = false;
            qName = Utils.getTypeQNameFromAttr(node, "base", nodeStack, env, legacy);
        }
        if (qName == null && Utils.getNodeQName(node).getLocalPart().equals("list")) {
            forElement.value = false;
            qName = Utils.getTypeQNameFromAttr(node, "itemType", nodeStack, env, legacy);
        }
        return qName;
    }

    static QName getTypeQNameFromAttr(Node node, String typeAttrName, List nodeStack, ToolEnv env) {
        return Utils.getTypeQNameFromAttr(node, typeAttrName, nodeStack, env, false);
    }

    static QName getTypeQNameFromAttr(Node node, String typeAttrName, List nodeStack, ToolEnv env, boolean legacy) {
        if (node == null) {
            return null;
        }
        String prefixedName = Utils.getAttribute(node, typeAttrName);
        if (prefixedName == null && typeAttrName.equals("type") && Utils.getAttribute(node, "ref") == null && Utils.getAttribute(node, "base") == null && Utils.getAttribute(node, "element") == null && Utils.getAttribute(node, "itemType") == null) {
            QName anonQName = Utils.getAnonQName(node, nodeStack, legacy, env);
            if (anonQName != null) {
                return anonQName;
            }
            QName nodeName = Utils.getNodeQName(node);
            if (nodeName != null && Constants.isSchemaXSD(nodeName.getNamespaceURI()) && (nodeName.getLocalPart().equals("element") || nodeName.getLocalPart().equals("attribute"))) {
                return Constants.XSD_ANYTYPE;
            }
        }
        if (prefixedName == null) {
            return null;
        }
        QName qName = Utils.getQNameFromPrefixedName(node, prefixedName, nodeStack, env);
        return qName;
    }

    private static QName getAnonQName(Node node, List nodeStack, boolean legacy, ToolEnv env) {
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && (nodeKind.getLocalPart().equals("element") || nodeKind.getLocalPart().equals("attribute") || nodeKind.getLocalPart().equals("list") || nodeKind.getLocalPart().equals("restriction")) && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            NodeList children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                QName kind = Utils.getNodeQName(children.item(j));
                if (kind == null || !kind.getLocalPart().equals("complexType") && !kind.getLocalPart().equals("simpleType") || !Constants.isSchemaXSD(kind.getNamespaceURI())) continue;
                if (legacy) {
                    return Utils.getNodeNameQName_v5(children.item(j), nodeStack);
                }
                return Utils.getNodeNameQName(children.item(j), nodeStack, env);
            }
        }
        return null;
    }

    public static QName getQNameFromPrefixedName(Node node, String prefixedName, List nodeStack, ToolEnv env) {
        String localName = prefixedName.substring(prefixedName.lastIndexOf(":") + 1);
        String namespace = null;
        if (prefixedName.length() == localName.length()) {
            namespace = Utils.getScopedAttribute(node, "xmlns", nodeStack);
        } else {
            String prefix = prefixedName.substring(0, prefixedName.lastIndexOf(":"));
            namespace = Utils.getScopedAttribute(node, "xmlns:" + prefix, nodeStack);
            if (namespace != null && namespace.indexOf(58) < 0 && !relativeNSset.contains(namespace)) {
                relativeNSset.add(namespace);
                if (env != null && env.isRelativeNamespaceAllowed()) {
                    env.reportWarning(Messages.getMessage("warningRelativeNamespace01", prefix + "=" + namespace));
                } else {
                    env.reportFatalErr(Messages.getMessage("warningRelativeNamespace01", prefix + "=" + namespace));
                }
            }
            if (namespace == null && "xml".equals(prefix)) {
                namespace = "http://www.w3.org/XML/1998/namespace";
            }
        }
        return QNameTable.createQName(namespace, localName);
    }

    public static Set getDerivedTypes(TypeEntry type, SymbolTable symbolTable) {
        Set types = (TreeSet)type.getDynamicVar(DERIVED_TYPES);
        if (types != null) {
            return types;
        }
        types = new TreeSet(new SymTabEntryComparator());
        if (Constants.isSchemaXSD(type.getQName().getNamespaceURI()) && (type.getQName().getLocalPart().equals("anyType") || type.getQName().getLocalPart().equals("any"))) {
            types = symbolTable._getAllTypes();
        } else if (type != null && type.getNode() != null) {
            Utils._getDerivedTypes(type, types, symbolTable);
        }
        type.setDynamicVar(DERIVED_TYPES, types);
        return types;
    }

    private static void _getDerivedTypes(TypeEntry type, Set types, SymbolTable symbolTable) {
        if (types.size() >= symbolTable.getTypes().size()) {
            return;
        }
        Vector allTypes = symbolTable.getTypes();
        Iterator it = allTypes.iterator();
        while (it.hasNext()) {
            TypeEntry derivedType = (TypeEntry)it.next();
            if (!(derivedType instanceof DefinedType) || types.contains(derivedType) || ((DefinedType)derivedType).getExtensionBase() != type && ((DefinedType)derivedType).getRestrictionBase() != type) continue;
            types.add(derivedType);
            types.addAll(Utils.getDerivedTypes(derivedType, symbolTable));
            if (types.size() < symbolTable.getTypes().size()) continue;
            types = symbolTable._getAllTypes();
            return;
        }
    }

    public static Set getNestedTypes(TypeEntry type, SymbolTable symbolTable) {
        Set<TypeEntry> types = (TreeSet<TypeEntry>)type.getDynamicVar(NESTED_TYPES);
        if (types != null) {
            return types;
        }
        types = new TreeSet<TypeEntry>(new SymTabEntryComparator());
        types.add(type);
        TreeSet anchorSet = new TreeSet(new SymTabEntryComparator());
        types = Utils._getNestedTypes(type, types, symbolTable, true, anchorSet);
        type.setDynamicVar(NESTED_TYPES, types);
        return types;
    }

    private static Set _getNestedTypes(TypeEntry type, Set types, SymbolTable symbolTable, boolean digFlag, Set anchorSet) {
        Set calcTypes;
        if (type == null) {
            return types;
        }
        if (digFlag) {
            anchorSet.add(type);
        }
        if ((calcTypes = (Set)type.getDynamicVar(NESTED_TYPES)) != null) {
            types.addAll(calcTypes);
            return types;
        }
        if (types.size() >= symbolTable.getTypes().size()) {
            types = symbolTable._getAllTypes();
            return types;
        }
        if (type.getRefType() == symbolTable.getUnmappableType()) {
            return types;
        }
        Vector children = null;
        int parentSIDX = 0;
        if (type instanceof Type) {
            children = ((Type)type).getChildren();
            parentSIDX = type.getSIDX();
        }
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                ChildAttribute attr;
                ChildElement elem;
                if (children.get(i) instanceof ChildElement && !anchorSet.contains((elem = (ChildElement)children.get(i)).getType())) {
                    types.add(elem.getType());
                    QName referentName = elem.getType().getQName();
                    if ((symbolTable.isDebug() || log.isDebugEnabled()) && Constants.isSchemaXSD(referentName.getNamespaceURI()) && ("anyType".equals(referentName.getLocalPart()) || "any".equals(referentName.getLocalPart()))) {
                        String msg = "Debug: added anytype child element SIDX: " + elem.getType().getSIDX() + " Parent SIDX: " + parentSIDX;
                        if (log.isDebugEnabled()) {
                            log.debug(msg);
                        } else {
                            symbolTable.getToolEnv().report(msg);
                        }
                    }
                    if ((types = Utils._getNestedTypes(elem.getType(), types, symbolTable, true, anchorSet)).size() >= symbolTable.getTypes().size()) {
                        types = symbolTable._getAllTypes();
                        return types;
                    }
                }
                if (!(children.get(i) instanceof ChildAttribute) || anchorSet.contains((attr = (ChildAttribute)children.get(i)).getType())) continue;
                if (attr.getType() instanceof Type) {
                    types.add(attr.getType());
                }
                if ((types = Utils._getNestedTypes(attr.getType(), types, symbolTable, true, anchorSet)).size() < symbolTable.getTypes().size()) continue;
                types = symbolTable._getAllTypes();
                return types;
            }
        }
        if (type.getRefType() != null && !anchorSet.contains(type.getRefType())) {
            types.add(type.getRefType());
            types = Utils._getNestedTypes(type.getRefType(), types, symbolTable, true, anchorSet);
            if (types.size() >= symbolTable.getTypes().size()) {
                types = symbolTable._getAllTypes();
                return types;
            }
        }
        if (digFlag && type instanceof Type) {
            Set derivedTypes = Utils.getDerivedTypes(type, symbolTable);
            if (derivedTypes.size() >= symbolTable.getTypes().size()) {
                types = symbolTable._getAllTypes();
                return types;
            }
            Iterator it = derivedTypes.iterator();
            while (it.hasNext()) {
                TypeEntry derivedType = (TypeEntry)it.next();
                if (types.contains(derivedType)) continue;
                types.add(derivedType);
                if ((types = Utils._getNestedTypes(derivedType, types, symbolTable, false, anchorSet)).size() < symbolTable.getTypes().size()) continue;
                types = symbolTable._getAllTypes();
                return types;
            }
        }
        Type inhType = null;
        if (type instanceof Type && (inhType = ((Type)type).getExtensionBase()) == null) {
            inhType = ((Type)type).getRestrictionBase();
        }
        if (inhType != null && !types.contains(inhType)) {
            types.add(inhType);
            types = Utils._getNestedTypes(inhType, types, symbolTable, false, anchorSet);
        }
        if (types.size() >= symbolTable.getTypes().size()) {
            types = symbolTable._getAllTypes();
        }
        return types;
    }

    public static String genQNameAttributeString(QName qname, String prefix) {
        if (qname.getNamespaceURI() == null || qname.getNamespaceURI().equals("")) {
            return qname.getLocalPart();
        }
        return prefix + ":" + qname.getLocalPart() + "\" xmlns:" + prefix + "=\"" + qname.getNamespaceURI();
    }

    public static boolean isXSDType(QName qname) {
        return SchemaUtils.isXSDType(qname);
    }

    public static URL getURL(URL contextURL, String spec) throws IOException {
        String path = spec.replace('\\', '/');
        URL url = null;
        try {
            url = new URL(contextURL, path);
            if (contextURL != null && url.getProtocol().equals("file") && contextURL.getProtocol().equals("file")) {
                url = Utils.getFileURL(contextURL, path);
            }
        }
        catch (MalformedURLException me) {
            if (log.isDebugEnabled()) {
                log.debug("Exception Logged: url contained no valid protocol information: " + me.getMessage());
            }
            url = Utils.getFileURL(contextURL, path);
        }
        return url;
    }

    private static URL getFileURL(URL contextURL, String path) throws IOException {
        String contextFileName;
        File context;
        if (contextURL != null && (context = new File(contextFileName = contextURL.getFile())) != null) {
            return new URL(context.toURL(), path);
        }
        return new URL("file", "", path);
    }

    public static TypeEntry getReferencedType(TypeEntry tEntry) {
        return Utils.getReferencedType(tEntry, true);
    }

    public static TypeEntry getReferencedType(TypeEntry tEntry, boolean useSimpleTypeRestriction) {
        TypeEntry refType = tEntry.getRefType();
        if (refType != null) {
            return refType;
        }
        Type component = (Type)tEntry.getDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN);
        if (component != null) {
            return component;
        }
        if (useSimpleTypeRestriction && tEntry instanceof Type && !((Type)tEntry).isEnumeration() && ((Type)tEntry).isSimpleTypeOrSimpleContent()) {
            return ((Type)tEntry).getRestrictionBase();
        }
        return null;
    }
}

