/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.mapping;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.tools.resource.ToolEnv;
import com.ibm.ws.webservices.wsdl.mapping.MappingMetaDOM;
import com.ibm.ws.webservices.wsdl.mapping.Utils;
import com.ibm.ws.webservices.wsdl.symbolTable.Attribute;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingParamEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildElement;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEnumValueEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildFaultPartEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Element;
import com.ibm.ws.webservices.wsdl.symbolTable.Entry;
import com.ibm.ws.webservices.wsdl.symbolTable.MMDEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.MessageEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.MetaInfo;
import com.ibm.ws.webservices.wsdl.symbolTable.MetaOperationKey;
import com.ibm.ws.webservices.wsdl.symbolTable.MetaOperationValue;
import com.ibm.ws.webservices.wsdl.symbolTable.PortEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.wsspi.webservices.models.IMappingMetaData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.xml.namespace.QName;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.ExceptionMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.JavaWSDLMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.JavaXMLTypeMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.MethodParamPartsMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.PackageMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.PortMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.ServiceEndpointInterfaceMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.ServiceEndpointMethodMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.ServiceInterfaceMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.VariableMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.WSDLPortType;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.WSDLReturnValueMapping;

public class MappingMetaData
implements IMappingMetaData {
    MappingMetaDOM dom = new MappingMetaDOM();
    String loadedFile = "";
    HashMap loggedMsgs = null;

    public static MappingMetaData loadFromFile(String file, ToolEnv env) throws IOException {
        MappingMetaData mmd = new MappingMetaData();
        mmd.dom = MappingMetaDOM.loadFromFile(file, env);
        mmd.loadedFile = file;
        return mmd;
    }

    public static MappingMetaData loadFromFile(String file, LoadStrategy loadStrategy) throws IOException {
        MappingMetaData mmd = new MappingMetaData();
        mmd.dom = MappingMetaDOM.loadFromFile(file, loadStrategy);
        mmd.loadedFile = file;
        return mmd;
    }

    public void setMap(JavaWSDLMapping map) {
        this.dom.setMap(map);
    }

    public void setVersion(String version) {
        this.dom.setVersion(version);
    }

    public void setLoadedFile(String loadedFile) {
        this.loadedFile = loadedFile;
    }

    public void write(String file, ToolEnv env) throws IOException {
        this.dom.write(file, env);
    }

    public void addPackageMappings(HashMap ns2Pkg) {
        Iterator keys = ns2Pkg.keySet().iterator();
        while (keys.hasNext()) {
            String ns = (String)keys.next();
            String pkg = (String)ns2Pkg.get(ns);
            this.dom.createPackageMapping(pkg, ns);
        }
    }

    public HashMap getPackageMappings() {
        HashMap<String, String> hash = new HashMap<String, String>();
        Iterator pms = this.dom.getPackageMappings();
        while (pms.hasNext()) {
            PackageMapping pm = (PackageMapping)pms.next();
            hash.put(this.dom.getNamespaceURI(pm), this.dom.getPackageType(pm));
        }
        return hash;
    }

    public HashMap getSEIMappings() {
        HashMap<String, QName> hash = new HashMap<String, QName>();
        Iterator seims = this.dom.getServiceEndpointInterfaceMappings();
        while (seims.hasNext()) {
            ServiceEndpointInterfaceMapping seim = (ServiceEndpointInterfaceMapping)seims.next();
            WSDLPortType wpt = seim.getWsdlPortType();
            QName portTypeQName = new QName(wpt.getNamespaceURI(), wpt.getLocalPart());
            hash.put(seim.getServiceEndpointInterface(), portTypeQName);
        }
        return hash;
    }

    public void preSymbolTable(MetaInfo metaInfo) {
        boolean foundSOAPElement = false;
        boolean foundNonSOAPElement = false;
        Iterator it = this.dom.getJavaXmlTypeMappings();
        if (!it.hasNext()) {
            metaInfo.setProperty("noWrappedArrays", Boolean.TRUE);
        }
        while (it.hasNext()) {
            JavaXMLTypeMapping jxtm = (JavaXMLTypeMapping)it.next();
            String classType = this.dom.getClassType(jxtm);
            if ("javax.xml.soap.SOAPElement".equals(classType)) {
                foundSOAPElement = true;
                continue;
            }
            foundNonSOAPElement = true;
        }
        it = this.dom.getServiceEndpointInterfaceMappings();
        while (it.hasNext()) {
            ServiceEndpointInterfaceMapping seim = (ServiceEndpointInterfaceMapping)it.next();
            QName bindingQName = this.dom.getWsdlBinding(seim);
            Iterator opIt = this.dom.getServiceEndpointMethodMappings(seim);
            while (opIt.hasNext()) {
                int i;
                ServiceEndpointMethodMapping semm = (ServiceEndpointMethodMapping)opIt.next();
                String opName = this.dom.getWsdlOperation(semm);
                QName inMessageQName = null;
                QName outMessageQName = null;
                ArrayList<MethodParamPartsMapping> params = new ArrayList<MethodParamPartsMapping>();
                Iterator parmIt = this.dom.getMethodParamPartsMappings(semm);
                while (parmIt.hasNext()) {
                    MethodParamPartsMapping mppm = (MethodParamPartsMapping)parmIt.next();
                    String mode = this.dom.getParamMode(mppm);
                    if (("IN".equalsIgnoreCase(mode) || "INOUT".equalsIgnoreCase(mode)) && inMessageQName == null) {
                        inMessageQName = this.dom.getWsdlMessage(mppm);
                    }
                    if ("OUT".equalsIgnoreCase(mode) && outMessageQName == null) {
                        outMessageQName = this.dom.getWsdlMessage(mppm);
                    }
                    params.add(mppm);
                    String paramType = this.dom.getParamType(mppm);
                    if ("javax.xml.soap.SOAPElement".equals(paramType)) {
                        foundSOAPElement = true;
                        continue;
                    }
                    foundNonSOAPElement = true;
                }
                ArrayList<String> order = new ArrayList<String>();
                ArrayList<String> modeOrder = new ArrayList<String>();
                for (i = 0; i < params.size(); ++i) {
                    order.add(null);
                    modeOrder.add(null);
                }
                for (i = 0; i < params.size(); ++i) {
                    MethodParamPartsMapping mppm = (MethodParamPartsMapping)params.get(i);
                    int pos = this.dom.getParamPosition(mppm);
                    if (pos < 0) continue;
                    order.set(pos, this.dom.getWsdlParam(mppm));
                    modeOrder.set(pos, this.dom.getParamMode(mppm));
                }
                String returnPart = null;
                WSDLReturnValueMapping wrvm = this.dom.getWSDLReturnValueMapping(semm);
                if (wrvm != null) {
                    String returnValue;
                    returnPart = this.dom.getWsdlParam(wrvm);
                    if (outMessageQName == null) {
                        outMessageQName = this.dom.getWsdlMessage(wrvm);
                    }
                    if (!"void".equals(returnValue = this.dom.getMethodReturnValue(wrvm))) {
                        if ("javax.xml.soap.SOAPElement".equals(returnValue)) {
                            foundSOAPElement = true;
                        } else {
                            foundNonSOAPElement = true;
                        }
                    }
                }
                MetaOperationKey key = new MetaOperationKey(bindingQName, opName, inMessageQName, outMessageQName);
                MetaOperationValue value2 = new MetaOperationValue(order, modeOrder, returnPart, this.dom.getWrappedElement(semm));
                metaInfo.getOperationMap().put(key, value2);
            }
        }
        if (foundNonSOAPElement) {
            metaInfo.setProperty("noDataBinding", Boolean.FALSE);
        } else if (foundSOAPElement) {
            metaInfo.setProperty("noDataBinding", Boolean.TRUE);
        }
        metaInfo.setProperty("MMDVersion", this.dom.getVersion());
    }

    public void postSymbolTable(SymbolTable symbolTable) {
        Iterator it = this.dom.getJavaXmlTypeMappings();
        while (it.hasNext()) {
            this.processJavaXmlTypeMapping((JavaXMLTypeMapping)it.next(), symbolTable);
        }
        it = this.dom.getExceptionMappings();
        while (it.hasNext()) {
            this.processExceptionMapping((ExceptionMapping)it.next(), symbolTable);
        }
        it = this.dom.getServiceEndpointInterfaceMappings();
        while (it.hasNext()) {
            this.processServiceEndpointInterfaceMapping((ServiceEndpointInterfaceMapping)it.next(), symbolTable);
        }
        it = this.dom.getServiceInterfaceMappings();
        while (it.hasNext()) {
            this.processServiceInterfaceMapping((ServiceInterfaceMapping)it.next(), symbolTable);
        }
        this.issueLoggedMessages(symbolTable.getToolEnv());
    }

    public void fromSymbolTable(SymbolTable symbolTable) {
        Iterator it = symbolTable.getHashMap().values().iterator();
        int bindingCount = 0;
        int serviceCount = 0;
        BindingEntry bEntry = null;
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (!entry.isReferenced()) continue;
                if (entry instanceof TypeEntry) {
                    this.fromTypeEntry(entry.getQName(), (TypeEntry)entry, symbolTable);
                    continue;
                }
                if (entry instanceof MessageEntry) {
                    this.fromMessageEntry((MessageEntry)entry, symbolTable);
                    continue;
                }
                if (entry instanceof BindingEntry) {
                    this.fromBindingEntry((BindingEntry)entry, symbolTable);
                    bEntry = (BindingEntry)entry;
                    ++bindingCount;
                    continue;
                }
                if (!(entry instanceof ServiceEntry)) continue;
                this.fromServiceEntry((ServiceEntry)entry, symbolTable);
                ++serviceCount;
            }
        }
        it = symbolTable.getMMDEntries();
        while (it.hasNext()) {
            MMDEntry mmdEntry = (MMDEntry)it.next();
            SymTabEntry stEntry = mmdEntry.getSymTabEntry();
            if (!(stEntry instanceof TypeEntry)) continue;
            this.fromTypeEntry(mmdEntry.getQName(), (TypeEntry)stEntry, symbolTable);
        }
        if (bEntry != null) {
            while (bindingCount < serviceCount) {
                ++bindingCount;
                this.fromBindingEntry(bEntry, symbolTable);
            }
        }
    }

    private TypeEntry getTypeEntry(QName qName, String scope, SymbolTable symbolTable) {
        MMDEntry mmdEntry;
        TypeEntry tEntry;
        if ("element".equalsIgnoreCase(scope)) {
            tEntry = symbolTable.getElement(qName);
            if (tEntry == null) {
                tEntry = symbolTable.getAttribute(qName);
            }
        } else {
            tEntry = symbolTable.getType(qName);
            if (tEntry == null && Utils.QNameIsAnonymous(qName)) {
                tEntry = symbolTable.getElement(qName);
            }
        }
        if (tEntry == null && (mmdEntry = symbolTable.getMMDEntry(qName)) != null && mmdEntry.getSymTabEntry() instanceof TypeEntry) {
            tEntry = (TypeEntry)mmdEntry.getSymTabEntry();
        }
        return tEntry;
    }

    private void processJavaXmlTypeMapping(JavaXMLTypeMapping jxtm, SymbolTable symbolTable) {
        QName newQn;
        String lp;
        String qNameScope = this.dom.getQNameScope(jxtm);
        QName qname = this.dom.getTypeQName(jxtm);
        String ns = qname.getNamespaceURI();
        TypeEntry tEntry = this.getTypeEntry(qname, qNameScope, symbolTable);
        if (tEntry == null && Utils.QNameIsAnonymous(qname)) {
            lp = qname.getLocalPart();
            lp = lp.replaceAll("\\[1,", "\\[,");
            newQn = QNameTable.createQName(ns, lp);
            tEntry = this.getTypeEntry(newQn, qNameScope, symbolTable);
        }
        if (tEntry == null && (lp = qname.getLocalPart()).indexOf("[unbounded]") >= 0 && (tEntry = this.getTypeEntry(newQn = QNameTable.createQName(ns, lp = lp.replaceAll("\\[", "\\[,")), qNameScope, symbolTable)) == null) {
            lp = lp.replaceAll("\\[,", "\\[0,");
            newQn = QNameTable.createQName(ns, lp);
            tEntry = this.getTypeEntry(newQn, qNameScope, symbolTable);
            int i = -1;
            while (tEntry == null && i++ < 10) {
                lp = lp.replaceAll("\\[" + i, "\\[" + (i + 1));
                newQn = QNameTable.createQName(ns, lp);
                tEntry = this.getTypeEntry(newQn, qNameScope, symbolTable);
            }
        }
        if (tEntry == null) {
            this.logNotInSymbolTable(qname, "root-type-qname or anonymous-type-qname", "java-xml-type-mapping");
            return;
        }
        if (tEntry.isOnlyWrappedLiteralReferenced()) {
            return;
        }
        Utils.setJavaName(symbolTable, tEntry, this.dom.getClassType(jxtm), true);
        if (tEntry.getDynamicVar("notMappable") != null && ((Boolean)tEntry.getDynamicVar("notMappable")).booleanValue()) {
            return;
        }
        Iterator it = this.dom.getVariableMappings(jxtm);
        if (it.hasNext()) {
            Vector children = null;
            TypeEntry refType = tEntry;
            while (refType != null && children == null) {
                if (refType instanceof Type && ((Type)refType).getChildren() != null) {
                    children = ((Type)refType).getChildren();
                    continue;
                }
                refType = refType.getRefType();
            }
            if (children != null) {
                while (it.hasNext()) {
                    String wsdlType;
                    VariableMapping vm = (VariableMapping)it.next();
                    Entry child = null;
                    for (int i = 0; i < children.size() && child == null; ++i) {
                        ChildEntry c = (ChildEntry)children.elementAt(i);
                        if (c instanceof ChildEnumValueEntry && ((ChildEnumValueEntry)c).getEnumValue().equals(this.dom.getXmlElementName(vm))) {
                            child = c;
                            continue;
                        }
                        if (c.getQName() == null || !c.getQName().getLocalPart().equals(this.dom.getXmlElementName(vm)) && !c.getQName().getLocalPart().equals(this.dom.getXmlAttributeName(vm)) && (!(c instanceof ChildElement) || !((ChildElement)c).getAnyElement() || !this.dom.getXmlWildcard(vm))) continue;
                        child = c;
                    }
                    if (child != null) {
                        Utils.setJavaName(symbolTable, child, this.dom.getJavaVariableName(vm), true);
                        if (!this.dom.getDataMember(vm)) continue;
                        child.setDynamicVar(JavaGeneratorFactory.IS_DATA_MEMBER, Boolean.TRUE);
                        continue;
                    }
                    String xmlName = this.dom.getXmlElementName(vm);
                    if (xmlName != null) {
                        wsdlType = "xml-element-name";
                    } else {
                        xmlName = this.dom.getXmlAttributeName(vm);
                        if (xmlName != null) {
                            wsdlType = "xml-attribute-name";
                        } else {
                            wsdlType = "xml-wildcard";
                            xmlName = "any";
                        }
                    }
                    this.logNotInSymbolTable(new QName("", xmlName), wsdlType, "variable-mapping");
                }
            }
        }
    }

    private void processExceptionMapping(ExceptionMapping em, SymbolTable symbolTable) {
        QName qName = this.dom.getWsdlMessage(em);
        MessageEntry mEntry = symbolTable.getMessageEntry(qName);
        if (mEntry == null) {
            TypeEntry entry = symbolTable.getElement(qName);
            if (entry == null) {
                entry = symbolTable.getType(qName);
            }
            if (entry != null) {
                Utils.setJavaName(symbolTable, entry, this.dom.getExceptionType(em), true);
                ArrayList constOrderList = this.dom.getConstructorParameterOrder(em);
                if (constOrderList != null) {
                    entry.setDynamicVar("constructorOrder", constOrderList);
                }
                return;
            }
        }
        if (mEntry == null) {
            this.logNotInSymbolTable(qName, "wsdl-message", "exception-mapping");
            return;
        }
        String javaName = this.dom.getExceptionType(em);
        Collection complexTypes = (Collection)mEntry.getDynamicVar(JavaGeneratorFactory.COMPLEX_TYPE_FAULT_COLLECTION);
        if (complexTypes == null) {
            Utils.setJavaName(symbolTable, mEntry, this.dom.getExceptionType(em), true);
            ArrayList constOrderList = this.dom.getConstructorParameterOrder(em);
            if (constOrderList != null) {
                mEntry.setDynamicVar("constructorOrder", constOrderList);
            }
            return;
        }
        Type type = null;
        Iterator it = complexTypes.iterator();
        while (it.hasNext() && type == null) {
            type = (Type)it.next();
            if (javaName.equals(type.getName())) continue;
            type = null;
        }
        if (type == null) {
            String qNameStr = qName == null ? "null" : qName.toString();
            symbolTable.getToolEnv().reportWarning(Messages.getMessage("warningMMDJXTMNotFound00", qNameStr, javaName, this.loadedFile));
            return;
        }
        ArrayList constOrderList = this.dom.getConstructorParameterOrder(em);
        if (constOrderList != null) {
            type.setDynamicVar("constructorOrder", constOrderList);
        }
    }

    private void processServiceEndpointInterfaceMapping(ServiceEndpointInterfaceMapping seim, SymbolTable symbolTable) {
        QName bQName = this.dom.getWsdlBinding(seim);
        BindingEntry bEntry = symbolTable.getBindingEntry(bQName);
        if (bEntry == null) {
            this.logNotInSymbolTable(bQName, "wsdl-binding", "service-endpoint-interface-mapping");
            return;
        }
        bEntry.setDynamicVar(JavaGeneratorFactory.INTERFACE_NAME, this.dom.getServiceEndpointInterface(seim));
        Iterator opIt = this.dom.getServiceEndpointMethodMappings(seim);
        while (opIt.hasNext()) {
            ServiceEndpointMethodMapping semm = (ServiceEndpointMethodMapping)opIt.next();
            String operationName = this.dom.getJavaMethodName(semm);
            BindingOperationEntry boe = this.getBindingOperationEntry(semm, bEntry);
            if (boe == null) {
                this.logNotInSymbolTable(new QName("", this.dom.getWsdlOperation(semm)), "wsdl-operation", "service-endpoint-method-mapping");
                continue;
            }
            Utils.setJavaName(symbolTable, boe, operationName, true);
            WSDLReturnValueMapping wrvm = this.dom.getWSDLReturnValueMapping(semm);
            if (wrvm != null && boe.getReturn() != null) {
                boe.getReturn().setDynamicVar("parameterType", this.dom.getMethodReturnValue(wrvm));
            }
            Iterator paramIt = this.dom.getMethodParamPartsMappings(semm);
            while (paramIt.hasNext()) {
                MethodParamPartsMapping mppm = (MethodParamPartsMapping)paramIt.next();
                int paramPos = this.dom.getParamPosition(mppm);
                boe.getParameter(paramPos).setDynamicVar("parameterType", this.dom.getParamType(mppm));
            }
        }
    }

    private BindingOperationEntry getBindingOperationEntry(ServiceEndpointMethodMapping semm, BindingEntry bEntry) {
        QName inputMessage;
        BindingOperationEntry boe;
        String matchName = this.dom.getWsdlOperation(semm);
        QName matchOutMessage = null;
        QName matchInMessage = null;
        Iterator parmIt = this.dom.getMethodParamPartsMappings(semm);
        while (parmIt.hasNext()) {
            MethodParamPartsMapping mppm = (MethodParamPartsMapping)parmIt.next();
            String mode = this.dom.getParamMode(mppm);
            if (("IN".equalsIgnoreCase(mode) || "INOUT".equalsIgnoreCase(mode)) && matchInMessage == null) {
                matchInMessage = this.dom.getWsdlMessage(mppm);
            }
            if (!"OUT".equalsIgnoreCase(mode) || matchOutMessage != null) continue;
            matchOutMessage = this.dom.getWsdlMessage(mppm);
        }
        WSDLReturnValueMapping wrvm = this.dom.getWSDLReturnValueMapping(semm);
        if (wrvm != null && matchOutMessage == null) {
            matchOutMessage = this.dom.getWsdlMessage(wrvm);
        }
        Iterator opIter = bEntry.getOperations();
        while (opIter.hasNext()) {
            boe = (BindingOperationEntry)opIter.next();
            Operation operation = boe.getBindingOperation().getOperation();
            int numIn = boe.numIns();
            int numInOut = boe.numInOuts();
            inputMessage = null;
            QName outputMessage = null;
            if (operation.getInput() != null && numIn + numInOut > 0 && operation.getInput().getMessage() != null) {
                inputMessage = operation.getInput().getMessage().getQName();
            }
            if (operation.getOutput() != null && operation.getOutput().getMessage() != null) {
                outputMessage = operation.getOutput().getMessage().getQName();
            }
            if (!matchName.equals(boe.getQName().getLocalPart()) || matchInMessage != inputMessage && (matchInMessage == null || !matchInMessage.equals(inputMessage)) || matchOutMessage != outputMessage && (matchOutMessage == null || !matchOutMessage.equals(outputMessage))) continue;
            return boe;
        }
        if (matchOutMessage == null) {
            opIter = bEntry.getOperations();
            while (opIter.hasNext()) {
                boe = (BindingOperationEntry)opIter.next();
                int numIn = boe.numIns();
                int numInOut = boe.numInOuts();
                Operation operation = boe.getBindingOperation().getOperation();
                inputMessage = null;
                if (operation.getInput() != null && numIn + numInOut > 0 && operation.getInput().getMessage() != null) {
                    inputMessage = operation.getInput().getMessage().getQName();
                }
                if (!matchName.equals(boe.getQName().getLocalPart()) || matchInMessage != inputMessage && (matchInMessage == null || !matchInMessage.equals(inputMessage))) continue;
                return boe;
            }
        }
        return null;
    }

    private void processServiceInterfaceMapping(ServiceInterfaceMapping sim, SymbolTable symbolTable) {
        QName sQName = this.dom.getWsdlServiceName(sim);
        ServiceEntry sEntry = symbolTable.getServiceEntry(sQName);
        if (sEntry == null) {
            this.logNotInSymbolTable(sQName, "wsdl-service-name", "service-interface-mapping");
            return;
        }
        Utils.setJavaName(symbolTable, sEntry, this.dom.getServiceInterface(sim), true);
        Iterator it = this.dom.getPortMappings(sim);
        while (it.hasNext()) {
            PortMapping pm = (PortMapping)it.next();
            String portName = this.dom.getPortName(pm);
            QName portQName = QNameTable.createQName(sEntry.getQName().getNamespaceURI(), portName);
            PortEntry pEntry = sEntry.getPort(portQName);
            if (pEntry == null) {
                this.logNotInSymbolTable(portQName, "port-name", "port-mapping");
                continue;
            }
            Utils.setJavaName(symbolTable, pEntry, this.dom.getJavaPortName(pm), true);
        }
    }

    private void fromTypeEntry(QName qName, TypeEntry tEntry, SymbolTable symbolTable) {
        Type type;
        Vector children;
        if (qName.getLocalPart().indexOf("(nillable)") >= 0) {
            return;
        }
        if (tEntry.isOnlyWrappedLiteralReferenced()) {
            return;
        }
        String qNameScope = "complexType";
        if (tEntry instanceof Element || tEntry instanceof Attribute) {
            if (!Utils.QNameIsAnonymous(qName)) {
                qNameScope = "element";
            }
        } else if (tEntry instanceof Type && ((Type)tEntry).isSimpleType()) {
            qNameScope = "simpleType";
        }
        JavaXMLTypeMapping jxtm = this.dom.createJavaXmlTypeMapping(tEntry.getName(), qName, qNameScope);
        if (tEntry instanceof Type && tEntry.getRefType() == null && !tEntry.getName().equals("javax.xml.soap.SOAPElement") && !tEntry.getName().equals("org.w3c.dom.Element") && (children = (type = (Type)tEntry).getChildren()) != null) {
            for (int i = 0; i < children.size(); ++i) {
                ChildEntry child = (ChildEntry)children.elementAt(i);
                if (child instanceof ChildEnumValueEntry) {
                    this.dom.createVariableMapping(jxtm, child.getName(), ((ChildEnumValueEntry)child).getEnumValue(), false, true, false);
                    continue;
                }
                Boolean isDataMember = (Boolean)child.getDynamicVar(JavaGeneratorFactory.IS_DATA_MEMBER);
                boolean isElement = child instanceof ChildElement;
                boolean isAny = false;
                if (isElement) {
                    isAny = ((ChildElement)child).getAnyElement();
                }
                this.dom.createVariableMapping(jxtm, child.getName(), child.getQName().getLocalPart(), isDataMember != null && isDataMember != false, isElement, isAny);
            }
        }
    }

    private void fromMessageEntry(MessageEntry mEntry, SymbolTable symbolTable) {
        if (!mEntry.isFault()) {
            return;
        }
        Boolean isComplex = (Boolean)mEntry.getDynamicVar(JavaGeneratorFactory.COMPLEX_TYPE_FAULT);
        if (isComplex == null || !isComplex.booleanValue()) {
            ArrayList order = (ArrayList)mEntry.getDynamicVar("constructorOrder");
            ArrayList<String> parts = new ArrayList<String>();
            Vector v = mEntry.getFaultParts();
            if (v != null) {
                for (int i = 0; i < v.size(); ++i) {
                    ChildFaultPartEntry part = (ChildFaultPartEntry)v.elementAt(i);
                    parts.add(part.getQName().getLocalPart());
                }
            }
            this.dom.createExceptionMapping(mEntry.getName(), mEntry.getQName(), order, parts);
        } else {
            Collection complexTypes = (Collection)mEntry.getDynamicVar(JavaGeneratorFactory.COMPLEX_TYPE_FAULT_COLLECTION);
            if (complexTypes != null) {
                Iterator it = complexTypes.iterator();
                while (it.hasNext()) {
                    Type type = (Type)it.next();
                    ArrayList order = (ArrayList)type.getDynamicVar("constructorOrder");
                    this.dom.createExceptionMapping(type.getName(), mEntry.getQName(), order, null);
                }
            }
        }
    }

    private void fromBindingEntry(BindingEntry bEntry, SymbolTable symbolTable) {
        String sei = (String)bEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME);
        PortTypeEntry pEntry = symbolTable.getPortTypeEntry(bEntry.getBinding().getPortType().getQName());
        ServiceEndpointInterfaceMapping seim = this.dom.createServiceEndpointInterfaceMapping(sei, pEntry.getQName(), bEntry.getQName());
        Iterator opIter = bEntry.getOperations();
        while (opIter.hasNext()) {
            BindingOperationEntry beo = (BindingOperationEntry)opIter.next();
            ServiceEndpointMethodMapping semm = this.dom.createServiceEndpointMethodMapping(seim, beo.getName(), beo.getQName().getLocalPart(), beo.isWrapped());
            BindingParamEntry ret = beo.getReturn();
            Operation operation = beo.getBindingOperation().getOperation();
            if (operation.getStyle() == OperationType.REQUEST_RESPONSE) {
                if (ret == null) {
                    this.dom.createWSDLReturnValueMapping(semm, "void", operation.getOutput().getMessage().getQName(), null);
                } else {
                    this.dom.createWSDLReturnValueMapping(semm, (String)ret.getDynamicVar("parameterType"), ret.getOutMessageEntry().getQName(), ret.getQName().getLocalPart());
                }
            }
            for (int i = 0; i < beo.numParameters(); ++i) {
                BindingParamEntry param = beo.getParameter(i);
                MessageEntry me = param.getInMessageEntry();
                if (me == null) {
                    me = param.getOutMessageEntry();
                }
                this.dom.createMethodParamPartsMapping(semm, (String)param.getDynamicVar("parameterType"), i, param.getModeString(), me.getQName(), param.getQName().getLocalPart(), false);
            }
        }
    }

    private void fromServiceEntry(ServiceEntry sEntry, SymbolTable symbolTable) {
        ServiceInterfaceMapping sim = this.dom.createServiceInterfaceMapping(sEntry.getName(), sEntry.getQName());
        for (int i = 0; i < sEntry.numPorts(); ++i) {
            PortEntry pEntry = sEntry.getPort(i);
            BindingEntry bEntry = symbolTable.getBindingEntry(pEntry.getPort().getBinding().getQName());
            if (bEntry.getBindingType() != 0) continue;
            this.dom.createPortMapping(sim, pEntry.getQName().getLocalPart(), pEntry.getName());
        }
    }

    private void logNotInSymbolTable(QName qName, String wsdlElement, String wsdlParentElement) {
        ArrayList<String> msgs;
        String qNameStr = qName == null ? "null" : qName.toString();
        String explanation = ". The construct is found in the mapping file but not in the wsdl file.";
        String msg = Messages.getMessage("warningInvalidMMData00", qNameStr, wsdlElement, wsdlParentElement, this.loadedFile + explanation);
        if (this.loggedMsgs == null) {
            this.loggedMsgs = new HashMap();
        }
        if ((msgs = (ArrayList<String>)this.loggedMsgs.get(wsdlElement)) != null && msgs.contains(msg)) {
            return;
        }
        if (msgs == null) {
            msgs = new ArrayList<String>();
            this.loggedMsgs.put(wsdlElement, msgs);
        }
        msgs.add(msg);
    }

    private void issueLoggedMessages(ToolEnv toolEnv) {
        if (this.loggedMsgs == null) {
            return;
        }
        this.issueLoggedMessages(toolEnv, (List)this.loggedMsgs.get("wsdl-binding"));
        this.issueLoggedMessages(toolEnv, (List)this.loggedMsgs.get("wsdl-operation"));
        this.issueLoggedMessages(toolEnv, (List)this.loggedMsgs.get("wsdl-service-name"));
        this.issueLoggedMessages(toolEnv, (List)this.loggedMsgs.get("port-name"));
        this.issueLoggedMessages(toolEnv, (List)this.loggedMsgs.get("wsdl-message"));
        this.issueLoggedMessages(toolEnv, (List)this.loggedMsgs.get("root-type-qname or anonymous-type-qname"));
        this.issueLoggedMessages(toolEnv, (List)this.loggedMsgs.get("xml-element-name"));
        this.issueLoggedMessages(toolEnv, (List)this.loggedMsgs.get("xml-attribute-name"));
        this.issueLoggedMessages(toolEnv, (List)this.loggedMsgs.get("xml-wildcard"));
    }

    private void issueLoggedMessages(ToolEnv toolEnv, List list) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                toolEnv.reportWarning((String)list.get(i));
            }
        }
    }
}

