/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.fromJava.description;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.wsdl.fromJava.Emitter;
import com.ibm.ws.webservices.wsdl.fromJava.description.FaultDesc;
import com.ibm.ws.webservices.wsdl.fromJava.description.ParameterDesc;
import com.ibm.ws.webservices.wsdl.fromJava.description.PortDesc;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;

public class OperationDesc {
    protected static Log log = LogFactory.getLog(OperationDesc.class.getName());
    private PortDesc parent;
    private ArrayList parameters = new ArrayList();
    private QName elementQName;
    private Method method;
    private int numInParams = 0;
    private String soapAction = null;
    private ArrayList faults = null;
    private ParameterDesc returnDesc = null;
    private boolean hasOutParams = false;

    private void initReturnDesc() {
        if (this.returnDesc == null) {
            this.returnDesc = new ParameterDesc();
            this.returnDesc.setMode((byte)2);
            this.returnDesc.setIsReturn(true);
            this.hasOutParams = true;
        }
    }

    public String getName() {
        return this.elementQName.getLocalPart();
    }

    public JavaHelpers getReturnClass() {
        return this.returnDesc == null ? null : this.returnDesc.getJavaType();
    }

    public void setReturnClass(JavaHelpers returnClass, Emitter emitter) {
        if (returnClass != null) {
            this.initReturnDesc();
            this.returnDesc.setJavaType(returnClass, emitter);
        }
    }

    public QName getElementQName() {
        return this.elementQName;
    }

    public void setElementQName(QName elementQName) {
        this.elementQName = elementQName;
    }

    public PortDesc getParent() {
        return this.parent;
    }

    public void setParent(PortDesc parent) {
        this.parent = parent;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public void addParameter(ParameterDesc param) {
        this.parameters.add(param);
        if (param.getMode() != 1) {
            this.hasOutParams = true;
        }
        if (param.getMode() == 1 || param.getMode() == 3) {
            param.setOrder(this.numInParams++);
        }
        if (log.isDebugEnabled()) {
            log.debug("@" + Integer.toHexString(this.hashCode()) + " added parameter >" + param + "@" + Integer.toHexString(param.hashCode()) + "<total parameters:" + this.getNumParams());
        }
    }

    public ParameterDesc getParameter(int i) {
        if (this.parameters.size() <= i) {
            return null;
        }
        return (ParameterDesc)this.parameters.get(i);
    }

    public ArrayList getParameters() {
        return this.parameters;
    }

    void setParameters(ArrayList parameters) {
        parameters = new ArrayList();
        ListIterator li = this.parameters.listIterator();
        while (li.hasNext()) {
            ParameterDesc param = (ParameterDesc)li.next();
            this.addParameter(param);
            if (param.getMode() == 1) continue;
            this.hasOutParams = true;
        }
    }

    public int getNumInParams() {
        return this.numInParams;
    }

    public int getNumParams() {
        return this.parameters.size();
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public boolean isReturnHeader() {
        return this.returnDesc == null ? false : this.returnDesc.isOutHeader();
    }

    public void setReturnHeader(boolean value2) {
        this.initReturnDesc();
        this.returnDesc.setOutHeader(value2);
    }

    public ParameterDesc getParamByQName(QName qname) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterDesc param = (ParameterDesc)this.parameters.get(i);
            if (!param.getQName().equals(qname)) continue;
            return param;
        }
        return null;
    }

    public ParameterDesc getInputParamByQName(QName qname) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterDesc param = (ParameterDesc)this.parameters.get(i);
            if (param.getMode() == 2 || !param.getQName().equals(qname)) continue;
            return param;
        }
        return null;
    }

    public ParameterDesc getOutputParamByQName(QName qname) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterDesc param = (ParameterDesc)this.parameters.get(i);
            if (param.getMode() == 1 || !param.getQName().equals(qname)) continue;
            return param;
        }
        ParameterDesc param = null;
        if (this.returnDesc != null && this.returnDesc.getQName() == null) {
            param = new ParameterDesc(this.returnDesc);
            param.setQName(qname);
        } else if (this.returnDesc != null && qname.equals(this.returnDesc.getQName())) {
            param = this.returnDesc;
        }
        return param;
    }

    public ArrayList getOutParams() {
        ArrayList<ParameterDesc> result = new ArrayList<ParameterDesc>();
        Iterator i = this.parameters.iterator();
        while (i.hasNext()) {
            ParameterDesc desc = (ParameterDesc)i.next();
            if (desc.getMode() != 2) continue;
            result.add(desc);
        }
        return result;
    }

    public void addFault(FaultDesc fault2) {
        if (this.faults == null) {
            this.faults = new ArrayList();
        }
        this.faults.add(fault2);
    }

    public ArrayList getFaults() {
        return this.faults;
    }

    public FaultDesc getFaultByClass(JavaClass cls) {
        if (this.faults == null || cls == null) {
            return null;
        }
        Iterator iterator = this.faults.iterator();
        while (iterator.hasNext()) {
            FaultDesc desc = (FaultDesc)iterator.next();
            if (!cls.getJavaName().equals(desc.getJavaClass().getJavaName())) continue;
            return desc;
        }
        return null;
    }

    public ParameterDesc getReturnParamDesc() {
        return this.returnDesc;
    }

    public boolean isOneway() {
        return this.returnDesc == null && !this.hasOutParams;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        int i;
        String text = "";
        text = text + indent + "returnClass: " + this.getReturnClass() + "\n";
        text = text + indent + "elementQName:" + this.getElementQName() + "\n";
        text = text + indent + "soapAction:  " + this.getSoapAction() + "\n";
        text = text + indent + "numInParams: " + this.getNumInParams() + "\n";
        text = text + indent + "method:" + this.getMethod() + "\n";
        for (i = 0; i < this.parameters.size(); ++i) {
            text = text + indent + " ParameterDesc[" + i + "]:\n";
            text = text + indent + ((ParameterDesc)this.parameters.get(i)).toString("  ") + "\n";
        }
        if (this.faults != null) {
            for (i = 0; i < this.faults.size(); ++i) {
                text = text + indent + " FaultDesc[" + i + "]:\n";
                text = text + indent + ((FaultDesc)this.faults.get(i)).toString() + "\n";
            }
        }
        return text;
    }
}

