/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.fromJava;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.wsdl.fromJava.BeanPropertyDescriptor;
import com.ibm.ws.webservices.wsdl.fromJava.BeanUtils;
import com.ibm.ws.webservices.wsdl.fromJava.EnumWriter;
import com.ibm.ws.webservices.wsdl.fromJava.SchemaWriter;
import com.ibm.ws.webservices.wsdl.fromJava.Types;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jem.java.ArrayType;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class BeanWriter
extends SchemaWriter {
    protected static Log log = LogFactory.getLog(Types.class.getName());
    JavaClass throwableCls = null;

    BeanWriter(Types types) {
        super(types);
        this.throwableCls = (JavaClass)types.getEmitter().getToolEnv().getClassFactory().forName("java.lang.Throwable");
    }

    boolean isWriter(JavaHelpers javaType, QName xmlType) {
        return BeanWriter.isBeanCompatible(javaType, this.types, false);
    }

    void writeSchema(JavaHelpers javaType, QName xmlType) throws Exception {
        JavaClass javaClass = (JavaClass)javaType;
        List propertyDescriptors = BeanUtils.getPd(javaClass, this.types.getEmitter().getToolEnv());
        Element complexType = this.types.createElement("complexType");
        Element schema = this.types.writeSchemaElement(xmlType.getNamespaceURI());
        if (schema != null) {
            schema.appendChild(complexType);
        }
        complexType.setAttribute("name", xmlType.getLocalPart());
        Element e = null;
        JavaClass superClass = javaClass.getSupertype();
        List superPds = null;
        List stopClasses = this.types.getStopClasses();
        if (!(superClass == null || superClass.getJavaName().equals("java.lang.Object") || superClass.getJavaName().equals("java.lang.Exception") || superClass.getJavaName().equals("java.lang.Throwable") || superClass.getJavaName().equals("java.rmi.RemoteException") || superClass.getJavaName().equals("com.ibm.ws.webservices.engine.WebServicesFault") || stopClasses != null && stopClasses.contains(superClass.getJavaName()))) {
            String base = this.types.writeType((JavaHelpers)superClass);
            this.types.recordReference(xmlType.getNamespaceURI(), this.types.getTypeQName((JavaHelpers)superClass).getNamespaceURI());
            Element complexContent = this.types.createElement("complexContent");
            complexType.appendChild(complexContent);
            Element extension = this.types.createElement("extension");
            complexContent.appendChild(extension);
            extension.setAttribute("base", base);
            e = extension;
            superPds = BeanUtils.getPd(superClass, this.types.getEmitter().getToolEnv());
        } else {
            e = complexType;
        }
        Element all = this.types.createElement("sequence");
        e.appendChild(all);
        if (javaClass.isAbstract()) {
            complexType.setAttribute("abstract", "true");
        }
        int numFields = 0;
        for (int i = 0; i < propertyDescriptors.size(); ++i) {
            BeanPropertyDescriptor pd = (BeanPropertyDescriptor)propertyDescriptors.get(i);
            String propName = pd.getName();
            if (propName.equals("class")) continue;
            ++numFields;
        }
        boolean writeExtraMessage = false;
        if (superClass != null && (superClass.getJavaName().equals("java.lang.Exception") || superClass.getJavaName().equals("java.lang.Throwable") || superClass.getJavaName().equals("java.rmi.RemoteException"))) {
            JavaClass stringCls = (JavaClass)this.types.getEmitter().getToolEnv().getClassFactory().forName("java.lang.String");
            if (stringCls == null) {
                throw new InternalException(new ClassNotFoundException("java.lang.String"));
            }
            String constructorName = javaClass.getJavaName().substring(javaType.getJavaName().lastIndexOf(46) + 1);
            List list = javaClass.getPublicMethodsNamed(constructorName);
            if (list != null) {
                for (int k = 0; k < list.size() && !writeExtraMessage; ++k) {
                    Method constructor = (Method)list.get(k);
                    if (constructor.getParameters() == null || constructor.getParameters().size() <= numFields) continue;
                    writeExtraMessage = true;
                }
            }
            if (writeExtraMessage) {
                this.writeField(this.types, "message", (JavaHelpers)stringCls, false, false, false, all, xmlType.getNamespaceURI());
            }
        }
        boolean inheritsFromThrowable = javaClass.inheritsFrom(this.throwableCls);
        for (int i = 0; i < propertyDescriptors.size(); ++i) {
            JavaHelpers cls;
            BeanPropertyDescriptor pd = (BeanPropertyDescriptor)propertyDescriptors.get(i);
            String propName = pd.getName();
            boolean writeProperty = true;
            if (propName.equals("class")) {
                writeProperty = false;
            }
            if (propName.equals("message") && writeExtraMessage) {
                writeProperty = false;
            }
            if (!pd.isReadable() || !inheritsFromThrowable && !pd.isWriteable()) {
                writeProperty = false;
            }
            if (superPds != null && writeProperty) {
                for (int j = 0; j < superPds.size() && writeProperty; ++j) {
                    BeanPropertyDescriptor superPd = (BeanPropertyDescriptor)superPds.get(j);
                    if (!propName.equals(superPd.getName())) continue;
                    writeProperty = false;
                }
            }
            if (!writeProperty) continue;
            boolean preferUnbounded = false;
            boolean isUnbounded = false;
            if (preferUnbounded) {
                cls = pd.getType();
                isUnbounded = pd.isIndexed();
                if (this.types.getUse() == Use.LITERAL && !cls.getJavaName().equals("byte[]") && !isUnbounded && cls.isArray()) {
                    isUnbounded = true;
                    cls = ((ArrayType)cls).getComponentTypeAsHelper();
                }
            } else {
                cls = pd.getRawType();
            }
            boolean isWrappedArray = isUnbounded && numFields == 1;
            this.writeField(this.types, propName, cls, isUnbounded, isWrappedArray, false, all, xmlType.getNamespaceURI());
        }
    }

    protected void writeField(Types types, String fieldName, JavaHelpers fieldType, boolean isUnbounded, boolean isWrappedArray, boolean isOmittable, Element where, String refingNS) throws Exception {
        Document docHolder = where.getOwnerDocument();
        if (fieldName.equals("_any") && (fieldType.getJavaName().equals("javax.xml.soap.SOAPElement[]") || fieldType.getJavaName().equals("javax.xml.soap.SOAPElement"))) {
            Element element = docHolder.createElement("any");
            if (fieldType.getJavaName().endsWith("[]")) {
                element.setAttribute("maxOccurs", "unbounded");
            }
            where.appendChild(element);
            return;
        }
        String elementType = types.writeType(fieldType, null, refingNS);
        if (elementType == null) {
            QName anyQN = Constants.XSD_ANYTYPE;
            String prefix = types.getNamespaces().getCreatePrefix(anyQN.getNamespaceURI());
            elementType = prefix + ":" + anyQN.getLocalPart();
        } else {
            types.recordReference(refingNS, types.getTypeQName(fieldType, refingNS).getNamespaceURI());
        }
        Element element = docHolder.createElement("element");
        element.setAttribute("name", JavaUtils.java2NCName(fieldName));
        if (types.isNullable(fieldType)) {
            element.setAttribute("nillable", "true");
        }
        if (isOmittable) {
            element.setAttribute("minOccurs", "0");
            element.setAttribute("maxOccurs", "1");
        }
        if (!isWrappedArray) {
            element.setAttribute("type", elementType);
            if (isUnbounded) {
                element.setAttribute("maxOccurs", "unbounded");
            }
        } else {
            Element complexType = docHolder.createElement("complexType");
            element.appendChild(complexType);
            Element sequence = docHolder.createElement("sequence");
            complexType.appendChild(sequence);
            Element component = types.createElement("element");
            sequence.appendChild(component);
            component.setAttribute("name", "item");
            component.setAttribute("type", elementType);
            component.setAttribute("maxOccurs", "unbounded");
            component.setAttribute("minOccurs", "0");
            component.setAttribute("nillable", "true");
        }
        where.appendChild(element);
    }

    protected void writeAttribute(Types types, String fieldName, JavaHelpers fieldType, Element where, String refingNS) throws Exception {
        types.recordReference(refingNS, types.getTypeQName(fieldType).getNamespaceURI());
        if (!types.isAcceptableAsAttribute(fieldType)) {
            types.getEmitter().getToolEnv().reportFatalErr(Messages.getMessage("AttrNotSimpleType00", fieldName, fieldType.getJavaName()));
        }
        String elementType = types.writeType(fieldType);
        Element elem = types.createAttributeElement(fieldName, elementType, false, where.getOwnerDocument());
        where.appendChild(elem);
    }

    static boolean isBeanCompatible(JavaHelpers javaType, Types types, boolean issueErrors) {
        if (!(javaType instanceof JavaClass)) {
            return false;
        }
        JavaClass javaClass = (JavaClass)javaType;
        String javaName = javaType.getJavaName();
        if (javaClass.isArray() || javaType.isPrimitive()) {
            if (issueErrors && !types.beanCompatErrs.contains(javaType)) {
                log.error(Messages.getMessage("beanCompatType00", javaName));
                types.getEmitter().getToolEnv().reporterr(Messages.getMessage("beanCompatType00", javaName));
                types.beanCompatErrs.add(javaType);
            }
            return false;
        }
        if (javaName.startsWith("java.") && !"java.net.URI".equals(javaName) || javaName.startsWith("javax.") || javaName.startsWith("org.w3c.dom")) {
            if (issueErrors && !BeanWriter.isMIMEType(javaName)) {
                log.warn(Messages.getMessage("beanCompatPkg00", javaName));
                types.getEmitter().getToolEnv().reportWarning(Messages.getMessage("beanCompatPkg00", javaName));
            }
            return false;
        }
        if (EnumWriter.isEnumClass(javaType, types.getEmitter().getToolEnv().getClassFactory(), types.getEmitter().getToolEnv())) {
            return false;
        }
        JavaClass throwableClass = (JavaClass)types.getEmitter().getToolEnv().getClassFactory().forName("java.lang.Throwable");
        if (throwableClass == null) {
            throw new InternalException(new ClassNotFoundException("java.lang.Throwable"));
        }
        if (!throwableClass.isAssignableFrom((EClassifier)javaType)) {
            String constructor = javaType.getJavaName().substring(javaType.getJavaName().lastIndexOf(46) + 1);
            boolean constructorFound = false;
            Method method = ((JavaClass)javaType).getPublicMethod(constructor, new ArrayList());
            boolean bl = constructorFound = method != null;
            if (!constructorFound && !((JavaClass)javaType).isInterface()) {
                EList list = ((JavaClass)javaType).getMethods();
                if (list == null) {
                    constructorFound = true;
                } else {
                    boolean found = false;
                    for (int i = 0; !found && i < list.size(); ++i) {
                        found = ((Method)list.get(i)).getName().equals(constructor);
                    }
                    boolean bl2 = constructorFound = !found;
                }
            }
            if (!constructorFound) {
                if (issueErrors && !types.beanCompatErrs.contains(javaType)) {
                    log.error(Messages.getMessage("beanCompatConstructor00", javaName));
                    types.getEmitter().getToolEnv().reporterr(Messages.getMessage("beanCompatConstructor00", javaName));
                    types.beanCompatErrs.add(javaType);
                }
                return false;
            }
        }
        if (types.getEmitter().getSEIClass().isAssignableFrom((EClassifier)javaType)) {
            if (issueErrors && !types.beanCompatErrs.contains(javaType)) {
                log.error(Messages.getMessage("beanCompatExtends00", javaType.getJavaName(), types.getEmitter().getSEIClass().getJavaName(), javaType.getJavaName()));
                types.getEmitter().getToolEnv().reporterr(Messages.getMessage("beanCompatExtends00", javaType.getJavaName(), types.getEmitter().getSEIClass().getJavaName(), javaType.getJavaName()));
            }
            return false;
        }
        if (types.getEmitter().getImplClass() != null && types.getEmitter().getImplClass().isAssignableFrom((EClassifier)javaType)) {
            if (issueErrors && !types.beanCompatErrs.contains(javaType)) {
                log.error(Messages.getMessage("beanCompatExtends00", javaType.getJavaName(), types.getEmitter().getImplClass().getJavaName(), javaType.getJavaName()));
                types.getEmitter().getToolEnv().reporterr(Messages.getMessage("beanCompatExtends00", javaType.getJavaName(), types.getEmitter().getImplClass().getJavaName(), javaType.getJavaName()));
            }
            return false;
        }
        List stopClasses = types.getStopClasses();
        JavaClass superClass = javaClass.getSupertype();
        if (!(superClass == null || superClass.getJavaName().equals("java.lang.Object") || superClass.getJavaName().equals("java.lang.Exception") || superClass.getJavaName().equals("java.lang.Throwable") || superClass.getJavaName().equals("java.rmi.RemoteException") || superClass.getJavaName().equals("com.ibm.ws.webservices.engine.WebServicesFault") || stopClasses != null && stopClasses.contains(superClass.getJavaName()) || BeanWriter.isBeanCompatible((JavaHelpers)superClass, types, false))) {
            if (issueErrors && !types.beanCompatErrs.contains(javaType)) {
                log.error(Messages.getMessage("beanCompatExtends00", javaName, superClass.getJavaName(), javaName));
                types.getEmitter().getToolEnv().reporterr(Messages.getMessage("beanCompatExtends00", javaName, superClass.getJavaName(), javaName));
                types.beanCompatErrs.add(javaType);
            }
            return false;
        }
        return true;
    }

    static boolean isMIMEType(String javaName) {
        return "java.awt.Image".equals(javaName) || "javax.xml.transform.Source".equals(javaName) || "javax.mail.internet.MimeMultipart".equals(javaName) || "javax.activation.DataHandler".equals(javaName);
    }
}

