/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.tools;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTypeMapping;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.encoding.custom.CustomRegistry;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.tools.resource.DefaultToolEnv;
import com.ibm.ws.webservices.wsdl.ImportResolver;
import com.ibm.ws.webservices.wsdl.mapping.MappingMetaData;
import com.ibm.ws.webservices.wsdl.query.ImportResolverDelegate;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaDeployGenerator;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Role;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WSDLQuery {
    private Emitter emitter = null;
    private HashMap allServices = new HashMap();
    private HashMap allBindings = new HashMap();
    private HashMap allPortTypes = new HashMap();
    private boolean lazyAnalyzed = false;

    public WSDLQuery() throws WebServicesFault {
        this(new HashMap(), true);
    }

    public WSDLQuery(HashMap nsMap) throws WebServicesFault {
        this(new HashMap(), true);
    }

    public WSDLQuery(boolean skipWCCMMappingPass) throws WebServicesFault {
        this(new HashMap(), skipWCCMMappingPass);
    }

    public WSDLQuery(HashMap nsMap, boolean skipWCCMMappingPass) throws WebServicesFault {
        this.emitter = new Emitter(skipWCCMMappingPass);
        this.emitter.setToolEnv(DefaultToolEnv.create(skipWCCMMappingPass));
        this.emitter.setDisplayDevelopmentMessages(false);
        JavaGeneratorFactory factory = (JavaGeneratorFactory)this.emitter.getFactory();
        factory.removeAllGenerators();
        factory.addGenerator(Definition.class, JavaDeployGenerator.class);
        this.emitter.setNamespaceMap(nsMap);
        this.emitter.setRole(Role.DEPLOY_SERVER.toString());
        this.emitter.setResolver(new ImportResolverDelegate(this.emitter), false);
        this.emitter.setVerbose(true);
        this.emitter.setLogToConsole(false);
        this.emitter.allowRelativeNamespace(true);
    }

    public void parse(String wsdlURI) throws Exception {
        this.lazyAnalyzed = false;
        this.emitter.run(wsdlURI);
    }

    public void parse(String context, Document doc) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        if (doc == null) {
            throw new IllegalArgumentException(Messages.getMessage("null00", "Document"));
        }
        this.lazyAnalyzed = false;
        this.emitter.run(context, doc);
    }

    public void parse(String context, InputStream in) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        if (in == null) {
            throw new IllegalArgumentException(Messages.getMessage("null00", "InputStream"));
        }
        this.lazyAnalyzed = false;
        this.emitter.run(context, XMLUtils.newDocument(new InputSource(in)));
    }

    public void parse(String context, Document doc, Definition def) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        if (doc == null) {
            throw new IllegalArgumentException(Messages.getMessage("null00", "Document"));
        }
        if (def == null) {
            throw new IllegalArgumentException(Messages.getMessage("null00", "Definition"));
        }
        this.lazyAnalyzed = false;
        this.emitter.run(context, doc, def);
    }

    private void analyze() {
        if (!this.lazyAnalyzed) {
            SymbolTable symbolTable = this.emitter.getSymbolTable();
            if (symbolTable.getHashMap() != null && symbolTable.getHashMap().values() != null) {
                Iterator it = symbolTable.getHashMap().values().iterator();
                while (it.hasNext()) {
                    Vector v = (Vector)it.next();
                    for (int i = 0; i < v.size(); ++i) {
                        String name2;
                        SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                        if (entry instanceof ServiceEntry) {
                            ServiceEntry se = (ServiceEntry)entry;
                            name2 = se.getQName().toString();
                            this.allServices.put(name2, se);
                            continue;
                        }
                        if (entry instanceof PortTypeEntry) {
                            PortTypeEntry pte = (PortTypeEntry)entry;
                            name2 = pte.getQName().toString();
                            this.allPortTypes.put(name2, pte);
                            continue;
                        }
                        if (!(entry instanceof BindingEntry)) continue;
                        BindingEntry be = (BindingEntry)entry;
                        name2 = be.getQName().toString();
                        this.allBindings.put(name2, be);
                    }
                }
                this.lazyAnalyzed = true;
            } else {
                this.lazyAnalyzed = false;
            }
        }
    }

    public HashMap getNamespaces() {
        this.analyze();
        return this.emitter.getNamespaces();
    }

    public void setNamespaces(HashMap namespaces) {
        this.emitter.setNamespaceMap(namespaces);
    }

    public SymbolTable getSymbolTable() {
        this.analyze();
        return this.emitter.getSymbolTable();
    }

    public Vector getTypeMappings(String portName) {
        this.analyze();
        HashMap typeMappingsByPort = (HashMap)this.emitter.getDynamicVar("queryTypeMappings");
        if (typeMappingsByPort == null) {
            typeMappingsByPort = new HashMap();
        }
        return (Vector)typeMappingsByPort.get(portName);
    }

    public HashMap getServices() {
        this.analyze();
        return this.allServices;
    }

    public HashMap getPortTypes() {
        this.analyze();
        return this.allPortTypes;
    }

    public HashMap getBindings() {
        this.analyze();
        return this.allBindings;
    }

    public String getPortType(PortEntry portEntry) {
        Binding binding;
        this.analyze();
        String ptQName = new String();
        Port port2 = portEntry.getPort();
        if (port2 != null && (binding = port2.getBinding()) != null) {
            ptQName = binding.getQName().toString();
        }
        return ptQName;
    }

    public HashMap getPorts(String service) {
        this.analyze();
        HashMap<String, PortEntry> ports = new HashMap<String, PortEntry>();
        ServiceEntry sEntry = (ServiceEntry)this.allServices.get(service);
        if (sEntry != null) {
            for (int i = 0; i < sEntry.numPorts(); ++i) {
                PortEntry pEntry = sEntry.getPort(i);
                String qname = pEntry.getQName().toString();
                ports.put(qname, pEntry);
            }
        }
        return ports;
    }

    public HashMap getTypeMappings() {
        this.analyze();
        HashMap typeMappingsByPort = (HashMap)this.emitter.getDynamicVar("queryTypeMappings");
        return typeMappingsByPort;
    }

    public Vector getOperationDescs(String portName) {
        this.analyze();
        HashMap operationsByPort = (HashMap)this.emitter.getDynamicVar("queryOperations");
        if (operationsByPort == null) {
            operationsByPort = new HashMap();
        }
        return (Vector)operationsByPort.get(portName);
    }

    public HashMap getOperationDescs() {
        this.analyze();
        HashMap operationsByPort = (HashMap)this.emitter.getDynamicVar("queryOperations");
        return operationsByPort;
    }

    public CustomRegistry getCustomRegistry() {
        return this.emitter.getCustomRegistry();
    }

    public void setCustomRegistry(CustomRegistry registry) {
        this.emitter.setCustomRegistry(registry);
    }

    public void setInputMappingFile(String name2) {
        this.emitter.setInputMappingFile(name2);
    }

    public void setInputMapping(MappingMetaData mmd) {
        this.emitter.setInputMapping(mmd);
    }

    public void setNoDataBinding(boolean value2) {
        this.emitter.setNoDataBinding(value2);
    }

    public void setResolver(ImportResolver resolver) {
        this.emitter.setResolver(resolver, false);
    }

    public boolean getNoDataBinding() {
        return this.emitter.getNoDataBinding();
    }

    public boolean isLogToConsole() {
        return this.emitter.getLogToConsole();
    }

    public void setLogToConsole(boolean logToConsole) {
        this.emitter.setLogToConsole(logToConsole);
        this.emitter.setVerbose(logToConsole);
    }

    public static void main(String[] args) {
        try {
            Vector v;
            String portName;
            Iterator keys;
            WSDLQuery queryTool;
            if (!(args.length > 1 && (args[1].equals("all") || args[1].equals("typeMappings") || args[1].equals("namespaces") || args[1].equals("operations") || args[1].equals("bindings") || args[1].equals("services") || args[1].equals("portTypes") || args[1].equals("symbolTable")))) {
                System.out.println("Usage: WSDLQuery <wsdlFile> <option> [<mappingFile>]");
                System.out.println("       <option> := all | bindings | namespaces | operations | portTypes | services | symbolTable | typeMappings");
            }
            if (args.length == 3) {
                queryTool = new WSDLQuery(false);
                queryTool.setInputMappingFile(args[2]);
            } else {
                queryTool = new WSDLQuery(true);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("This is a test namespace", "com.here.is.the.test.pkg");
            queryTool.setNamespaces(map);
            queryTool.parse(args[0]);
            if (args.length >= 2 && (args[1].equals("symbolTable") || args[1].equals("all"))) {
                queryTool.emitter.getSymbolTable().dump(System.out);
            }
            if (args.length >= 2 && (args[1].equals("namespaces") || args[1].equals("all"))) {
                Set nsKeys;
                System.out.println();
                System.out.println(" Namespace -> Java Package");
                System.out.println("--------------------------");
                System.out.println();
                HashMap ns2pkg = queryTool.getNamespaces();
                if (ns2pkg != null && (nsKeys = ns2pkg.keySet()) != null) {
                    Iterator i = nsKeys.iterator();
                    while (i != null && i.hasNext()) {
                        String ns = (String)i.next();
                        String pkg = (String)ns2pkg.get(ns);
                        if (ns == null || ns.equals("")) continue;
                        System.out.println("\"" + ns + "\" -> \"" + pkg + "\"");
                    }
                }
            }
            if (args.length >= 2 && (args[1].equals("typeMappings") || args[1].equals("all"))) {
                System.out.println();
                System.out.println(" TypeMappings");
                System.out.println("-------------");
                System.out.println();
                HashMap typeMappings = queryTool.getTypeMappings();
                keys = typeMappings.keySet().iterator();
                while (keys.hasNext()) {
                    portName = (String)keys.next();
                    System.out.println("Port name = " + portName);
                    v = (Vector)typeMappings.get(portName);
                    for (int i = 0; i < v.size(); ++i) {
                        System.out.println("TypeMapping " + ((WSDDTypeMapping)v.get(i)).toString());
                    }
                }
            }
            if (args.length >= 2 && (args[1].equals("operations") || args[1].equals("all"))) {
                System.out.println();
                System.out.println(" Operations");
                System.out.println("-------------");
                System.out.println();
                HashMap operations = queryTool.getOperationDescs();
                keys = operations.keySet().iterator();
                while (keys.hasNext()) {
                    portName = (String)keys.next();
                    System.out.println("Port name = " + portName);
                    v = (Vector)operations.get(portName);
                    for (int i = 0; i < v.size(); ++i) {
                        System.out.println("Operation " + ((OperationDesc)v.get(i)).getName() + " " + ((OperationDesc)v.get(i)).toString());
                    }
                }
            }
            if (args.length >= 2 && (args[1].equals("services") || args[1].equals("all"))) {
                System.out.println();
                System.out.println(" Services");
                System.out.println("----------");
                System.out.println();
                HashMap services = queryTool.getServices();
                keys = services.keySet().iterator();
                while (keys.hasNext()) {
                    String serviceName = (String)keys.next();
                    System.out.println("Service Name = " + serviceName);
                    HashMap ports = queryTool.getPorts(serviceName);
                    Iterator pKeys = ports.keySet().iterator();
                    Iterator pVals = ports.values().iterator();
                    while (pKeys.hasNext()) {
                        String portName2 = (String)pKeys.next();
                        String portType = new String();
                        if (pVals.hasNext()) {
                            PortEntry pEntry = (PortEntry)pVals.next();
                            portType = queryTool.getPortType(pEntry);
                        }
                        System.out.println("  Port Name = " + portName2 + ", of type " + portType);
                    }
                }
            }
            if (args.length >= 2 && (args[1].equals("portTypes") || args[1].equals("all"))) {
                System.out.println();
                System.out.println(" Port Types");
                System.out.println("------------");
                System.out.println();
                HashMap porttypes = queryTool.getPortTypes();
                keys = porttypes.keySet().iterator();
                while (keys.hasNext()) {
                    String portTypeName = (String)keys.next();
                    System.out.println("Port Type Name = " + portTypeName);
                }
            }
            if (args.length >= 2 && (args[1].equals("bindings") || args[1].equals("all"))) {
                System.out.println();
                System.out.println(" Bindings");
                System.out.println("----------");
                System.out.println();
                HashMap bindings = queryTool.getBindings();
                keys = bindings.keySet().iterator();
                while (keys.hasNext()) {
                    String bindingName = (String)keys.next();
                    System.out.println("Binding Name = " + bindingName);
                }
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.webservices.axis.ext.wsdl.WSDLQuery.main", "498");
            t.printStackTrace();
        }
    }
}

