/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.pmi.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.pmi.modules.EndpointPmiModule;
import com.ibm.ws.webservices.pmi.modules.PmiModuleUtils;
import com.ibm.wsspi.pmi.factory.StatisticActions;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPIAverageStatistic;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import com.ibm.wsspi.pmi.stat.SPITimeStatistic;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ServicePmiModule
extends StatisticActions {
    private static TraceComponent _tc = Tr.register(ServicePmiModule.class, "WebServices.Shared", "com.ibm.ws.webservices.resources.WSMessages");
    public static final String serviceTemplate = "/com/ibm/ws/webservices/pmi/modules/webServicesServiceStats.xml";
    public static final String SERVICE_PMI_MODULE = "pmiWebServiceService";
    private StatsGroup endpointStatsGroup = null;
    private StatsInstance serviceStatsInstance = null;
    private Map endpointData = null;
    private String moduleName = null;
    private String serviceName = null;
    private SPICountStatistic numberReceived = null;
    private SPICountStatistic numberDispatched = null;
    private SPICountStatistic numberSuccessful = null;
    private SPITimeStatistic responseTime = null;
    private SPITimeStatistic requestResponseTime = null;
    private SPITimeStatistic dispatchResponseTime = null;
    private SPITimeStatistic replyResponseTime = null;
    private SPIAverageStatistic size = null;
    private SPIAverageStatistic requestSize = null;
    private SPIAverageStatistic replySize = null;
    public static final int PMI_ID_NUMBER_RECEIVED = 11;
    public static final int PMI_ID_NUMBER_DISPATCHED = 12;
    public static final int PMI_ID_NUMBER_SUCCESSFULL = 13;
    public static final int PMI_ID_AVERAGE_RESPONSE_TIME = 14;
    public static final int PMI_ID_AVERAGE_REQUEST_RESPONSE_TIME = 15;
    public static final int PMI_ID_AVERAGE_DISPATCH_RESPONSE_TIME = 16;
    public static final int PMI_ID_AVERAGE_REPLY_RESPONSE_TIME = 17;
    public static final int PMI_ID_AVERAGE_SIZE = 18;
    public static final int PMI_ID_AVERAGE_REQUEST_SIZE = 19;
    public static final int PMI_ID_AVERAGE_REPLY_SIZE = 20;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServicePmiModule(String moduleName, String serviceName, StatsGroup serviceStatsGroup) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ServicePmiModule.ServicePmiModule()...");
        }
        this.moduleName = moduleName;
        this.serviceName = serviceName;
        this.endpointData = new HashMap();
        try {
            String string = serviceTemplate;
            synchronized (serviceTemplate) {
                this.serviceStatsInstance = StatsFactory.getStatsInstance((String[])new String[]{"pmiWebServiceModule", moduleName, SERVICE_PMI_MODULE, serviceName});
                if (this.serviceStatsInstance == null) {
                    this.serviceStatsInstance = StatsFactory.createStatsInstance((String)serviceName, (StatsGroup)serviceStatsGroup, null, (StatisticActions)this);
                } else {
                    this.copyStatisticCreated();
                }
                this.createEndpointStatsGroup();
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        catch (StatsFactoryException e) {
            Object[] inserts = new Object[]{moduleName, serviceName, e};
            Tr.error(_tc, "createServicePmiModuleFail", inserts);
        }
        {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "...ServicePmiModule.ServicePmiModule()");
            }
            return;
        }
    }

    private void createEndpointStatsGroup() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ServicePmiModule.createEndpointStatsGroup()...");
        }
        try {
            this.endpointStatsGroup = StatsFactory.getStatsGroup((String[])new String[]{"pmiWebServiceModule", this.moduleName, SERVICE_PMI_MODULE, this.serviceName, "pmiWebServiceEndpoint"});
            if (this.endpointStatsGroup == null) {
                this.endpointStatsGroup = StatsFactory.createStatsGroup((String)"pmiWebServiceEndpoint", (String)"/com/ibm/ws/webservices/pmi/modules/webServicesEndpointStats.xml", (StatsInstance)this.serviceStatsInstance, null);
            }
        }
        catch (StatsFactoryException e) {
            Object[] inserts = new Object[]{this.moduleName, this.serviceName, e};
            Tr.error(_tc, "createEndpointPmiGroupFail", inserts);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...ServicePmiModule.createEndpointStatsGroup()");
        }
    }

    public void statisticCreated(SPIStatistic data) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ServicePmiModule.statisticCreated()...");
        }
        switch (data.getId()) {
            case 11: {
                this.numberReceived = (SPICountStatistic)data;
                break;
            }
            case 12: {
                this.numberDispatched = (SPICountStatistic)data;
                break;
            }
            case 13: {
                this.numberSuccessful = (SPICountStatistic)data;
                break;
            }
            case 14: {
                this.responseTime = (SPITimeStatistic)data;
                break;
            }
            case 15: {
                this.requestResponseTime = (SPITimeStatistic)data;
                break;
            }
            case 16: {
                this.dispatchResponseTime = (SPITimeStatistic)data;
                break;
            }
            case 17: {
                this.replyResponseTime = (SPITimeStatistic)data;
                break;
            }
            case 18: {
                this.size = (SPIAverageStatistic)data;
                break;
            }
            case 19: {
                this.requestSize = (SPIAverageStatistic)data;
                break;
            }
            case 20: {
                this.replySize = (SPIAverageStatistic)data;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...ServicePmiModule.statisticCreated()");
        }
    }

    private void copyStatisticCreated() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ServicePmiModule.copyStatisticCreated()...");
        }
        if (this.serviceStatsInstance != null) {
            this.numberReceived = (SPICountStatistic)this.serviceStatsInstance.getStatistic(11);
            this.numberDispatched = (SPICountStatistic)this.serviceStatsInstance.getStatistic(12);
            this.numberSuccessful = (SPICountStatistic)this.serviceStatsInstance.getStatistic(13);
            this.responseTime = (SPITimeStatistic)this.serviceStatsInstance.getStatistic(14);
            this.requestResponseTime = (SPITimeStatistic)this.serviceStatsInstance.getStatistic(15);
            this.dispatchResponseTime = (SPITimeStatistic)this.serviceStatsInstance.getStatistic(16);
            this.replyResponseTime = (SPITimeStatistic)this.serviceStatsInstance.getStatistic(17);
            this.size = (SPIAverageStatistic)this.serviceStatsInstance.getStatistic(18);
            this.requestSize = (SPIAverageStatistic)this.serviceStatsInstance.getStatistic(19);
            this.replySize = (SPIAverageStatistic)this.serviceStatsInstance.getStatistic(20);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...ServicePmiModule.copyStatisticCreated()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointPmiModule registerEndpoint(String endpointName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ServicePmiModule.registerEndpoint()...", this.moduleName + "#" + this.serviceName + "#" + endpointName);
        }
        EndpointPmiModule module = null;
        Map map = this.endpointData;
        synchronized (map) {
            module = (EndpointPmiModule)((Object)this.endpointData.get(endpointName));
            if (module == null) {
                module = new EndpointPmiModule(this.moduleName, this.serviceName, endpointName, this.endpointStatsGroup);
                this.endpointData.put(endpointName, module);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Registered new endpoint PMI module.");
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Endpoint PMI module already registered.");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...ServicePmiModule.registerEndpoint()");
        }
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEndpoint(String endpointName) {
        EndpointPmiModule module;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ServicePmiModule.unregisterEndpoint()...", this.moduleName + "#" + this.serviceName + "#" + endpointName);
        }
        if ((module = (EndpointPmiModule)((Object)this.endpointData.get(endpointName))) != null) {
            Map map = this.endpointData;
            synchronized (map) {
                this.endpointData.remove(endpointName);
            }
            module.destroy();
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Could not find endpoint PMI module.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...ServicePmiModule.unregisterEndpoint()");
        }
    }

    public EndpointPmiModule getEndpoint(String endpointName) {
        EndpointPmiModule module;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ServicePmiModule.getEndpoint()...");
        }
        if ((module = (EndpointPmiModule)((Object)this.endpointData.get(endpointName))) == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Endpoint not registered, registering now...");
            }
            module = this.registerEndpoint(endpointName);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...ServicePmiModule.getEndpoint()");
        }
        return module;
    }

    public void destroy() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ServicePmiModule.destroy()...");
        }
        try {
            StatsFactory.removeStatsInstance((StatsInstance)this.serviceStatsInstance);
            if (this.endpointStatsGroup != null) {
                StatsFactory.removeStatsGroup((StatsGroup)this.endpointStatsGroup);
            }
        }
        catch (Exception e) {
            Object[] inserts = new Object[]{this.moduleName, this.serviceName, e};
            Tr.error(_tc, "removeServicePmiModuleFail", inserts);
        }
        if (this.endpointData != null) {
            Collection entryValues = this.endpointData.values();
            Iterator it = entryValues.iterator();
            while (it.hasNext()) {
                ((EndpointPmiModule)((Object)it.next())).destroy();
            }
        }
        this.endpointData = null;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...ServicePmiModule.destroy()");
        }
    }

    public void incRequestReceived(long currTime) {
        PmiModuleUtils.increment(ServicePmiModule.class.getName(), "incRequestReceived", currTime, this.numberReceived);
    }

    public void incRequestDispatched(long currTime) {
        PmiModuleUtils.increment(ServicePmiModule.class.getName(), "incRequestDispatched", currTime, this.numberDispatched);
    }

    public void incRequestSuccessful(long currTime, boolean successful) {
        if (successful) {
            PmiModuleUtils.increment(ServicePmiModule.class.getName(), "incRequestSuccessful", currTime, this.numberSuccessful);
        }
    }

    public void addResponseTime(long currTime, long rspTime) {
        PmiModuleUtils.addTime(ServicePmiModule.class.getName(), "addResponseTime", currTime, rspTime, this.responseTime);
    }

    public void addRequestResponseTime(long currTime, long rspTime) {
        PmiModuleUtils.addTime(ServicePmiModule.class.getName(), "addRequestResponseTime", currTime, rspTime, this.requestResponseTime);
    }

    public void addDispatchResponseTime(long currTime, long rspTime) {
        PmiModuleUtils.addTime(ServicePmiModule.class.getName(), "addDispatchResponseTime", currTime, rspTime, this.dispatchResponseTime);
    }

    public void addReplyResponseTime(long currTime, long rspTime) {
        PmiModuleUtils.addTime(ServicePmiModule.class.getName(), "addReplyResponseTime", currTime, rspTime, this.replyResponseTime);
    }

    public void addTotalSize(long currTime, long msgSize) {
        PmiModuleUtils.addAverage(ServicePmiModule.class.getName(), "addTotalSize", currTime, msgSize, this.size);
    }

    public void addRequestSize(long currTime, long msgSize) {
        PmiModuleUtils.addAverage(ServicePmiModule.class.getName(), "addRequestSize", currTime, msgSize, this.requestSize);
    }

    public void addReplySize(long currTime, long msgSize) {
        PmiModuleUtils.addAverage(ServicePmiModule.class.getName(), "addReplySize", currTime, msgSize, this.replySize);
    }
}

