/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.encoding.custom.CustomRegistry;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.multiprotocol.ServiceInformation;
import com.ibm.ws.webservices.tools.resource.DefaultToolEnv;
import com.ibm.ws.webservices.tools.resource.ToolEnv;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.MetaInfo;
import com.ibm.ws.webservices.wsdl.symbolTable.PortEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaStubWriter;
import com.ibm.ws.webservices.wsdl.toJava.RuntimeJavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import com.ibm.ws.webservices.wsdl.utils.OperationDescBuilder;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DynamicServiceInformation
implements ServiceInformation {
    protected static MetaInfo metaInfo = new MetaInfo();
    protected static ToolEnv env = DefaultToolEnv.create();
    private static final List customProviders = DynamicServiceInformation.loadCustomProviders();
    private Map typeMappings = new HashMap();
    private Map operationDescriptions = new HashMap();

    public DynamicServiceInformation(Definition def, String wsdlLoc, QName serviceQName) {
        Iterator extEleIt;
        Types types;
        Document doc = null;
        if (def != null && (types = def.getTypes()) != null && (extEleIt = types.getExtensibilityElements().iterator()).hasNext()) {
            UnknownExtensibilityElement typesElement = (UnknownExtensibilityElement)extEleIt.next();
            Element schemaEl = typesElement.getElement();
            doc = schemaEl.getOwnerDocument();
        }
        this.init(def, doc, wsdlLoc, serviceQName);
    }

    public DynamicServiceInformation(Definition def, Document doc, String wsdlLoc, QName serviceQName) throws Exception {
        this.init(def, doc, wsdlLoc, serviceQName);
    }

    public void init(Definition def, Document doc, String wsdlLoc, QName serviceQName) {
        try {
            Emitter em = new Emitter(true);
            CustomRegistry registry = new CustomRegistry();
            registry.populate(customProviders);
            em.setCustomRegistry(registry);
            em.setFactory(new RuntimeJavaGeneratorFactory(em));
            em.setLogToConsole(false);
            em.setDisplayDevelopmentMessages(false);
            if (def != null && doc != null) {
                em.run(wsdlLoc, doc, def);
            } else if (doc != null) {
                em.run(wsdlLoc, doc);
            } else {
                em.run(wsdlLoc);
            }
            SymbolTable symbolTable = em.getSymbolTable();
            ServiceEntry sEntry = symbolTable.getServiceEntry(serviceQName);
            this.parseService(sEntry, symbolTable);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.utils.DynamicServiceInformation.init", "191", this);
        }
        catch (SAXException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.utils.DynamicServiceInformation.init", "193", this);
        }
        catch (WSDLException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.utils.DynamicServiceInformation.init", "195", this);
        }
        catch (ParserConfigurationException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.utils.DynamicServiceInformation.init", "197", this);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.utils.DynamicServiceInformation.init", "199", this);
        }
    }

    public Map getTypeMappings() {
        return this.typeMappings;
    }

    public Class getJavaType(QName xmlName) {
        return (Class)this.typeMappings.get(xmlName);
    }

    public Map getOperationDescriptions(String portName) {
        return (Map)this.operationDescriptions.get(portName);
    }

    public List getOperationDescriptions(String portName, String operationName) {
        Map map = (Map)this.operationDescriptions.get(portName);
        if (map != null) {
            return (List)map.get(operationName);
        }
        return null;
    }

    protected void parseService(ServiceEntry sEntry, SymbolTable symbolTable) throws Exception {
        HashSet types = new HashSet();
        ArrayList<PortType> portTypes = new ArrayList<PortType>();
        HashMap ports = new HashMap();
        for (int i = 0; i < sEntry.numPorts(); ++i) {
            ArrayList<BindingOperationEntry> boes = new ArrayList<BindingOperationEntry>();
            PortEntry pe = sEntry.getPort(i);
            Port p = pe.getPort();
            Binding binding = p.getBinding();
            if (binding == null) {
                throw new IOException(Messages.getMessage("emitFailNoBinding01", p.getName()));
            }
            BindingEntry bEntry = symbolTable.getBindingEntry(binding.getQName());
            if (bEntry == null) {
                throw new IOException(Messages.getMessage("emitFailNoBindingEntry01", binding.getQName().toString()));
            }
            this.populateTypesFromPortType(binding.getPortType(), bEntry, types, symbolTable);
            if (bEntry.isReferenced() && !portTypes.contains(binding.getPortType())) {
                portTypes.add(binding.getPortType());
                List operations = binding.getBindingOperations();
                for (int j = 0; j < operations.size(); ++j) {
                    BindingOperation operation = (BindingOperation)operations.get(j);
                    BindingOperationEntry boe = bEntry.getOperation(operation.getOperation());
                    Operation ptOperation = operation.getOperation();
                    OperationType type = ptOperation.getStyle();
                    if (type == OperationType.NOTIFICATION || type == OperationType.SOLICIT_RESPONSE) continue;
                    boes.add(boe);
                }
            }
            if (boes.size() > 1) {
                Collections.sort(boes, new Comparator(){

                    public int compare(Object obj1, Object obj2) {
                        int i = 0;
                        try {
                            i = ((BindingOperationEntry)obj1).getName().compareTo(((BindingOperationEntry)obj2).getName());
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.utils.DynamicServiceInformation.compare", "289", this);
                        }
                        return i;
                    }
                });
            }
            ports.put(p, boes);
        }
        this.typeMappings.putAll(this.getTypeMappings(types));
        this.operationDescriptions.putAll(this.getOperationDescriptions(ports, symbolTable));
    }

    private void populateTypesFromPortType(PortType portType, BindingEntry bEntry, HashSet types, SymbolTable symbolTable) {
        HashSet firstPassTypes = new HashSet();
        List operations = portType.getOperations();
        for (int i = 0; i < operations.size(); ++i) {
            Operation op = (Operation)operations.get(i);
            firstPassTypes.addAll(JavaStubWriter.getTypesInOperation(op, bEntry));
        }
        Iterator i = firstPassTypes.iterator();
        while (i.hasNext()) {
            TypeEntry type = (TypeEntry)i.next();
            if (types.contains(type)) continue;
            types.add(type);
            types.addAll(Utils.getNestedTypes(type, symbolTable));
        }
    }

    private Map getTypeMappings(HashSet types) throws Exception {
        HashMap<QName, Class> tm = new HashMap<QName, Class>();
        Iterator it = types.iterator();
        while (it.hasNext()) {
            TypeEntry type = (TypeEntry)it.next();
            if (type.isBaseType() && type.getRefType() == null || type.isCollectionTypeEntry() || !(type instanceof Type) || !type.isReferenced() || type.isOnlyWrappedLiteralReferenced()) continue;
            QName qname = type.getQName();
            tm.put(QNameTable.createQName(qname.getNamespaceURI(), qname.getLocalPart()), ClassUtils.forName(type.getName()));
        }
        return tm;
    }

    protected Map getOperationDescriptions(HashMap ports, SymbolTable symbolTable) throws Exception {
        HashMap od = new HashMap();
        HashMap portTypes = new HashMap();
        Iterator it = ports.keySet().iterator();
        while (it.hasNext()) {
            Port port2 = (Port)it.next();
            List boes = (List)ports.get(port2);
            QName pt = port2.getBinding().getPortType().getQName();
            BindingEntry be = symbolTable.getBindingEntry(port2.getBinding().getQName());
            HashMap innerMap = null;
            HashMap existingMap = (HashMap)portTypes.get(pt);
            if (existingMap != null) {
                innerMap = existingMap;
            } else {
                innerMap = new HashMap();
                portTypes.put(pt, innerMap);
            }
            String previous = null;
            ArrayList<OperationDesc> list = null;
            Iterator pit = boes.iterator();
            while (pit.hasNext()) {
                BindingOperationEntry boe = (BindingOperationEntry)pit.next();
                if (!boe.getName().equals(previous)) {
                    list = new ArrayList<OperationDesc>();
                    innerMap.put(boe.getName(), list);
                }
                list.add(this.getOperationDesc(boe, be, symbolTable));
                previous = boe.getName();
            }
            if (innerMap == null) continue;
            od.put(port2.getName(), innerMap);
        }
        return od;
    }

    protected OperationDesc getOperationDesc(BindingOperationEntry boe, BindingEntry bEntry, SymbolTable symbolTable) throws Exception {
        OperationDescBuilder odb = OperationDescBuilder.create(boe, bEntry, symbolTable);
        OperationDesc oper = odb.getOperationDesc(true);
        return oper;
    }

    private static List loadCustomProviders() {
        return (List)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return com.ibm.ws.webservices.engine.encoding.custom.Utils.loadCustomProviders(Thread.currentThread().getContextClassLoader());
            }
        });
    }
}

