/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.naming;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.WebServicesException;
import com.ibm.ws.webservices.WebServicesServiceHome;
import com.ibm.ws.webservices.engine.client.Service;
import com.ibm.ws.webservices.metadata.ClientEntityMetaData;
import com.ibm.ws.webservices.metadata.ClientModuleMetaData;
import com.ibm.ws.webservices.metadata.ClientServiceMetaData;
import com.ibm.ws.webservices.multiprotocol.AgnosticServiceFactory;
import com.ibm.ws.webservices.multiprotocol.GeneratedService;
import com.ibm.ws.webservices.multiprotocol.ServiceContext;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;

public class ObjectFactoryImpl
extends AgnosticServiceFactory
implements ObjectFactory {
    protected static TraceComponent _tc = Tr.register(ObjectFactoryImpl.class, "WebServices", "com.ibm.ws.webservices.multiprotocol.resources.mpMessages");
    private static String SET_WSDDPORT_METHOD_PREFIX = "set";
    private static String SET_WSDDPORT_METHOD_SUFFIX = "WSDDPortName";
    private static String UNSPECIFIED_PORT_NAME = null;

    private static String getClassLocator(String className) {
        return className + "Locator";
    }

    public Object getObjectInstance(Object refObj, Name name2, Context nameCtx, Hashtable env) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getObjectInstance", new Object[]{refObj, name2, nameCtx, env});
        }
        javax.xml.rpc.Service srv = null;
        Reference ref = (Reference)refObj;
        if (ref != null) {
            String cr = ref.getClassName();
            if (cr.equals(ClientServiceMetaData.class.getName())) {
                ClientEntityMetaData clientEntityMetaData = WebServicesServiceHome.getWebServicesService().getClientEntityMetaData();
                if (clientEntityMetaData == null) {
                    String msg = "ClientEntityMetaData is not available";
                    Tr.error(_tc, "internal.error", msg);
                    throw new WebServicesException(msg);
                }
                ClientServiceMetaData clientServiceMetaData = clientEntityMetaData.getClientServiceMetaData(ref);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "clientEntityMetaData.getClientServiceMetaData(ref) == " + clientServiceMetaData);
                }
                String serviceName = clientServiceMetaData.getName();
                String wsdlFile = clientServiceMetaData.getWsdlFileName();
                Map defaultPortMapping = clientServiceMetaData.getDefaultPortMapping();
                Map seiPortTypeMapping = clientServiceMetaData.getSeiToPortTypeMapping();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Refname on java:comp lookup is " + serviceName);
                    Tr.debug(_tc, "RefWsdlFile on java:comp lookup is " + wsdlFile);
                }
                if (clientServiceMetaData.getServiceInterface().equals(javax.xml.rpc.Service.class.getName())) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Generic Service was requested...");
                    }
                    ServiceContext context = null;
                    QName serviceQName = clientServiceMetaData.getQName();
                    if (wsdlFile == null) {
                        context = new ServiceContext(null, null, serviceQName);
                    } else {
                        Definition refDefinition = clientServiceMetaData.getWsdlDoc();
                        Map refNamespace2PackageMapping = clientServiceMetaData.getNamespaceToPackageMapping();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "RefWsdlDoc on java:comp lookup is " + refDefinition);
                            Tr.debug(_tc, "refNamespace2PackageMapping on java:comp lookup is " + refNamespace2PackageMapping);
                        }
                        URL url = null;
                        url = wsdlFile.indexOf(":") == -1 ? new URL("file", null, wsdlFile) : new URL(wsdlFile);
                        context = new ServiceContext(url, refDefinition, serviceQName);
                        context.setNamespace2PackageMapping(refNamespace2PackageMapping);
                    }
                    context.setSEIToPortTypeMapping(clientServiceMetaData.getSeiToPortTypeMapping());
                    context.setPortTypeToPortMapping(defaultPortMapping);
                    context.setServiceRefName(serviceName);
                    context.setClientMetaData(clientEntityMetaData);
                    context.setManagedEnvironment(true);
                    context.setOverriddingEndpointURIs(clientServiceMetaData.getOverriddingEndpointURIs());
                    context.setOverriddingBindingNamespaces(clientServiceMetaData.getOverriddingBindingNamespaces());
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Created the following ServiceContext: \n" + context.toString());
                    }
                    srv = this.createService(serviceQName, context);
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Generated ServiceLocator was requested...");
                    }
                    ClassLoader cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return Thread.currentThread().getContextClassLoader();
                        }
                    });
                    Class<?> srvcl = null;
                    try {
                        srvcl = cl.loadClass(ObjectFactoryImpl.getClassLocator(clientServiceMetaData.getServiceInterface()));
                    }
                    catch (ClassNotFoundException ex) {
                        FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.multiprotocol.naming.ObjectFactoryImpl.getObjectInstance", "132", this);
                        Tr.error(_tc, "internal.error", ex);
                        throw ex;
                    }
                    if (!javax.xml.rpc.Service.class.isAssignableFrom(srvcl)) {
                        throw new Exception(Messages.getMessage("invalidService1", srvcl.getName(), "javax.xml.rpc.Service"));
                    }
                    if (GeneratedService.class.isAssignableFrom(srvcl)) {
                        Constructor<?> con;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "This is a new ServiceLocator...");
                        }
                        if ((con = srvcl.getConstructor(ServiceContext.class)) == null) {
                            throw new Exception(Messages.getMessage("noSvcCtor", srvcl.getName()));
                        }
                        ServiceContext context = null;
                        QName serviceQName = clientServiceMetaData.getQName();
                        if (wsdlFile == null) {
                            context = new ServiceContext(null, null, serviceQName);
                        } else {
                            Definition refDefinition = clientServiceMetaData.getWsdlDoc();
                            Map refNamespace2PackageMapping = clientServiceMetaData.getNamespaceToPackageMapping();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "RefWsdlDoc on java:comp lookup is " + refDefinition);
                                Tr.debug(_tc, "refNamespace2PackageMapping on java:comp lookup is " + refNamespace2PackageMapping);
                            }
                            URL url = null;
                            url = wsdlFile.indexOf(":") == -1 ? new URL("file", null, wsdlFile) : new URL(wsdlFile);
                            context = new ServiceContext(url, refDefinition, serviceQName);
                            context.setNamespace2PackageMapping(refNamespace2PackageMapping);
                        }
                        context.setSEIToPortTypeMapping(seiPortTypeMapping);
                        context.setPortTypeToPortMapping(defaultPortMapping);
                        context.setServiceRefName(serviceName);
                        context.setClientMetaData(clientEntityMetaData);
                        context.setManagedEnvironment(true);
                        context.setOverriddingEndpointURIs(clientServiceMetaData.getOverriddingEndpointURIs());
                        context.setOverriddingBindingNamespaces(clientServiceMetaData.getOverriddingBindingNamespaces());
                        srv = (javax.xml.rpc.Service)con.newInstance(context);
                        ((GeneratedService)((Object)srv)).setPortNamePrefix(serviceName);
                    } else {
                        if (!javax.xml.rpc.Service.class.isAssignableFrom(srvcl)) {
                            Tr.error(_tc, "internal.error", "Specified service " + srvcl + " is not assignable from javax.xml.rpc.Service");
                            throw new Exception("Specified service does not inherit from javax.xml.rpc.Service");
                        }
                        srv = (javax.xml.rpc.Service)srvcl.newInstance();
                        if (srv instanceof Service) {
                            ((Service)srv).setEngine(clientEntityMetaData.getEngine());
                        }
                        Method[] locatorMethods = srvcl.getMethods();
                        String[] wsdlPorts = this.getWsdlPortsFromReferencable(clientServiceMetaData);
                        for (int wsdlPortIndex = 0; wsdlPortIndex < wsdlPorts.length; ++wsdlPortIndex) {
                            Object[] params;
                            String methodName;
                            int i;
                            Method setWSDDPortNameMethod = null;
                            String expectedMethodName = null;
                            if (wsdlPorts[wsdlPortIndex] == UNSPECIFIED_PORT_NAME) {
                                expectedMethodName = SET_WSDDPORT_METHOD_PREFIX + "<PortName>" + SET_WSDDPORT_METHOD_SUFFIX;
                                if (wsdlPortIndex != 0) {
                                    Tr.error(_tc, "internal.error", "ObjectFactoryImpl: Empty PortName in WSDL Port Names Array");
                                }
                                for (i = 0; i < locatorMethods.length; ++i) {
                                    methodName = locatorMethods[i].getName();
                                    if (!methodName.startsWith(SET_WSDDPORT_METHOD_PREFIX) || !methodName.endsWith(SET_WSDDPORT_METHOD_SUFFIX)) continue;
                                    setWSDDPortNameMethod = locatorMethods[i];
                                    break;
                                }
                            } else {
                                expectedMethodName = SET_WSDDPORT_METHOD_PREFIX + wsdlPorts[wsdlPortIndex] + SET_WSDDPORT_METHOD_SUFFIX;
                                for (i = 0; i < locatorMethods.length; ++i) {
                                    methodName = locatorMethods[i].getName();
                                    if (!methodName.equals(expectedMethodName)) continue;
                                    setWSDDPortNameMethod = locatorMethods[i];
                                    break;
                                }
                            }
                            String portName = ClientModuleMetaData.clientConfigurationPortName(clientServiceMetaData.getName(), wsdlPorts[wsdlPortIndex]);
                            if (setWSDDPortNameMethod != null) {
                                params = new Object[]{portName};
                                setWSDDPortNameMethod.invoke((Object)srv, params);
                                if (!_tc.isDebugEnabled()) continue;
                                Tr.debug(_tc, "ServiceLocator " + srvcl + " WSDDPort name set to " + portName);
                                continue;
                            }
                            params = new Object[]{srvcl, expectedMethodName, clientServiceMetaData.getName(), portName};
                            Tr.warning(_tc, "warning.ServiceNameSetter.notfound", params);
                        }
                        ((Service)srv).setServiceRefName(serviceName);
                        ((Service)srv).setWSDLFileName(wsdlFile);
                        ((Service)srv).setPortTypeToPortMapping(defaultPortMapping);
                        ((Service)srv).setSEIToPortTypeMapping(seiPortTypeMapping);
                        ((Service)srv).setOverriddingEndpointURIs(clientServiceMetaData.getOverriddingEndpointURIs());
                    }
                }
            } else {
                Object[] params = new Object[]{cr, ClientServiceMetaData.class.getName()};
                Tr.warning(_tc, "warning.client.reference.wrong.type", params);
            }
        } else {
            Tr.warning(_tc, "warning.client.reference.not.found");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getObjectInstance");
        }
        return srv;
    }

    private String[] getWsdlPortsFromReferencable(ClientServiceMetaData serviceMetaData) {
        String[] refWsdlPorts = serviceMetaData.getWsdlPortNames();
        if (refWsdlPorts == null) {
            refWsdlPorts = new String[]{UNSPECIFIED_PORT_NAME};
        }
        return refWsdlPorts;
    }
}

