/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.etools.webservice.wscbnd.DefaultMapping;
import com.ibm.etools.webservice.wscbnd.PortQnameBinding;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.etools.webservice.wscommonbnd.Parameter;
import com.ibm.websphere.naming.JndiHelper;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.util.CacheableReference;
import com.ibm.ws.webservices.client.ModuleWSDLLocator;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDPort;
import com.ibm.ws.webservices.engine.encoding.SerializationContextImpl;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.metadata.ClientEntityMetaData;
import com.ibm.ws.webservices.metadata.ClientPortMetaData;
import com.ibm.ws.webservices.multiprotocol.naming.ObjectFactoryImpl;
import com.ibm.ws.webservices.security.SecurityHooks;
import com.ibm.ws.webservices.wsdl.mapping.MappingMetaData;
import com.ibm.wsspi.webservices.models.WSModels;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.webservice.wsclient.Handler;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ClientServiceMetaData
implements Referenceable {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceComponent _tc = Tr.register(ClientServiceMetaData.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private static final String VERSION = "version: ";
    private static final String VERSION_ID = "1.0";
    private static final String REFSERVICENAME = "refServiceName:";
    private ClientEntityMetaData parent;
    private String name = null;
    private QName qName = null;
    private String serviceInterface = null;
    private boolean wsdlDocLoaded = false;
    private String wsdlFileName;
    private Definition wsdlDoc;
    private Service wsdlServiceElement;
    private String wsdlTargetNamespace;
    private String[] wsdlPortNames;
    private boolean cleanedPortMapping = false;
    private Map defaultPortMapping;
    private boolean mappingMetaDataLoaded = false;
    private String jaxrpcMappingFileName;
    private Map seiToPortTypeMapping;
    private Map namespaceToPackageMapping;
    private Map overriddingEndpointURIs = null;
    private Map overriddingBindingNamespaces = null;
    private boolean jndiBound = false;
    private List globalHandlers = new ArrayList();
    private Map portHandlers = new HashMap();
    private Map clientPorts = new HashMap();
    private String portComponentLink = null;

    public ClientServiceMetaData(String name2, ClientEntityMetaData parent) {
        this.name = name2.intern();
        this.parent = parent;
    }

    public void destroy() {
        Iterator iter;
        this.parent = null;
        this.wsdlDoc = null;
        this.wsdlServiceElement = null;
        this.wsdlPortNames = null;
        if (this.defaultPortMapping != null) {
            this.defaultPortMapping.clear();
            this.defaultPortMapping = null;
        }
        if (this.seiToPortTypeMapping != null) {
            this.seiToPortTypeMapping.clear();
            this.seiToPortTypeMapping = null;
        }
        if (this.namespaceToPackageMapping != null) {
            this.namespaceToPackageMapping.clear();
            this.namespaceToPackageMapping = null;
        }
        if (this.globalHandlers != null) {
            this.globalHandlers.clear();
            this.globalHandlers = null;
        }
        if (this.portHandlers != null) {
            iter = this.portHandlers.values().iterator();
            while (iter.hasNext()) {
                List list = (List)iter.next();
                if (list == null) continue;
                list.clear();
            }
            this.portHandlers.clear();
            this.portHandlers = null;
        }
        if (this.clientPorts != null) {
            iter = this.clientPorts.values().iterator();
            while (iter.hasNext()) {
                ClientPortMetaData cpmd = (ClientPortMetaData)iter.next();
                if (cpmd == null) continue;
                cpmd.destroy();
            }
            this.clientPorts.clear();
            this.clientPorts = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public QName getQName() {
        return this.qName;
    }

    public void setQName(QName name2) {
        this.qName = name2;
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(String string) {
        this.serviceInterface = string.intern();
    }

    public LoadStrategy getLoadStrategy() {
        return this.parent.getLoadStrategy();
    }

    protected ClassLoader getClassLoader() {
        return this.parent.getClassLoader();
    }

    public String getWsdlFileName() {
        return this.wsdlFileName;
    }

    public Definition getWsdlDoc() {
        if (!this.wsdlDocLoaded) {
            this.loadWsdlFile(this.getWsdlFileName());
        }
        return this.wsdlDoc;
    }

    private Service getWsdlServiceElement() {
        Definition doc;
        if (this.wsdlServiceElement == null && (doc = this.getWsdlDoc()) != null) {
            this.wsdlServiceElement = doc.getService(this.getQName());
            if (this.wsdlServiceElement == null) {
                String key = "no.wsdl.services.for.qname";
                Object[] params = new Object[]{this.getQName()};
                Tr.error(_tc, key, params);
                throw new RuntimeException(nls.getFormattedMessage(key, params, null));
            }
        }
        return this.wsdlServiceElement;
    }

    public String[] getWsdlPortNames() {
        Service wsdlServiceElement;
        if (this.wsdlPortNames == null && (wsdlServiceElement = this.getWsdlServiceElement()) != null && wsdlServiceElement.getPorts() != null) {
            Object[] portElements = wsdlServiceElement.getPorts().values().toArray();
            this.wsdlPortNames = new String[portElements.length];
            for (int i = 0; i < portElements.length; ++i) {
                this.wsdlPortNames[i] = ((Port)portElements[i]).getName();
            }
        }
        return this.wsdlPortNames;
    }

    public Map getDefaultPortMapping() {
        if (this.defaultPortMapping != null && !this.cleanedPortMapping) {
            this.defaultPortMapping = this.cleanDefaultPortMappingInformation(this.defaultPortMapping);
        }
        return this.defaultPortMapping;
    }

    public void setDefaultPortMapping(Map defaultMapping) {
        this.defaultPortMapping = defaultMapping;
    }

    public void setWsdlFileName(String string) {
        this.wsdlFileName = string.intern();
        this.wsdlDocLoaded = false;
        this.wsdlDoc = null;
        this.wsdlServiceElement = null;
        this.wsdlPortNames = null;
        this.defaultPortMapping = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadWsdlFile(String wsdlFileName) {
        block22: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "loadWsdlFile");
            }
            try {
                this.wsdlDocLoaded = true;
                this.wsdlDoc = null;
                if (wsdlFileName == null) break block22;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Loading WSDL file \"" + wsdlFileName + "\"");
                }
                LoadStrategy loadStrategy = this.getLoadStrategy();
                InputStream wsdlInputStream = null;
                try {
                    wsdlInputStream = WSModels.getJavaWSDLInputStream(wsdlFileName, loadStrategy);
                    if (wsdlInputStream != null) {
                        WSDLReader reader = WSModels.getWSDLReader();
                        this.wsdlDoc = reader.readWSDL(new ModuleWSDLLocator(wsdlFileName, wsdlInputStream, loadStrategy));
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "loadWsdlFile: WSDLReader doc is " + (this.wsdlDoc == null ? "null." : "not null."));
                        }
                    } else if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "loadWsdlFile: wsdlInputStream is null ");
                    }
                }
                catch (WSDLException ex) {
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.metadata.ClientServiceMetaData.loadWsdlFile", "366", this);
                    Tr.error(_tc, "internal.error", ex);
                    throw new RuntimeException("Caught WSDLException " + ex);
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.metadata.ClientServiceMetaData.loadWsdlFile", "373", this);
                    Tr.error(_tc, "internal.error", ex);
                    throw new RuntimeException("Caught Exception " + ex);
                }
                if (this.wsdlDoc == null) {
                    try {
                        wsdlInputStream = WSModels.getJavaWSDLInputStream(wsdlFileName, loadStrategy);
                        if (wsdlInputStream == null) {
                            ClassLoader classLoader = this.getClassLoader();
                            if (classLoader != null) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "WSDL file " + wsdlFileName + " not found using " + "LoadStrategy, attempting with ClassLoader: " + classLoader);
                                }
                                wsdlInputStream = classLoader.getResourceAsStream(wsdlFileName);
                            }
                            if (wsdlInputStream == null) {
                                RuntimeException re = new RuntimeException("WSDL File not in EAR " + wsdlFileName);
                                Tr.error(_tc, "internal.error", re);
                                throw re;
                            }
                        }
                    }
                    catch (IOException ex) {
                        FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.metadata.ClientServiceMetaData.loadWsdlFile", "409", this);
                        Tr.error(_tc, "internal.error", ex);
                        throw new RuntimeException("Caught IOException reading wsdl file from EAR " + ex);
                    }
                }
                if (this.wsdlDoc != null) {
                    this.wsdlTargetNamespace = this.wsdlDoc.getTargetNamespace();
                    if (this.getQName() == null) {
                        this.setQName(this.getFirstWSDLServiceQName());
                    }
                }
            }
            finally {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "loadWsdlFile");
                }
            }
        }
    }

    private ClientPortMetaData getPort(String name2, boolean force) {
        ClientPortMetaData cpmd = (ClientPortMetaData)this.clientPorts.get(name2);
        if (cpmd == null && force) {
            cpmd = new ClientPortMetaData(name2, this);
            this.clientPorts.put(name2, cpmd);
            List handlers = (List)this.portHandlers.get(name2);
            if (handlers != null) {
                cpmd.addHandlers(handlers);
                this.portHandlers.remove(name2);
            } else {
                cpmd.addHandlers(this.globalHandlers);
            }
        }
        return cpmd;
    }

    public Collection getPorts() {
        return this.clientPorts.values();
    }

    public String getJaxrpcMappingFileName() {
        return this.jaxrpcMappingFileName;
    }

    public Map getNamespaceToPackageMapping() {
        if (!this.mappingMetaDataLoaded) {
            this.loadMappingMetaData(this.getJaxrpcMappingFileName());
        }
        return this.namespaceToPackageMapping;
    }

    public Map getSeiToPortTypeMapping() {
        if (!this.mappingMetaDataLoaded) {
            this.loadMappingMetaData(this.getJaxrpcMappingFileName());
        }
        return this.seiToPortTypeMapping;
    }

    public void setJaxrpcMappingFileName(String jaxrpcMappingFileName) {
        this.jaxrpcMappingFileName = jaxrpcMappingFileName;
        this.namespaceToPackageMapping = null;
        this.seiToPortTypeMapping = null;
        this.mappingMetaDataLoaded = false;
    }

    private void loadMappingMetaData(String jaxrpcMappingFileName) {
        this.mappingMetaDataLoaded = true;
        this.namespaceToPackageMapping = null;
        this.seiToPortTypeMapping = null;
        if (jaxrpcMappingFileName != null) {
            MappingMetaData mmd = null;
            try {
                mmd = (MappingMetaData)WSModels.getJavaWSDLMapping(this.getLoadStrategy(), jaxrpcMappingFileName);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.client.ClientServiceMetaData.loadMappingMetaData", "461", this);
                Tr.error(_tc, "internal.error", e);
                throw new RuntimeException("Caught Exception " + e);
            }
            if (mmd == null) {
                Tr.error(_tc, "client.mappingFile.not.found", new Object[]{jaxrpcMappingFileName, this.getName()});
                throw new RuntimeException("Unable to read Client JAX-RPC mapping file");
            }
            this.namespaceToPackageMapping = mmd.getPackageMappings();
            this.seiToPortTypeMapping = mmd.getSEIMappings();
        }
    }

    public Map getOverriddingEndpointURIs() {
        return this.overriddingEndpointURIs;
    }

    public void setOverriddingEndpointURIs(Map overriddingEndpointURIs) {
        this.overriddingEndpointURIs = overriddingEndpointURIs;
    }

    private static Map getOverriddingEndpointURIsInformation(ServiceRef cbsr) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getOverriddingEndpointURIsInformation");
        }
        HashMap<String, String> overridingEndpointURIsInformation = null;
        if (cbsr != null && cbsr.getPortQnameBindings().size() > 0) {
            overridingEndpointURIsInformation = new HashMap<String, String>();
            EList portQnameBindingsList = cbsr.getPortQnameBindings();
            int portQnameBindingsListSize = portQnameBindingsList.size();
            for (int mapIndex = 0; mapIndex < portQnameBindingsListSize; ++mapIndex) {
                PortQnameBinding portQnameBinding = (PortQnameBinding)portQnameBindingsList.get(mapIndex);
                String portQNameLocal = portQnameBinding.getPortQnameLocalNameLink();
                String overriddenEndpointURI = portQnameBinding.getOverriddenEndpointURI();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "portQnameLocal = " + portQNameLocal + " and overrddenEndpoint = " + overriddenEndpointURI);
                }
                if (portQNameLocal == null || overriddenEndpointURI == null) continue;
                overridingEndpointURIsInformation.put(portQNameLocal, overriddenEndpointURI);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getOverriddingEndpointURIsInformation");
        }
        return overridingEndpointURIsInformation;
    }

    public Map getOverriddingBindingNamespaces() {
        return this.overriddingBindingNamespaces;
    }

    public void setOverriddingBindingNamespaces(Map overriddingBindingNamespaces) {
        this.overriddingBindingNamespaces = overriddingBindingNamespaces;
    }

    private static Map getOverriddingBindingNamespacesInformation(ServiceRef cbsr) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getOverriddingBindingNamespacesInformation");
        }
        HashMap<String, String> overriddingBindingNamespacesInformation = null;
        if (cbsr != null && cbsr.getPortQnameBindings().size() > 0) {
            overriddingBindingNamespacesInformation = new HashMap<String, String>();
            EList portQnameBindingsList = cbsr.getPortQnameBindings();
            int portQnameBindingsListSize = portQnameBindingsList.size();
            for (int mapIndex = 0; mapIndex < portQnameBindingsListSize; ++mapIndex) {
                PortQnameBinding portQnameBinding = (PortQnameBinding)portQnameBindingsList.get(mapIndex);
                String portQNameLocal = portQnameBinding.getPortQnameLocalNameLink();
                String overriddenBindingNamespace = portQnameBinding.getOverriddenBindingNamespace();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "portQnameLocal = " + portQNameLocal + " and overrdden binding namespace = " + overriddenBindingNamespace);
                }
                if (portQNameLocal == null || overriddenBindingNamespace == null) continue;
                overriddingBindingNamespacesInformation.put(portQNameLocal, overriddenBindingNamespace);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getOverriddingBindingNamespacesInformation");
        }
        return overriddingBindingNamespacesInformation;
    }

    private QName getFirstWSDLServiceQName() {
        QName qName = null;
        Map allServicesMap = this.wsdlDoc.getServices();
        Collection allServicesCollection = allServicesMap.values();
        Object[] servicesArray = allServicesCollection.toArray();
        if (servicesArray != null && servicesArray.length == 1) {
            qName = ((Service)servicesArray[0]).getQName();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "No ServiceQName in 109 DD.  Using first service in WSDL file as default. Note there should only be one.");
            }
        } else {
            if (servicesArray != null && servicesArray.length > 1) {
                Tr.error(_tc, "client.invalid.wsdlservice.specification.noqname", new Object[]{this.getName()});
                throw new RuntimeException("Invalid WSDL Service specification in Client DD");
            }
            Tr.error(_tc, "client.invalid.wsdlservice.specification.noservices", new Object[]{this.getName()});
            throw new RuntimeException("No WSDL Services");
        }
        return qName;
    }

    private Map cleanDefaultPortMappingInformation(Map defaultPortMapping) {
        Service wsdlServiceElement;
        HashMap<QName, QName> portTypeToDefaultPortMapping = null;
        if (defaultPortMapping != null && defaultPortMapping.size() > 0 && (wsdlServiceElement = this.getWsdlServiceElement()) != null) {
            portTypeToDefaultPortMapping = new HashMap<QName, QName>();
            Iterator iter = defaultPortMapping.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                QName portTypeQName = (QName)entry.getKey();
                QName defaultPortQName = (QName)entry.getValue();
                boolean defaultInfoValid = false;
                Object servicePortObject = wsdlServiceElement.getPorts().get(defaultPortQName.getLocalPart());
                if (servicePortObject != null && wsdlServiceElement.getQName().getNamespaceURI().equals(defaultPortQName.getNamespaceURI())) {
                    Port checkPort = (Port)servicePortObject;
                    defaultInfoValid = portTypeQName.equals(checkPort.getBinding().getPortType().getQName());
                }
                if (defaultInfoValid) {
                    portTypeToDefaultPortMapping.put(portTypeQName, defaultPortQName);
                    continue;
                }
                Object[] params = new Object[]{this.getName(), portTypeQName.getLocalPart(), portTypeQName.getNamespaceURI(), defaultPortQName.getLocalPart(), defaultPortQName.getNamespaceURI()};
                Tr.warning(_tc, "invalid.defaultport.information", params);
            }
        }
        return portTypeToDefaultPortMapping;
    }

    public void addGlobalHandler(Handler handler2) {
        this.globalHandlers.add(handler2);
        Iterator iter = this.clientPorts.values().iterator();
        while (iter.hasNext()) {
            ClientPortMetaData port2 = (ClientPortMetaData)iter.next();
            port2.addHandler(handler2);
        }
        iter = this.portHandlers.values().iterator();
        while (iter.hasNext()) {
            List ports = (List)iter.next();
            ports.add(handler2);
        }
    }

    public void addHandlers(EList handlers) {
        int handlerCount = handlers.size();
        for (int handlerIndex = 0; handlerIndex < handlerCount; ++handlerIndex) {
            Handler handler2 = (Handler)handlers.get(handlerIndex);
            int portNameCount = handler2.getPortNames().size();
            if (portNameCount == 0) {
                this.addGlobalHandler(handler2);
                continue;
            }
            for (int portNameIndex = 0; portNameIndex < portNameCount; ++portNameIndex) {
                String handlerPortName = (String)handler2.getPortNames().get(portNameIndex);
                ClientPortMetaData port2 = this.getPort(handlerPortName, false);
                if (port2 != null) {
                    port2.addHandler(handler2);
                    continue;
                }
                ArrayList<Handler> ports = (ArrayList<Handler>)this.portHandlers.get(handlerPortName);
                if (ports == null) {
                    ports = new ArrayList<Handler>();
                    this.portHandlers.put(handlerPortName, ports);
                    ports.addAll(this.globalHandlers);
                }
                ports.add(handler2);
            }
        }
    }

    public void bind(Context javaColonCompEnvContext) throws NamingException {
        if (!this.jndiBound) {
            try {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "binding service-ref \"" + this.getName() + "\" to " + (this.parent.getName() == null ? "module" : "compenent " + this.parent.getName()) + " @ " + javaColonCompEnvContext);
                }
                JndiHelper.recursiveRebind((Context)javaColonCompEnvContext, (String)this.getName(), (Object)this);
                this.jndiBound = true;
            }
            catch (NamingException ne) {
                FFDCFilter.processException((Throwable)ne, "com.ibm.ws.webservices.client.ClientServiceMetaData.bind", "674", this);
                Tr.error(_tc, "error.binding.service.ref.named", new Object[]{"!!", this.getName(), "comp/env"});
                throw ne;
            }
        }
    }

    static String getServiceName(Reference ref) {
        String serviceName = (String)ref.get(REFSERVICENAME).getContent();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "refServiceName: on java:comp lookup is " + serviceName);
        }
        return serviceName;
    }

    public Reference getReference() throws NamingException {
        CacheableReference ref = new CacheableReference(this.getClass().getName(), ObjectFactoryImpl.class.getName(), null);
        ref.add(new StringRefAddr(VERSION, VERSION_ID));
        ref.add(new StringRefAddr(REFSERVICENAME, this.getName()));
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getReference(" + this.getName() + ") == " + JavaUtils.getObjectIdentity(ref));
        }
        return ref;
    }

    public static Context getJavaColonCompEnvContext(Context javaColonContext) throws NamingException {
        String subContextName = "comp/env";
        Context compEnvCtxt = null;
        try {
            compEnvCtxt = (Context)javaColonContext.lookup("comp/env");
            if (compEnvCtxt == null) {
                compEnvCtxt = JndiHelper.recursiveCreateSubcontext((Context)javaColonContext, (String)"comp/env");
            }
        }
        catch (NamingException ne) {
            FFDCFilter.processException(ne, "com.ibm.ws.webservices.client.ClientServiceMetaData.getJavaColonCompEnvContext", "743");
            Tr.error(_tc, "error.binding.service.refs.in.ns", new Object[]{"!!", "comp/env"});
            throw ne;
        }
        return compEnvCtxt;
    }

    public void extendServiceRef(ServiceRef cbsr, com.ibm.etools.webservice.wscext.ServiceRef cesr) throws NoSuchMethodException, ClassNotFoundException, InstantiationException, IllegalAccessException, ConfigurationError {
        if (this.globalHandlers.size() > 0 || cbsr != null) {
            int numberOfWSDDPorts;
            if (cbsr != null && cbsr.getDeployedWSDLFile() != null) {
                this.setWsdlFileName(cbsr.getDeployedWSDLFile());
            }
            this.setDefaultPortMapping(ClientServiceMetaData.getDefaultPortMappingInformation(cbsr));
            this.setOverriddingEndpointURIs(ClientServiceMetaData.getOverriddingEndpointURIsInformation(cbsr));
            this.setOverriddingBindingNamespaces(ClientServiceMetaData.getOverriddingBindingNamespacesInformation(cbsr));
            String[] wsdlServicePorts = this.getWsdlPortNames();
            if (wsdlServicePorts == null || wsdlServicePorts.length == 0) {
                wsdlServicePorts = null;
                numberOfWSDDPorts = 1;
            } else {
                numberOfWSDDPorts = wsdlServicePorts.length;
            }
            for (int processingWsdlPort = 0; processingWsdlPort < numberOfWSDDPorts; ++processingWsdlPort) {
                String wsdlServicePortName = wsdlServicePorts == null ? null : wsdlServicePorts[processingWsdlPort];
                WSDDPort wsddPort = this.getPort(wsdlServicePortName, true).getWsddPort();
                if (this.wsdlTargetNamespace != null) {
                    wsddPort.setWSDLPort(QNameTable.createQName(this.wsdlTargetNamespace, wsdlServicePortName));
                }
                ClientServiceMetaData.addSyncTimeoutToWSDDPort(wsdlServicePortName, wsddPort, cbsr);
                ClientServiceMetaData.addTransportPropertiesToWSDDPort(wsdlServicePortName, wsddPort, cbsr);
                SecurityHooks.addWSSecurityConfigurationToWSDDPort(wsddPort, wsdlServicePortName, cbsr, cesr, this.getClassLoader());
                if (!_tc.isDebugEnabled()) continue;
                ClientServiceMetaData.dumpPort(wsddPort);
            }
        }
    }

    private static Map getDefaultPortMappingInformation(ServiceRef cbsr) {
        HashMap<QName, QName> portTypeToDefaultPortMapping = null;
        if (cbsr != null && cbsr.getDefaultMappings().size() > 0) {
            portTypeToDefaultPortMapping = new HashMap<QName, QName>();
            EList defaultMappings = cbsr.getDefaultMappings();
            for (int mapIndex = 0; mapIndex < defaultMappings.size(); ++mapIndex) {
                DefaultMapping defaultPortMapping = (DefaultMapping)defaultMappings.get(mapIndex);
                QName portTypeQName = QNameTable.createQName(defaultPortMapping.getPortTypeNamespace(), defaultPortMapping.getPortTypeLocalName());
                QName defaultPortQName = QNameTable.createQName(defaultPortMapping.getPortNamespace(), defaultPortMapping.getPortLocalName());
                portTypeToDefaultPortMapping.put(portTypeQName, defaultPortQName);
            }
        }
        return portTypeToDefaultPortMapping;
    }

    private static void addSyncTimeoutToWSDDPort(String wsdlServicePort, WSDDPort wsddPort, ServiceRef cbsr) {
        String timeout = "300";
        if (wsdlServicePort != null && cbsr != null) {
            int pqnbcount = cbsr.getPortQnameBindings().size();
            for (int i = 0; i < pqnbcount; ++i) {
                PortQnameBinding pqnb = (PortQnameBinding)cbsr.getPortQnameBindings().get(i);
                String portQNameLocal = pqnb.getPortQnameLocalNameLink();
                if (portQNameLocal == null || !portQNameLocal.equals(wsdlServicePort)) continue;
                String to = pqnb.getSyncTimeout();
                if (to == null) break;
                timeout = to;
                break;
            }
        }
        wsddPort.setObject("SyncTimeout", timeout);
    }

    private static void addTransportPropertiesToWSDDPort(String wsdlServicePort, WSDDPort wsddPort, ServiceRef cbsr) {
        block19: {
            Iterator parameterIt;
            String sslcfgname;
            String password;
            String username;
            block21: {
                String portQNameLocal;
                int pqnbcount;
                block20: {
                    if (_tc.isEntryEnabled()) {
                        Tr.entry(_tc, "addTransportPropertiesToWSDDPort");
                    }
                    if (cbsr == null) break block19;
                    pqnbcount = cbsr.getPortQnameBindings().size();
                    username = null;
                    password = null;
                    sslcfgname = null;
                    portQNameLocal = null;
                    parameterIt = null;
                    if (wsdlServicePort != null && wsdlServicePort.length() != 0) break block20;
                    PortQnameBinding pqnb = (PortQnameBinding)cbsr.getPortQnameBindings().get(0);
                    if (pqnb == null) break block21;
                    if (pqnb.getBasicAuth() != null) {
                        username = pqnb.getBasicAuth().getUserid();
                        password = pqnb.getBasicAuth().getPassword();
                    }
                    if (pqnb.getSslConfig() != null) {
                        sslcfgname = pqnb.getSslConfig().getName();
                    }
                    if (pqnb.getParameters() != null && pqnb.getParameters().size() > 0) {
                        parameterIt = pqnb.getParameters().iterator();
                    }
                    break block21;
                }
                for (int i = 0; i < pqnbcount; ++i) {
                    PortQnameBinding pqnb = (PortQnameBinding)cbsr.getPortQnameBindings().get(i);
                    portQNameLocal = pqnb != null ? pqnb.getPortQnameLocalNameLink() : null;
                    if (portQNameLocal == null || !portQNameLocal.equals(wsdlServicePort)) continue;
                    if (pqnb.getBasicAuth() != null) {
                        username = pqnb.getBasicAuth().getUserid();
                        password = pqnb.getBasicAuth().getPassword();
                    }
                    if (pqnb.getSslConfig() != null) {
                        sslcfgname = pqnb.getSslConfig().getName();
                    }
                    if (pqnb.getParameters() == null || pqnb.getParameters().size() <= 0) break;
                    parameterIt = pqnb.getParameters().iterator();
                    break;
                }
            }
            if (JavaUtils.hasValue(username)) {
                wsddPort.setObject("javax.xml.rpc.security.auth.username", username);
            }
            if (JavaUtils.hasValue(password)) {
                wsddPort.setObject("javax.xml.rpc.security.auth.password", password);
            }
            if (JavaUtils.hasValue(sslcfgname)) {
                wsddPort.setObject("ssl.configName", sslcfgname);
            }
            if (parameterIt != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Adding generic properties to WSDDPort object...");
                }
                Parameter p = null;
                while (parameterIt.hasNext()) {
                    p = (Parameter)parameterIt.next();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Parameter name(s): " + p.getName());
                        Tr.debug(_tc, "Parameter value(s): " + p.getValue());
                    }
                    if (p.getName().indexOf(":") != -1 && p.getValue().indexOf(":") != -1) {
                        StringTokenizer sN = new StringTokenizer(p.getName(), ":");
                        StringTokenizer sV = new StringTokenizer(p.getValue(), ":");
                        while (sN.hasMoreTokens() && sV.hasMoreTokens()) {
                            String name2 = sN.nextToken();
                            String value2 = sV.nextToken();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Setting " + name2 + "=" + value2 + " on WSDDPort object.");
                            }
                            wsddPort.setObject(name2, value2);
                        }
                        continue;
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Setting " + p.getName() + "=" + p.getValue() + " on WSDDPort object.");
                    }
                    wsddPort.setObject(p.getName(), p.getValue());
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addTransportToWSDDPort");
        }
    }

    private static void dumpPort(WSDDPort wsddPort) {
        try {
            StringWriter writer = new StringWriter();
            SerializationContextImpl context = new SerializationContextImpl(writer, null);
            context.getSerializationWriter().setPretty(true);
            wsddPort.writeToContext(context);
            writer.close();
            Document doc = XMLUtils.newDocument(new InputSource(new StringReader(writer.getBuffer().toString())));
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "config is \n" + XMLUtils.DocumentToString(doc));
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.client.ClientServiceMetaData.dumpPort", "965", null);
            Tr.warning(_tc, "dumpService.failed", e);
        }
    }

    public String getPortComponentLink() {
        return this.portComponentLink;
    }

    public void setPortComponentLink(String portComponentLink) {
        this.portComponentLink = portComponentLink;
    }
}

