/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.websphere.webservices.soap.IBMAttr;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.dom.DOM3AttrDelta;
import com.ibm.ws.webservices.engine.xmlsoap.dom.DOMAttr;
import com.ibm.ws.webservices.engine.xmlsoap.dom.impl.DOMAttrImpl;
import com.ibm.ws.webservices.engine.xmlsoap.dom.impl.DOMAttrNSImpl;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Utils {
    private static Log log = LogFactory.getLog(Utils.class.getName());
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_COLON = "xmlns:";
    private static final String EMPTY_STRING = "";
    private static boolean enableSAAJ13 = true;
    private static boolean enableDOM3 = true;
    private static final boolean isSAAJ13Available = Utils.discoverSAAJ13Availability();
    private static final boolean isDOM3Available = Utils.discoverDOM3Availability();
    private static boolean gotSOAPDynamicConstants = false;

    static void addImplicitNamespaceDeclarations(SOAPElement se) {
        SOAPElement parent;
        Node parentNode = se.getParentNode();
        if (parentNode instanceof SOAPElement && (parent = (SOAPElement)((Object)parentNode)).getParentNode() == null && se == parent.getFirstChild() && se == parent.getLastChild()) {
            Utils._addImplicitNamespaces(parent);
            Utils._addImplicitNamespacesForAttrs(parent);
        }
        Utils._addImplicitNamespaces(se);
        Utils._addImplicitNamespacesForAttrs(se);
    }

    private static void _addImplicitNamespaces(SOAPElement se) {
        String prefix;
        String namespace;
        MappingScope ms = se._getMappingScope();
        boolean needsXMLNSAttr = Utils.needsNamespaceDeclaration(ms, namespace = se.getNamespaceURI(), prefix = se.getPrefix(), false);
        if (needsXMLNSAttr) {
            if (log.isDebugEnabled()) {
                log.debug("adding implicit xmlns declaration for prefix = {" + prefix + "} and " + "namespace = {" + namespace + "}");
            }
            Utils.addXMLNSAttribute((Element)((Object)se), prefix, namespace);
        }
    }

    private static void _addImplicitNamespacesForAttrs(SOAPElement se) {
        MappingScope ms = se._getMappingScope();
        NamedNodeMap attrs = se.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            boolean needsXMLNSAttr;
            Attr attr = (Attr)attrs.item(i);
            String namespace = attr.getNamespaceURI();
            if ("http://www.w3.org/2000/xmlns/" == namespace || "http://www.w3.org/2000/xmlns/".equals(namespace)) continue;
            String prefix = attr.getPrefix();
            if (prefix == null || prefix.length() == 0) {
                int index = attr.getName().indexOf(58);
                if (index >= 0) {
                    prefix = attr.getName().substring(0, index);
                }
                if (prefix == null) {
                    prefix = EMPTY_STRING;
                }
            }
            if (!(needsXMLNSAttr = Utils.needsNamespaceDeclaration(ms, namespace, prefix, true))) continue;
            if (log.isDebugEnabled()) {
                log.debug("adding implicit xmlns declaration for prefix = {" + prefix + "} and " + "namespace = {" + namespace + "} due to attr reference");
            }
            Utils.addXMLNSAttribute((Element)((Object)se), prefix, namespace);
        }
    }

    private static boolean needsNamespaceDeclaration(MappingScope ms, String namespace, String prefix, boolean isAttrRef) {
        Mapping mapping;
        boolean rc = false;
        rc = namespace == null || namespace.length() == 0 ? (isAttrRef ? false : (mapping = ms.getMappingForPrefix(EMPTY_STRING, false)) != null && (mapping.getPrefix().length() != 0 || mapping.getNamespaceURI().length() != 0)) : (prefix == null || prefix.length() == 0 ? (mapping = ms.getMappingForPrefix(EMPTY_STRING, false)) == null || mapping.getPrefix().length() != 0 || mapping.getNamespaceURI() != namespace && !mapping.getNamespaceURI().equals(namespace) : (mapping = ms.getMappingForPrefix(prefix, false)) == null || !mapping.getPrefix().equals(prefix) || mapping.getNamespaceURI() != namespace && !mapping.getNamespaceURI().equals(namespace));
        return rc;
    }

    static void addXMLNSAttribute(Element el, String prefix, String uri) {
        String qualifiedName = XMLNS;
        if (prefix != null && prefix.length() != 0) {
            qualifiedName = qualifiedName + ":" + prefix;
        }
        if (uri == null) {
            uri = EMPTY_STRING;
        }
        el.setAttributeNS("http://www.w3.org/2000/xmlns/", qualifiedName, uri);
    }

    static boolean removeXMLNSAttribute(Element el, String prefix) {
        boolean result;
        String qualifiedName = XMLNS;
        if (prefix != null && prefix.length() > 0) {
            qualifiedName = qualifiedName + ":" + prefix;
        }
        if (result = el.hasAttribute(qualifiedName)) {
            el.removeAttribute(qualifiedName);
        }
        return result;
    }

    public static DOMAttr create(Attr attr, Document document) {
        if (!(attr instanceof DOMAttr)) {
            DOM3AttrDelta newAttr = null;
            newAttr = attr.getNamespaceURI() == null ? DOMAttrImpl.create(attr, document) : DOMAttrNSImpl.create(attr, document);
            attr = newAttr;
        }
        return (DOMAttr)attr;
    }

    static List getNamespaceDeclarations(SOAPElement se, boolean above, boolean on, boolean below) {
        ArrayList list = new ArrayList();
        if (above) {
            Utils._getNamespaceDeclarationsAbove(se, list);
        }
        if (on) {
            Utils._getNamespaceDeclarationsOn(se, list);
        }
        if (below) {
            Utils._getNamespaceDeclarationsBelow(se, list);
        }
        return list;
    }

    private static void _getNamespaceDeclarationsAbove(SOAPElement se, List list) {
        for (SOAPElement parent = (SOAPElement)se.getParentElement(); parent != null; parent = (SOAPElement)parent.getParentElement()) {
            MappingScope ms = parent._getMappingScope();
            if (ms.size() <= 0) continue;
            NamedNodeMap attrs = parent.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                IBMAttr attr = (IBMAttr)attrs.item(i);
                if (!attr.isNamespaceDeclaration()) continue;
                list.add(0, attr);
            }
        }
    }

    private static void _getNamespaceDeclarationsOn(SOAPElement se, List list) {
        MappingScope ms = se._getMappingScope();
        if (ms.size() > 0) {
            NamedNodeMap attrs = se.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                IBMAttr attr = (IBMAttr)attrs.item(i);
                if (!attr.isNamespaceDeclaration()) continue;
                list.add(attr);
            }
        }
    }

    private static void _getNamespaceDeclarationsBelow(SOAPElement se, List list) {
        for (Node node = se.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof SOAPElement)) continue;
            Utils._getNamespaceDeclarationsOn((SOAPElement)((Object)node), list);
            Utils._getNamespaceDeclarationsBelow((SOAPElement)((Object)node), list);
        }
    }

    public static List getAttributes(SOAPElement se, boolean above, boolean on, boolean below) {
        ArrayList list = new ArrayList();
        if (above) {
            Utils._getAttributesAbove(se, list);
        }
        if (on) {
            Utils._getAttributesOn(se, list);
        }
        if (below) {
            Utils._getAttributesBelow(se, list);
        }
        return list;
    }

    private static void _getAttributesAbove(SOAPElement se, List list) {
        for (SOAPElement parent = (SOAPElement)se.getParentElement(); parent != null; parent = (SOAPElement)parent.getParentElement()) {
            NamedNodeMap attrs = parent.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                IBMAttr attr = (IBMAttr)attrs.item(i);
                list.add(0, attr);
            }
        }
    }

    private static void _getAttributesOn(SOAPElement se, List list) {
        NamedNodeMap attrs = se.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            IBMAttr attr = (IBMAttr)attrs.item(i);
            list.add(attr);
        }
    }

    private static void _getAttributesBelow(SOAPElement se, List list) {
        for (Node node = se.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof SOAPElement)) continue;
            Utils._getAttributesOn((SOAPElement)((Object)node), list);
            Utils._getAttributesBelow((SOAPElement)((Object)node), list);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static QName toQName(SOAPElement se, String qualifiedName) {
        String namespace;
        String localPart;
        String prefix;
        int indexColon = qualifiedName.indexOf(":");
        if (indexColon > 0) {
            prefix = qualifiedName.substring(0, indexColon);
            localPart = qualifiedName.substring(indexColon + 1);
        } else {
            prefix = EMPTY_STRING;
            localPart = qualifiedName;
        }
        MappingScope ms = se._getMappingScope();
        Mapping mapping = ms.getMappingForPrefix(prefix, false);
        if (mapping == null) {
            if (prefix.length() != 0) throw new IllegalArgumentException();
            namespace = EMPTY_STRING;
            return new QName(namespace, localPart, prefix);
        } else {
            namespace = mapping.getNamespaceURI();
        }
        return new QName(namespace, localPart, prefix);
    }

    static String toQualifiedName(SOAPElement se, QName qName) {
        String prefix = EMPTY_STRING;
        MappingScope ms = se._getMappingScope();
        if (qName.getNamespaceURI().length() > 0) {
            String preferPrefix = null;
            if (qName.getPrefix() != null || qName.getPrefix().length() > 0) {
                preferPrefix = qName.getPrefix();
            }
            prefix = ms.getOrCreatePrefix(qName.getNamespaceURI(), preferPrefix, true);
        } else {
            Mapping entry = ms.getMappingForPrefix(EMPTY_STRING, false);
            if (entry != null && entry.getNamespaceURI().length() > 0) {
                ms.addMapping(EMPTY_STRING, EMPTY_STRING);
            }
        }
        if (prefix.length() == 0) {
            return qName.getLocalPart();
        }
        return prefix + ":" + qName.getLocalPart();
    }

    public static boolean _isSAAJ13Enabled() {
        return Utils._isSAAJ13Available() && enableSAAJ13;
    }

    public static boolean _isSAAJ13Available() {
        return isSAAJ13Available;
    }

    public static boolean _isDOM3Enabled() {
        return Utils._isDOM3Available() && enableDOM3 && Utils._isSAAJ13Enabled();
    }

    public static boolean _isDOM3Available() {
        return isSAAJ13Available;
    }

    private static boolean discoverSAAJ13Availability() {
        if (gotSOAPDynamicConstants) {
            return true;
        }
        return Utils.loadSOAPDynamicConstants() != null;
    }

    private static boolean discoverDOM3Availability() {
        try {
            return SOAPElement.class.getMethod("getSchemaTypeInfo", new Class[0]) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    static SOAPConstants loadSOAPDynamicConstants() {
        SOAPConstants retClass = null;
        try {
            Class cls = null;
            try {
                cls = ClassUtils.forName("com.ibm.ws.webservices.engine.xmlsoap.SOAPDynamicConstants");
            }
            catch (Exception e) {
                cls = null;
            }
            if (cls == null) {
                cls = ClassUtils.forName("com.ibm.ws.webservices.engine.xmlsoap.saaj13only.SOAPDynamicConstants");
            }
            retClass = (SOAPConstants)cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        if (retClass != null) {
            gotSOAPDynamicConstants = true;
            return retClass;
        }
        return null;
    }

    public static SOAPConstants getSOAPConstants(String protocol2) throws SOAPException {
        if (protocol2.equals("SOAP 1.1 Protocol")) {
            return SOAPConstants.SOAP11_CONSTANTS;
        }
        if (protocol2.equals("SOAP 1.2 Protocol")) {
            return SOAPConstants.SOAP12_CONSTANTS;
        }
        if (protocol2.equals("Dynamic Protocol")) {
            return SOAPConstants.SOAPDYNAMIC_CONSTANTS;
        }
        throw new SOAPException(Messages.getMessage("unrecognizedProtocol", protocol2));
    }
}

