/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.TransactionSuspender;
import com.ibm.ws.webservices.engine.transport.jms.JMSCacheData;
import com.ibm.ws.webservices.engine.transport.jms.JMSConnectionCache;
import com.ibm.ws.webservices.engine.transport.jms.JMSConnectionData;
import com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperBase;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.trace.MessageTrace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.naming.NamingException;
import javax.xml.soap.SOAPException;

public class JMSSenderHelperIBM
extends JMSSenderHelperBase {
    private static final TraceComponent _tc = Tr.register(JMSSenderHelperIBM.class, "WebServices", "com.ibm.ws.webservices.engine.resources.engineMessages");
    private static final int defaultRequestTimeout = 300000;

    public JMSSenderHelperIBM() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSSenderHelperIBM()");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "JMSSenderHelperIBM()");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(MessageContext msgContext) throws WebServicesFault {
        JMSConnectionData connData = new JMSConnectionData();
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSSenderHelperIBM.invoke()");
        }
        try {
            try {
                this.initialize(msgContext, connData);
                this.sendMessage(msgContext, connData);
            }
            catch (WebServicesFault e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSSender.JMSSenderHelperIBM.invoke", "96", this);
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSSender.JMSSenderHelperIBM.invoke", "104", this);
                WebServicesFault wsf = WebServicesFault.makeFault(e);
                throw wsf;
            }
            Object var6_3 = null;
            if (!_tc.isEntryEnabled()) return;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "JMSSenderHelperIBM.invoke()");
            throw throwable;
        }
        Tr.exit(_tc, "JMSSenderHelperIBM.invoke()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initialize(MessageContext mc, JMSConnectionData connData) throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSSenderHelperIBM.initialize()");
        }
        try {
            try {
                URL targetURL = mc.getTargetEndpointAddressAsURL();
                this.parseURL(connData, targetURL);
                this.getJMSObjects(connData);
            }
            catch (WebServicesFault e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSSender.JMSSenderHelperIBM.initialize", "178", this);
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSSender.JMSSenderHelperIBM.initialize", "183", this);
                WebServicesFault wsf = WebServicesFault.makeFault(e);
                throw wsf;
            }
            Object var6_6 = null;
            if (!_tc.isEntryEnabled()) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "JMSSenderHelperIBM.initialize()");
            throw throwable;
        }
        Tr.exit(_tc, "JMSSenderHelperIBM.initialize()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getJMSObjects(JMSConnectionData cd) throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSSenderHelperIBM.getJMSObjects()");
        }
        try {
            try {
                try {
                    cd.jndiContext = this.getInitialContext(cd.initialContextFactory, cd.jndiProviderURL);
                }
                catch (NamingException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperIBM.getJMSObjects", "357", this);
                    Tr.error(_tc, "JMS.JNDIError01", e.toString());
                    throw new WebServicesFault("JMS", Messages.getMessage("JMS.JNDIError01", e.toString()), null, null);
                }
                switch (cd.messageMode) {
                    case 1: {
                        try {
                            cd.queueConnectionFactory = (QueueConnectionFactory)this.getJNDIObject(cd, cd.connectionFactoryName);
                            cd.queue = (Queue)this.getJNDIObject(cd, cd.destinationName);
                            break;
                        }
                        catch (NamingException ne) {
                            FFDCFilter.processException((Throwable)ne, "com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperIBM.getJMSObjects", "385", this);
                            Tr.error(_tc, "JMS.JNDIError02", ne.toString());
                            throw new WebServicesFault("JMS", Messages.getMessage("JMS.JNDIError02", ne.toString()), null, null);
                        }
                    }
                    case 2: {
                        try {
                            cd.topicConnectionFactory = (TopicConnectionFactory)this.getJNDIObject(cd, cd.connectionFactoryName);
                            cd.topic = (Topic)this.getJNDIObject(cd, cd.destinationName);
                            break;
                        }
                        catch (NamingException ne) {
                            FFDCFilter.processException((Throwable)ne, "com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperIBM.getJMSObjects", "410", this);
                            Tr.error(_tc, "JMS.JNDIError02", ne.toString());
                            throw new WebServicesFault("JMS", Messages.getMessage("JMS.JNDIError02", ne.toString()), null, null);
                        }
                    }
                }
            }
            catch (WebServicesFault e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperIBM.getJMSObjects", "425", this);
                throw e;
            }
            {
            }
            Object var4_6 = null;
            if (!_tc.isEntryEnabled()) return;
            Tr.exit(_tc, "JMSSenderHelperIBM.getJMSObjects()");
            return;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "JMSSenderHelperIBM.getJMSObjects()");
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeConnection(JMSConnectionData cd) throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSSenderHelperIBM.closeConnection()");
        }
        try {
            try {
                switch (cd.messageMode) {
                    case 1: {
                        if (cd.queueConnection != null) {
                            cd.queueConnection.close();
                        }
                        break;
                    }
                    case 2: {
                        if (cd.topicConnection != null) {
                            cd.topicConnection.close();
                        }
                        break;
                    }
                }
            }
            catch (JMSException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperIBM.closeConnection", "562", this);
                Tr.error(_tc, "JMS.JMSError01", e.toString());
                throw new WebServicesFault("JMS", Messages.getMessage("JMS.JMSError01", e.toString()), null, null);
            }
            {
            }
            Object var4_2 = null;
            if (!_tc.isEntryEnabled()) return;
            Tr.exit(_tc, "JMSSenderHelperIBM.closeConnection()");
            return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "JMSSenderHelperIBM.closeConnection()");
            throw throwable;
        }
    }

    private void cleanUp(JMSConnectionData cd) throws WebServicesFault {
        if (!this.connectionManagementIsDesired()) {
            this.closeConnection(cd);
        } else {
            try {
                if (cd.topicSession != null) {
                    cd.topicSession.close();
                    cd.topicSession = null;
                }
                if (cd.queueSession != null) {
                    cd.queueSession.close();
                    cd.queueSession = null;
                }
            }
            catch (JMSException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperIBM.cleanUp", "612", this);
                Tr.error(_tc, "JMS.JMSError01", e.toString());
                throw new WebServicesFault("JMS", Messages.getMessage("JMS.JMSError01", e.toString()), null, null);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendMessage(MessageContext msgContext, JMSConnectionData connData) throws WebServicesFault, IOException, SOAPException {
        String prq;
        int requestTimeout;
        Integer tTimeToLive;
        Integer tPriority;
        Integer tDeliveryMode;
        boolean isTwoWay;
        OperationDesc oper;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSSenderHelperIBM.sendMessage()");
        }
        URL targetURL = msgContext.getTargetEndpointAddressAsURL();
        Object o = msgContext.getProperty("enableTransactionalOneWay");
        if (o != null) {
            connData.enableTranOneWay = JavaUtils.isTrue(o);
        }
        boolean bl = (oper = msgContext.getOperation()) == null ? true : (isTwoWay = !oper.isOneway());
        if (isTwoWay) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Two way...");
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "One way...");
        }
        if (msgContext.isResponsePath()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Response path. Setting TwoWay to false...");
            }
            isTwoWay = false;
        }
        if (isTwoWay && connData.messageMode == 2) {
            Tr.error(_tc, "JMS.NoTwoWay");
            throw new WebServicesFault("JMS", Messages.getMessage("JMS.NoTwoWay"), null, null);
        }
        TransactionSuspender tranSuspender = null;
        boolean transactionalSession = false;
        if (!isTwoWay && connData.enableTranOneWay) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Bypassing transaction suspension...");
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Initiating transaction suspension...");
            }
            tranSuspender = new TransactionSuspender();
            tranSuspender.suspendTransaction();
            transactionalSession = TransactionSuspender.isTxnServiceEnabled();
        }
        Message reqMessage = msgContext.getRequestMessage();
        String user = msgContext.getUsername();
        String password = msgContext.getPassword();
        if (_tc.isDebugEnabled()) {
            String tpassword;
            String tuser = user == null || user.length() == 0 ? "<not-specified>" : user;
            if (password == null || password.length() == 0) {
                tpassword = "<not-specified>";
            } else {
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < password.length(); ++i) {
                    buf.append('*');
                }
                tpassword = buf.toString();
            }
            Tr.debug(_tc, "Userid: " + tuser);
            Tr.debug(_tc, "Password: " + tpassword);
        }
        if ((tDeliveryMode = (Integer)msgContext.getProperty("deliveryMode")) != null) {
            connData.deliveryMode = tDeliveryMode;
        }
        if ((tPriority = (Integer)msgContext.getProperty("priority")) != null) {
            connData.priority = tPriority;
        }
        if ((tTimeToLive = (Integer)msgContext.getProperty("timeToLive")) != null) {
            connData.timeToLive = tTimeToLive;
        }
        if ((requestTimeout = msgContext.getTimeout()) <= 0) {
            requestTimeout = 300000;
        }
        if (requestTimeout > 0 && (connData.timeToLive <= 0 || connData.timeToLive > requestTimeout)) {
            connData.timeToLive = requestTimeout;
        }
        if (connData.permanentReplyToQueueJNDI != null && (prq = (String)msgContext.getProperty("JMSReplyQueueJndiName")) != null) {
            connData.permanentReplyToQueueJNDI = prq;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Permanent reply queue (stub or client-binding) JNDI name property is " + connData.permanentReplyToQueueJNDI);
        }
        HashMap requestTransportHeaders = null;
        requestTransportHeaders = (HashMap)msgContext.getProperty("com.ibm.websphere.webservices.requestTransportProperties");
        HashMap responseTransportHeaders = null;
        responseTransportHeaders = (HashMap)msgContext.getProperty("com.ibm.websphere.webservices.responseTransportProperties");
        QueueSender queueSender = null;
        TopicPublisher topicPublisher = null;
        BytesMessage jmsMessage = null;
        ByteArrayOutputStream strm = null;
        String reqContentType = null;
        boolean caughtException = false;
        try {
            try {
                switch (connData.messageMode) {
                    case 1: {
                        this.getQueueConnectionAndSession(connData, user, password, transactionalSession);
                        queueSender = connData.queueSession.createSender(connData.queue);
                        reqContentType = reqMessage.getContentType(msgContext.getSOAPConstants());
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Content-Type from Queue Request Message is " + reqContentType);
                        }
                        jmsMessage = connData.queueSession.createBytesMessage();
                        strm = new ByteArrayOutputStream();
                        reqMessage.writeTo(strm, reqContentType);
                        reqMessage.removeAllAttachments();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "About to write the following Bytes request message to the JMS message:\n" + strm.toString());
                        }
                        jmsMessage.writeBytes(strm.toByteArray());
                        if (MessageTrace.isTraceEnabled()) {
                            MessageTrace.log(MessageTrace.OUTBOUND_JMS_REQUEST, reqContentType, strm.toByteArray());
                        }
                        jmsMessage.setStringProperty("contentType", reqContentType);
                        jmsMessage.setStringProperty("targetService", connData.targetService);
                        jmsMessage.setStringProperty("endpointURL", targetURL.toString());
                        jmsMessage.setStringProperty("transportVersion", "1");
                        if (!isTwoWay && connData.enableTranOneWay) {
                            jmsMessage.setStringProperty("enableTransaction", "true");
                        }
                        this.setSoapAction(jmsMessage, msgContext, "soapAction");
                        if (requestTransportHeaders != null) {
                            this.setRequestUserTransportProperties(jmsMessage, requestTransportHeaders);
                        }
                        Queue replyQueue = null;
                        QueueReceiver queueRcvr = null;
                        String replySelectorID = null;
                        String pr2q = null;
                        if (isTwoWay) {
                            pr2q = this.getPermanentReplyQueueJNDI(connData.permanentReplyToQueueJNDI);
                            if (pr2q != null) {
                                connData.permanentReplyToQueueJNDI = pr2q;
                                try {
                                    replyQueue = (Queue)connData.jndiContext.lookup(connData.permanentReplyToQueueJNDI);
                                }
                                catch (NamingException ne) {
                                    FFDCFilter.processException((Throwable)ne, "com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperIBM.sendMessage", "830", this);
                                    Tr.error(_tc, "JMS.JNDIError02", ne.toString());
                                    throw new WebServicesFault("JMS", Messages.getMessage("JMS.JNDIError02", ne.toString()), null, null);
                                }
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Using permanent reply-to queue " + pr2q);
                                }
                            } else {
                                replyQueue = connData.queueSession.createTemporaryQueue();
                            }
                            jmsMessage.setJMSReplyTo(replyQueue);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Set the reply-to queue and started the queue connection in preparation for the reply message.");
                            }
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "About to send message:\n" + jmsMessage.toString() + "\n" + "Message send options:\n" + "deliveryMode=" + connData.deliveryMode + ", priority=" + connData.priority + ", timeToLive=" + connData.timeToLive);
                        }
                        queueSender.send(jmsMessage, connData.deliveryMode, connData.priority, connData.timeToLive);
                        String requestMessageId = jmsMessage.getJMSMessageID();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Sent the message, messageID=" + requestMessageId);
                        }
                        if (transactionalSession) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "About to commit QueueSession (send)");
                            }
                            connData.queueSession.commit();
                        }
                        if (replyQueue != null) {
                            if (pr2q != null) {
                                replySelectorID = "JMSCorrelationID = '" + requestMessageId + "'";
                            }
                            queueRcvr = connData.queueSession.createReceiver(replyQueue, replySelectorID);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Created the queue receiver with selector " + replySelectorID);
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "About to receive response message, requestTimeout=" + requestTimeout + "ms.");
                            }
                            javax.jms.Message replyMsg = queueRcvr.receive(requestTimeout);
                            if (_tc.isDebugEnabled()) {
                                if (replyMsg != null) {
                                    Tr.debug(_tc, "Received JMS response message:\n" + replyMsg.toString());
                                } else {
                                    Tr.debug(_tc, "Received null response message :-(");
                                }
                            }
                            if (replyMsg == null) {
                                Tr.error(_tc, "JMS.RequestTimeOut");
                                throw new WebServicesFault(Messages.getMessage("JMS.RequestTimeOut"));
                            }
                            if (transactionalSession) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "About to commit QueueSession (receive)");
                                }
                                connData.queueSession.commit();
                            }
                            String replyCorrelationId = replyMsg.getJMSCorrelationID();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Reply message contains correlation id: " + replyCorrelationId);
                            }
                            if (replyCorrelationId == null || !replyCorrelationId.equals(requestMessageId)) {
                                Tr.error(_tc, "JMS.MismatchedReply");
                                throw new WebServicesFault(Messages.getMessage("JMS.MismatchedReply"));
                            }
                            String contentType = replyMsg.getStringProperty("contentType");
                            contentType = contentType == null ? null : contentType.trim();
                            Message responseMsg = null;
                            if (replyMsg instanceof BytesMessage) {
                                ByteArrayOutputStream ostrm = new ByteArrayOutputStream();
                                byte[] chunk = new byte[4096];
                                int numBytes = 1;
                                while (numBytes > 0) {
                                    numBytes = ((BytesMessage)replyMsg).readBytes(chunk);
                                    if (numBytes <= 0) continue;
                                    ostrm.write(chunk, 0, numBytes);
                                }
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Extracted the following SOAP Bytes message from the JMS response message:\n" + ostrm.toString());
                                }
                                ByteArrayInputStream istrm = new ByteArrayInputStream(ostrm.toByteArray());
                                responseMsg = new Message((Object)istrm, contentType, null);
                                msgContext.setResponseMessage(responseMsg);
                            } else {
                                if (!(replyMsg instanceof TextMessage)) {
                                    Tr.error(_tc, "JMS.InvalidReplyMsgType");
                                    throw new WebServicesFault(Messages.getMessage("JMS.InvalidReplyMsgType"));
                                }
                                String replyString = ((TextMessage)replyMsg).getText();
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Extracted the following SOAP Text message from the JMS response message:\n" + replyString);
                                }
                                responseMsg = new Message((Object)replyString, contentType, null);
                                msgContext.setResponseMessage(responseMsg);
                            }
                            if (responseTransportHeaders == null) break;
                            this.getResponseUserTransportProperties(responseTransportHeaders, replyMsg);
                        }
                        break;
                    }
                    case 2: {
                        this.getTopicConnectionAndSession(connData, user, password, transactionalSession);
                        topicPublisher = connData.topicSession.createPublisher(connData.topic);
                        reqContentType = reqMessage.getContentType(msgContext.getSOAPConstants());
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Content-Type from Topic Request Message is " + reqContentType);
                        }
                        jmsMessage = connData.topicSession.createBytesMessage();
                        if (connData.enableTranOneWay) {
                            jmsMessage.setStringProperty("enableTransaction", "true");
                        }
                        this.setSoapAction(jmsMessage, msgContext, "soapAction");
                        strm = new ByteArrayOutputStream();
                        reqMessage.writeTo(strm, reqContentType);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "About to write the following Bytes request message to the JMS message:\n" + strm.toString());
                        }
                        jmsMessage.writeBytes(strm.toByteArray());
                        jmsMessage.setStringProperty("contentType", reqContentType);
                        jmsMessage.setStringProperty("targetService", connData.targetService);
                        jmsMessage.setStringProperty("endpointURL", targetURL.toString());
                        jmsMessage.setStringProperty("transportVersion", "1");
                        if (requestTransportHeaders != null) {
                            this.setRequestUserTransportProperties(jmsMessage, requestTransportHeaders);
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "About to publish message:\n" + jmsMessage.toString());
                        }
                        topicPublisher.publish(jmsMessage);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Published the message.");
                        }
                        if (transactionalSession) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "About to commit TopicSession (publish)");
                            }
                            connData.topicSession.commit();
                        }
                        break;
                    }
                }
            }
            catch (JMSException je) {
                StringBuffer exceptionInfo;
                block87: {
                    caughtException = true;
                    FFDCFilter.processException((Throwable)je, "com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperIBM.sendMessage", "968", this);
                    exceptionInfo = new StringBuffer();
                    exceptionInfo.append(Messages.getMessage("JMS.JMSError01", je.toString()));
                    Exception e = je.getLinkedException();
                    while (e != null) {
                        exceptionInfo.append("\n");
                        exceptionInfo.append(Messages.getMessage("JMS.JMSError02", e.toString()));
                        if (e instanceof JMSException) {
                            e = ((JMSException)e).getLinkedException();
                            continue;
                        }
                        e = null;
                    }
                    if (transactionalSession) {
                        try {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Doing rollback of session due to JMSException.");
                            }
                            if (connData.queueSession != null) {
                                connData.queueSession.rollback();
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Rolled back queue session.");
                                }
                            }
                            if (connData.topicSession == null) break block87;
                            connData.topicSession.rollback();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Rolled back topic session.");
                            }
                        }
                        catch (Throwable t) {
                            if (!_tc.isDebugEnabled()) break block87;
                            Tr.debug(_tc, "Session rollback failed with exception: " + t.toString());
                        }
                    }
                }
                Tr.error(_tc, exceptionInfo.toString());
                if (!_tc.isDebugEnabled()) throw new WebServicesFault("JMS", exceptionInfo.toString(), null, null);
                Tr.debug(_tc, exceptionInfo.toString());
                throw new WebServicesFault("JMS", exceptionInfo.toString(), null, null);
            }
            {
            }
            Object var37_43 = null;
            if (tranSuspender != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Initiating transaction resumption...");
                }
                tranSuspender.resumeTransaction();
            }
            this.cleanUp(connData);
            if (!_tc.isEntryEnabled()) return;
            Tr.exit(_tc, "JMSSenderHelperIBM.sendMessage()");
            return;
        }
        catch (Throwable throwable) {
            Object var37_44 = null;
            if (tranSuspender != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Initiating transaction resumption...");
                }
                tranSuspender.resumeTransaction();
            }
            this.cleanUp(connData);
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "JMSSenderHelperIBM.sendMessage()");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getQueueConnectionAndSession(JMSConnectionData cd, String user, String password, boolean transactionalSession) throws JMSException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSSenderHelperIBM.getQueueConnectionAndSession()");
        }
        cd.queueConnection = null;
        cd.queueSession = null;
        if (!this.connectionManagementIsDesired()) {
            this.createQueueConnection(cd, user, password);
        } else {
            JMSConnectionCache jMSConnectionCache = this.activeConnections;
            synchronized (jMSConnectionCache) {
                JMSCacheData cData;
                String key = this.getKey(cd, user);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Looking for Queue connection in cache, key=[" + key + "].");
                }
                if ((cData = this.activeConnections.get(key)) != null) {
                    cd.queueConnection = (QueueConnection)cData.getConnection();
                }
                if (cd.queueConnection != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Queue connection found: " + cd.queueConnection.toString());
                    }
                    try {
                        cd.queueSession = cd.queueConnection.createQueueSession(transactionalSession, 1);
                    }
                    catch (JMSException badQ) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "createQueueSession threw JMSException, must create fresh QueueConnection.");
                        }
                        cd.queueConnection.close();
                        cd.queueConnection = null;
                        cd.queueSession = null;
                    }
                }
                if (cd.queueConnection == null) {
                    this.createQueueConnection(cd, user, password);
                    this.activeConnections.put(key, cd.queueConnection);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Queue connection added to cache, key=[" + key + "].");
                        Tr.debug(_tc, "Queue connection added: " + cd.queueConnection.toString());
                    }
                }
            }
        }
        if (cd.queueSession == null) {
            cd.queueSession = cd.queueConnection.createQueueSession(transactionalSession, 1);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "JMSSenderHelperIBM.getQueueConnectionAndSession()");
        }
    }

    private void createQueueConnection(JMSConnectionData cd, String user, String password) throws JMSException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSSenderHelperIBM.createQueueConnection()");
        }
        if (user != null && user.length() != 0 && password != null && password.length() != 0) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Creating queue connection with user [" + user + "] and password.");
            }
            cd.queueConnection = cd.queueConnectionFactory.createQueueConnection(user, password);
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Creating queue connection without user/password.");
            }
            cd.queueConnection = cd.queueConnectionFactory.createQueueConnection();
        }
        if (cd.queueConnection != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Starting queue connection...");
            }
            cd.queueConnection.start();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "JMSSenderHelperIBM.createQueueConnection()");
        }
    }

    private void createTopicConnection(JMSConnectionData cd, String user, String password) throws JMSException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSSenderHelperIBM.createTopicConnection()");
        }
        if (user != null && user.length() != 0 && password != null && password.length() != 0) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Creating topic connection with user [" + user + "] and password.");
            }
            cd.topicConnection = cd.topicConnectionFactory.createTopicConnection(user, password);
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Creating topic connection without user/password.");
            }
            cd.topicConnection = cd.topicConnectionFactory.createTopicConnection();
        }
        if (cd.topicConnection != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Starting topic connection...");
            }
            cd.topicConnection.start();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "JMSSenderHelperIBM.createTopicConnection()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTopicConnectionAndSession(JMSConnectionData cd, String user, String password, boolean transactionalSession) throws JMSException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSSenderHelperIBM.getTopicConnectionAndSession()");
        }
        cd.topicConnection = null;
        cd.topicSession = null;
        if (!this.connectionManagementIsDesired()) {
            this.createTopicConnection(cd, user, password);
        } else {
            JMSConnectionCache jMSConnectionCache = this.activeConnections;
            synchronized (jMSConnectionCache) {
                JMSCacheData cData;
                String key = this.getKey(cd, user);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Looking for Topic connection in cache, key=[" + key + "].");
                }
                if ((cData = this.activeConnections.get(key)) != null) {
                    cd.topicConnection = (TopicConnection)cData.getConnection();
                }
                if (cd.topicConnection != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Topic connection found: " + cd.topicConnection.toString());
                    }
                    try {
                        cd.topicSession = cd.topicConnection.createTopicSession(transactionalSession, 1);
                    }
                    catch (JMSException e) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "createTopicSession threw JMSException, must create fresh TopicConnection.");
                        }
                        cd.topicConnection.close();
                        cd.topicConnection = null;
                        cd.topicSession = null;
                    }
                }
                if (cd.topicConnection == null) {
                    this.createTopicConnection(cd, user, password);
                    this.activeConnections.put(key, cd.topicConnection);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Topic connection added to cache, key=[" + this.getKey(cd, user) + "].");
                    }
                }
            }
        }
        if (cd.topicSession == null) {
            cd.topicSession = cd.topicConnection.createTopicSession(transactionalSession, 1);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "JMSSenderHelperIBM.getTopicConnectionAndSession()");
        }
    }
}

