/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.WebServicesProperties;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.server.ServerEngine;
import com.ibm.ws.webservices.engine.transport.http.WebServicesServlet;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;

public class WebServicesServletBase
extends HttpServlet {
    protected ServerEngine webServicesServer = null;
    private static Log log = LogFactory.getLog(WebServicesServlet.class.getName());
    private static boolean isDebug = false;
    private static int loadCounter = 0;
    private static Object loadCounterLock = new Object();
    protected static final String ATTR_WEBSERVICES_ENGINE = "WebServicesEngine";
    private String webInfPath = null;
    private String homeDir = null;
    private boolean isDevelopment;
    private static final String INIT_PROPERTY_DEVELOPMENT_SYSTEM = "webservices.development.system";

    public void init() throws ServletException {
        ServletContext context = this.getServletConfig().getServletContext();
        this.webInfPath = context.getRealPath("/WEB-INF");
        this.homeDir = context.getRealPath("/");
        isDebug = log.isDebugEnabled();
        if (log.isDebugEnabled()) {
            log.debug("In WebServicesServletBase init");
        }
        this.isDevelopment = JavaUtils.isTrueExplicitly(this.getOption(context, INIT_PROPERTY_DEVELOPMENT_SYSTEM, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        super.destroy();
        if (this.webServicesServer != null) {
            ServerEngine serverEngine = this.webServicesServer;
            synchronized (serverEngine) {
                if (this.webServicesServer != null) {
                    this.webServicesServer.destroy();
                    this.webServicesServer = null;
                    WebServicesServletBase.storeEngine(this.getServletContext(), null);
                }
            }
        }
    }

    public ServerEngine getEngine() throws WebServicesFault {
        if (this.webServicesServer == null) {
            this.webServicesServer = WebServicesServletBase.getEngine(this);
        }
        return this.webServicesServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerEngine getEngine(HttpServlet servlet) throws WebServicesFault {
        ServletContext context;
        ServerEngine engine2 = null;
        if (isDebug) {
            log.debug("Enter: getEngine()");
        }
        ServletContext servletContext = context = servlet.getServletContext();
        synchronized (servletContext) {
            engine2 = WebServicesServletBase.retrieveEngine(context);
            if (engine2 == null) {
                Map environment = WebServicesServletBase.getEngineEnvironment(servlet);
                engine2 = ServerEngine.getServer(context, environment);
                WebServicesServletBase.storeEngine(context, engine2);
            }
        }
        if (isDebug) {
            log.debug("Exit: getEngine()");
        }
        return engine2;
    }

    private static void storeEngine(ServletContext context, ServerEngine engine2) {
        context.setAttribute(ATTR_WEBSERVICES_ENGINE, engine2);
    }

    private static ServerEngine retrieveEngine(ServletContext context) {
        Object contextObject = context.getAttribute(ATTR_WEBSERVICES_ENGINE);
        if (contextObject instanceof ServerEngine) {
            return (ServerEngine)contextObject;
        }
        return null;
    }

    private static Map getEngineEnvironment(HttpServlet servlet) {
        HashMap<String, Object> environment = new HashMap<String, Object>();
        String attdir = servlet.getInitParameter("webservices.attachments.Directory");
        if (attdir != null) {
            environment.put("webservices.attachments.Directory", attdir);
        }
        ServletContext context = servlet.getServletContext();
        environment.put("servletContext", context);
        String webInfPath = context.getRealPath("/WEB-INF");
        if (webInfPath != null) {
            environment.put("servlet.realpath", webInfPath + File.separator + "attachments");
        }
        return environment;
    }

    public static int getLoadCounter() {
        return loadCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void incLockCounter() {
        Object object = loadCounterLock;
        synchronized (object) {
            ++loadCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void decLockCounter() {
        Object object = loadCounterLock;
        synchronized (object) {
            --loadCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        WebServicesServletBase.incLockCounter();
        try {
            super.service(req, resp);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            WebServicesServletBase.decLockCounter();
            throw throwable;
        }
        WebServicesServletBase.decLockCounter();
    }

    protected String getWebappBase(HttpServletRequest request) {
        StringBuffer baseURL = new StringBuffer(128);
        baseURL.append(request.getScheme());
        baseURL.append("://");
        baseURL.append(request.getServerName());
        if (request.getServerPort() != 80) {
            baseURL.append(":");
            baseURL.append(request.getServerPort());
        }
        baseURL.append(request.getContextPath());
        return baseURL.toString();
    }

    public ServletContext getServletContext() {
        return this.getServletConfig().getServletContext();
    }

    protected String getWebInfPath() {
        return this.webInfPath;
    }

    protected String getHomeDir() {
        return this.homeDir;
    }

    protected String getOption(ServletContext context, String param, String dephault) {
        String value2 = WebServicesProperties.getProperty(param);
        if (value2 == null) {
            value2 = this.getInitParameter(param);
        }
        if (value2 == null) {
            value2 = context.getInitParameter(param);
        }
        return value2 != null ? value2 : dephault;
    }

    public boolean isDevelopment() {
        return this.isDevelopment;
    }
}

