/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ws.webservices.engine.session.Session;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.xml.rpc.server.ServiceLifecycle;

public class WebServicesHttpSession
implements Session {
    private static final String SESSION_LISTENER_KEY = "com.ibm.ws.webservices.engine.transport.http.WebServicesHttpSession";
    private HttpSession rep;
    private HttpServletRequest req;

    public WebServicesHttpSession(HttpServletRequest realRequest) {
        this.req = realRequest;
    }

    protected void ensureSession() {
        if (this.rep == null) {
            this.rep = this.req.getSession();
            if (this.rep.getAttribute(SESSION_LISTENER_KEY) == null) {
                this.rep.setAttribute(SESSION_LISTENER_KEY, new SessionListener());
            }
        }
    }

    public Object get(String key) {
        this.ensureSession();
        return this.rep.getAttribute(key);
    }

    public void set(String key, Object value2) {
        this.ensureSession();
        this.rep.setAttribute(key, value2);
    }

    public void remove(String key) {
        this.ensureSession();
        this.rep.removeAttribute(key);
    }

    public Enumeration getKeys() {
        this.ensureSession();
        return this.rep.getAttributeNames();
    }

    public void setTimeout(int timeout) {
        this.ensureSession();
        this.rep.setMaxInactiveInterval(timeout);
    }

    public int getTimeout() {
        this.ensureSession();
        return this.rep.getMaxInactiveInterval();
    }

    public void touch() {
    }

    private class SessionListener
    implements HttpSessionBindingListener {
        private SessionListener() {
        }

        public void valueBound(HttpSessionBindingEvent event) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void valueUnbound(HttpSessionBindingEvent event) {
            Enumeration keys = WebServicesHttpSession.this.getKeys();
            if (keys != null) {
                WebServicesHttpSession webServicesHttpSession = WebServicesHttpSession.this;
                synchronized (webServicesHttpSession) {
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        Object obj = WebServicesHttpSession.this.get(key);
                        if (obj == null || !(obj instanceof ServiceLifecycle)) continue;
                        ((ServiceLifecycle)obj).destroy();
                        WebServicesHttpSession.this.remove(key);
                    }
                }
            }
        }
    }
}

