/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.engine.session.SessionContext;
import com.ibm.ws.webservices.engine.transport.http.CookieValueList;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class HTTPCookieManager
implements SessionContext {
    private static final TraceComponent _tc = Tr.register(HTTPCookieManager.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private HashMap chM = null;
    private String cookie_name = null;
    private String requestPath = null;
    private CookieValueList cvs = null;

    public HTTPCookieManager() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HTTPCookieManager ctor()");
        }
        this.chM = new HashMap();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HTTPCookieManager ctor() this : " + this);
        }
    }

    public static boolean newCookieHandling() {
        boolean result = false;
        String sysProp = System.getProperty("UseNewCookieHandling");
        if (sysProp != null) {
            result = Boolean.valueOf(sysProp);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "System property value of UseNewCookieHandling: " + sysProp);
            }
        }
        return result;
    }

    public void setCookies(String cookie, String cookie2, String reqPath) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setCookies this : " + this);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, HTTPConstants.HEADER_SET_COOKIE + " : " + cookie + "  " + HTTPConstants.HEADER_SET_COOKIE2 + " : " + cookie2);
        }
        if (reqPath != null) {
            this.requestPath = reqPath;
        }
        if (JavaUtils.hasValue(cookie)) {
            this.cookie_name = HTTPConstants.HEADER_SET_COOKIE;
            this.parseCookieandStore(cookie);
        }
        if (JavaUtils.hasValue(cookie2)) {
            this.cookie_name = HTTPConstants.HEADER_SET_COOKIE2;
            this.parseCookieandStore(cookie2);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Stored cookie LIST " + this.printCookieSet());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setCookies");
        }
    }

    public String getCookie(String path, String domain, int port2, boolean secure) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getCookie() this : " + this);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Stored cookie LIST " + this.printCookieSet());
        }
        StringBuffer token = new StringBuffer();
        Set HostKeys = this.chM.keySet();
        Iterator It = HostKeys.iterator();
        token.append("$Version=\"1\";");
        while (It.hasNext()) {
            String HostNow = (String)It.next();
            CookieValueList cvs = (CookieValueList)this.chM.get(HostNow);
            token.append(cvs.getList(path, domain, port2, secure));
        }
        String result = token.toString().substring(0, token.length() - 1);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getCookie() : " + result);
        }
        return result;
    }

    public String printCookieSet() {
        StringBuffer token = new StringBuffer();
        Set HostKeys = this.chM.keySet();
        Iterator It = HostKeys.iterator();
        while (It.hasNext()) {
            String HostNow = (String)It.next();
            CookieValueList cvs = (CookieValueList)this.chM.get(HostNow);
            token.append(cvs.printList());
        }
        if (token.toString() == null || token.toString().equals("")) {
            return "";
        }
        String result = token.toString().substring(0, token.length() - 1);
        return result;
    }

    protected List splitMultipleCookies(String header2) {
        ArrayList<String> cookies = new ArrayList<String>();
        int Count = 0;
        int b = 0;
        for (int a = 0; a < header2.length(); ++a) {
            char ch = header2.charAt(a);
            if (ch == '\"') {
                ++Count;
            }
            if (ch != ',' || Count % 2 != 0) continue;
            cookies.add(header2.substring(b, a));
            b = a + 1;
        }
        cookies.add(header2.substring(b));
        return cookies;
    }

    protected void parseCookieandStore(String cookie) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "parseCookieandStore() this : " + this);
        }
        if (cookie != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "cookie Received : " + cookie);
            }
            List cookies = this.splitMultipleCookies(cookie);
            String name2 = null;
            for (int i = 0; i < cookies.size(); ++i) {
                name2 = (String)cookies.get(i);
                this.cvs = null;
                int tokenValueSeperatorIndex = name2.indexOf(HTTPConstants.ATTR_TOKEN_SEPARATOR);
                String name1 = name2.substring(0, tokenValueSeperatorIndex).trim();
                String token = name2.substring(tokenValueSeperatorIndex + 1).trim();
                if (name1 == null) continue;
                int nameValueSeperatorIndex = name1.indexOf(HTTPConstants.ATTR_VALUE_SEPARATOR);
                String prop = name1.substring(0, nameValueSeperatorIndex).trim();
                String value2 = name1.substring(nameValueSeperatorIndex + 1).trim();
                if (prop == null) continue;
                if (this.chM != null) {
                    Set HostKeys = this.chM.keySet();
                    Iterator It = HostKeys.iterator();
                    while (It.hasNext()) {
                        String HostNow = (String)It.next();
                        if (prop.compareTo(HostNow) != 0) continue;
                        this.cvs = (CookieValueList)this.chM.get(HostNow);
                        break;
                    }
                }
                if (this.cvs == null) {
                    this.cvs = new CookieValueList(this.cookie_name);
                }
                this.cvs.setCookieNameValuePath(prop, value2, this.requestPath);
                this.cvs.setCookie(token);
                this.chM.put(prop, this.cvs);
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Stored cookie");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "parseCookieandStore()");
        }
    }
}

