/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers;

import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.security.AuthenticatedUser;
import com.ibm.ws.webservices.engine.security.SecurityProvider;
import com.ibm.ws.webservices.engine.security.simple.SimpleSecurityProvider;
import org.apache.commons.logging.Log;

public class SimpleAuthenticationHandler
extends BasicHandler {
    protected static Log log = LogFactory.getLog(SimpleAuthenticationHandler.class.getName());

    public void invoke(MessageContext msgContext) throws WebServicesFault {
        SecurityProvider provider;
        if (log.isDebugEnabled()) {
            log.debug("Enter: SimpleAuthenticationHandler::invoke");
        }
        if ((provider = (SecurityProvider)msgContext.getProperty("securityProvider")) == null) {
            provider = new SimpleSecurityProvider();
            msgContext.setProperty("securityProvider", provider);
        }
        if (provider != null) {
            String userID = msgContext.getUsername();
            if (userID == null || userID.equals("")) {
                throw new WebServicesFault("Server.Unauthenticated", Messages.getMessage("cantAuth00", userID), null, null);
            }
            String passwd = msgContext.getPassword();
            AuthenticatedUser authUser = provider.authenticate(msgContext);
            if (authUser == null) {
                throw new WebServicesFault("Server.Unauthenticated", Messages.getMessage("cantAuth01", userID), null, null);
            }
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("auth00", userID));
            }
            msgContext.setProperty(MessageContext.AUTHUSER, authUser);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SimpleAuthenticationHandler::invoke");
        }
    }
}

