/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.description.TypeDesc;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.ser.AttributeDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.CalendarDeserializer;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SimpleDeserializer
extends AttributeDeserializer {
    String valString = null;
    StringBuffer valBuffer = null;
    private Constructor constructor = null;

    public SimpleDeserializer(Class javaType, QName xmlType) {
        super(javaType, xmlType);
    }

    public SimpleDeserializer(Class javaType, QName xmlType, TypeDesc typeDesc) {
        super(javaType, xmlType);
    }

    public boolean recycle() {
        boolean recycled = super.recycle();
        if (recycled) {
            this.valString = null;
            this.valBuffer = null;
        }
        return recycled;
    }

    public void removeValueTargets() {
        if (this.targets != null) {
            this.targets.clear();
        }
    }

    public void setConstructor(Constructor c) {
        this.constructor = c;
    }

    public DEventProcessor onStartChild(String namespace, String localName, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        throw new SAXException(Messages.getMessage("cantHandle00", "SimpleDeserializer"));
    }

    public void characters(String value2) throws SAXException {
        if (this.valString != null) {
            if (this.valBuffer == null) {
                this.valBuffer = new StringBuffer();
                this.valBuffer.append(this.valString);
            }
            this.valBuffer.append(value2);
        } else {
            this.valString = value2;
        }
    }

    public void onEndElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        if (this.isNil) {
            this.value = null;
            return;
        }
        try {
            if (this.valBuffer != null) {
                this.value = this.makeValue(this.valBuffer.toString());
            } else {
                if (this.valString == null) {
                    this.valString = "";
                }
                this.value = this.makeValue(this.valString);
            }
        }
        catch (SAXException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.onEndElement", "225", this);
            throw e;
        }
        catch (InvocationTargetException ite) {
            FFDCFilter.processException((Throwable)ite, "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.onEndElement", "211", this);
            Throwable realException = ite.getTargetException();
            if (realException instanceof Exception) {
                throw new SAXException((Exception)realException);
            }
            throw new SAXException(ite.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.onEndElement", "218", this);
            throw new SAXException(e);
        }
        super.onEndElement(namespace, localName, context);
    }

    public static Object convert(String source, Class javaType) throws SAXException {
        if (javaType == String.class) {
            return source;
        }
        if (javaType == Integer.TYPE || javaType == Integer.class) {
            return SimpleDeserializer.parseInteger(source);
        }
        if (javaType == Boolean.TYPE || javaType == Boolean.class) {
            try {
                return SimpleDeserializer.parseBoolean(source);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.convert", "265");
                throw new SAXException(Messages.getMessage("badBool00", source));
            }
        }
        if (javaType == Float.TYPE || javaType == Float.class) {
            return SimpleDeserializer.parseFloat(source);
        }
        if (javaType == Double.TYPE || javaType == Double.class) {
            return SimpleDeserializer.parseDouble(source);
        }
        if (javaType == Short.TYPE || javaType == Short.class) {
            return SimpleDeserializer.parseShort(source);
        }
        if (javaType == Long.TYPE || javaType == Long.class) {
            return SimpleDeserializer.parseLong(source);
        }
        if (javaType == Byte.TYPE || javaType == Byte.class) {
            return SimpleDeserializer.parseByte(source);
        }
        if (javaType == Character.TYPE || javaType == Character.class) {
            return SimpleDeserializer.parseCharacter(source);
        }
        return null;
    }

    protected Object makeValue(String source) throws Exception {
        Object ret = SimpleDeserializer.convert(source, this.javaType);
        if (ret == null) {
            return this.constructor.newInstance(source);
        }
        return ret;
    }

    public void onStartElement(String namespace, String localName, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        this.processAttributes(attributes, mappingScope, context, true);
    }

    public static boolean parseboolean(String source) {
        if (source == "1" || source == "true") {
            return true;
        }
        if (source == "0" || source == "false") {
            return false;
        }
        String trimmed = source.trim();
        if (trimmed.length() == 1) {
            switch (trimmed.charAt(0)) {
                case '0': {
                    return false;
                }
                case '1': {
                    return true;
                }
            }
        } else {
            if (trimmed.equalsIgnoreCase("true")) {
                return true;
            }
            if (trimmed.equalsIgnoreCase("false")) {
                return false;
            }
        }
        throw new NumberFormatException("invalid boolean");
    }

    public static Boolean parseBoolean(String source) {
        if (source == "1" || source == "true") {
            return Boolean.TRUE;
        }
        if (source == "0" || source == "false") {
            return Boolean.FALSE;
        }
        String trimmed = source.trim();
        if (trimmed.length() == 1) {
            switch (trimmed.charAt(0)) {
                case '0': {
                    return Boolean.FALSE;
                }
                case '1': {
                    return Boolean.TRUE;
                }
            }
        } else {
            if (trimmed.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (trimmed.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
        }
        throw new NumberFormatException("invalid boolean");
    }

    public static byte parsebyte(String source) {
        return Byte.parseByte(source.trim());
    }

    public static Byte parseByte(String source) {
        return new Byte(source.trim());
    }

    public static char parsechar(String source) {
        if (source.length() > 0) {
            return source.charAt(0);
        }
        return '\u0000';
    }

    public static Character parseCharacter(String source) {
        if (source.length() > 0) {
            return new Character(source.charAt(0));
        }
        return new Character('\u0000');
    }

    public static short parseshort(String source) {
        return Short.parseShort(source.trim());
    }

    public static Short parseShort(String source) {
        return new Short(source.trim());
    }

    public static int parseint(String source) {
        return Integer.parseInt(source.trim());
    }

    public static Integer parseInteger(String source) {
        return new Integer(source.trim());
    }

    public static long parselong(String source) {
        return Long.parseLong(source.trim());
    }

    public static Long parseLong(String source) {
        return new Long(source.trim());
    }

    public static float parsefloat(String source) {
        if ((source = source.trim()).equals("NaN")) {
            return Float.NaN;
        }
        if (source.equals("INF")) {
            return Float.POSITIVE_INFINITY;
        }
        if (source.equals("-INF")) {
            return Float.NEGATIVE_INFINITY;
        }
        return Float.parseFloat(source);
    }

    public static Float parseFloat(String source) {
        if ((source = source.trim()).equals("NaN")) {
            return new Float(Float.NaN);
        }
        if (source.equals("INF")) {
            return new Float(Float.POSITIVE_INFINITY);
        }
        if (source.equals("-INF")) {
            return new Float(Float.NEGATIVE_INFINITY);
        }
        return new Float(Float.parseFloat(source));
    }

    public static double parsedouble(String source) {
        if ((source = source.trim()).equals("NaN")) {
            return Double.NaN;
        }
        if (source.equals("INF")) {
            return Double.POSITIVE_INFINITY;
        }
        if (source.equals("-INF")) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.parseDouble(source);
    }

    public static Double parseDouble(String source) {
        if ((source = source.trim()).equals("NaN")) {
            return new Double(Double.NaN);
        }
        if (source.equals("INF")) {
            return new Double(Double.POSITIVE_INFINITY);
        }
        if (source.equals("-INF")) {
            return new Double(Double.NEGATIVE_INFINITY);
        }
        return new Double(source);
    }

    public static Date parseDateTimeToDate(String source) {
        return SimpleDeserializer.parseDateTimeToCalendar(source).getTime();
    }

    public static Calendar parseDateTimeToCalendar(String source) {
        return (Calendar)CalendarDeserializer.makeDateTimeValue(source);
    }

    public static Calendar parseDateToCalendar(String source) {
        return (Calendar)CalendarDeserializer.makeDateValue(source);
    }

    public static Calendar parseTimeToCalendar(String source) {
        return (Calendar)CalendarDeserializer.makeTimeValue(source);
    }

    public static BigInteger parseBigInteger(String source) {
        return new BigInteger(source);
    }

    public static BigDecimal parseBigDecimal(String source) {
        return new BigDecimal(source);
    }

    public String getBuildNumber() {
        return this.beanDesc == null ? null : this.beanDesc.getBuildNumber();
    }

    public void relinquish() {
        this.valString = null;
        this.valBuffer = null;
        super.relinquish();
    }
}

