/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class ListDeserializer
extends SimpleDeserializer {
    private QName componentTypeQName = null;
    private Class javaCompType = null;
    private Deserializer dSer = null;
    private DeserializationContext context = null;

    public ListDeserializer(Class javaType, QName xmlType) {
        this(javaType, xmlType, (QName)null, (QName)null);
    }

    public ListDeserializer(Class javaType, QName xmlType, QName compQName, QName componentTypeQName) {
        super(javaType, xmlType);
        this.componentTypeQName = componentTypeQName;
    }

    public void onStartElement(String namespace, String localName, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        this.context = context;
        this.initialize();
        super.onStartElement(namespace, localName, prefixedName, attributes, mappingScope, context);
        this.dSer.onStartElement(namespace, localName, prefixedName, attributes, mappingScope, context);
    }

    public Object makeValue(String source) throws Exception {
        if (this.javaType.isArray()) {
            return this.makeArrayValue(source);
        }
        return this.makeListValue(source);
    }

    public final Object makeArrayValue(String source) throws Exception {
        StringTokenizer st = new StringTokenizer(source);
        int size = st.countTokens();
        Object arrayValue = Array.newInstance(this.javaCompType, size);
        for (int i = 0; i < size; ++i) {
            Array.set(arrayValue, i, ((SimpleDeserializer)this.dSer).makeValue(st.nextToken()));
        }
        return arrayValue;
    }

    public final Object makeListValue(String source) throws Exception {
        StringTokenizer st = new StringTokenizer(source);
        Collection listValue = (Collection)this.javaType.newInstance();
        while (st.hasMoreTokens()) {
            listValue.add(((SimpleDeserializer)this.dSer).makeValue(st.nextToken()));
        }
        return listValue;
    }

    private void initialize() throws SAXException {
        Class<?> clazz = this.javaCompType = this.javaType.isArray() ? this.javaType.getComponentType() : this.javaType;
        if (this.componentTypeQName != null) {
            this.dSer = this.context.getDeserializer(this.javaCompType, this.componentTypeQName);
        }
        if (this.dSer == null) {
            throw new SAXException(Messages.getMessage("noDeser00", this.componentTypeQName != null ? this.componentTypeQName.toString() : null));
        }
        if (!(this.dSer instanceof SimpleDeserializer)) {
            throw new SAXException(Messages.getMessage("ListCompNotSimpleType00", this.javaCompType.toString()));
        }
    }
}

