/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding;

import [Ljava.lang.Object;;
import [Ljava.lang.String;;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DefaultTypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.DeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.SerializerFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMappingBase;
import com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.SOAPElementDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.SOAPElementSerializerFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.SOAPElement;
import org.apache.commons.logging.Log;

public class TypeMappingImpl
extends TypeMappingBase {
    protected static Log log = LogFactory.getLog(TypeMappingImpl.class.getName());
    private Hashtable qName2Pair = new Hashtable();
    private Hashtable class2Pair = new Hashtable();
    private Hashtable pair2SF = new Hashtable();
    private Hashtable pair2DF = new Hashtable();
    private ArrayList namespaces;
    private boolean autoRegisterSOAPElements = true;
    private boolean debug = false;
    private Pair cachePair = null;

    public TypeMappingImpl(TypeMappingBase delegate) {
        this.delegate = delegate;
        this.namespaces = new ArrayList();
        this.debug = log.isDebugEnabled() || this.debug;
    }

    void setDelegate(TypeMappingBase delegate) {
        this.delegate = delegate;
    }

    public TypeMappingBase getDelegate() {
        return this.delegate;
    }

    public String[] getSupportedEncodings() {
        String[] stringArray = new String[this.namespaces.size()];
        return this.namespaces.toArray(stringArray);
    }

    public void setSupportedEncodings(String[] namespaceURIs) {
        this.namespaces.clear();
        for (int i = 0; i < namespaceURIs.length; ++i) {
            if (this.namespaces.contains(namespaceURIs[i])) continue;
            this.namespaces.add(namespaceURIs[i]);
        }
    }

    public boolean isRegistered(Class javaType, QName xmlType) {
        if (javaType == null || xmlType == null) {
            throw new JAXRPCException(Messages.getMessage(javaType == null ? "badJavaType" : "badXmlType"));
        }
        Pair pair = this.getPair(javaType, xmlType);
        boolean registered = this.pair2SF.keySet().contains(pair);
        pair.inUse = false;
        if (registered) {
            return true;
        }
        if (this.delegate != null) {
            boolean found = this.delegate.isRegistered(javaType, xmlType);
            return found;
        }
        return false;
    }

    public void register(Class javaType, QName xmlType, javax.xml.rpc.encoding.SerializerFactory sf, javax.xml.rpc.encoding.DeserializerFactory dsf) throws JAXRPCException {
        if (sf == null && dsf == null) {
            throw new JAXRPCException(Messages.getMessage("badSerFac"));
        }
        this.internalRegister(javaType, xmlType, sf, dsf);
    }

    protected synchronized void internalRegister(Class javaType, QName xmlType, javax.xml.rpc.encoding.SerializerFactory sf, javax.xml.rpc.encoding.DeserializerFactory dsf) throws JAXRPCException {
        if (this.debug) {
            log.debug("name: " + this.getClass().toString());
            log.debug("internalRegister(" + (javaType != null ? javaType.toString() : "<null>") + ", " + (xmlType != null ? xmlType.toString() : "<null>") + ", " + (sf != null ? sf.toString() : "<null>") + ", " + (dsf != null ? dsf.toString() : "<null>") + ")");
            if (!this.isRegistered(javaType, xmlType)) {
                if (sf != null) {
                    try {
                        log.debug(sf.getSerializerAs("").getClass().toString());
                    }
                    catch (Exception e) {
                        log.error("Cannot obtain a Serializer. Exception details: " + e);
                    }
                }
                if (dsf != null) {
                    try {
                        log.debug(dsf.getDeserializerAs("").getClass().toString());
                    }
                    catch (Exception e) {
                        log.error("Cannot obtain a Deserializer. Exception details: " + e);
                    }
                }
            }
        }
        if (javaType == null || xmlType == null) {
            throw new JAXRPCException(Messages.getMessage(javaType == null ? "badJavaType" : "badXmlType"));
        }
        Pair pair = this.getPair(javaType, xmlType);
        if (dsf != null || this.qName2Pair.get(xmlType) == null) {
            this.qName2Pair.put(xmlType, pair);
        }
        this.class2Pair.put(javaType.getName(), pair);
        if (sf != null) {
            this.pair2SF.put(pair, sf);
        }
        if (dsf != null) {
            this.pair2DF.put(pair, dsf);
        }
    }

    public javax.xml.rpc.encoding.SerializerFactory getSerializer(Class javaType, QName xmlType) throws JAXRPCException {
        Class maybeBase;
        javax.xml.rpc.encoding.SerializerFactory sf = null;
        if (this.debug) {
            log.debug("getSerializer(" + javaType + "," + xmlType + ")");
        }
        if (javaType == null) {
            if (this.debug) {
                log.debug("getSerializer javaType is null");
            }
            return null;
        }
        if (xmlType == null && (xmlType = this.getTypeQName(javaType)) == null) {
            if (this.debug) {
                log.debug("getSerializer xmlType is null");
            }
            return null;
        }
        Pair pair = this.getPair(javaType, xmlType);
        sf = (javax.xml.rpc.encoding.SerializerFactory)this.pair2SF.get(pair);
        pair.inUse = false;
        if (this.autoRegisterSOAPElements && sf == null && SOAPElement.class.isAssignableFrom(javaType)) {
            sf = BaseSerializerFactory.createFactory(SOAPElementSerializerFactory.class, javaType, xmlType);
            DeserializerFactory df = BaseDeserializerFactory.createFactory(SOAPElementDeserializerFactory.class, javaType, xmlType);
            if (!(this instanceof DefaultTypeMappingImpl)) {
                this.internalRegister(javaType, xmlType, sf, df);
            }
            if (this.debug) {
                log.debug("getSerializer sf [" + sf + "]");
            }
            return sf;
        }
        if (sf == null && Collection.class.isAssignableFrom(javaType)) {
            pair = this.getPair(Object;.class, xmlType);
            sf = (javax.xml.rpc.encoding.SerializerFactory)this.pair2SF.get(pair);
            pair.inUse = false;
        }
        if (sf == null && (maybeBase = this.getClassForQName(xmlType)) != null && maybeBase != javaType && maybeBase.isAssignableFrom(javaType)) {
            QName javaTypeXMLType = null;
            if (javaType.isArray() || Collection.class.isAssignableFrom(javaType)) {
                javaTypeXMLType = xmlType;
                javaType = maybeBase;
            } else {
                javaTypeXMLType = this.getTypeQName(javaType);
            }
            if (javaTypeXMLType != null && !javaTypeXMLType.getLocalPart().startsWith(">")) {
                Pair pair2 = this.getPair(javaType, javaTypeXMLType);
                sf = (SerializerFactory)this.pair2SF.get(pair2);
                pair2.inUse = false;
            }
        }
        if (sf == null && this.delegate != null) {
            sf = (SerializerFactory)this.delegate.getSerializer(javaType, xmlType);
        }
        if (sf == null && xmlType.equals(Constants.SOAP_ARRAY) && (pair = (Pair)this.qName2Pair.get(Constants.SOAP_ARRAY)) != null) {
            sf = (javax.xml.rpc.encoding.SerializerFactory)this.pair2SF.get(pair);
        }
        if (sf == null && !javaType.isArray() && (pair = (Pair)this.class2Pair.get(javaType.getName())) != null && pair.xmlType.equals(xmlType)) {
            sf = (javax.xml.rpc.encoding.SerializerFactory)this.pair2SF.get(pair);
        }
        if (sf == null && javaType.isArray() && (pair = (Pair)this.qName2Pair.get(Constants.SOAP_ARRAY)) != null) {
            sf = (javax.xml.rpc.encoding.SerializerFactory)this.pair2SF.get(pair);
        }
        if (this.debug) {
            log.debug("getSerializer sf [" + sf + "]");
        }
        return sf;
    }

    public QName getXMLType(Class javaType, QName xmlType) throws JAXRPCException {
        Class maybeBase;
        javax.xml.rpc.encoding.SerializerFactory sf = null;
        QName retXmlType = null;
        if (xmlType == null && (xmlType = this.getTypeQNameRecursive(javaType)) == null) {
            return retXmlType;
        }
        Pair pair = this.getPair(javaType, xmlType);
        sf = (javax.xml.rpc.encoding.SerializerFactory)this.pair2SF.get(pair);
        retXmlType = pair.xmlType;
        pair.inUse = false;
        if (sf == null && (maybeBase = this.getClassForQName(xmlType)) != null && maybeBase.isAssignableFrom(javaType)) {
            QName javaTypeXMLType = null;
            if (javaType.isArray() || Collection.class.isAssignableFrom(javaType)) {
                javaTypeXMLType = xmlType;
                javaType = maybeBase;
            } else {
                javaTypeXMLType = this.getTypeQName(javaType);
            }
            if (javaTypeXMLType != null && !javaTypeXMLType.getLocalPart().startsWith(">")) {
                Pair pair2 = this.getPair(javaType, javaTypeXMLType);
                sf = (SerializerFactory)this.pair2SF.get(pair2);
                retXmlType = pair2.xmlType;
                pair2.inUse = false;
            }
        }
        if (sf == null && this.delegate != null) {
            return this.delegate.getXMLType(javaType, xmlType);
        }
        if (sf == null && !javaType.isArray() && (pair = (Pair)this.class2Pair.get(javaType.getName())) != null) {
            sf = (javax.xml.rpc.encoding.SerializerFactory)this.pair2SF.get(pair);
            retXmlType = pair.xmlType;
        }
        if (sf == null && javaType.isArray() && (pair = (Pair)this.qName2Pair.get(Constants.SOAP_ARRAY)) != null) {
            sf = (javax.xml.rpc.encoding.SerializerFactory)this.pair2SF.get(pair);
            retXmlType = pair.xmlType;
        }
        return retXmlType;
    }

    public javax.xml.rpc.encoding.DeserializerFactory getDeserializer(Class javaType, QName xmlType) throws JAXRPCException {
        SerializerFactory sf;
        javax.xml.rpc.encoding.DeserializerFactory df = null;
        if (this.debug) {
            log.debug("getDeserializer(" + javaType + "," + xmlType);
        }
        if (xmlType == null) {
            if (this.debug) {
                log.debug("  can't continue");
            }
            return null;
        }
        if (javaType == null) {
            javaType = this.getClassForQName(xmlType);
            if (this.debug) {
                log.debug("  No javaType swizzle: new javaType=" + javaType);
            }
            if (this.autoRegisterSOAPElements && javaType == null) {
                Class clazz = javaType = SOAPElement.class;
                if (this.debug) {
                    log.debug("  Default to SOAPElement javaType=" + javaType);
                }
            }
        }
        if (javaType == null) {
            if (this.debug) {
                log.debug("  no java type, bail out");
            }
            return null;
        }
        Pair pair = this.getPair(javaType, xmlType);
        df = (javax.xml.rpc.encoding.DeserializerFactory)this.pair2DF.get(pair);
        if (this.debug) {
            log.debug("  First attempt: df=" + df);
        }
        pair.inUse = false;
        if (df == null && this.autoRegisterSOAPElements && SOAPElement.class.isAssignableFrom(javaType)) {
            sf = BaseSerializerFactory.createFactory(SOAPElementSerializerFactory.class, javaType, xmlType);
            df = BaseDeserializerFactory.createFactory(SOAPElementDeserializerFactory.class, javaType, xmlType);
            if (!(this instanceof DefaultTypeMappingImpl)) {
                this.internalRegister(javaType, xmlType, sf, df);
            }
            if (this.debug) {
                log.debug("  Use autoregistered SOAPElement: df=" + df);
            }
            return df;
        }
        if (df == null && Collection.class.isAssignableFrom(javaType)) {
            pair = this.getPair(Object;.class, xmlType);
            df = (javax.xml.rpc.encoding.DeserializerFactory)this.pair2DF.get(pair);
            pair.inUse = false;
            if (this.debug) {
                log.debug("  Try Collection swizzle: df=" + df);
            }
        }
        if (df == null && xmlType.equals(Constants.SOAP_ARRAY) && (pair = (Pair)this.qName2Pair.get(xmlType)) != null) {
            df = (javax.xml.rpc.encoding.DeserializerFactory)this.pair2DF.get(pair);
            if (this.debug) {
                log.debug("  Try SOAP_ARRAY swizzle: df=" + df);
            }
        }
        if (df == null && javaType == Object.class) {
            pair = (Pair)this.qName2Pair.get(xmlType);
            if (pair != null) {
                df = (javax.xml.rpc.encoding.DeserializerFactory)this.pair2DF.get(pair);
            }
            if (this.debug) {
                log.debug("  Try Object swizzle: df=" + df);
            }
        }
        if (df == null && this.delegate != null) {
            if (this.debug) {
                log.debug("  Try Delegation Start");
            }
            df = this.delegate.getDeserializer(javaType, xmlType);
            if (this.debug) {
                log.debug("  Try Delegation End: df=" + df);
            }
        }
        if (df == null && this.autoRegisterSOAPElements && javaType == Object.class) {
            sf = null;
            df = BaseDeserializerFactory.createFactory(SOAPElementDeserializerFactory.class, SOAPElement.class, xmlType);
            if (!(this instanceof DefaultTypeMappingImpl)) {
                this.internalRegister(javaType, xmlType, sf, df);
            }
            if (this.debug) {
                log.debug("  Try Object->SOAPElement swizzle: df=" + df);
            }
        }
        return df;
    }

    public void removeSerializer(Class javaType, QName xmlType) throws JAXRPCException {
        if (javaType == null || xmlType == null) {
            throw new JAXRPCException(Messages.getMessage(javaType == null ? "badJavaType" : "badXmlType"));
        }
        Pair pair = this.getPair(javaType, xmlType);
        this.pair2SF.remove(pair);
        pair.inUse = false;
    }

    public void removeDeserializer(Class javaType, QName xmlType) throws JAXRPCException {
        if (javaType == null || xmlType == null) {
            throw new JAXRPCException(Messages.getMessage(javaType == null ? "badJavaType" : "badXmlType"));
        }
        Pair pair = this.getPair(javaType, xmlType);
        this.pair2DF.remove(pair);
        pair.inUse = false;
    }

    public QName getTypeQNameRecursive(Class javaType) {
        QName ret = null;
        while (javaType != null) {
            ret = this.getTypeQName(javaType);
            if (ret != null) {
                return ret;
            }
            Class<?>[] interfaces = javaType.getInterfaces();
            if (interfaces != null) {
                for (int i = 0; i < interfaces.length; ++i) {
                    Class<?> iface = interfaces[i];
                    ret = this.getTypeQName(iface);
                    if (ret == null) continue;
                    return ret;
                }
            }
            javaType = javaType.getSuperclass();
        }
        return null;
    }

    public QName getTypeQName(Class javaType) {
        if (javaType == null) {
            return null;
        }
        if (String;.class.equals(javaType)) {
            if (log.isDebugEnabled()) {
                log.debug("Java type is a String array");
            }
            return Constants.SOAP_ARRAY;
        }
        QName xmlType = null;
        Pair pair = (Pair)this.class2Pair.get(javaType.getName());
        if (pair == null && this.delegate != null) {
            xmlType = this.delegate.getTypeQName(javaType);
        } else if (pair != null) {
            xmlType = pair.xmlType;
        }
        if (xmlType == null && (javaType.isArray() || javaType == List.class || List.class.isAssignableFrom(javaType))) {
            xmlType = Constants.SOAP_ARRAY;
        }
        return xmlType;
    }

    public QName getRegisteredQName(String className) {
        if (className == null) {
            return null;
        }
        Pair pair = (Pair)this.class2Pair.get(className);
        QName xmlType = null;
        if (pair == null && this.delegate != null) {
            xmlType = this.delegate.getRegisteredQName(className);
        } else if (pair != null) {
            xmlType = pair.xmlType;
        }
        return xmlType;
    }

    public Class getClassForQName(QName xmlType) {
        if (xmlType == null) {
            return null;
        }
        Class javaType = null;
        Pair pair = (Pair)this.qName2Pair.get(xmlType);
        if (pair == null && this.delegate != null) {
            javaType = this.delegate.getClassForQName(xmlType);
        } else if (pair != null) {
            javaType = pair.javaType;
        }
        return javaType;
    }

    public javax.xml.rpc.encoding.SerializerFactory getSerializer(Class javaType) throws JAXRPCException {
        return this.getSerializer(javaType, null);
    }

    public javax.xml.rpc.encoding.DeserializerFactory getDeserializer(QName xmlType) throws JAXRPCException {
        return this.getDeserializer(null, xmlType);
    }

    private synchronized Pair getPair(Class javaType, QName xmlType) {
        if (this.cachePair == null || this.cachePair.inUse) {
            this.cachePair = new Pair(javaType, xmlType);
        } else {
            this.cachePair.inUse = true;
            this.cachePair.javaType = javaType;
            this.cachePair.xmlType = xmlType;
        }
        return this.cachePair;
    }

    private class Pair {
        public Class javaType;
        public QName xmlType;
        public boolean inUse;

        public Pair(Class javaType, QName xmlType) {
            this.javaType = javaType;
            this.xmlType = xmlType;
            this.inUse = true;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            Pair p = (Pair)o;
            if (p.xmlType == this.xmlType && p.javaType == this.javaType) {
                return true;
            }
            return p.xmlType.equals(this.xmlType) && p.javaType.equals(this.javaType);
        }

        public int hashCode() {
            int hashcode = 0;
            if (this.javaType != null) {
                hashcode ^= this.javaType.hashCode();
            }
            if (this.xmlType != null) {
                hashcode ^= this.xmlType.hashCode();
            }
            return hashcode;
        }
    }
}

