/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.attachments.AttachmentUtils;
import com.ibm.ws.webservices.engine.attachments.Attachments;
import com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DefaultTypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.SerializationWriter;
import com.ibm.ws.webservices.engine.encoding.Serializer;
import com.ibm.ws.webservices.engine.encoding.SerializerFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.TypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.JAFDataHandlerSerializer;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleSerializer;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleValueSerializer;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.schema.SchemaVersion;
import com.ibm.ws.webservices.engine.types.HexBinary;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import com.ibm.ws.webservices.wsdl.symbolTable.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.AttachmentPart;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public final class SerializationContextImpl
implements SerializationContext {
    protected static Log log = LogFactory.getLog(SerializationContextImpl.class.getName());
    private static final Serializer intSerializer = new SimpleSerializer(Integer.class, Constants.XSD_INT);
    SerializationWriter sWriter;
    private MessageContext msgContext;
    private QName currentXMLType;
    private TypeMappingRegistry tmr = null;
    private TypeMapping tm = null;
    private String encodingStyle = null;
    private SOAPConstants soapConstants = SOAPConstants.SOAP11_CONSTANTS;
    SchemaVersion schemaVersion = SchemaVersion.SCHEMA_2001;
    private static QName multirefQName = QNameTable.createQName("", "multiRef");
    private QName actualXMLType = null;
    private int nesting = 0;
    private boolean doMultiRefs = false;
    private boolean sendXSIType = true;
    private HashMap multiRefValues = null;
    private int multiRefIndex = -1;
    private HashSet secondLevelObjects = null;
    private Object forceSer = null;
    private boolean outputMultiRefsFlag = false;
    private List buildNumbers = null;

    public SerializationContextImpl(Writer writer) {
        this.sWriter = new SerializationWriter(writer, "utf-8", true);
    }

    public SerializationContextImpl(Writer writer, MessageContext msgContext) {
        this(writer, msgContext, true);
    }

    public SerializationContextImpl(Writer writer, MessageContext msgContext, boolean fullDocument) {
        this(writer, msgContext, fullDocument, "utf-8");
    }

    public SerializationContextImpl(Writer writer, MessageContext msgContext, boolean fullDocument, String charEncoding) {
        boolean sendXMLDecl = true;
        this.msgContext = msgContext;
        WebServicesEngine optionSource = null;
        if (msgContext != null) {
            Boolean opt;
            this.soapConstants = msgContext.getSOAPConstants();
            if (optionSource == null) {
                optionSource = msgContext.getEngine();
            }
            this.schemaVersion = msgContext.getSchemaVersion();
            Boolean shouldSendDecl = (Boolean)optionSource.getOption("sendXMLDeclaration");
            if (shouldSendDecl != null) {
                sendXMLDecl = shouldSendDecl;
            }
            Boolean shouldSendMultiRefs = (Boolean)msgContext.getProperty("sendMultiRefs");
            if (log.isDebugEnabled()) {
                log.debug("The value of the MessageContext sendMultiRefs property is " + shouldSendMultiRefs);
            }
            if (shouldSendMultiRefs == null) {
                shouldSendMultiRefs = (Boolean)optionSource.getOption("sendMultiRefs");
                if (log.isDebugEnabled()) {
                    log.debug("The value of the Engine Configuration sendMultiRefs property is " + shouldSendMultiRefs);
                }
            }
            if (shouldSendMultiRefs != null) {
                this.doMultiRefs = shouldSendMultiRefs;
            }
            if (!msgContext.isPropertyTrue("send_type_attr", true)) {
                this.sendXSIType = false;
            }
            if ((opt = (Boolean)optionSource.getOption("sendXsiTypes")) != null && opt.equals(Boolean.FALSE)) {
                this.sendXSIType = false;
            }
            Use use = null;
            if (msgContext.getOperationUseString() != null) {
                use = Use.getUse(msgContext.getOperationUseString());
            }
            if (use != null && use != Use.ENCODED) {
                this.sendXSIType = false;
                this.doMultiRefs = false;
            }
            if (log.isDebugEnabled()) {
                if (this.doMultiRefs) {
                    log.debug("The message will be serialized using the multiref algorithm.");
                } else {
                    log.debug("The message will be serialized using the normal (no multiref) algorithm.");
                }
            }
        }
        this.sWriter = new SerializationWriter(writer, charEncoding, sendXMLDecl && fullDocument);
    }

    public SerializationWriter getSerializationWriter() {
        return this.sWriter;
    }

    public void serialize(QName elemQName, Attributes attributes, Object value2) throws IOException {
        this.serialize(elemQName, attributes, value2, null, true, null);
    }

    public void serialize(QName elemQName, Attributes attributes, Object value2, QName xmlType, boolean sendNull, Boolean sendType) throws IOException {
        this.serialize(elemQName, attributes, value2, xmlType, sendNull, sendType, null);
    }

    public void serialize(QName elemQName, Attributes attributes, Object value2, QName xmlType, boolean sendNull, Boolean sendType, Serializer serializer) throws IOException {
        this.serialize(elemQName, attributes, value2, xmlType, value2 == null ? null : value2.getClass(), sendNull, sendType, serializer);
    }

    public void serialize(QName elemQName, Attributes attributes, Object value2, QName xmlType, Class javaType, boolean sendNull, Boolean sendType, Serializer serializer) throws IOException {
        Attachments attachments;
        Message msg;
        boolean shouldSendType;
        boolean bl = shouldSendType = sendType == null ? this.shouldSendXSIType() : sendType.booleanValue();
        if (value2 == null) {
            String mime = AttachmentUtils.mime(xmlType);
            if (mime != null) {
                value2 = new DataHandler(new ManagedMemoryDataSource(new ByteArrayInputStream(new byte[0]), mime));
            } else {
                if (sendNull) {
                    AttributesImpl attrs = new AttributesImpl();
                    if (attributes != null && 0 < attributes.getLength()) {
                        attrs.setAttributes(attributes);
                    }
                    if (shouldSendType) {
                        attrs = (AttributesImpl)this.setTypeAttribute(attrs, xmlType);
                    }
                    String nil = this.schemaVersion.getNilQName().getLocalPart();
                    attrs.addAttribute(this.schemaVersion.getXsiURI(), nil, "xsi:" + nil, "CDATA", "true");
                    this.simpleElement(elemQName, attrs, null);
                    return;
                }
                return;
            }
        }
        if (value2 instanceof AttachmentPart) {
            try {
                value2 = ((AttachmentPart)value2).getDataHandler();
            }
            catch (Exception se) {
                FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.encoding.SerializationContextImpl.serialize", "411", this);
                throw new IOException(Messages.getMessage("nullInSerActual00"));
            }
        }
        if ((msg = this.getCurrentMessage()) != null && (attachments = msg.getAttachmentsImpl()) != null && attachments.isAttachment(value2)) {
            this.serializeActual(elemQName, attributes, value2, xmlType, javaType, sendType, serializer);
            return;
        }
        if (!this.doMultiRefs || value2 == this.forceSer || this.isPrimitive(value2) || AttachmentUtils.isMIME(xmlType)) {
            if (value2 == this.forceSer) {
                this.forceSer = null;
            }
            this.serializeActual(elemQName, attributes, value2, xmlType, javaType, sendType, serializer);
        } else {
            String id;
            MultiRefItem mri;
            if (this.multiRefIndex == -1) {
                this.multiRefValues = new HashMap();
            }
            if ((mri = (MultiRefItem)this.multiRefValues.get(this.getIdentityKey(value2))) != null) {
                id = mri.id;
            } else {
                ++this.multiRefIndex;
                id = "id" + this.multiRefIndex;
                mri = new MultiRefItem(id, xmlType, sendType, value2, serializer);
                this.multiRefValues.put(this.getIdentityKey(value2), mri);
                if (this.soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
                    AttributesImpl attrs = new AttributesImpl();
                    if (attributes != null && 0 < attributes.getLength()) {
                        attrs.setAttributes(attributes);
                    }
                    attrs.addAttribute("", "id", "id", "CDATA", id);
                    this.serializeActual(elemQName, attrs, value2, xmlType, javaType, sendType, serializer);
                    return;
                }
                if (this.outputMultiRefsFlag) {
                    if (this.secondLevelObjects == null) {
                        this.secondLevelObjects = new HashSet();
                    }
                    this.secondLevelObjects.add(this.getIdentityKey(value2));
                }
            }
            AttributesImpl attrs = new AttributesImpl();
            if (attributes != null && 0 < attributes.getLength()) {
                attrs.setAttributes(attributes);
            }
            attrs.addAttribute("", "href", "href", "CDATA", '#' + id);
            this.simpleElement(elemQName, attrs, null);
        }
    }

    public void serialize(QName elemQName, Attributes attributes, Object value2, QName xmlType, Class javaType, boolean sendNull, Boolean sendType, Serializer serializer, RequestResponse rr) throws IOException {
        Attachments attachments;
        Message msg;
        boolean shouldSendType;
        boolean bl = shouldSendType = sendType == null ? this.shouldSendXSIType() : sendType.booleanValue();
        if (value2 == null) {
            String mime = AttachmentUtils.mime(xmlType);
            if (mime != null) {
                value2 = new DataHandler(new ManagedMemoryDataSource(new ByteArrayInputStream(new byte[0]), mime));
            } else {
                if (sendNull) {
                    AttributesImpl attrs = new AttributesImpl();
                    if (attributes != null && 0 < attributes.getLength()) {
                        attrs.setAttributes(attributes);
                    }
                    if (shouldSendType) {
                        attrs = (AttributesImpl)this.setTypeAttribute(attrs, xmlType);
                    }
                    String nil = this.schemaVersion.getNilQName().getLocalPart();
                    attrs.addAttribute(this.schemaVersion.getXsiURI(), nil, "xsi:" + nil, "CDATA", "true");
                    this.simpleElement(elemQName, attrs, null);
                    return;
                }
                return;
            }
        }
        if (value2 instanceof AttachmentPart) {
            try {
                value2 = ((AttachmentPart)value2).getDataHandler();
            }
            catch (Exception se) {
                FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.encoding.SerializationContextImpl.serialize", "411", this);
                throw new IOException(Messages.getMessage("nullInSerActual00"));
            }
        }
        if ((msg = this.getCurrentMessage()) != null && (attachments = msg.getAttachmentsImpl()) != null && attachments.isAttachment(value2)) {
            this.serializeActual(elemQName, attributes, value2, xmlType, javaType, sendType, serializer, rr);
            return;
        }
        if (!this.doMultiRefs || value2 == this.forceSer || this.isPrimitive(value2) || AttachmentUtils.isMIME(xmlType)) {
            if (value2 == this.forceSer) {
                this.forceSer = null;
            }
            this.serializeActual(elemQName, attributes, value2, xmlType, javaType, sendType, serializer);
        } else {
            String id;
            MultiRefItem mri;
            if (this.multiRefIndex == -1) {
                this.multiRefValues = new HashMap();
            }
            if ((mri = (MultiRefItem)this.multiRefValues.get(this.getIdentityKey(value2))) != null) {
                id = mri.id;
            } else {
                ++this.multiRefIndex;
                id = "id" + this.multiRefIndex;
                mri = new MultiRefItem(id, xmlType, sendType, value2, serializer);
                this.multiRefValues.put(this.getIdentityKey(value2), mri);
                if (this.soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
                    AttributesImpl attrs = new AttributesImpl();
                    if (attributes != null && 0 < attributes.getLength()) {
                        attrs.setAttributes(attributes);
                    }
                    attrs.addAttribute("", "id", "id", "CDATA", id);
                    this.serializeActual(elemQName, attrs, value2, xmlType, javaType, sendType, serializer, rr);
                    return;
                }
                if (this.outputMultiRefsFlag) {
                    if (this.secondLevelObjects == null) {
                        this.secondLevelObjects = new HashSet();
                    }
                    this.secondLevelObjects.add(this.getIdentityKey(value2));
                }
            }
            AttributesImpl attrs = new AttributesImpl();
            if (attributes != null && 0 < attributes.getLength()) {
                attrs.setAttributes(attributes);
            }
            attrs.addAttribute("", "href", "href", "CDATA", '#' + id);
            this.simpleElement(elemQName, attrs, null);
        }
    }

    public void outputMultiRefs() throws IOException {
        if (!this.doMultiRefs || this.multiRefValues == null || this.soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
            return;
        }
        this.outputMultiRefsFlag = true;
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "", "", "", "");
        String encodingURI = this.soapConstants.getEncodingURI();
        String prefix = this.sWriter.getOrCreatePrefix(encodingURI, null, true);
        String root = prefix + ":root";
        attrs.addAttribute(encodingURI, "root", root, "CDATA", "0");
        String encodingStyle = this.msgContext != null ? this.msgContext.getEncodingStyle() : this.soapConstants.getEncodingURI();
        String encPrefix = this.sWriter.getOrCreatePrefix(this.soapConstants.getEnvelopeURI(), null, true);
        String encStyle = encPrefix + ':' + "encodingStyle";
        attrs.addAttribute(this.soapConstants.getEnvelopeURI(), "encodingStyle", encStyle, "CDATA", encodingStyle);
        HashSet keys = new HashSet();
        keys.addAll(this.multiRefValues.keySet());
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            while (i.hasNext()) {
                Object val = i.next();
                MultiRefItem mri = (MultiRefItem)this.multiRefValues.get(val);
                attrs.setAttribute(0, "", "id", "id", "CDATA", mri.id);
                this.forceSer = mri.value;
                this.serialize(multirefQName, attrs, mri.value, mri.xmlType, true, null, mri.serializer);
            }
            if (this.secondLevelObjects == null) continue;
            i = this.secondLevelObjects.iterator();
            this.secondLevelObjects = null;
        }
        this.forceSer = null;
        this.outputMultiRefsFlag = false;
        this.multiRefValues = null;
        this.multiRefIndex = -1;
        this.secondLevelObjects = null;
    }

    private void serializeActual(QName elemQName, Attributes attributes, Object value2, QName xmlType, Class javaType, Boolean sendType, Serializer serializer) throws IOException {
        Serializer ser;
        TypeMapping tm;
        boolean shouldSendType;
        if (log.isDebugEnabled()) {
            log.debug("serializeActual:" + elemQName + " , " + xmlType);
        }
        ++this.nesting;
        if (this.nesting > 100) {
            --this.nesting;
            throw new IOException(Messages.getMessage("serNesting00", value2.getClass().getName()));
        }
        boolean bl = shouldSendType = sendType == null ? this.shouldSendXSIType() : sendType.booleanValue();
        if (value2 == null) {
            --this.nesting;
            throw new IOException(Messages.getMessage("nullInSerActual00"));
        }
        if (javaType == null) {
            javaType = value2.getClass();
        }
        if (log.isDebugEnabled()) {
            log.debug("  javaType=" + javaType);
        }
        if ((tm = this.getTypeMapping()) == null) {
            --this.nesting;
            this.throwSerNotFound(value2.getClass());
        }
        this.currentXMLType = xmlType;
        if (Constants.equals(Constants.XSD_ANYTYPE, xmlType)) {
            xmlType = null;
            shouldSendType = true;
        }
        if (serializer != null) {
            ser = serializer;
            this.actualXMLType = xmlType;
        } else {
            ser = this.getSerializer(javaType, xmlType);
        }
        if (ser == null) {
            --this.nesting;
            this.throwSerNotFound(value2.getClass());
        }
        if (shouldSendType || xmlType != null && !xmlType.equals(this.actualXMLType)) {
            attributes = this.setTypeAttribute(attributes, this.actualXMLType);
        }
        this.logBuildNumber(ser.getBuildNumber());
        ser.serialize(elemQName, attributes, value2, this);
        --this.nesting;
    }

    private void serializeActual(QName elemQName, Attributes attributes, Object value2, QName xmlType, Class javaType, Boolean sendType, Serializer serializer, RequestResponse rr) throws IOException {
        Serializer ser;
        TypeMapping tm;
        boolean shouldSendType;
        if (log.isDebugEnabled()) {
            log.debug("serializeActual:" + elemQName + " , " + xmlType);
        }
        ++this.nesting;
        if (this.nesting > 100) {
            --this.nesting;
            throw new IOException(Messages.getMessage("serNesting00", value2.getClass().getName()));
        }
        boolean bl = shouldSendType = sendType == null ? this.shouldSendXSIType() : sendType.booleanValue();
        if (value2 == null) {
            --this.nesting;
            throw new IOException(Messages.getMessage("nullInSerActual00"));
        }
        if (javaType == null) {
            javaType = value2.getClass();
        }
        if (log.isDebugEnabled()) {
            log.debug("  javaType=" + javaType);
        }
        if ((tm = this.getTypeMapping()) == null) {
            --this.nesting;
            this.throwSerNotFound(value2.getClass());
        }
        this.currentXMLType = xmlType;
        if (Constants.equals(Constants.XSD_ANYTYPE, xmlType)) {
            xmlType = null;
            shouldSendType = true;
        }
        if (serializer != null) {
            ser = serializer;
            this.actualXMLType = xmlType;
        } else {
            ser = this.getSerializer(javaType, xmlType);
        }
        if (ser == null) {
            --this.nesting;
            this.throwSerNotFound(value2.getClass());
        }
        if (shouldSendType || xmlType != null && !xmlType.equals(this.actualXMLType)) {
            attributes = this.setTypeAttribute(attributes, this.actualXMLType);
        }
        this.logBuildNumber(ser.getBuildNumber());
        if (ser instanceof JAFDataHandlerSerializer) {
            ((JAFDataHandlerSerializer)ser).serialize(elemQName, attributes, value2, this, rr);
        } else {
            ser.serialize(elemQName, attributes, value2, this);
        }
        --this.nesting;
    }

    public void setDoMultiRefs(boolean shouldDo) {
        this.doMultiRefs = shouldDo;
    }

    public boolean shouldSendXSIType() {
        return this.sendXSIType;
    }

    public TypeMapping getTypeMapping() {
        if (this.tm == null) {
            this.tm = this.msgContext == null ? DefaultTypeMappingImpl.getSingleton() : (TypeMapping)this.getTypeMappingRegistry().getTypeMapping(this.getEncodingStyle());
        }
        return this.tm;
    }

    public String getEncodingStyle() {
        if (this.encodingStyle == null) {
            if (this.msgContext != null) {
                this.encodingStyle = this.msgContext.getEncodingStyle();
            }
            if (this.encodingStyle == null) {
                this.encodingStyle = this.soapConstants.getEncodingURI();
            }
        }
        return this.encodingStyle;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.tmr == null && this.msgContext != null) {
            this.tmr = this.msgContext.getTypeMappingRegistry();
        }
        return this.tmr;
    }

    public Message getCurrentMessage() {
        if (this.msgContext == null) {
            return null;
        }
        return this.msgContext.getCurrentMessage();
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    private QName getQNameForClass(Class cls) {
        return this.getTypeMapping().getTypeQName(cls);
    }

    private boolean isPrimitive(Object value2) {
        if (value2 == null) {
            return true;
        }
        Class<?> javaType = value2.getClass();
        if (javaType.isPrimitive()) {
            return true;
        }
        if (javaType == String.class) {
            return true;
        }
        if (Calendar.class.isAssignableFrom(javaType)) {
            return true;
        }
        if (Date.class.isAssignableFrom(javaType)) {
            return true;
        }
        if (HexBinary.class.isAssignableFrom(javaType)) {
            return true;
        }
        if (Element.class.isAssignableFrom(javaType)) {
            return true;
        }
        if (Node.class.isAssignableFrom(javaType)) {
            return true;
        }
        if (javaType == [B.class) {
            return true;
        }
        if (javaType.isArray()) {
            return true;
        }
        QName qName = this.getQNameForClass(javaType);
        return qName != null && Constants.isSchemaXSD(qName.getNamespaceURI()) && Utils.isXSDType(qName);
    }

    private IDKey getIdentityKey(Object value2) {
        return new IDKey(value2);
    }

    public QName getCurrentXMLType() {
        return this.currentXMLType;
    }

    private SerializerFactory getSerializerFactoryFromInterface(Class javaType, QName xmlType, TypeMapping tm) {
        SerializerFactory serFactory = null;
        Class<?>[] interfaces = javaType.getInterfaces();
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> iface = interfaces[i];
                serFactory = (SerializerFactory)tm.getSerializer(iface, xmlType);
                if (serFactory == null) {
                    serFactory = this.getSerializerFactoryFromInterface(iface, xmlType, tm);
                }
                if (serFactory != null) break;
            }
        }
        return serFactory;
    }

    public Serializer getSerializer(Class javaType, QName xmlType) {
        if (xmlType == Constants.XSD_INT && javaType != null && (javaType.equals(Integer.TYPE) || javaType.equals(Integer.class))) {
            this.actualXMLType = Constants.XSD_INT;
            return intSerializer;
        }
        SerializerFactory serFactory = null;
        TypeMapping tm = this.getTypeMapping();
        this.actualXMLType = null;
        while (javaType != null && (serFactory = (SerializerFactory)tm.getSerializer(javaType, xmlType)) == null && (serFactory = this.getSerializerFactoryFromInterface(javaType, xmlType, tm)) == null) {
            javaType = javaType.getSuperclass();
        }
        Serializer ser = null;
        if (serFactory != null) {
            ser = (Serializer)serFactory.getSerializerAs("WebServices SAX Mechanism");
            if (serFactory instanceof BaseSerializerFactory) {
                this.actualXMLType = ((BaseSerializerFactory)serFactory).getXMLType();
            }
            if (this.actualXMLType == null) {
                this.actualXMLType = ((TypeMappingImpl)tm).getXMLType(javaType, xmlType);
            }
        }
        return ser;
    }

    public String qName2String(QName qName, boolean noDefaultPrefix) {
        return this.sWriter.qName2String(qName, noDefaultPrefix);
    }

    public final Serializer getSerializerForJavaType(Class javaType) {
        SerializerFactory serF = null;
        Serializer ser = null;
        try {
            serF = (SerializerFactory)this.getTypeMapping().getSerializer(javaType);
            if (serF != null) {
                ser = (Serializer)serF.getSerializerAs("WebServices SAX Mechanism");
            }
        }
        catch (JAXRPCException e) {
            // empty catch block
        }
        return ser;
    }

    public Attributes setTypeAttribute(Attributes attributes, QName type) {
        if (type == null || type.getLocalPart().indexOf(">") >= 0 || attributes != null && attributes.getIndex("http://www.w3.org/2001/XMLSchema-instance", "type") != -1) {
            return attributes;
        }
        AttributesImpl attrs = new AttributesImpl();
        if (attributes != null && 0 < attributes.getLength()) {
            attrs.setAttributes(attributes);
        }
        String prefix = this.sWriter.getOrCreatePrefix("http://www.w3.org/2001/XMLSchema-instance", "xsi", true);
        attrs.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", prefix + ":type", "CDATA", this.sWriter.qName2String(type));
        return attrs;
    }

    public String getValueAsString(Object value2, QName xmlType) throws IOException {
        Class primitiveCls;
        if (value2 == null) {
            return null;
        }
        Class javaType = value2.getClass();
        Serializer ser = this.getSerializer(javaType, xmlType);
        if (!(ser != null && ser instanceof SimpleValueSerializer || (primitiveCls = JavaUtils.getPrimitiveClass(javaType)) == null)) {
            javaType = primitiveCls;
            ser = this.getSerializer(javaType, xmlType);
        }
        if (ser == null) {
            this.throwSerNotFound(javaType);
        } else if (!(ser instanceof SimpleValueSerializer)) {
            throw new IOException(Messages.getMessage("needSimpleValueSer", ser.getClass().getName()));
        }
        SimpleValueSerializer simpleSer = (SimpleValueSerializer)ser;
        return simpleSer.getValueAsString(value2, this);
    }

    public void startElement(QName qName, Attributes attributes) throws IOException {
        this.sWriter.startElement(qName, attributes);
    }

    public void simpleElement(QName qName, Attributes attributes, String value2) throws IOException {
        this.sWriter.simpleElement(qName, attributes, value2);
    }

    public void endElement() throws IOException {
        this.sWriter.endElement();
    }

    private void throwSerNotFound(Class javaType) throws IOException {
        TypeMappingRegistry tmr = this.getTypeMappingRegistry();
        if (tmr.getRegisteredEncodingStyleURIs().length == 0) {
            throw new IOException(Messages.getMessage("noSerErr01", javaType.getName()));
        }
        throw new IOException(Messages.getMessage("noSerErr02", javaType.getName()));
    }

    public void logBuildNumber(String buildNumber) {
        if (buildNumber != null) {
            if (this.buildNumbers == null) {
                this.buildNumbers = new ArrayList();
            }
            if (!this.buildNumbers.contains(buildNumber)) {
                this.buildNumbers.add(buildNumber);
            }
        }
    }

    public List getBuildNumbers() {
        if (this.buildNumbers == null) {
            this.buildNumbers = new ArrayList();
        }
        return this.buildNumbers;
    }

    class IDKey {
        private Object value = null;
        private int id = 0;

        public IDKey(Object _value) {
            this.id = System.identityHashCode(_value);
            this.value = _value;
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object other) {
            if (!(other instanceof IDKey)) {
                return false;
            }
            IDKey idKey = (IDKey)other;
            if (this.id != idKey.id) {
                return false;
            }
            return this.value == idKey.value;
        }
    }

    class MultiRefItem {
        String id;
        QName xmlType;
        Boolean sendType;
        Object value;
        Serializer serializer;

        MultiRefItem(String id, QName xmlType, Boolean sendType, Object value2, Serializer serializer) {
            this.id = id;
            this.xmlType = xmlType;
            this.sendType = sendType;
            this.value = value2;
            this.serializer = serializer;
        }
    }
}

