/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.dispatchers.java;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.dispatchers.BasicDispatcher;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;

public abstract class JavaDispatcher
extends BasicDispatcher {
    protected static Log log = LogFactory.getLog(JavaDispatcher.class.getName());

    protected abstract Class getServiceClass(SOAPPort var1) throws WebServicesFault;

    public void bindPortToDispatcher(SOAPPort port2) throws WebServicesFault {
        Class cls = this.getServiceClass(port2);
    }

    public Object invokeOperation(OperationDesc operation, Object obj, Object[] argValues, MessageContext msgContext) throws WebServicesFault, InvocationTargetException {
        Method method = operation.getMethod();
        if (method == null) {
            throw new WebServicesFault(Messages.getMessage("npemethodtarget00", "method==null"));
        }
        try {
            return this.invokeMethod(method, obj, argValues, msgContext);
        }
        catch (InvocationTargetException ite) {
            throw ite;
        }
        catch (IllegalArgumentException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.dispatchers.java.Dispatcher.invokeMethod", "280", this);
            String methodSig = method.toString();
            String argClasses = "";
            for (int i = 0; i < argValues.length; ++i) {
                argClasses = argValues[i] == null ? argClasses + "null" : argClasses + argValues[i].getClass().getName();
                if (i + 1 >= argValues.length) continue;
                argClasses = argClasses + ",";
            }
            String translatedMessage = Messages.getMessage("dispatchIAE00", new String[]{methodSig, argClasses, obj.toString(), obj.getClass().getName()});
            log.info(translatedMessage, e);
            if (log.isDebugEnabled()) {
                this.logClassInfo("Target Class", obj.getClass());
                this.logClassInfo("Method Declaring Class", method.getDeclaringClass());
            }
            throw new WebServicesFault(translatedMessage, e);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.dispatchers.java.Dispatcher.invokeMethod", "300", this);
            String methodSig = method.toString();
            String translatedMessage = Messages.getMessage("dispatchIAE01", new String[]{methodSig, obj.toString(), obj.getClass().getName()});
            log.info(translatedMessage, e);
            throw new WebServicesFault(translatedMessage, e);
        }
    }

    protected Object invokeMethod(Method method, Object obj, Object[] argValues, MessageContext msgContext) throws Exception {
        return method.invoke(obj, argValues);
    }

    private void logClassInfo(String id, Class clazz) {
        if (log.isDebugEnabled()) {
            log.debug(id + ": Class.getName() == " + clazz.getName());
            log.debug(id + ": Class.getClassLoader() == " + clazz.getClassLoader());
        }
    }
}

