/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.client;

import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.client.ClientEngine;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configuration.DefaultEngineConfigurationFactory;
import com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder;
import java.util.HashMap;
import org.apache.commons.logging.Log;

public class ClientEngineFactory {
    protected static Log log = LogFactory.getLog(ClientEngineFactory.class.getName());
    private static HashMap engines = new HashMap();
    private static int CACHE_THRESHOLD = 5;

    public static synchronized ClientEngine getManagedEngine() {
        EngineConfiguration defaultConfig = EngineConfigurationFactoryFinder.newFactory().getClientEngineConfig();
        return ClientEngineFactory.getEngine(defaultConfig);
    }

    public static synchronized ClientEngine getEngine(EngineConfiguration config) {
        ClientEngine engine2 = (ClientEngine)engines.get(config);
        if (engine2 == null) {
            engine2 = new ClientEngine(config);
            if (log.isDebugEnabled()) {
                log.debug("Registering new engine: " + engine2.toString());
            }
            ClientEngineFactory.registerEngine(config, engine2);
        } else if (log.isDebugEnabled()) {
            log.debug("Cache hit! - Found engine : " + engine2.toString());
        }
        return engine2;
    }

    public static synchronized ClientEngine getUnmanagedEngine() {
        EngineConfiguration defaultConfig = DefaultEngineConfigurationFactory.newFactory(null).getClientEngineConfig();
        return ClientEngineFactory.getEngine(defaultConfig);
    }

    static synchronized void registerEngine(EngineConfiguration config, ClientEngine engine2) {
        ClientEngineFactory.checkCache();
        engines.put(config, engine2);
    }

    private static synchronized void checkCache() {
        if (engines.size() > CACHE_THRESHOLD) {
            if (log.isDebugEnabled()) {
                log.debug("Cache threshold exceeded - clearing cache.");
            }
            engines.clear();
        }
    }
}

