/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.WebServicesProperties;
import com.ibm.ws.webservices.engine.attachments.AttachmentUtils;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.SessionUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeader;
import org.apache.commons.logging.Log;

public class MimeUtils {
    protected static Log log = LogFactory.getLog(MimeUtils.class.getName());
    public static String[] filter = new String[]{"Message-ID", "Mime-Version", "Content-Type"};

    public static long getContentLength(Multipart mp2) throws MessagingException, IOException {
        int totalParts = mp2.getCount();
        long totalContentLength = 0L;
        for (int i = 0; i < totalParts; ++i) {
            MimeBodyPart bp = (MimeBodyPart)mp2.getBodyPart(i);
            totalContentLength += MimeUtils.getContentLength(bp);
        }
        String ctype = mp2.getContentType();
        ContentType ct = new ContentType(ctype);
        String boundaryStr = ct.getParameter("boundary");
        int boundaryStrLen = boundaryStr.length() + 4;
        return totalContentLength + (long)(boundaryStrLen * (totalParts + 1)) + (long)(2 * totalParts) + 4L;
    }

    protected static long getContentLength(MimeBodyPart bp) {
        long headerLength = -1L;
        long dataSize = -1L;
        try {
            headerLength = MimeUtils.getHeaderLength(bp);
            DataHandler dh = bp.getDataHandler();
            DataSource ds = dh.getDataSource();
            if (ds instanceof FileDataSource) {
                FileDataSource fdh = (FileDataSource)ds;
                File df = fdh.getFile();
                if (!df.exists()) {
                    throw new RuntimeException(Messages.getMessage("noFile", df.getAbsolutePath()));
                }
                dataSize = df.length();
            } else {
                dataSize = bp.getSize();
                if (-1L == dataSize) {
                    int bytesread;
                    dataSize = 0L;
                    InputStream in = null;
                    final DataSource finalds = ds;
                    in = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            return finalds.getInputStream();
                        }
                    });
                    byte[] readbuf = new byte[65536];
                    do {
                        if ((bytesread = in.read(readbuf)) <= 0) continue;
                        dataSize += (long)bytesread;
                    } while (bytesread > -1);
                    in.close();
                }
            }
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException(e.getException(), "com.ibm.ws.webservices.engine.MimeUtils.getContentLength", "201");
            log.error(Messages.getMessage("exception00"), e.getException());
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.attachments.MimeUtils.getContentLength", "204");
            log.error(Messages.getMessage("exception00"), e);
        }
        return dataSize + headerLength;
    }

    private static long getHeaderLength(MimeBodyPart bp) throws MessagingException, IOException {
        MimeBodyPart headersOnly = new MimeBodyPart(new InternetHeaders(), new byte[0]);
        Enumeration en = bp.getAllHeaders();
        while (en.hasMoreElements()) {
            Header header2 = (Header)en.nextElement();
            headersOnly.addHeader(header2.getName(), header2.getValue());
        }
        ByteArrayOutputStream bas = new ByteArrayOutputStream(16384);
        headersOnly.writeTo(bas);
        bas.close();
        return bas.size();
    }

    public static void writeToMultiPartStream(final OutputStream os, final MimeMultipart mp2) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Properties props = WebServicesProperties.getProperties();
                    props.setProperty("mail.smtp.host", "localhost");
                    Session session = Session.getInstance(props, null);
                    MimeMessage message = new MimeMessage(session);
                    message.setContent(mp2);
                    message.saveChanges();
                    message.writeTo(os, filter);
                }
                catch (MessagingException e) {
                    FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.attachments.MimeUtils.writeToMultiPartStream", "249");
                    log.error(Messages.getMessage("javaxMailMessagingException00"), e);
                }
                catch (IOException e) {
                    FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.attachments.MimeUtils.writeToMultiPartStream", "252");
                    log.error(Messages.getMessage("javaIOException00"), e);
                }
                return null;
            }
        });
    }

    public static String getContentType(MimeMultipart mp2) {
        StringBuffer contentType = new StringBuffer(mp2.getContentType());
        int i = 0;
        while (i < contentType.length()) {
            char ch = contentType.charAt(i);
            if (ch == '\r' || ch == '\n') {
                contentType.deleteCharAt(i);
                continue;
            }
            ++i;
        }
        return contentType.toString();
    }

    public static MimeMultipart createMP(boolean useBase64, String env, Collection parts) throws WebServicesFault {
        MimeMultipart multipart = null;
        try {
            String rootCID = SessionUtils.generateSessionId();
            String type = MimeUtils.getType(env);
            multipart = new MimeMultipart("related; type=\"" + type + "\"; start=\"<" + rootCID + ">\"");
            MimeBodyPart rootBodyPart = new MimeBodyPart();
            rootBodyPart.setText(env);
            rootBodyPart.setHeader("Content-Type", type + "; charset=UTF-8");
            rootBodyPart.setHeader("Content-Id", "<" + rootCID + ">");
            rootBodyPart.setHeader("Content-Transfer-Encoding", "binary");
            multipart.addBodyPart(rootBodyPart);
            if (log.isDebugEnabled()) {
                log.debug("About to process " + parts.size() + " attachment parts...");
            }
            Iterator it = parts.iterator();
            while (it.hasNext()) {
                String[] arr;
                Part part = (Part)it.next();
                DataHandler dh = AttachmentUtils.getActivationDataHandler(part);
                String contentID = part.getContentId();
                String cteValue = "binary";
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setDataHandler(dh);
                String contentType = dh.getContentType();
                if (contentType == null || contentType.trim().length() == 0) {
                    contentType = "application/octet-stream";
                }
                if ((arr = part.getMimeHeader("Content-Transfer-Encoding")) != null && arr.length > 0) {
                    cteValue = arr[0];
                    if (log.isDebugEnabled()) {
                        log.debug("User-defined Content-Transfer-Encoding value obtained from Part's MimeHeader: " + cteValue);
                    }
                } else if (useBase64 && !MimeUtils.isTextualPart(contentType)) {
                    if (log.isDebugEnabled()) {
                        log.debug("Caller requested base64-encoding...");
                    }
                    cteValue = "base64";
                }
                messageBodyPart.setHeader("Content-Transfer-Encoding", cteValue);
                messageBodyPart.setHeader("Content-Type", contentType);
                messageBodyPart.setHeader("Content-Id", "<" + contentID + ">");
                if (log.isDebugEnabled()) {
                    log.debug("Created new MimeBodyPart");
                    log.debug("  Content-ID = " + contentID);
                    log.debug("  Content-Type = " + contentType);
                    log.debug("  Content-Transfer-Encoding = " + cteValue);
                }
                String[] knownHeaders = new String[]{"Content-Type", "Content-Id", "Content-Transfer-Encoding"};
                Iterator i = part.getNonMatchingMimeHeaders(knownHeaders);
                while (i.hasNext()) {
                    MimeHeader header2 = (MimeHeader)i.next();
                    messageBodyPart.setHeader(header2.getName(), header2.getValue());
                    if (!log.isDebugEnabled()) continue;
                    log.debug("  " + header2.getName() + " = " + header2.getValue());
                }
                multipart.addBodyPart(messageBodyPart);
            }
        }
        catch (MessagingException e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.attachments.MimeUtils.createMP", "447");
            log.error(Messages.getMessage("javaxMailMessagingException00"), e);
        }
        return multipart;
    }

    private static String getType(String env) {
        String type = "text/xml";
        String search = env;
        if (env.length() > 300) {
            search = env.substring(0, 300);
        }
        if (search.indexOf("http://www.w3.org/2003/05/soap-envelope") > 0) {
            type = "application/soap+xml";
        }
        return type;
    }

    public static QName getMIMETypeQName(String mimeName) {
        if ("text/plain".equals(mimeName)) {
            return Constants.MIME_PLAINTEXT;
        }
        if ("image/gif".equals(mimeName) || "image/jpeg".equals(mimeName)) {
            return Constants.MIME_IMAGE;
        }
        if ("text/xml".equals(mimeName) || "applications/xml".equals(mimeName)) {
            return Constants.MIME_SOURCE;
        }
        if ("application/octetstream".equals(mimeName)) {
            return Constants.MIME_OCTETSTREAM;
        }
        if (mimeName != null && mimeName.startsWith("multipart/")) {
            return Constants.MIME_MULTIPART;
        }
        return Constants.MIME_DATA_HANDLER;
    }

    public static boolean isTextualPart(String contentType) {
        String ct = contentType.trim();
        boolean isTextual = false;
        if (ct.startsWith("text/") || ct.startsWith("application/soap") || ct.startsWith("application/xml") || ct.contains("charset")) {
            isTextual = true;
        }
        if (log.isDebugEnabled()) {
            log.debug("isTextualPart() returning: " + isTextual);
        }
        return isTextual;
    }
}

