/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ClosureHandler;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.PreHandler;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFault;
import com.ibm.ws.webservices.trace.UserExceptionTrace;
import java.rmi.RemoteException;
import java.util.MissingResourceException;
import org.apache.commons.logging.Log;

public class PivotHandlerWrapper
extends BasicHandler
implements PreHandler {
    protected static Log log = LogFactory.getLog(PivotHandlerWrapper.class.getName());
    private Handler _requestHandler;
    private Handler _pivotHandler;
    private Handler _responseHandler;
    private static final String ROOT_HANDLER_CHAIN = "com.ibm.ws.webservices.engine.PivotHandlerWrapper.ROOT_HANDLER_CHAIN";

    public static Handler factory(Handler flows, Handler pivHandler) {
        if (flows instanceof PivotHandlerWrapper) {
            PivotHandlerWrapper reqResFlows = (PivotHandlerWrapper)flows;
            return reqResFlows == null ? pivHandler : PivotHandlerWrapper.factory(reqResFlows.getRequestHandler(), pivHandler, reqResFlows.getResponseHandler());
        }
        return pivHandler;
    }

    public static Handler factory(Handler reqHandler, Handler pivHandler, Handler respHandler) {
        return reqHandler == null && respHandler == null ? pivHandler : new PivotHandlerWrapper(reqHandler, pivHandler, respHandler);
    }

    public PivotHandlerWrapper() {
    }

    public PivotHandlerWrapper(Handler pivHandler) {
        this(null, pivHandler, null);
    }

    public PivotHandlerWrapper(Handler reqHandler, Handler pivHandler, Handler respHandler) {
        this(reqHandler, pivHandler, respHandler, null);
    }

    public PivotHandlerWrapper(Handler reqHandler, Handler pivHandler, Handler respHandler, Handler closHandler) {
        this.setRequestHandler(reqHandler);
        this.setPivotHandler(pivHandler);
        this.setResponseHandler(respHandler);
    }

    protected void setRequestHandler(Handler reqHandler) {
        this._requestHandler = reqHandler;
    }

    public Handler getRequestHandler() {
        return this._requestHandler;
    }

    protected void setPivotHandler(Handler pivHandler) {
        this._pivotHandler = pivHandler;
    }

    public Handler getPivotHandler() {
        return this._pivotHandler;
    }

    protected void setResponseHandler(Handler respHandler) {
        this._responseHandler = respHandler;
    }

    public Handler getResponseHandler() {
        return this._responseHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(MessageContext msgContext) throws WebServicesFault {
        if (msgContext.getMessagePath() == 0) {
            msgContext.setProperty(ROOT_HANDLER_CHAIN, this);
            this.preHandleIncoming(msgContext);
            msgContext.setMessagePath(1);
        }
        try {
            Handler responseHandler;
            block34: {
                Handler requestHandler = this.getRequestHandler();
                if (requestHandler != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("PivotHandlerWrapper.getRequestHandler().invoke()");
                    }
                    requestHandler.invoke(msgContext);
                } else if (log.isDebugEnabled()) {
                    log.debug("PivotHandlerWrapper.getRequestHandler() == null");
                }
                if (msgContext.getMessagePath() != 1) return;
                responseHandler = this.getResponseHandler();
                Handler pivotHandler = this.getPivotHandler();
                try {
                    block33: {
                        try {
                            if (pivotHandler != null) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Calling PivotHandlerWrapper.getPivotHandler().invoke() :  Invoking: " + (pivotHandler.getClass() == null ? "null" : pivotHandler.getClass().getName()));
                                }
                                pivotHandler.invoke(msgContext);
                                if (log.isDebugEnabled()) {
                                    log.debug("Returning from PivotHandlerWrapper.getPivotHandler().invoke()  : " + (pivotHandler.getClass() == null ? "null" : pivotHandler.getClass().getName()));
                                }
                            } else if (log.isDebugEnabled()) {
                                log.debug("PivotHandlerWrapper.getPivotHandler() == null");
                            }
                            Object var6_7 = null;
                            msgContext.setPastPivot(true);
                            if (!msgContext.isClient() || msgContext.isOneWay() || msgContext.getMessagePath() != 1) break block33;
                        }
                        catch (Throwable throwable) {
                            Object var6_8 = null;
                            msgContext.setPastPivot(true);
                            if (!msgContext.isClient()) throw throwable;
                            if (msgContext.isOneWay()) throw throwable;
                            if (msgContext.getMessagePath() != 1) throw throwable;
                            PreHandler preHandler = (PreHandler)msgContext.getProperty(ROOT_HANDLER_CHAIN);
                            preHandler.preHandleIncoming(msgContext);
                            throw throwable;
                        }
                        PreHandler preHandler = (PreHandler)msgContext.getProperty(ROOT_HANDLER_CHAIN);
                        preHandler.preHandleIncoming(msgContext);
                    }
                    if (msgContext.getMessagePath() == 1) {
                        if (msgContext.isOneWay()) {
                            msgContext.setMessagePath(5);
                        } else {
                            msgContext.setMessagePath(2);
                        }
                    }
                    if (msgContext.getMessagePath() == 5) break block34;
                    if (msgContext.getResponseMessage() != null) {
                        msgContext.getResponseMessage().ifFaultThrowSelf();
                    } else {
                        log.error(Messages.getMessage("nullResponse00"));
                        if (msgContext.getProperty("SOAPConnection") == null) throw new RemoteException(Messages.getMessage("nullResponse00"));
                        if (!((Boolean)msgContext.getProperty("SOAPConnection")).booleanValue()) {
                            throw new RemoteException(Messages.getMessage("nullResponse00"));
                        }
                    }
                }
                catch (Throwable t) {
                    if (log.isDebugEnabled()) {
                        log.debug("Caught exception from PivotHandlerWrapper.getPivotHandler().invoke() logic  : " + t.toString());
                    }
                    if (!UserExceptionTrace.isUserDefinedException(t) && msgContext.getMessagePath() == 1) {
                        FFDCFilter.processException(t, "com.ibm.ws.webservices.engine.PivotHandlerWrapper.invoke", "302", this);
                        if (log.isDebugEnabled()) {
                            log.debug(Messages.getMessage("pivotThrewException00", pivotHandler.getClass() == null ? "null" : pivotHandler.getClass().getName()), t);
                        }
                    }
                    if (!msgContext.isOneWay()) {
                        msgContext.setMessagePath(4);
                    } else {
                        msgContext.setMessagePath(5);
                    }
                    WebServicesFault wsf = this.bindExceptionToResponse(msgContext, t);
                    try {
                        if (!msgContext.isOneWay()) {
                            PivotHandlerWrapper.onFault("invoke", "request", msgContext, this.getRequestHandler());
                            throw wsf;
                        }
                        if (!log.isDebugEnabled()) throw wsf;
                        log.debug("Application handler handleFault() is not invoked for a one-way operation; see JAX-RPC 12.1.4.");
                        throw wsf;
                    }
                    catch (Throwable t2) {
                        FFDCFilter.processException(t2, "com.ibm.ws.webservices.engine.PivotHandlerWrapper.invoke", "249", this);
                        log.error(Messages.getMessage("handlerRewindException00"));
                    }
                    throw wsf;
                }
            }
            if (responseHandler == null) {
                if (!log.isDebugEnabled()) return;
                log.debug("PivotHandlerWrapper.invoke(): NO responseHandler!");
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("PivotHandlerWrapper.invoke(): responseHandler.invoke()");
            }
            if (msgContext.getMessagePath() == 2) {
                responseHandler.invoke(msgContext);
                return;
            }
            if (!(responseHandler instanceof ClosureHandler)) return;
            ((ClosureHandler)responseHandler).handleClosure(msgContext);
            return;
        }
        catch (Throwable t) {
            msgContext.setMessagePath(4);
            WebServicesFault webServicesFault = this.bindExceptionToResponse(msgContext, t);
        }
    }

    private WebServicesFault bindExceptionToResponse(MessageContext msgContext, Throwable t) throws MissingResourceException {
        WebServicesFault f;
        if (t instanceof WebServicesFault) {
            f = (WebServicesFault)t;
            if (!f.isUserException()) {
                log.debug("Caught WebServicesFault", f);
            } else {
                UserExceptionTrace.log(f);
            }
        } else {
            log.error(Messages.getMessage("unexpectedException00"), t);
            f = new WebServicesFault(Messages.getMessage("unexpectedException00"), t);
        }
        if (!msgContext.isPropertyTrue("com.ibm.ws.webservices.engine.SimpleChain.caughtFaultInResponse")) {
            msgContext.setProperty("com.ibm.ws.webservices.engine.SimpleChain.caughtFaultInResponse", Boolean.TRUE);
            if (msgContext.getResponseMessage() == null) {
                Message respMsg = new Message(f);
                msgContext.setResponseMessage(respMsg);
            } else {
                boolean isFault;
                Message respMsg;
                block14: {
                    respMsg = msgContext.getResponseMessage();
                    isFault = false;
                    try {
                        if (respMsg.getFault() != null) {
                            isFault = true;
                        }
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.PivotHandlerWrapper.invoke", "418", this);
                        if (!log.isDebugEnabled()) break block14;
                        log.debug("PivotHandlerWrapper.bindExceptionToResponse encountered an exception while processing the respMsg.getFault()" + e.toString());
                    }
                }
                if (!isFault) {
                    try {
                        SOAPEnvelope env = respMsg.getSOAPEnvelope();
                        SOAPBody body = (SOAPBody)env.getBody();
                        body.removeContents();
                        SOAPFault fault2 = (SOAPFault)body.addFault();
                        fault2.setFault(f);
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.PivotHandlerWrapper.invoke", "441", this);
                        if (log.isDebugEnabled()) {
                            log.debug("PivotHandlerWrapper.bindExceptionToResponse encountered an exception while processing the SOAPEnvelope " + e.toString());
                        }
                        Message newRespMsg = new Message(f);
                        msgContext.setResponseMessage(newRespMsg);
                    }
                }
            }
        }
        return f;
    }

    public void onFault(MessageContext msgContext) {
        if (msgContext.getPastPivot()) {
            PivotHandlerWrapper.onFault("onFault", "response", msgContext, this.getResponseHandler());
        } else {
            PivotHandlerWrapper.onFault("onFault", "request", msgContext, this.getRequestHandler());
        }
    }

    protected static final void onFault(String method, String path, MessageContext msgContext, Handler handler2) {
        if (handler2 != null) {
            if (log.isDebugEnabled()) {
                log.debug("PivotHandlerWrapper." + method + "(): " + path + "Handler.onFault()");
            }
            handler2.onFault(msgContext);
        } else if (log.isDebugEnabled()) {
            log.debug("PivotHandlerWrapper." + method + "(): NO " + path + "Handler for onFault!");
        }
    }

    public void preHandleIncoming(MessageContext msgContext) {
        Handler responseHandler;
        Handler pivotHandler;
        Handler requestHandler;
        if (msgContext.isServer() && (requestHandler = this.getRequestHandler()) instanceof PreHandler) {
            if (log.isDebugEnabled()) {
                log.debug("PivotHandlerWrapper.getRequestHandler().preHandleIncoming()");
            }
            ((PreHandler)requestHandler).preHandleIncoming(msgContext);
        }
        if ((pivotHandler = this.getPivotHandler()) instanceof PreHandler) {
            if (log.isDebugEnabled()) {
                log.debug("PivotHandlerWrapper.getPivotHandler().preHandleIncoming()");
            }
            ((PreHandler)pivotHandler).preHandleIncoming(msgContext);
        }
        if (msgContext.isClient() && (responseHandler = this.getResponseHandler()) instanceof PreHandler) {
            if (log.isDebugEnabled()) {
                log.debug("PivotHandlerWrapper.getResponseHandler().preHandleIncoming()");
            }
            ((PreHandler)responseHandler).preHandleIncoming(msgContext);
        }
    }

    public void generateWSDL(MessageContext msgContext) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: PivotHandlerWrapper::generateWSDL");
        }
        try {
            if (this.getRequestHandler() != null) {
                if (log.isDebugEnabled()) {
                    log.debug("PivotHandlerWrapper.generateWSDL(): requestHandler.generateWSDL()");
                }
                this.getRequestHandler().generateWSDL(msgContext);
            } else if (log.isDebugEnabled()) {
                log.debug("PivotHandlerWrapper.generateWSDL(): NO requestHandler!");
            }
            if (this.getPivotHandler() != null) {
                if (log.isDebugEnabled()) {
                    log.debug("PivotHandlerWrapper.generateWSDL(): pivotHandler.generateWSDL()");
                }
                this.getPivotHandler().generateWSDL(msgContext);
            } else if (log.isDebugEnabled()) {
                log.debug("PivotHandlerWrapper.generateWSDL(): NO pivotHandler!");
            }
            msgContext.setPastPivot(true);
            if (this.getResponseHandler() != null) {
                if (log.isDebugEnabled()) {
                    log.debug("PivotHandlerWrapper.generateWSDL(): responseHandler.generateWSDL()");
                }
                this.getResponseHandler().generateWSDL(msgContext);
            } else if (log.isDebugEnabled()) {
                log.debug("PivotHandlerWrapper.generateWSDL(): NO responseHandler!");
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.webservices.engine.PivotHandlerWrapper.generateWSDL", "413", this);
            throw this.bindExceptionToResponse(msgContext, t);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: PivotHandlerWrapper::generateWSDL");
        }
    }
}

