/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine;

import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.wsspi.webservices.rpc.handler.RPCContext;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;

public class GuardedMessageContext
implements com.ibm.wsspi.webservices.rpc.handler.MessageContext,
SOAPMessageContext {
    private static final Set guardedProperties;
    protected static Log log;
    private final MessageContext mc;

    public GuardedMessageContext(MessageContext mc) {
        this.mc = mc;
    }

    public RPCContext getRPCContext() {
        return this.mc.getRPCContext();
    }

    public boolean isClient() {
        return this.mc.isClient();
    }

    public boolean isHighFidelity() {
        return this.mc.isHighFidelity();
    }

    public boolean isResponsePath() {
        return this.mc.isResponsePath();
    }

    public boolean isReponsePath() {
        return this.mc.isResponsePath();
    }

    public boolean isRequestPath() {
        return this.mc.isRequestPath();
    }

    public boolean isServer() {
        return this.mc.isServer();
    }

    public void setHighFidelity(boolean highFidelity) {
        this.mc.setHighFidelity(highFidelity);
    }

    public SOAPMessage getMessage() {
        return this.mc.getMessage();
    }

    public String[] getRoles() {
        return this.mc.getRoles();
    }

    public void setMessage(SOAPMessage message) {
        this.mc.setMessage(message);
    }

    public void setProperty(String name2, Object value2) {
        if (guardedProperties.contains(name2) && this.mc.containsProperty(name2)) {
            if (log.isDebugEnabled()) {
                log.debug("Property " + name2 + " can only be set once.");
            }
            throw new IllegalArgumentException();
        }
        this.mc.setProperty(name2, value2);
    }

    public Object getProperty(String name2) {
        this.checkGuard(name2);
        return this.mc.getProperty(name2);
    }

    public Object getPortProperty(String name2) {
        this.checkGuard(name2);
        return this.mc.getPortProperty(name2);
    }

    public void removeProperty(String name2) {
        this.checkGuard(name2);
        this.mc.removeProperty(name2);
    }

    public boolean containsProperty(String name2) {
        return this.mc.containsProperty(name2);
    }

    public Iterator getPropertyNames() {
        HashSet<String> unguardedProperties = new HashSet<String>();
        Iterator properties = this.mc.getPropertyNames();
        while (properties.hasNext()) {
            String property = (String)properties.next();
            if (guardedProperties.contains(property)) continue;
            unguardedProperties.add(property);
        }
        return unguardedProperties.iterator();
    }

    public SOAPPort getPort() {
        return this.mc.getPort();
    }

    private void checkGuard(String property) throws IllegalArgumentException {
        if (guardedProperties.contains(property)) {
            throw new IllegalArgumentException();
        }
    }

    static {
        log = LogFactory.getLog(GuardedMessageContext.class.getName());
        guardedProperties = new HashSet();
        guardedProperties.add("javax.xml.rpc.security.auth.password");
    }
}

