/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.webservices.component.JAXRPCMetaDataHelper;
import com.ibm.ws.webservices.component.JAXRPCMetaDataWrapper;
import com.ibm.ws.webservices.deploy.PortComponentInfo;
import com.ibm.ws.webservices.deploy.ServiceImplInfo;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsdd.EJBLink;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.ServiceImplBean;
import org.eclipse.jst.j2ee.webservice.wsdd.ServletLink;
import org.eclipse.jst.j2ee.webservice.wsdd.WSDLPort;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;

public class WSDeploymentDescriptorAccessor {
    private static TraceComponent tc = Tr.register(WSDeploymentDescriptorAccessor.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    private final EObject refObject;
    private final AppDeploymentInfo appDeploymentInfo;
    private final AppDeploymentTask appDeploymentTask;
    private final String moduleURIString;
    private List jaxrpcPortComponents;
    private WebServices ws = null;

    public WSDeploymentDescriptorAccessor(EObject refObject, AppDeploymentInfo appDeploymentInfo, AppDeploymentTask task) throws AppDeploymentException {
        this.refObject = refObject;
        this.appDeploymentInfo = appDeploymentInfo;
        this.appDeploymentTask = task;
        this.moduleURIString = util.formUriString((AppDeploymentInfo)appDeploymentInfo, (EObject)refObject);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor: moduleURIString=" + this.moduleURIString);
        }
        String pathToWebservicesXmlFile = "";
        if (refObject instanceof WebApp) {
            pathToWebservicesXmlFile = "WEB-INF/webservices.xml";
        } else if (refObject instanceof EJBJar) {
            pathToWebservicesXmlFile = "META-INF/webservices.xml";
        } else {
            Tr.error(tc, "WSWS0020E", "Constructor: SHOULD NOT HAPPEN, the module must either be an EJB or WAR module");
        }
        ModuleFile mfile = appDeploymentInfo.getModuleFileForDD(refObject);
        try {
            this.jaxrpcPortComponents = null;
            JAXRPCMetaDataHelper helper = new JAXRPCMetaDataHelper((Archive)mfile, mfile.getArchiveClassLoader());
            JAXRPCMetaDataWrapper wrapper = helper.loadJAXRPCMetaData();
            if (wrapper != null && wrapper.containsJAXRPCServices()) {
                this.ws = wrapper.getWebServices();
                this.jaxrpcPortComponents = wrapper.getJaxrpcPortComponents();
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.deploy.WSDeploymentDescriptorAccessor.WSDeploymentDescriptorAccessor", "112", this);
            Object[] fillins = new Object[]{pathToWebservicesXmlFile, util.formUriString((AppDeploymentInfo)appDeploymentInfo, (EObject)refObject), ex};
            String message = MessageFormat.format(util.getMessage((AppDeploymentTask)task, (String)"WSWS0011E"), fillins);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "constructor: " + message);
            }
            Tr.error(tc, "WSWS0011E", fillins);
            throw new AppDeploymentException(message, (Throwable)ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor");
        }
    }

    public String[] getWebserviceDescriptionNames() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWebserviceDescriptionNames for " + this.moduleURIString);
        }
        ArrayList<String> theWebserviceDescriptionNames = new ArrayList<String>();
        if (this.ws == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getWebserviceDescriptionNames for " + this.moduleURIString + " The module does not contain a Web Services" + " Deployment Descriptor");
            }
            return new String[0];
        }
        int wsdCount = this.ws.getWebServiceDescriptions().size();
        for (int i = 0; i < wsdCount; ++i) {
            WebServiceDescription description = (WebServiceDescription)this.ws.getWebServiceDescriptions().get(i);
            if (description == null) {
                String message = "For the module \"" + this.moduleURIString + "\" getWebServicesDescription returned " + "null for webservices-description stanza number " + i;
                Tr.error(tc, "WSWS0020E", message);
                throw new AppDeploymentException(message, null);
            }
            String name2 = description.getWebServiceDescriptionName();
            String nameValue = null;
            if (name2 != null) {
                nameValue = name2;
            }
            if (name2 == null || nameValue == null) {
                Object[] fillins = new Object[]{this.moduleURIString, new Integer(i)};
                String message = MessageFormat.format(util.getMessage((AppDeploymentTask)this.appDeploymentTask, (String)"WSWS0027E"), fillins);
                Tr.error(tc, "WSWS0027E", fillins);
                throw new AppDeploymentException(message, null);
            }
            theWebserviceDescriptionNames.add(nameValue);
        }
        String[] returnValue = theWebserviceDescriptionNames.toArray(new String[0]);
        if (tc.isEntryEnabled()) {
            String msg = "getWSDLFiles for " + this.moduleURIString + ": About to return an array of wsld-file names. " + "The array length is " + returnValue.length + " The array contents are:\n";
            for (int i = 0; i < returnValue.length; ++i) {
                msg = msg + "\t" + returnValue[i];
            }
            Tr.exit(tc, msg);
        }
        return returnValue;
    }

    PortComponentInfo[] getPortComponentDataForWebserviceDescriptionElement(String webserviceDescriptionName) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPortComponentDataForWebserviceDescriptionElement for " + this.moduleURIString + ": wsdlFile=" + webserviceDescriptionName);
        }
        ArrayList<PortComponentInfo> thePortComponents = new ArrayList<PortComponentInfo>();
        if (this.ws == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPortComponentDataForWebserviceDescriptionElement for " + this.moduleURIString + " The module does not contain a Web Services" + " Deployment Descriptor");
            }
            return new PortComponentInfo[0];
        }
        int wsdCount = this.ws.getWebServiceDescriptions().size();
        boolean foundit = false;
        block0: for (int i = 0; i < wsdCount; ++i) {
            WebServiceDescription description = (WebServiceDescription)this.ws.getWebServiceDescriptions().get(i);
            if (description == null) {
                String message = "For the module \"" + this.moduleURIString + "\" getWebServicesDescription returned " + "null for webservices-description stanza number " + i;
                Tr.error(tc, "WSWS0020E", message);
                throw new AppDeploymentException(message, null);
            }
            String name2 = description.getWebServiceDescriptionName();
            String nameValue = null;
            if (name2 != null) {
                nameValue = name2;
            }
            if (name2 == null || nameValue == null) {
                Object[] fillins = new Object[]{this.moduleURIString, new Integer(i)};
                String message = MessageFormat.format(util.getMessage((AppDeploymentTask)this.appDeploymentTask, (String)"WSWS0027E"), fillins);
                Tr.error(tc, "WSWS0027E", fillins);
                throw new AppDeploymentException(message, null);
            }
            if (!nameValue.equals(webserviceDescriptionName)) continue;
            int pcCount = description.getPortComponents().size();
            for (int j = 0; j < pcCount; ++j) {
                String pcName = null;
                String pcQnameNameSpace = null;
                String pcQnameLocalName = null;
                ServiceImplInfo serviceImplInfo = null;
                PortComponent pc = (PortComponent)description.getPortComponents().get(j);
                if (pc != null) {
                    String pcn = pc.getPortComponentName();
                    if (!this.jaxrpcPortComponents.contains(pcn)) {
                        if (!tc.isDebugEnabled()) continue block0;
                        Tr.debug(tc, "getPortComponentDataForWSDL: The port component " + pc.getPortComponentName() + " is not a JAX-RPC port component");
                        continue block0;
                    }
                    WSDLPort theWsdlPort = pc.getWsdlPort();
                    String qns = null;
                    String qln = null;
                    if (theWsdlPort != null) {
                        qns = theWsdlPort.getNamespaceURI();
                        qln = theWsdlPort.getLocalPart();
                    }
                    if (pcn != null) {
                        pcName = pcn;
                    }
                    if (qns != null) {
                        pcQnameNameSpace = qns;
                    }
                    if (qln != null) {
                        pcQnameLocalName = qln;
                    }
                    serviceImplInfo = this.getServerImplInfo(pc);
                }
                if (pcName == null || pcQnameNameSpace == null || pcQnameLocalName == null || serviceImplInfo == null) {
                    Object[] fillins = new Object[]{this.moduleURIString, new Integer(j), new Integer(i)};
                    Tr.error(tc, "WSWS0022E", fillins);
                    String message = MessageFormat.format(util.getMessage((AppDeploymentTask)this.appDeploymentTask, (String)"WSWS0022E"), fillins);
                    throw new AppDeploymentException(message, null);
                }
                PortComponentInfo pci = new PortComponentInfo(pcName, pcQnameNameSpace, pcQnameLocalName, serviceImplInfo.getLinkValue(), serviceImplInfo.getLinkType());
                thePortComponents.add(pci);
            }
        }
        PortComponentInfo[] returnValue = thePortComponents.toArray(new PortComponentInfo[0]);
        if (tc.isEntryEnabled()) {
            String msg = "getPortComponentDataForWSDL for " + this.moduleURIString + ": About to return an array of PortComponentInfo objects. " + "The array length is " + returnValue.length + " The array contents are:\n";
            for (int k = 0; k < returnValue.length; ++k) {
                msg = msg + "\t" + returnValue[k];
            }
            Tr.exit(tc, msg);
        }
        return returnValue;
    }

    public boolean isModuleWebServiceEnabled(AppDeploymentTask task) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isModuleWebServiceEnabled for module " + this.moduleURIString);
        }
        String pathToWebServicesXmlFile = null;
        if (this.refObject instanceof WebApp) {
            pathToWebServicesXmlFile = "WEB-INF/webservices.xml";
        } else if (this.refObject instanceof EJBJar) {
            pathToWebServicesXmlFile = "META-INF/webservices.xml";
        } else {
            String message = "Constructor: SHOULD NOT HAPPEN, the module must either be an EJB or WAR module";
            Tr.error(tc, "WSWS0020E", message);
            throw new AppDeploymentException(message, null);
        }
        ModuleFile mfile = this.appDeploymentInfo.getModuleFileForDD(this.refObject);
        boolean hasDD = mfile.getLoadStrategy().getContainer().containsFile(pathToWebServicesXmlFile);
        boolean returnValue = false;
        if (hasDD && this.jaxrpcPortComponents != null && !this.jaxrpcPortComponents.isEmpty()) {
            returnValue = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isModuleWebServiceEnabled for module " + this.moduleURIString + " returning " + returnValue);
        }
        return returnValue;
    }

    public boolean isModuleWebServiceEnabledClient() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isModuleWebServiceEnabledClient for module " + this.moduleURIString);
        }
        String pathToWebServicesXmlFile = null;
        if (this.refObject instanceof WebApp) {
            pathToWebServicesXmlFile = "WEB-INF/ibm-webservicesclient-bnd.xmi";
        } else if (this.refObject instanceof EJBJar) {
            pathToWebServicesXmlFile = "META-INF/ibm-webservicesclient-bnd.xmi";
        } else {
            String message = "Constructor: SHOULD NOT HAPPEN, the module must either be an EJB or WAR module";
            Tr.error(tc, "WSWS0020E", message);
            throw new AppDeploymentException(message, null);
        }
        ModuleFile mfile = this.appDeploymentInfo.getModuleFileForDD(this.refObject);
        boolean returnValue = mfile.getLoadStrategy().getContainer().containsFile(pathToWebServicesXmlFile);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isModuleWebServiceEnabledClient for module " + this.moduleURIString + " returning " + returnValue);
        }
        return returnValue;
    }

    public String getWsdlFileForWebserviceDescriptionName(String webserviceDescriptionName) throws AppDeploymentException {
        if (this.ws == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getWsdlFileForWebserviceDescriptionName for " + this.moduleURIString + " The module does not contain a Web Services" + " Deployment Descriptor");
            }
            return null;
        }
        int wsdCount = this.ws.getWebServiceDescriptions().size();
        boolean foundit = false;
        for (int i = 0; i < wsdCount; ++i) {
            WebServiceDescription description = (WebServiceDescription)this.ws.getWebServiceDescriptions().get(i);
            if (description == null) {
                String message = "For the module \"" + this.moduleURIString + "\" getWsdlFileForWebserviceDescriptionName returned " + "null for webservices-description stanza number " + i;
                Tr.error(tc, "WSWS0020E", message);
                throw new AppDeploymentException(message, null);
            }
            String name2 = description.getWebServiceDescriptionName();
            String nameValue = null;
            if (name2 != null) {
                nameValue = name2;
            }
            if (name2 == null || nameValue == null) {
                Object[] fillins = new Object[]{this.moduleURIString, new Integer(i)};
                String message = MessageFormat.format(util.getMessage((AppDeploymentTask)this.appDeploymentTask, (String)"WSWS0027E"), fillins);
                Tr.error(tc, "WSWS0027E", fillins);
                throw new AppDeploymentException(message, null);
            }
            if (!nameValue.equals(webserviceDescriptionName)) continue;
            String theWSDLFile = description.getWsdlFile();
            String wsdlFileName = null;
            if (theWSDLFile != null) {
                wsdlFileName = theWSDLFile;
            }
            if (theWSDLFile == null || wsdlFileName == null) {
                Object[] fillins = new Object[]{this.moduleURIString, new Integer(i)};
                String message = MessageFormat.format(util.getMessage((AppDeploymentTask)this.appDeploymentTask, (String)"WSWS0021E"), fillins);
                Tr.error(tc, "WSWS0021E", fillins);
                throw new AppDeploymentException(message, null);
            }
            return wsdlFileName;
        }
        return null;
    }

    private ServiceImplInfo getServerImplInfo(PortComponent pc) {
        ServiceImplBean sib = pc.getServiceImplBean();
        if (sib == null) {
            return null;
        }
        EJBLink ejbl = sib.getEEJBLink();
        ServletLink servletl = sib.getEServletLink();
        if (ejbl != null && servletl != null || ejbl == null && servletl == null) {
            return null;
        }
        String linkValue = null;
        ServiceImplInfo returnValue = null;
        if (ejbl != null) {
            linkValue = ejbl.getEjbLink();
            if (linkValue == null) {
                returnValue = null;
            }
            returnValue = new ServiceImplInfo(linkValue, 0);
        } else if (servletl != null) {
            linkValue = servletl.getServletLink();
            if (linkValue == null) {
                returnValue = null;
            }
            returnValue = new ServiceImplInfo(linkValue, 1);
        }
        return returnValue;
    }
}

