/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscbnd.ComponentScopedRefs;
import com.ibm.etools.webservice.wscbnd.PortQnameBinding;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.etools.webservice.wscommonbnd.Parameter;
import com.ibm.etools.webservice.wscommonbnd.WscommonbndFactory;
import com.ibm.etools.webservice.wscommonbnd.WscommonbndPackage;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.webservices.deploy.ClientCustomProperty;
import com.ibm.ws.webservices.deploy.WSBindingsFileAccessor;
import com.ibm.ws.webservices.deploy.WSDeploymentDescriptorAccessor;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

public class ClientCustomPropertyTaskHelper
implements AppDeploymentTaskHelper {
    private static TraceComponent tc = Tr.register(ClientCustomPropertyTaskHelper.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        return new ClientCustomProperty(appController);
    }

    public void prepareTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask task) throws AppDeploymentException {
        String[][] newTaskData;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ClientCustomPropertyTaskHelper prepareTask");
        }
        if (task.getTaskData() != null) {
            return;
        }
        Vector<String> dataForTwoDimensionalArray = new Vector<String>();
        String[] columnNames = task.getColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "prepareTask: columnName[" + i + "] = " + columnNames[i]);
            }
            dataForTwoDimensionalArray.addElement(columnNames[i]);
        }
        Vector ejbJars = appDeploymentInfo.getModuleConfig("JAR_DD");
        Vector wars = appDeploymentInfo.getModuleConfig("WAR_DD");
        Vector combined = new Vector();
        combined.addAll(ejbJars);
        combined.addAll(wars);
        boolean webServiceEnabled = false;
        boolean firstRowFilled = false;
        Iterator iter = combined.iterator();
        while (iter.hasNext()) {
            WSDeploymentDescriptorAccessor ddAccessor;
            EObject refObject = (EObject)iter.next();
            String moduleURI = util.formUriString((AppDeploymentInfo)appDeploymentInfo, (EObject)refObject);
            String[] pieces = util.separateUriString((String)moduleURI);
            String moduleName = pieces[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "prepareTask: working on module " + moduleURI);
            }
            if ((ddAccessor = new WSDeploymentDescriptorAccessor(refObject, appDeploymentInfo, task)).isModuleWebServiceEnabledClient()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "prepareTask: module " + moduleURI + " is Web Service enabled");
                }
                webServiceEnabled = true;
                WSBindingsFileAccessor bindingAccessor = new WSBindingsFileAccessor(refObject, moduleURI, task, appDeploymentInfo);
                ClientBinding clientBinding = bindingAccessor.getClientBinding();
                if (clientBinding == null) continue;
                String ejbName = "";
                if (bindingAccessor.isWebType(null)) {
                    EList services;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "prepareTask: bindingAccessor.isWebType");
                    }
                    if ((services = clientBinding.getServiceRefs()) == null || services.isEmpty()) continue;
                    this.fillServicesRows(dataForTwoDimensionalArray, moduleName, ejbName, services);
                    firstRowFilled = true;
                    continue;
                }
                EList scopedComponents = clientBinding.getComponentScopedRefs();
                if (scopedComponents == null || scopedComponents.isEmpty()) continue;
                int sc_size = scopedComponents.size();
                for (int i = 0; i < sc_size; ++i) {
                    ComponentScopedRefs csr = (ComponentScopedRefs)scopedComponents.get(i);
                    ejbName = csr.getComponentNameLink();
                    EList services = csr.getServiceRefs();
                    if (services == null || services.isEmpty()) continue;
                    this.fillServicesRows(dataForTwoDimensionalArray, moduleName, ejbName, services);
                    firstRowFilled = true;
                }
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "prepareTask: module " + moduleURI + " is NOT Web Service enabled");
        }
        if (webServiceEnabled) {
            if (!firstRowFilled) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "prepareTask: firstRowFilled false");
                }
                for (int i = 0; i < columnNames.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "prepareTask: columnName[" + i + "] = " + columnNames[i]);
                    }
                    dataForTwoDimensionalArray.addElement("");
                }
            }
            newTaskData = util.buildTaskData(dataForTwoDimensionalArray, (int)columnNames.length);
            task.setTaskData(newTaskData);
        } else {
            newTaskData = null;
            task.setTaskData(newTaskData);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ClientCustomPropertyTaskHelper prepareTask");
        }
    }

    private void fillServicesRows(Vector dataForTwoDimensionalArray, String moduleName, String ejbName, EList services) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fillServicesRows", new Object[]{moduleName, ejbName});
        }
        int size = services.size();
        for (int i = 0; i < size; ++i) {
            ServiceRef sr = (ServiceRef)services.get(i);
            String serviceName = sr.getServiceRefLink();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "fillServicesRows: serviceName = " + serviceName);
            }
            EList ports = sr.getPortQnameBindings();
            int portCount = ports.size();
            for (int jj = 0; jj < portCount; ++jj) {
                PortQnameBinding aPort = (PortQnameBinding)ports.get(jj);
                dataForTwoDimensionalArray.addElement(moduleName);
                dataForTwoDimensionalArray.addElement(ejbName);
                dataForTwoDimensionalArray.addElement(serviceName);
                String portName = ClientCustomPropertyTaskHelper.getPortQNameString(aPort);
                dataForTwoDimensionalArray.addElement(portName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "fillServicesRows: portName = " + portName + "  aPort = " + aPort);
                }
                EList allParams = aPort.getParameters();
                String aName = "";
                String aValue = "";
                if (allParams != null && !allParams.isEmpty()) {
                    int pSize = allParams.size();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "fillServicesRows: allParams.size() = " + allParams.size());
                    }
                    for (int ii = 0; ii < pSize; ++ii) {
                        Parameter aParam;
                        if (ii == 0) {
                            aParam = (Parameter)allParams.get(ii);
                            aName = aParam.getName();
                            if (aName == null) {
                                aName = "";
                            }
                            if ((aValue = aParam.getValue()) == null) {
                                aValue = "";
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "fillServicesRows: aName = " + aName + "  aValue = " + aValue);
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        aParam = (Parameter)allParams.get(ii);
                        Tr.debug(tc, "  aName = " + aParam.getName() + "  aValue = " + aParam.getValue());
                    }
                }
                dataForTwoDimensionalArray.addElement(aName);
                dataForTwoDimensionalArray.addElement(aValue);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dataForTwoDimensionalArray" + dataForTwoDimensionalArray.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fillServicesRows");
        }
    }

    public void completeTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask task) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ClientCustomPropertyTaskHelper completeTask");
        }
        if (!task.isTaskEmpty() && !task.isTaskDisabled()) {
            Hashtable appOptions = appDeploymentInfo.getAppOptions();
            String[][] taskData = task.getTaskData();
            if (tc.isDebugEnabled()) {
                for (int ndx = 0; ndx < taskData.length; ++ndx) {
                    for (int ndx2 = 0; ndx2 < taskData[ndx].length; ++ndx2) {
                        Tr.debug(tc, "taskData[" + ndx + "][" + ndx2 + "] = " + "[" + taskData[ndx][ndx2] + "]");
                    }
                }
            }
            Vector ejbJars = appDeploymentInfo.getModuleConfig("JAR_DD");
            Vector wars = appDeploymentInfo.getModuleConfig("WAR_DD");
            Vector combined = new Vector();
            combined.addAll(ejbJars);
            combined.addAll(wars);
            Iterator iter = combined.iterator();
            while (iter.hasNext()) {
                WSBindingsFileAccessor bindingAccessor;
                ClientBinding clientBinding;
                WSDeploymentDescriptorAccessor ddAccessor;
                EObject refObject = (EObject)iter.next();
                String moduleURI = util.formUriString((AppDeploymentInfo)appDeploymentInfo, (EObject)refObject);
                String[] pieces = util.separateUriString((String)moduleURI);
                String moduleName = pieces[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "working on module " + moduleURI);
                }
                if (!(ddAccessor = new WSDeploymentDescriptorAccessor(refObject, appDeploymentInfo, task)).isModuleWebServiceEnabledClient()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " module " + moduleURI + " is Web Service enabled");
                }
                if ((clientBinding = (bindingAccessor = new WSBindingsFileAccessor(refObject, moduleURI, task, appDeploymentInfo)).getClientBinding()) == null) continue;
                String ejbName = "";
                if (bindingAccessor.isWebType(null)) {
                    EList services = clientBinding.getServiceRefs();
                    if (services == null || services.isEmpty()) continue;
                    this.searchServicesAndSetNameValue(moduleName, ejbName, services, taskData);
                    continue;
                }
                EList scopedComponents = clientBinding.getComponentScopedRefs();
                if (scopedComponents == null || scopedComponents.isEmpty()) continue;
                int sc_size = scopedComponents.size();
                for (int i = 0; i < sc_size; ++i) {
                    ComponentScopedRefs csr = (ComponentScopedRefs)scopedComponents.get(i);
                    ejbName = csr.getComponentNameLink();
                    EList services = csr.getServiceRefs();
                    if (services == null || services.isEmpty()) continue;
                    this.searchServicesAndSetNameValue(moduleName, ejbName, services, taskData);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ClientCustomPropertyTaskHelper completeTask");
        }
    }

    private void searchServicesAndSetNameValue(String moduleMatch, String ejbMatch, EList services, String[][] taskData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchServicesAndSetNameValue completeTask for module: " + moduleMatch, ", and ejb: " + ejbMatch);
        }
        for (int i = 0; i < services.size(); ++i) {
            ServiceRef sr = (ServiceRef)services.get(i);
            String serviceName = sr.getServiceRefLink();
            EList ports = sr.getPortQnameBindings();
            for (int pi = 0; pi < ports.size(); ++pi) {
                PortQnameBinding aPort = (PortQnameBinding)ports.get(pi);
                String portName = ClientCustomPropertyTaskHelper.getPortQNameString(aPort);
                for (int jj = 1; jj < taskData.length; ++jj) {
                    String[] taskRow = taskData[jj];
                    if (!moduleMatch.equals(taskRow[0]) || !ejbMatch.equals(taskRow[1]) || !serviceName.equals(taskRow[2]) || !portName.equals(taskRow[3])) continue;
                    String aName = taskRow[4];
                    String aValue = taskRow[5];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "aName[" + aName + "]  aValue[" + aValue + "]");
                    }
                    if (aName.length() == 0) continue;
                    EList allParams = aPort.getParameters();
                    if (allParams == null) {
                        Object[] fillins = new Object[]{"Null parameter list for " + moduleMatch};
                        Tr.error(tc, "WSWS0020E", fillins);
                    }
                    if (aValue.length() == 0) continue;
                    String[] newParmsNames = aName.split("\\+");
                    String[] newParmsValues = aValue.split("\\+");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "aName[" + aName + "]  newParmsNames = " + ClientCustomPropertyTaskHelper.stringArrayToString(newParmsNames));
                        Tr.debug(tc, "aValue[" + aValue + "]  newParmsValues = " + ClientCustomPropertyTaskHelper.stringArrayToString(newParmsValues));
                    }
                    if (newParmsNames.length != newParmsValues.length) {
                        newParmsNames = new String[1];
                        newParmsValues = new String[1];
                        newParmsNames[0] = aName;
                        newParmsValues[0] = aValue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Lengths did not match for name value pairs using + sign, treating as single value pair");
                            Tr.debug(tc, "newParmsNames = " + ClientCustomPropertyTaskHelper.stringArrayToString(newParmsNames));
                            Tr.debug(tc, "newParmsValues = " + ClientCustomPropertyTaskHelper.stringArrayToString(newParmsValues));
                        }
                    }
                    Parameter parm = null;
                    String uri = "http://www.ibm.com/websphere/appserver/schemas/5.0.2/wscommonbnd.xmi";
                    WscommonbndPackage pkg = (WscommonbndPackage)EPackage.Registry.INSTANCE.getEPackage(uri);
                    WscommonbndFactory factory = pkg.getWscommonbndFactory();
                    for (int ndx = 0; ndx < newParmsNames.length; ++ndx) {
                        parm = this.getExistingParm(allParams, newParmsNames[ndx]);
                        if (parm == null) {
                            if (newParmsValues[ndx].equals(" ")) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, newParmsNames[ndx] + " has value of space and is not in parameter list");
                                continue;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Creating new parameter for " + newParmsNames[ndx]);
                            }
                            parm = factory.createParameter();
                            allParams.add(parm);
                        }
                        if (newParmsValues[ndx].equals(" ")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Removing parameter " + newParmsNames[ndx]);
                            }
                            allParams.remove(parm);
                            continue;
                        }
                        if (newParmsValues[ndx].equals("")) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Ignoring empty parameter value for " + newParmsNames[ndx]);
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            String os = "Setting Parameter: " + moduleMatch + ", ";
                            os = os + ejbMatch + ", " + serviceName;
                            os = os + ", " + portName + ", Name: ";
                            os = os + newParmsNames[ndx] + ", Value: " + newParmsValues[ndx];
                            Tr.debug(tc, os);
                        }
                        parm.setName(newParmsNames[ndx]);
                        parm.setValue(newParmsValues[ndx]);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchServicesAndSetNameValue completeTask");
        }
    }

    private static String getPortQNameString(PortQnameBinding port2) {
        String localName = port2.getPortQnameLocalNameLink();
        String nameSpace = port2.getPortQnameNamespaceLink();
        QName aPortQName = new QName(nameSpace, localName);
        String aPortQNameString = aPortQName.toString();
        return aPortQNameString;
    }

    private static String stringArrayToString(String[] arrayIn) {
        String retValue = "";
        for (int ndx = 0; ndx < arrayIn.length; ++ndx) {
            retValue = retValue.concat("[" + arrayIn[ndx] + "] ");
        }
        return retValue;
    }

    private Parameter getExistingParm(EList parmsIn, String nameIn) {
        for (int ndx = 0; ndx < parmsIn.size(); ++ndx) {
            Parameter curParm = (Parameter)parmsIn.get(ndx);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nameIn[" + nameIn + "]  curParm.getName()[" + curParm.getName() + "]");
            }
            if (!nameIn.equals(curParm.getName())) continue;
            return curParm;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getExistingParm returning null for " + nameIn);
        }
        return null;
    }
}

